

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_MoveRACInstance.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_MoveRACInstance')
BEGIN
	print '>>> Drop Stored Procedure: QS_MoveRACInstance <<<'
	drop procedure QS_MoveRACInstance
END
IF EXISTS (select * from GxQscripts where name='QS_MoveRACInstance')
	delete from GxQscripts where name = 'QS_MoveRACInstance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MoveRACInstance')
	delete from GXDBVersions where aliasname = 'QS_MoveRACInstance'
GO
print '... Creating Procedure: QS_MoveRACInstance'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_MoveRACInstance
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @SourceClientName NVARCHAR(1024) = N'%s',
  @TargetClientName NVARCHAR(1024) = N'%s',
  @RACInstanceName NVARCHAR(1024) = N'%s',
  @MoveToDeconfClientOnly NVARCHAR(16) = N'%s'
AS
	SET NOCOUNT ON
	DECLARE @scriptName nvarchar(128) = 'MoveRACInstance'
	DECLARE @nowTime integer = dbo.GetUnixTime (GetUTCdate())
	DECLARE @sourceClientID INT
	DECLARE @TargetClientID INT
	DECLARE @RACInstanceID INT
	DECLARE	@DestinationClientDeconfigured INT = 0
	DECLARE @Apptype INTEGER = 80 --Oracle RAC
	-----------------------error handling------------------------------------
	DECLARE @errorCode int
	SET @errorCode = 0
	DECLARE @errorString NVARCHAR(4000)
	SET @errorString = ''
	---------------insufficient parameters -----------------------------------------
	DECLARE @noParameter NVARCHAR(32)
	SET @noParameter = '%'
	SET @noParameter = @noParameter + 's'
	/* SOURCE CLIENT NAME CANNOT BE BLANK */
	If @SourceClientName = @noParameter OR @SourceClientName IS NULL OR @SourceClientName = ''
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'ERROR: You must specify a Source Client name.'
		GOTO ERROR_EXIT
	END
	/*FIND SOURCE CLIENT ID*/
	IF EXISTS (SELECT 1 FROM APP_Client C WHERE C.name = RTRIM(LTRIM(@SourceClientName)) AND C.simOperatingSystemId =56)
	BEGIN
		SELECT	@sourceClientID = c.id
		FROM	APP_Client C
		WHERE	C.name = RTRIM(LTRIM(@SourceClientName))
	END
	ELSE
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Source Client name [' + @SourceClientName + '] not found or not a valid RAC client.'
		GOTO ERROR_EXIT
	END
	/*DESTINATION CLIENT NAME CANNOT BE BLANK */
	If @TargetClientName = @noParameter OR @TargetClientName IS NULL OR @TargetClientName = ''
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'ERROR: You must specify a Destination Client name.'
		GOTO ERROR_EXIT
	END
	/*FIND DESTINATION CLIENT ID*/
	IF EXISTS (SELECT 1 FROM APP_Client C, App_Application A WHERE C.name = RTRIM(LTRIM(@TargetClientName)) AND A.clientId = C.id AND A.appTypeId = @Apptype)
	BEGIN
		SELECT	@TargetClientID = c.id
		FROM	APP_Client C
		WHERE	C.name = RTRIM(LTRIM(@TargetClientName))
	END
	ELSE
	IF EXISTS (SELECT 1 FROM APP_Client C WHERE C.name = RTRIM(LTRIM(@TargetClientName)) AND C.simOperatingSystemId =56)
	BEGIN
		SELECT	@TargetClientID = c.id
		FROM	APP_Client C
		WHERE	C.name = RTRIM(LTRIM(@TargetClientName))
	END
	ELSE
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Destination Client name [' + @TargetClientName + '] not found or not a valid RAC client.'
		GOTO ERROR_EXIT
	END
	/*INSTANCE NAME CANNOT BE BLANK */
	If @RACInstanceName = @noParameter OR @RACInstanceName IS NULL OR @RACInstanceName = ''
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'ERROR: You must specify an Instance name.'
		GOTO ERROR_EXIT
	END
	/*FIND INSTANCE ID*/
	IF EXISTS (SELECT 1 FROM APP_Application A, APP_InstanceName I WHERE A.instance = I.id AND A.clientId = @sourceClientID AND I.name= RTRIM(LTRIM(@RACInstanceName)))
	BEGIN
		IF EXISTS (SELECT 1 FROM APP_InstanceName WHERE id IN (SELECT instance FROM APP_Application WHERE clientId = @TargetClientID AND appTypeId = @AppType) AND NAME = RTRIM(LTRIM(@RACInstanceName)))
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Source Instance name [' + @RACInstanceName + '] already exists in the RAC client [' + @TargetClientName + '] '
			GOTO ERROR_EXIT
		END
		BEGIN
			SELECT	@RACInstanceID = I.id
			FROM	APP_InstanceName I
				INNER JOIN APP_Application A
					ON I.id = A.instance
			WHERE	I.name = RTRIM(LTRIM(@RACInstanceName))
				AND	A.clientId = @sourceClientID
				AND	A.appTypeId = @Apptype
		END
	END
	ELSE
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Source Instance name [' + @RACInstanceName + '] not found for the client [' + @SourceClientName + '].'
		GOTO ERROR_EXIT
	END
	/* Do not allow Indexing V2 client to Indexing V1 client and vice versa */
	DECLARE @sourceIndexingV2	NVARCHAR(MAX)
	DECLARE @targetIndexingV2	NVARCHAR(MAX)
	SET @sourceIndexingV2 = ISNULL((SELECT attrVal
									FROM	APP_ClientProp
									WHERE	componentNameId = @sourceClientID
										AND attrName = 'IndexingV2_Oracle'
										AND modified = 0), '0')
	SET @targetIndexingV2 = ISNULL((SELECT attrVal
									FROM	APP_ClientProp
									WHERE	componentNameId = @TargetClientID
										AND attrName = 'IndexingV2_Oracle'
										AND modified = 0), '0')
	IF (@sourceIndexingV2 != @targetIndexingV2)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Cannot move instance from Indexing V1 client to Indexing V2 client and vice versa.'
		GOTO ERROR_EXIT
	END
	/*VALIDATE THE OPTIONAL PARAMETER */
	If @MoveToDeconfClientOnly = @noParameter OR @MoveToDeconfClientOnly IS NULL OR @MoveToDeconfClientOnly = ''
	BEGIN
		SET @DestinationClientDeconfigured = 0
	END
	ELSE IF @MoveToDeconfClientOnly = 'Y' OR @MoveToDeconfClientOnly = 'Yes'
	BEGIN
		SET @DestinationClientDeconfigured = 1
	END
	IF (@DestinationClientDeconfigured = 1)
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM APP_Client WHERE id = @TargetClientID AND (status & 6) > 0)
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Destination client [' + @TargetClientName + '] is not in deconfigured state.'
			GOTO ERROR_EXIT
		END
	END
	BEGIN TRANSACTION
	BEGIN TRY
		UPDATE APP_Application SET clientId = @TargetClientID WHERE clientId = @sourceClientID AND instance = @RACInstanceID
		PRINT 'Moved the RAC instance [' + @RACInstanceName + '] from client [' + @SourceClientName + '] to client [' + @TargetClientName + '] successfully.'
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = 1
		SET @errorString = 'Error ' + CONVERT(varchar(50), ERROR_NUMBER()) +
				', Severity ' + CONVERT(varchar(5), ERROR_SEVERITY()) +
				', State ' + CONVERT(varchar(5), ERROR_STATE()) +
				', Procedure ' + ISNULL(ERROR_PROCEDURE(), '-') +
				', Line ' + CONVERT(varchar(5), ERROR_LINE());
	END CATCH
	IF @errorCode <> 0
	BEGIN
		ROLLBACK TRANSACTION
	END
	ELSE
	BEGIN
		COMMIT TRANSACTION
	END
	ERROR_EXIT:
	Print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+'. ErrorCode ('+  Convert(varchar(10), @errorCode) +').'
	if @errorCode <> 0
		Raiserror(@errorString,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1    --State
					)
	SET NOCOUNT ON
GO

IF EXISTS (select * from GxQscripts where name = 'QS_MoveRACInstance')
	delete from GxQscripts where name = 'QS_MoveRACInstance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MoveRACInstance')
	delete from GXDBVersions where aliasname = 'QS_MoveRACInstance'
GO

insert into GXDBVersions values(2, 'QS_MoveRACInstance',  '00000000000000000000', 'QS_MoveRACInstance', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_MoveRACInstance',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn MoveRACInstance.sql -si [Source RAC Client Name] -si [Destination RAC Client Name] -si [Source Instance Name] -si [MoveToDeconfClientOnly]
'
 + CHAR(10) + '--   script_name : MoveRACInstance'
)
GO

