

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_MoveOraInstanceToRAC.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_MoveOraInstanceToRAC')
BEGIN
	print '>>> Drop Stored Procedure: QS_MoveOraInstanceToRAC <<<'
	drop procedure QS_MoveOraInstanceToRAC
END
IF EXISTS (select * from GxQscripts where name='QS_MoveOraInstanceToRAC')
	delete from GxQscripts where name = 'QS_MoveOraInstanceToRAC'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MoveOraInstanceToRAC')
	delete from GXDBVersions where aliasname = 'QS_MoveOraInstanceToRAC'
GO
print '... Creating Procedure: QS_MoveOraInstanceToRAC'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_MoveOraInstanceToRAC
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @SrcClientName NVARCHAR(1024) = N'%s',
  @DestClientName NVARCHAR(1024) = N'%s',
  @SrcInstanceName NVARCHAR(1024) = N'%s'
AS
	SET NOCOUNT ON
	DECLARE @scriptName nvarchar(128) = 'MoveOraInstanceToRAC'
	DECLARE @nowTime integer = dbo.GetUnixTime (GetUTCdate())
	DECLARE @SrcClientID INTEGER
	DECLARE @SrcInstanceID INTEGER
	DECLARE @DestClientID INTEGER
	DECLARE @Apptype INTEGER = 22 /*CV_APPTYPE_ORACLE8*/
	DECLARE @OracleHome		  VARCHAR(1024)
	DECLARE @OracleUser		  VARCHAR(1024)
	DECLARE @InstanceOraUser    VARCHAR(1024)
	DECLARE @InstanceOraPasswd  VARCHAR(1024)
	DECLARE @InstanceOraService VARCHAR(1024)
	DECLARE @tnsAdmin			  VARCHAR(1024)
	DECLARE @sbtLibName		  VARCHAR(1024)
	DECLARE @attrname		      VARCHAR(1024)
	DECLARE @SqlInstanceName VARCHAR(1024)
	DECLARE @SqlDBName VARCHAR(1024)
	SELECT @SqlInstanceName = CONVERT(sysname, SERVERPROPERTY('servername'))
	SELECT @SqlDBName = DB_NAME()
	DECLARE @oracleRACInstanceId INTEGER
	DECLARE @logStreamsCount NVARCHAR(MAX)
	-----------------------error handling------------------------------------
	DECLARE @errorCode int
	SET @errorCode = 0
	DECLARE @errorString NVARCHAR(4000)
	SET @errorString = ''
	---------------insufficient parameters -----------------------------------------
	DECLARE @noParameter NVARCHAR(32)
	SET @noParameter = '%'
	SET @noParameter = @noParameter + 's'
	BEGIN TRANSACTION
	/*SOURCE CLIENT NAME CANNOT BE BLANK */
	If @SrcClientName = @noParameter OR @SrcClientName IS NULL OR @SrcClientName = ''
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'ERROR: You must specify a Source Client name.'
		GOTO ERROR_EXIT
	END
	/*FIND SOURCE CLIENT ID*/
	IF EXISTS (SELECT 1 FROM APP_Client WHERE name = RTRIM(LTRIM(@SrcClientName)))
	BEGIN
		SELECT	@SrcClientID = c.id
		FROM	APP_Client C
		WHERE	C.name = RTRIM(LTRIM(@SrcClientName))
	END
	ELSE
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Source Client name [' + @SrcClientName + '] not found in [' + @SqlInstanceName + '] in database [' + @SqlDBName + '].'
		GOTO ERROR_EXIT
	END
	/*DESTINATION CLIENT NAME CANNOT BE BLANK */
	If @DestClientName = @noParameter OR @DestClientName IS NULL OR @DestClientName = ''
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'ERROR: You must specify a Destination Client name.'
		GOTO ERROR_EXIT
	END
	/*FIND DESTINATION CLIENT ID*/
	IF EXISTS (SELECT 1 FROM APP_Client C, App_Application A WHERE C.name = RTRIM(LTRIM(@DestClientName)) AND A.clientId = C.id AND A.appTypeId = 80)
	BEGIN
		SELECT	@DestClientID = c.id
		FROM	APP_Client C
		WHERE	C.name = RTRIM(LTRIM(@DestClientName))
	END
	ELSE
	IF EXISTS (SELECT 1 FROM APP_Client C WHERE C.name = RTRIM(LTRIM(@DestClientName)) AND C.simOperatingSystemId =56)
	BEGIN
		SELECT	@DestClientID = c.id
		FROM	APP_Client C
		WHERE	C.name = RTRIM(LTRIM(@DestClientName))
	END
	ELSE
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Destination Client name [' + @DestClientName + '] not found or not a valid RAC client.'
		GOTO ERROR_EXIT
	END
	/*INSTANCE NAME CANNOT BE BLANK */
	If @SrcInstanceName = @noParameter OR @SrcInstanceName IS NULL OR @SrcInstanceName = ''
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'ERROR: You must specify an Instance name.'
		GOTO ERROR_EXIT
	END
	/*FIND INSTANCE ID*/
	IF EXISTS (SELECT 1 FROM APP_InstanceName WHERE name= RTRIM(LTRIM(@SrcInstanceName)))
	BEGIN
		IF EXISTS (SELECT 1 FROM APP_InstanceName WHERE id IN (SELECT instance FROM APP_Application WHERE clientId = @DestClientID AND appTypeId=80) AND NAME = RTRIM(LTRIM(@SrcInstanceName)))
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Source Instance name [' + @SrcInstanceName + '] already exists in the RAC client [' + @DestClientName + '] '
			GOTO ERROR_EXIT
		END
		BEGIN
			SELECT	@SrcInstanceID = I.id
			FROM	APP_InstanceName I
				INNER JOIN APP_Application A
					ON I.id = A.instance
			WHERE	I.name = RTRIM(LTRIM(@SrcInstanceName))
				AND	A.clientId = @SrcClientID
				AND	A.appTypeId = @Apptype
		END
	END
	ELSE
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Source Instance name [' + @SrcInstanceName + '] not found for the client [' + @SrcClientName + '] in  [' + @SqlInstanceName + '] in database [' + @SqlDBName + '].'
		GOTO ERROR_EXIT
	END
	BEGIN TRY
			IF @SrcInstanceID <> NULL or @SrcInstanceID <> 0
			BEGIN
				/*MOVE INSTANCE AND BACKUP HISTORY*/
				UPDATE [dbo].[APP_Application]
				SET		clientid = @DestClientID, appTypeId = 80
				WHERE	clientId = @SrcClientID
					AND	instance = @SrcInstanceID
				/*ORACLE_HOME*/
				SET @attrname=null
				SELECT @attrname = attrName FROM APP_InstanceProp P WHERE P.componentNameId = @SrcInstanceID AND P.attrName = LTRIM(RTRIM('Oracle Home')) AND modified=0
				IF @attrname IS NULL
				BEGIN
					SELECT @OracleHome = ''
				END
				ELSE
				BEGIN
					SELECT @OracleHome = ISNULL((SELECT TOP 1 P.attrVal FROM APP_InstanceProp P WHERE P.componentNameId = @SrcInstanceID and P.attrName = LTRIM(RTRIM('Oracle Home')) AND modified=0),'')
				END
				/*ORACLE_USER*/
				SET @attrname=null
				SELECT @attrname = attrname FROM APP_InstanceProp P WHERE P.componentNameId = @SrcInstanceID AND P.attrName = LTRIM(RTRIM('Oracle User')) AND modified=0
				IF @attrname IS NULL
				BEGIN
					SELECT @OracleUser = ''
				END
				ELSE
				BEGIN
					SELECT @OracleUser = ISNULL((SELECT TOP 1 P.attrVal FROM APP_InstanceProp P WHERE P.componentNameId = @SrcInstanceID AND P.attrName = LTRIM(RTRIM('Oracle User')) AND modified=0),'')
				END
				/*SQL CONNECT*/
				SET @attrname=null
				SELECT @attrname = attrname FROM APP_InstanceProp P WHERE P.componentNameId = @SrcInstanceID AND P.attrName = LTRIM(RTRIM('SQL Connect')) AND modified=0
				IF @attrname IS NULL
				BEGIN
					SELECT @InstanceOraUser = ''
				END
				ELSE
				BEGIN
					SELECT @InstanceOraUser  = ISNULL((SELECT TOP 1 P.attrVal FROM APP_InstanceProp P WHERE P.componentNameId = @SrcInstanceID AND P.attrName = LTRIM(RTRIM('SQL Connect')) AND modified=0),'')
				END
				/*SQL Connect Password*/
				SET @attrname=null
				SELECT @attrname = attrname FROM APP_InstanceProp P WHERE P.componentNameId = @SrcInstanceID AND P.attrName = LTRIM(RTRIM('SQL Connect Password')) AND modified=0
				IF @attrname IS NULL
				BEGIN
					SELECT @InstanceOraPasswd = ''
				END
				ELSE
				BEGIN
					SELECT @InstanceOraPasswd = ISNULL((SELECT TOP 1 dbo.pswConvertV5ToV3(P.attrVal) FROM APP_InstanceProp P WHERE P.componentNameId = @SrcInstanceID AND P.attrName = LTRIM(RTRIM('SQL Connect Password')) AND modified=0),'')
				END
				/*Oracle SID*/
				SET @attrname=null
				SELECT @attrname = attrname FROM APP_InstanceProp P WHERE P.componentNameId = @SrcInstanceID AND P.attrName = LTRIM(RTRIM('Oracle SID')) AND modified=0
				IF @attrname IS NULL
				BEGIN
					SELECT @InstanceOraService = ''
				END
				ELSE
				BEGIN
					SELECT @InstanceOraService = ISNULL((SELECT TOP 1 P.attrVal FROM APP_InstanceProp P WHERE P.componentNameId = @SrcInstanceID AND P.attrName = LTRIM(RTRIM('Oracle SID')) AND modified=0),'')
				END
				/*TNS admin path*/
				SET @attrname=null
				SELECT @attrname = attrname FROM APP_InstanceProp P WHERE P.componentNameId = @SrcInstanceID AND P.attrName = LTRIM(RTRIM('TNS admin path')) AND modified=0
				IF @attrname IS NULL
				BEGIN
					SELECT @tnsAdmin = ''
				END
				ELSE
				BEGIN
					SELECT @tnsAdmin = ISNULL((SELECT TOP 1 p.attrVal from APP_InstanceProp p where p.componentNameId = @SrcInstanceID and p.attrName = Ltrim(Rtrim('TNS admin path')) and modified=0),'')
				END
				/*Oracle SBT Library Name*/
				SET @attrname=null
				SELECT @attrname = attrname FROM APP_InstanceProp P WHERE P.componentNameId = @SrcInstanceID AND P.attrName = LTRIM(RTRIM('Oracle SBT Library Name')) AND modified=0
				IF @attrname IS NULL
				BEGIN
					SELECT @sbtLibName = ''
				END
				ELSE
				BEGIN
					SELECT @sbtLibName = ISNULL((SELECT TOP 1 P.attrVal FROM APP_InstanceProp P WHERE P.componentNameId = @SrcInstanceID AND P.attrName = LTRIM(RTRIM('Oracle SBT Library Name')) AND modified=0),'')
				END
			END
			ELSE
			BEGIN
				SET @errorCode = 1
				SET @errorString = 'ERROR: Instance not found.'
				GOTO ERROR_EXIT
			END
	/*INSERT CLIENT INTO RAC-INSTANCE PROPERTIES */
			INSERT INTO APP_OracleRacInstance
				(instaceId
				,clientId
				,name
				,oracleHome
				,oracleUser
				,parellelInstance
				,InstanceOraUser
				,InstanceOraPasswd
				,InstanceOraService
				,tnsAdmin
				,threadId
				,instanceNumber
				,flag
				,[status]
				,sbtLibName
				,ntPassword)
			VALUES (
				@SrcInstanceID
				,@SrcClientID
				,@SrcInstanceName,
				@OracleHome
				,@OracleUser
				,'YES'
				,@InstanceOraUser
				,@InstanceOraPasswd
				,@InstanceOraService
				,@tnsAdmin
				,0		--threadId
				,0		--instanceNumber
				,0		--flag
				,90		--status
				,@sbtLibName
				,''		--ntPassword
			)
			SET @oracleRACInstanceId = SCOPE_IDENTITY()
			SET @logStreamsCount = ISNULL((SELECT attrVal FROM APP_SubclientProp WHERE componentNameId IN (SELECT id FROM APP_Application where instance = @SrcInstanceID AND (subclientStatus & 8) = 8) AND attrName = 'Oracle Log backup streams' and modified = 0), '1')
			/* Insert RAC data and log streams for each subclient*/
			INSERT INTO APP_SubclientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			SELECT	DISTINCT A.id, 'Oracle RAC Data Properties', 117, CAST(@oracleRACInstanceId AS NVARCHAR(16)) + ' ' + ISNULL(SCP.attrVal, '1') + ' ' + '1', @nowTime, 0, 0
			FROM	APP_Application A
				LEFT JOIN APP_SubclientProp SCP
					ON A.id = SCP.componentNameId
					AND SCP.modified = 0
					AND SCP.attrName = 'Oracle Data backup streams'
			WHERE	A.instance = @SrcInstanceId
			INSERT INTO APP_SubclientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			SELECT	DISTINCT A.id, 'Oracle RAC Log Properties', 117, CAST(@oracleRACInstanceId AS NVARCHAR(16)) + ' ' + @logStreamsCount + ' ' + '1', @nowTime, 0, 0
			FROM	APP_Application A
			WHERE	A.instance = @SrcInstanceId
			/*
				Updating schedule tables to reflect migration of oracle instance to RAC.
			*/
			UPDATE TM_SubTaskOptions
			  SET value = @DestClientID
			  WHERE subTaskId IN (
				SELECT subTaskId FROM TM_SubTask
					WHERE  taskId IN (
							SELECT taskId FROM TM_AssocEntity
							WHERE clientId = @SrcClientID
							AND instanceId  = @SrcInstanceID
							AND appTypeId = @Apptype
						)
				)
				AND optionId = 293753447 /*DESTCLIENT_CLIENT_ID*/
			UPDATE TM_AssocEntity
			  SET clientId = @DestClientID, appTypeId = 80 /*CV_APPTYPE_ORACLE_RAC*/
			  WHERE clientId  = @SrcClientID
				AND instanceId  = @SrcInstanceID
				AND appTypeId = @Apptype
			-- We need to send refresh OSC tokens to clients so that if there are any automatic schedules associated, they would be reflected.
			INSERT INTO APP_WorkQueueRequest
			(clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
			VALUES
			(@SrcClientID, 4/*WORK_TOKEN_OSC*/, 0, @nowTime, 0, 0, 0, -1),
			(@DestClientID, 4/*WORK_TOKEN_OSC*/, 0, @nowTime, 0, 0, 0, -1)
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = 1
		SET @errorString = 'Error ' + CONVERT(varchar(50), ERROR_NUMBER()) +
				', Severity ' + CONVERT(varchar(5), ERROR_SEVERITY()) +
				', State ' + CONVERT(varchar(5), ERROR_STATE()) +
				', Procedure ' + ISNULL(ERROR_PROCEDURE(), '-') +
				', Line ' + CONVERT(varchar(5), ERROR_LINE());
	END CATCH
	ERROR_EXIT:
	IF @errorCode <> 0
	BEGIN
		ROLLBACK TRANSACTION
	END
	ELSE
	BEGIN
		COMMIT TRANSACTION
	END
	Print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+'. ErrorCode ('+  Convert(varchar(10), @errorCode) +').'
	if @errorCode <> 0
		Raiserror(@errorString,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1    --State
					)
	SET NOCOUNT ON
GO

IF EXISTS (select * from GxQscripts where name = 'QS_MoveOraInstanceToRAC')
	delete from GxQscripts where name = 'QS_MoveOraInstanceToRAC'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MoveOraInstanceToRAC')
	delete from GXDBVersions where aliasname = 'QS_MoveOraInstanceToRAC'
GO

insert into GXDBVersions values(2, 'QS_MoveOraInstanceToRAC',  '00000000000000000000', 'QS_MoveOraInstanceToRAC', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_MoveOraInstanceToRAC',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn MoveOraInstanceToRAC.sql -si [Source Client Name] -si [Destination New RAC Client Name] -si [Source Instance Name]
'
 + CHAR(10) + '--   script_name : MoveOraInstanceToRAC'
)
GO

