

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_MoveNASSubclient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_MoveNASSubclient')
BEGIN
	print '>>> Drop Stored Procedure: QS_MoveNASSubclient <<<'
	drop procedure QS_MoveNASSubclient
END
IF EXISTS (select * from GxQscripts where name='QS_MoveNASSubclient')
	delete from GxQscripts where name = 'QS_MoveNASSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MoveNASSubclient')
	delete from GXDBVersions where aliasname = 'QS_MoveNASSubclient'
GO
print '... Creating Procedure: QS_MoveNASSubclient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_MoveNASSubclient
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @srcClientName varchar(1024) = '%s',
  @srcBsetName varchar(1024) = '%s',
  @srcSCName varchar(1024) = '%s',
  @destClientName varchar(1024) = '%s',
  @destBsetName varchar(1024) = '%s'
AS
SET NOCOUNT ON
---------------command line inputs-------
--DECLARE @srcClientName nvarchar(1024)
--SET @srcClientName = '%s'
--DECLARE @srcBsetName nvarchar(1024)
--SET @srcBsetName = '%s'
--DECLARE @srcSCName nvarchar(1024)
--SET @srcSCName = '%s'
--DECLARE @destClientName nvarchar(1024)
--SET @destClientName = '%s'
--DECLARE @destBsetName nvarchar(1024)
--SET @destBsetName = '%s'
------------------------------
--SET @srcClientName = '%s'
--SET @srcBsetName = '%s'
--SET @srcSCName = '%s'
--SET @destClientName = '%s'
--SET @destBsetame = '%s'
------------------------------
----------------------constants--------
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = 'MoveNASSubclient'
DECLARE @nowTime   integer
SET		@nowTime  =   dbo.GetUnixTime (GetUTCdate())
-----------------------error handling----
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
DECLARE @noParameter NVARCHAR(32)
SET @noParameter = '%'
SET @noParameter = @noParameter + 's'
IF @srcClientName = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. No input was given.'
	GOTO ARGS_ERROR
END
---------------------validate input-------------------------
DECLARE @srcClientId integer
DECLARE @srcBsetId integer
DECLARE @srcSCID integer
DECLARE @destClientID integer
DECLARE @destBsetID integer
DECLARE @isIndexV2 integer
SET @srcClientId = ISNULL((SELECT id from APP_Client where name like @srcClientName), 0)
IF @srcClientId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client ['+@srcClientName+'] does not exist.'
	GOTO ARGS_ERROR
END
SET @isIndexV2 = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_ClientProp cliProp WITH(NOLOCK)
                       WHERE cliProp.attrName = N'IndexingV2_NAS' AND cliProp.attrVal = N'1' AND cliProp.modified = 0 AND cliProp.componentNameId =@srcClientId), 0)
IF @isIndexV2 = 1
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Source client ['+@srcClientName+'] is on Indexing V2. Indexing V2 does not allow move of subclients.'
	GOTO ARGS_ERROR
END
SET @srcBsetId = ISNULL((Select DISTINCT BSN.id from APP_BACKUPSETNAME AS BSN, APP_APPLICATION AS APP
                      where APP.clientId = @srcClientId
						AND APP.backupSet = BSN.id
						AND BSN.name = @srcBsetName
						AND appTypeId = 13  --CV_APPTYPE_NAS_FS
						), 0)
IF @srcBsetId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Backupset ['+@srcBsetName+'] does not exist.'
	GOTO ARGS_ERROR
END
SET @srcSCId = ISNULL((Select DISTINCT id FROM APP_APPLICATION
                      where clientId = @srcClientId
						AND backupSet = @srcBsetId
						AND appTypeId = 13  --CV_APPTYPE_NAS_FS
						AND subclientName = @srcSCName
						AND subClientStatus & 2 <>2
						AND subclientStatus & 4 <> 4 --UNINSTALLED, DELETED
						), 0)
IF @srcSCId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Subclient ['+@srcSCName+'] does not exist.'
	GOTO ARGS_ERROR
END
SET @destClientId = ISNULL((SELECT id from APP_Client where name like @destClientName), 0)
IF @destClientId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client ['+@destClientName+'] does not exist.'
	GOTO ARGS_ERROR
END
SET @isIndexV2 = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_ClientProp cliProp WITH(NOLOCK)
                       WHERE cliProp.attrName = N'IndexingV2_NAS' AND cliProp.attrVal = N'1' AND cliProp.modified = 0 AND cliProp.componentNameId =@destClientId), 0)
IF @isIndexV2 = 1
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Destination client ['+@destClientName+'] is on Indexing V2. Indexing V2 does not allow move of subclients.'
	GOTO ARGS_ERROR
END
SET @destBsetId = ISNULL((Select DISTINCT BSN.id from APP_BACKUPSETNAME AS BSN, APP_APPLICATION AS APP
                      where APP.clientId = @destClientId
						AND APP.backupSet = BSN.id
						AND BSN.name = @destBsetName
						AND appTypeId = 13  --CV_APPTYPE_NAS_FS
						), 0)
IF @destBsetId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Backupset ['+@destBsetName+'] does not exist.'
	GOTO ARGS_ERROR
END
IF exists (select 1 from app_application where @destClientId=clientId and @destBsetId=backupSet and subclientName = @srcSCName AND subClientStatus & 2 <>2 AND subclientStatus & 4 <> 4)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Subclient with name ['+@srcSCName+'] already exists in Destination Client'
	GOTO ARGS_ERROR
END
--exists but is deleted,So append the timestamp
IF exists (select 1 from app_application where @destClientId=clientId and @destBsetId=backupSet and subclientName = @srcSCName AND subClientStatus&4 = 4)
BEGIN
UPDATE APP_Application SET subclientName = subclientName+'_'+CAST(modified AS NVARCHAR(10)) WHERE @destClientId=clientId and @destBsetId=backupSet and subclientName = @srcSCName
END
-------------------------Move subclient---------------
BEGIN TRY
BEGIN TRAN
UPDATE APP_Application SET clientId = @destClientId, backupset = @destBsetId, modified = @nowTime
		WHERE  id = @srcSCId
UPDATE SchedBackupTask SET clientId = @destClientId, backupset = @destBsetId
		WHERE clientId = @srcClientId
		AND subclient = @srcSCId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
    set @errorCode = ERROR_NUMBER()
    set @errorString = 'Problems updating Job Result Information ' +ERROR_MESSAGE()
END
END CATCH
IF (@errorCode  = 0)
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
         + '. Exit Code(' +convert(varchar(2), @errorCode) + ').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_MoveNASSubclient')
	delete from GxQscripts where name = 'QS_MoveNASSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MoveNASSubclient')
	delete from GXDBVersions where aliasname = 'QS_MoveNASSubclient'
GO

insert into GXDBVersions values(2, 'QS_MoveNASSubclient',  '00000000000000000000', 'QS_MoveNASSubclient', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_MoveNASSubclient',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn MoveNASSubclient.sql -si source_client_Name -si source_backupset -si source_subclient -si dest_client -si dest_backupset
'
 + CHAR(10) + '--   script_name : MoveNASSubclient'
)
GO

