

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_MoveMediaToStream.sp] ---------- 

  -- ----------------------------------------------------------------------
  --
 --           Copyright (c) 1998  CommVault Systems, Inc.
 --                  All rights reserved.
 --
 --
 --        This is unpublished proprietary source code of CommVault
 --        Systems, Inc. The copyright notice above does not evidence
 --        any actual or intended publication of such source code.
 -- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_MoveMediaToStream')
BEGIN
	print '>>> Drop Stored Procedure: QS_MoveMediaToStream <<<'
	drop procedure QS_MoveMediaToStream
END
IF EXISTS (select * from GxQscripts where name='QS_MoveMediaToStream')
	delete from GxQscripts where name = 'QS_MoveMediaToStream'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MoveMediaToStream')
	delete from GXDBVersions where aliasname = 'QS_MoveMediaToStream'
GO
print '... Creating Procedure: QS_MoveMediaToStream'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_MoveMediaToStream
--Modified for Checkin
--QScript is enabled
-- QScript secure this script does the user validation
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
-- SP Input Params
  @i_StoragePolicy NVARCHAR(2048) = N'',
  @i_StoragePolicyCopy NVARCHAR(2048) = N'',
  @i_DestStreamNum INTEGER = 0,
  @i_SrcStreamNum INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @errorCode INTEGER = 0
DECLARE @errorMessage NVARCHAR(MAX) = N''
DECLARE @l_SPId INTEGER = -1
DECLARE @l_defaultSPCId INTEGER = -1
DECLARE @l_SPCId INTEGER = -1
DECLARE @l_SPCType INTEGER = -1
DECLARE @l_IsSnapCopy INTEGER = -1
DECLARE @l_maxStream INTEGER = 0
DECLARE @l_currentTime INTEGER = dbo.GetUnixTime(GetUTCDate())
BEGIN TRANSACTION
	BEGIN TRY
		SELECT @l_SPId = Id, @l_defaultSPCId = defaultCopy, @l_maxStream = maxStreams
		FROM archGroup WITH (NOLOCK)
		WHERE name = @i_StoragePolicy
		IF @l_SPId = -1
		BEGIN
			SET	@errorCode = -1
			GOTO CX_EXIT
		END
SELECT @l_SPCId = id, @l_SPCType = type, @l_IsSnapCopy = isSnapCopy, @l_maxStream = (CASE WHEN ((flags & 4) = 0) THEN @l_maxStream ELSE maxStreamNum END)
		FROM archGroupCopy WITH (NOLOCK)
		WHERE	name = @i_StoragePolicyCopy
				AND archGroupId = @l_SPId
		SELECT	@errorCode = @@ERROR, @errorMessage = ERROR_MESSAGE()
		IF	@errorCode <> 0 GOTO CX_EXIT
		IF @l_SPCId = -1
		BEGIN
			SET	@errorCode = -2
			GOTO CX_EXIT
		END
		IF (@l_maxStream < @i_DestStreamNum)
		BEGIN
			SET	@errorCode = -3
			GOTO CX_EXIT
		END
		IF @l_IsSnapCopy = 1
		BEGIN
			SET	@errorCode = -5
			GOTO CX_EXIT
		END
		IF (@i_SrcStreamNum != 0) AND NOT EXISTS (SELECT TOP 1 Stream FROM archStream WITH (READUNCOMMITTED) WHERE archGroupCopyId = @l_SPCId AND Stream = @i_SrcStreamNum)
		BEGIN
			SET	@errorCode = -4
			GOTO CX_EXIT
		END
		DECLARE @streamMap TABLE (SrcStreamNum INT, SrcMediaGroupId INT, DestStreamNum INT, DestMediaGroupId INT)
		IF (@i_DestStreamNum = 0 AND @i_SrcStreamNum > 0)
			SET @i_DestStreamNum = 1 + ((@i_SrcStreamNum-1) % @l_maxStream)
		IF (@i_DestStreamNum > 0 AND @i_SrcStreamNum > 0)
		BEGIN
			INSERT INTO @streamMap
			SELECT	S.stream, S.mediaGroupId, @i_DestStreamNum, 0
			FROM	archStream S WITH (READUNCOMMITTED)
			WHERE	S.archGroupCopyId = @l_SPCId
					AND S.Stream = @i_SrcStreamNum
			UPDATE  SM
			SET		DestMediaGroupId = S.mediaGroupId
			FROM	@streamMap SM, archStream S WITH (READUNCOMMITTED)
			WHERE	S.archGroupCopyId = @l_SPCId
					AND SM.DestStreamNum = S.stream
		END
		ELSE IF (@i_DestStreamNum = 0 AND @i_SrcStreamNum = 0)
		BEGIN
			INSERT INTO @streamMap
			SELECT	S.stream, S.mediaGroupId, 1 + ((S.stream-1) % @l_maxStream), 0
			FROM	archStream S WITH (READUNCOMMITTED)
			WHERE	S.archGroupCopyId = @l_SPCId
					AND S.Stream > @l_maxStream
			UPDATE  SM
			SET		DestMediaGroupId = mediaGroupId
			FROM	@streamMap SM, archStream S WITH (READUNCOMMITTED)
			WHERE	S.archGroupCopyId = @l_SPCId
					AND SM.DestStreamNum = S.stream
		END
		UPDATE	M
		SET		LastBackupTime = @l_currentTime, ScheduleRunId = 0
		FROM	MMMedia M, MMVolume MV, @streamMap SM
		WHERE	M.MediaId = MV.MediaId
				AND MV.MediaGroupId = SM.SrcMediaGroupId
				AND (MV.VolumeFlags = 1 /*VOL_ACTIVE*/ OR MV.VolumeFlags = 7 /*VOL_ACTIVE_APPEND*/)
		UPDATE	MV
		SET		MediaGroupId = SM.DestMediaGroupId,
				VolumeFlags = (CASE WHEN MV.VolumeFlags = 1 /*VOL_ACTIVE*/ THEN 7 /*VOL_ACTIVE_APPEND*/ ELSE MV.VolumeFlags END)
		FROM	MMVolume MV, @streamMap SM
		WHERE	MV.MediaGroupId = SM.SrcMediaGroupId
		UPDATE	AFC
		SET		streamNum = SM.DestStreamNum
		FROM	archFileCopy AFC, @streamMap SM
		WHERE	AFC.archCopyId = @l_SPCId
				AND AFC.streamNum = SM.SrcStreamNum
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		ROLLBACK TRANSACTION
		SELECT	@errorCode = ERROR_NUMBER(), @errorMessage = ERROR_MESSAGE()
		;THROW;
	END CATCH
CX_EXIT:
	IF @errorCode <> 0
		ROLLBACK TRANSACTION
	ELSE
		COMMIT TRANSACTION
	IF @errorCode = -1
		SET @errorMessage = 'Error: Invalid Storage Policy Name [' + @i_StoragePolicy + ']'
	ELSE IF @errorCode = -2
		SET @errorMessage = 'Error: Invalid Storage Policy Copy Name [' + @i_StoragePolicyCopy + ']'
	ELSE IF @errorCode = -3
		SET @errorMessage = 'Error: Invalid Destination Stream Number [' + CAST(@i_DestStreamNum AS VARCHAR(20)) + '], It is greater than maximum allowed stream number [' + CAST(@l_maxStream AS VARCHAR(20)) + '].'
	ELSE IF @errorCode = -4
		SET @errorMessage = 'Error: Invalid Source Stream Number [' + CAST(@i_SrcStreamNum AS VARCHAR(20)) + ']. It does not exist on Copy'
	ELSE IF @errorCode = -5
		SET @errorMessage = 'Error: Storage Policy [' + @i_StoragePolicy + '] Storage Policy Copy [' + @i_StoragePolicyCopy + '] is a snap copy'
	ELSE IF @errorCode <> 0
		SET @errorMessage = 'Error: Failed to execute script. Error code [' + CAST(@errorCode AS VARCHAR(20)) + '], Error Message [' + @errorMessage + ']'
	ELSE
		SET @errorMessage = 'MoveMediaToStream completed successfully at '	+ CONVERT(VARCHAR(60), GETDATE())+'.'
	IF @errorCode NOT IN (0)
		Raiserror(@errorMessage,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
	ELSE
		SELECT	@errorMessage
	RETURN  @errorCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_MoveMediaToStream')
	delete from GxQscripts where name = 'QS_MoveMediaToStream'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MoveMediaToStream')
	delete from GXDBVersions where aliasname = 'QS_MoveMediaToStream'
GO

insert into GXDBVersions values(2, 'QS_MoveMediaToStream',  '00000000000000000000', 'QS_MoveMediaToStream', '00000000000000000000')
GO

insert into GxQscripts values(2+8,'QS_MoveMediaToStream',  1, GETDATE(), GETDATE(), '' + CHAR(10) + '  Execute the following command to Move all media from one stream to another stream on a storage policy copy for the auxiliary copy job:
'
 + CHAR(10) + ' qoperation execscript -sn MoveMediaToStream -si StoragePolicyName -si StoragePolicyCopyName
'
 + CHAR(10) + ' All the media from streams greater then Combined Stream on Copy will be moved to lower stream numbers
'
 + CHAR(10) + ' script_name : MoveMediaToStream
'
)
GO

