

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_MigrateMountPathLibraryToLibrary.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- Input XML Format - <MigrateMountPath>  <MountPath id='' name='' /> <SourceLibrary id='' name='' /> <DestinationLibrary id='' name='' /> <User id='' name='' /> </MigrateMountPath>
-- all id and mountpath name are mandatory
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_MigrateMountPathLibraryToLibrary <<<'

IF EXISTS (select * from sysobjects where name='QS_MigrateMountPathLibraryToLibrary')
	drop procedure QS_MigrateMountPathLibraryToLibrary
IF EXISTS (select * from GxQscripts where name='QS_MigrateMountPathLibraryToLibrary')
	delete from GxQscripts where name = 'QS_MigrateMountPathLibraryToLibrary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MigrateMountPathLibraryToLibrary')
	delete from GXDBVersions where aliasname = 'QS_MigrateMountPathLibraryToLibrary'
GO
print '... Creating Procedure: QS_MigrateMountPathLibraryToLibrary'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_MigrateMountPathLibraryToLibrary
  @i_sXML XML,
  @i_flag INTEGER 
AS
SET NOCOUNT ON
--Outputs
  DECLARE @o_sMPName NVARCHAR(MAX)
  DECLARE @o_status NVARCHAR(10)
  DECLARE @o_reason NVARCHAR(MAX)
DECLARE @errorCode INT = 0
DECLARE @errorMsg  NVARCHAR(MAX)
DECLARE @MigrateMountPathList TABLE (iMPId INT, sMPName NVARCHAR(MAX))
DECLARE @MediaAgentsList TABLE (iMediaAgentId INT, sMediaAgentName NVARCHAR(1024))
DECLARE @MigrateInfo TABLE (sMPName NVARCHAR(MAX), sStatus NVARCHAR(20), iErrorCode INT, sReason NVARCHAR(MAX))
DECLARE @iXML int
DECLARE @nodeName NVARCHAR(100)
DECLARE @MigrateMountPathName NVARCHAR(MAX)
DECLARE @MigrateMountPathId INT = 0
DECLARE @newLibId INT = 0
DECLARE @newLibName NVARCHAR(MAX)
DECLARE @oldLibId INT = 0
DECLARE @oldLibName NVARCHAR(MAX)
DECLARE @userId INT = 0
DECLARE @userName NVARCHAR(MAX)
DECLARE @NewMasterPoolId INT = 0
DECLARE @TotalMpCount INT = 0
DECLARE @SuccessMpCount INT = 0
DECLARE @FailedMpCount INT = 0
DECLARE @message NVARCHAR(MAX)
DECLARE @ScriptName NVARCHAR(MAX) = N'MigrateMountPathLibraryToLibrary'
BEGIN TRY
	EXEC sp_xml_preparedocument @iXML OUTPUT, @i_sXML
	SET @NodeName  = '/MigrateMountPath/MountPath'
	INSERT INTO @MigrateMountPathList
	SELECT CONVERT(INTEGER,MountPathId), MountPathName
	FROM OPENXML(@iXML,@nodeName,1)
	WITH
	(
	MountPathId NVARCHAR(10) '@id',
	MountPathName NVARCHAR(100) '@name'
	)
	SET @NodeName  = '/MigrateMountPath/DestinationLibrary'
	SELECT top 1 @newLibId = CONVERT(INTEGER,LibraryId),@newLibName = LibraryName
	FROM OPENXML(@iXML,@nodeName,1)
	WITH
	(
	LibraryId NVARCHAR(10) '@id',
	LibraryName NVARCHAR(100) '@name'
	)
	SET @NodeName  = '/MigrateMountPath/SourceLibrary'
	SELECT top 1 @oldLibId = CONVERT(INTEGER,LibraryId),@oldLibName = LibraryName
	FROM OPENXML(@iXML,@nodeName,1)
	WITH
	(
	LibraryId NVARCHAR(10) '@id',
	LibraryName NVARCHAR(100) '@name'
	)
	SET @NodeName  = '/MigrateMountPath/User'
	SELECT top 1 @userId = CONVERT(INTEGER,UserId),@userName = UserName
	FROM OPENXML(@iXML,@nodeName,1)
	WITH
	(
	UserId NVARCHAR(10) '@id',
	UserName NVARCHAR(100) '@name'
	)
	IF NOT EXISTS(SELECT * FROM MMDataPath MDP, MMDrivePool DP, MMMasterPool MP
						WHERE DP.DrivePoolId = MDP.DrivePoolId
						AND DP.MasterPoolId = MP.MasterPoolId
						AND MP.LibraryId = @newLibId)
	BEGIN
			SET @errorCode = 1
			SET @errorMsg = 'No Data Path found for the Destination Library ' + @newLibName
			RAISERROR(@errorMsg, 16, 1)
	END
	INSERT INTO @MediaAgentsList
	SELECT DISTINCT CL.id, CL.name FROM APP_Client CL, MMDeviceController MDC, MMMountPathToStorageDevice MP2SD, MMMountPath MP
	WHERE MDC.ClientId = CL.id
	AND MP2SD.DeviceId = MDC.DeviceId
	AND MP.MountPathId = MP2SD.MountPathId
	AND MP.LibraryId = @newLibId
	IF EXISTS(SELECT * FROM MMDataPath MDP, MMDrivePool DP, MMMasterPool MP
						WHERE DP.DrivePoolId = MDP.DrivePoolId
						AND DP.MasterPoolId = MP.MasterPoolId
						AND MP.LibraryId = @oldLibId)
	BEGIN
			SET @errorCode = 1
			SET @errorMsg = 'Selected Source library [' + @oldLibName + '] is not a Spare Library.'
			RAISERROR(@errorMsg, 16, 1)
	END
	IF NOT EXISTS(SELECT MasterPoolId FROM MMMasterPool(NOLOCK) WHERE LibraryId = @newLibId)
	BEGIN
			SET @errorCode = 1
			SET @errorMsg = 'Master pool count incorrect for Destination Library ' + @newLibName
			RAISERROR(@errorMsg, 16, 1)
	END
	SELECT @NewMasterPoolId = MasterPoolId FROM MMMasterPool WHERE LibraryId = @newLibId
	IF EXISTS(SELECT 1 FROM MMMountPath(NOLOCK) WHERE MountPathTypeId <> 4 AND libraryId = @newLibId)
	BEGIN
			SET @errorCode = 1
			SET @errorMsg = 'Unsupported mount path types found for Destination Library - ' + @newLibName
			RAISERROR(@errorMsg, 16, 1)
	END
	DECLARE MigrateMountPathCursor CURSOR FOR SELECT iMPId, sMPName FROM @MigrateMountPathList
	OPEN MigrateMountPathCursor
	FETCH NEXT FROM MigrateMountPathCursor INTO @MigrateMountPathId, @MigrateMountPathName
	WHILE @@FETCH_STATUS = 0
	BEGIN
		BEGIN TRY
			BEGIN TRANSACTION TRAN_MIGRATE_MP
			DECLARE @MediaToUpdate TABLE (MediaId INT)
			DECLARE @DeviceCtrlInfo TABLE (DeviceConrollerId INT, ClientId INT, UserName NVARCHAR(1024), UserPassword NVARCHAR(2048))
			DECLARE @oldDeviceCtrlId INT = 0;
			--Update LIBRARY of the MountPath
			UPDATE MMMountPath SET LibraryId = @newLibId, MasterPoolId = @NewMasterPoolId
			WHERE MountPathId =  @MigrateMountPathId
			--Update library of the media of selected mount path that we updated
			UPDATE MMMedia SET LibraryId = @newLibId
			OUTPUT DELETED.MediaId INTO @MediaToUpdate
			FROM MMMedia MED INNER JOIN MMMediaSide MS ON MED.MediaId = MS.MediaId
			INNER JOIN MMMountPath MP1 ON MP1.MediaSideId = MS.MediaSideId
			WHERE MP1.MountPathId = @MigrateMountPathId
			--Update drives of those media that we updated
			UPDATE MMDrive SET MasterPoolId = @NewMasterPoolId
			FROM MMDrive MD INNER JOIN @MediaToUpdate M ON MD.MediaId = M.MediaId
			-- Update or Add DeviceController
			INSERT INTO @DeviceCtrlInfo
			SELECT DC.DeviceControllerId,DC.ClientId,DC.UserName,DC.UserPassword FROM MMMountPath MP, MMMountPathToStorageDevice MP2SD, MMDeviceController DC
			WHERE MP.MountPathId = MP2SD.MountPathId
			AND MP2SD.DeviceId = DC.DeviceId
			AND MP.MountPathId = @MigrateMountPathId
			SELECT TOP 1 @oldDeviceCtrlId = DeviceConrollerId FROM @DeviceCtrlInfo
			-- Creating new Device controllers for migrated mount path
			INSERT INTO MMDeviceController(ClientId, DeviceId, DeviceControllerActive, DeviceControllerEnabled, SNRVolumeId, UseCount, UserName, UserPassword, Folder, DeviceMounted, DeviceAccessible,
			VolumeRecoveryStatus, VolumeRecoveryTime, VolumeScsiReserved, DeviceAccessType, RMStatus, RMStatusUpdateTime, CredentialAssocId)
			SELECT MALST.iMediaAgentId, DC.DeviceId, DC.DeviceControllerActive, DC.DeviceControllerEnabled, DC.SNRVolumeId, DC.UseCount, DC.UserName, DC.UserPassword, DC.Folder, DC.DeviceMounted, DC.DeviceAccessible,
			DC.VolumeRecoveryStatus, DC.VolumeRecoveryTime, DC.VolumeScsiReserved, DC.DeviceAccessType, DC.RMStatus, DC.RMStatusUpdateTime, DC.CredentialAssocId
			FROM @MediaAgentsList MALST, MMDeviceController DC
			WHERE DC.DeviceControllerId = @oldDeviceCtrlId
			-- Deleting existing device controller for migrated mount path
			DELETE FROM MMDeviceController WHERE DeviceControllerId IN (SELECT DeviceConrollerId FROM @DeviceCtrlInfo)
			DELETE FROM @MediaToUpdate
			DELETE FROM @DeviceCtrlInfo
			INSERT INTO @MigrateInfo
			SELECT @MigrateMountPathName,'SUCCEED',0,''
			COMMIT TRANSACTION TRAN_MIGRATE_MP
		END TRY
		BEGIN CATCH
			SET @errorCode = 1
			SET @errorMsg = 'Mount path['+ @MigrateMountPathName +'] migration failed with exception message - ' + ISNULL(ERROR_MESSAGE(), 'UNKNOWN ERROR')
			RAISERROR(@errorMsg, 16, 1)
			INSERT INTO @MigrateInfo
			SELECT @MigrateMountPathName,'FAILED',@errorCode, @errorMsg
			IF @@TRANCOUNT > 0
				ROLLBACK TRANSACTION TRAN_MIGRATE_MP
		END CATCH
		FETCH NEXT FROM MigrateMountPathCursor INTO @MigrateMountPathId, @MigrateMountPathName
	END
	-- GUI AUDIT
	DECLARE @opMsgId    INTEGER
	DECLARE @opEvMsgId  INTEGER
	DECLARE @opId       INTEGER
	DECLARE @paramMsgId INTEGER
	DECLARE @MountPathNameStatus NVARCHAR(MAX) = N''
	DECLARE @status NVARCHAR(10) = N''
	DECLARE @MediaAgentsListStr NVARCHAR(MAX) = N''
	-- SET GUI AUDIT OPERATION (MountPath Migration)
SET @opMsgId = (45 | (CAST(POWER(2, 24) AS BIGINT) * 84))
	EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
	IF @@ERROR != 0
	BEGIN
		SET @errorMsg= N'Failed to audit delete media operation by script DeleteMediaFromList.'
		SET @errorCode = 2
		GOTO SCRIPT_EXIT
	END
	-- SET GUI AUDIT PARAMETER
	-- ScriptName
SET @paramMsgId  = (468 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	EXEC EvGuiAuditSetParamData @opId, @ScriptName, 0
	IF @@ERROR != 0
	BEGIN
		SET @errorMsg= N'Failed to audit mount path migration operation by script ' + @ScriptName
		SET @errorCode = 2
		GOTO SCRIPT_EXIT
	END
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
	IF @@ERROR != 0
	BEGIN
		SET @errorMsg= N'Failed to audit mount path migration operation by script ' + @ScriptName
		SET @errorCode  = 2
		GOTO SCRIPT_EXIT
	END
	IF @i_flag = 1
	BEGIN
SET @paramMsgId  = (276 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParamData @opId, 'Spare Mount Path Migration Workflow', 0
		IF @@ERROR != 0
		BEGIN
			SET @errorMsg= N'Failed to audit some of the mountpath migration information.'
			SET @errorCode = 2
		END
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		IF @@ERROR != 0
		BEGIN
			SET @errorMsg= N'Failed to audit some of the mountpath migration information.'
			SET @errorCode  = 2
		END
	END
	-- Source Library
SET @paramMsgId  = (191 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	EXEC EvGuiAuditSetParamData @opId, @oldLibName, 0
	IF @@ERROR != 0
	BEGIN
		SET @errorMsg= N'Failed to audit source library information for mountpath migration operation by script ' + @ScriptName
		SET @errorCode = 2
		GOTO SCRIPT_EXIT
	END
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
	IF @@ERROR != 0
	BEGIN
		SET @errorMsg= N'Failed to audit source library information for mountpath migration operation by script ' + @ScriptName
		SET @errorCode  = 2
		GOTO SCRIPT_EXIT
	END
	-- Destination Library
SET @paramMsgId  = (192 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	EXEC EvGuiAuditSetParamData @opId, @newLibName, 0
	IF @@ERROR != 0
	BEGIN
		SET @errorMsg= N'Failed to audit destination library information for mountpath migration operation by script ' + @ScriptName
		SET @errorCode = 2
		GOTO SCRIPT_EXIT
	END
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
	IF @@ERROR != 0
	BEGIN
		SET @errorMsg= N'Failed to audit destination library information for mountpath migration operation by script ' + @ScriptName
		SET @errorCode  = 2
		GOTO SCRIPT_EXIT
	END
	-- MountPath status
	DECLARE MPCursor CURSOR FOR SELECT sMPName, sStatus FROM @MigrateInfo
	OPEN MPCursor
	FETCH NEXT FROM MPCursor INTO @MigrateMountPathName,@status
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @MountPathNameStatus = @MigrateMountPathName + ', Status : ' + @status
SET @paramMsgId  = (196 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParamData @opId, @MountPathNameStatus, 0
		IF @@ERROR != 0
		BEGIN
			SET @errorMsg= N'Failed to audit some of the mountpath migration information.'
			SET @errorCode = 2
		END
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		IF @@ERROR != 0
		BEGIN
			SET @errorMsg= N'Failed to audit some of the mountpath migration information.'
			SET @errorCode  = 2
		END
		FETCH NEXT FROM MPCursor INTO @MigrateMountPathName, @status
	END
	-- Media Agents
	SELECT @MediaAgentsListStr = coalesce(@MediaAgentsListStr + ', ',' ') + sMediaAgentName FROM @MediaAgentsList
SET @paramMsgId  = (978 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	EXEC EvGuiAuditSetParamData @opId, @MediaAgentsListStr, 0
	IF @@ERROR != 0
	BEGIN
		SET @errorMsg= N'Failed to audit media agents information for mountpath migration operation.'
		SET @errorCode = 2
	END
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
	IF @@ERROR != 0
	BEGIN
		SET @errorMsg= N'Failed to audit media agents information for mountpath migration operation.'
		SET @errorCode  = 2
	END
	DELETE FROM @MediaAgentsList
	DELETE FROM @MigrateMountPathList
END TRY
BEGIN CATCH
	SET @errorCode = 1
    SET @errorMsg = 'Script failed with exception message - ' + ISNULL(ERROR_MESSAGE(), 'UNKNOWN ERROR')
    RAISERROR(@errorMsg, 16, 1)
END CATCH
SCRIPT_EXIT:
IF @errorCode = 1
BEGIN
	 SELECT 'MESSAGE:'+@errorMsg
END
ELSE
BEGIN
	IF @errorCode = 2
		SELECT @errorMsg
	SELECT @TotalMpCount=COUNT(*) FROM @MigrateInfo
	SELECT @SuccessMpCount = COUNT(*) FROM @MigrateInfo WHERE sStatus = 'SUCCEED'
	SELECT @FailedMpCount = COUNT(*) FROM @MigrateInfo WHERE sStatus = 'FAILED'
	SET @message = 'MESSAGESTART:Mount path(s) migration result: Total ['+CONVERT(NVARCHAR(10), @TotalMpCount)+'], Success ['+CONVERT(NVARCHAR(10), @SuccessMpCount)+'], Failed ['+CONVERT(NVARCHAR(10), @FailedMpCount)+']. MESSAGEEND' ;
	SELECT @message
	SELECT sMPName AS 'Mount Path', '	',sStatus AS 'Migration Status', '		',	sReason AS 'Failure Reason' from @MigrateInfo
END
DELETE FROM @MigrateInfo
GO

IF EXISTS (select * from GxQscripts where name = 'QS_MigrateMountPathLibraryToLibrary')
	delete from GxQscripts where name = 'QS_MigrateMountPathLibraryToLibrary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MigrateMountPathLibraryToLibrary')
	delete from GXDBVersions where aliasname = 'QS_MigrateMountPathLibraryToLibrary'
GO

insert into GXDBVersions values(2, 'QS_MigrateMountPathLibraryToLibrary',  '00000000000000000000', 'QS_MigrateMountPathLibraryToLibrary', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_MigrateMountPathLibraryToLibrary',  3, GETDATE(), GETDATE(), '')
GO

