

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_MediaRefreshGetDependentMediaList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_MediaRefreshGetDependentMediaList.sp,v $ $Id: QS_MediaRefreshGetDependentMediaList.sp,v 1.1.4.4 2018/03/20 19:54:40 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_MediaRefreshGetDependentMediaList <<<'

IF EXISTS (select * from sysobjects where name='QS_MediaRefreshGetDependentMediaList')
	drop procedure QS_MediaRefreshGetDependentMediaList
IF EXISTS (select * from GxQscripts where name='QS_MediaRefreshGetDependentMediaList')
	delete from GxQscripts where name = 'QS_MediaRefreshGetDependentMediaList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MediaRefreshGetDependentMediaList')
	delete from GXDBVersions where aliasname = 'QS_MediaRefreshGetDependentMediaList'
GO
print '... Creating Procedure: QS_MediaRefreshGetDependentMediaList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_MediaRefreshGetDependentMediaList
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @sInputBarCodes VARCHAR(1024)
AS
SET NOCOUNT ON
DECLARE @tInputBarCode NVARCHAR(256) = ''
--DECLARE @StartIndex INT, @EndIndex INT
IF object_id('tempdb.dbo.#inPutBarCodes') IS  NOT null DROP TABLE #inPutBarCodes
CREATE TABLE #inPutBarCodes ( barCode nvarchar(256))
DECLARE @str_command nvarchar(max)
SET @str_command = 'BULK
INSERT #inPutBarCodes
FROM '''+ @sInputBarCodes +
'''WITH
(
FIELDTERMINATOR = '','',
ROWTERMINATOR = ''\n''
)'
EXEC SP_EXECUTESQL @str_command
	IF object_id('tempdb.dbo.#TmpMRDepMediaUI') IS  NOT null DROP TABLE #TmpMRDepMediaUI
IF object_id('tempdb.dbo.#TmpMRDepMediaResultSet') IS  NOT null DROP TABLE #TmpMRDepMediaResultSet
 CREATE TABLE #TmpMRDepMediaUI(VolumeId INT)
CREATE TABLE #TmpMRDepMediaResultSet(BucketId INT, VolumeId INT, VolumeFlags INT,VolumeAttributes INT,
            MediaId INT, MediaLocation INT, MediaFlags INT)
DECLARE cursor_ CURSOR
  LOCAL STATIC READ_ONLY FORWARD_ONLY
  FOR
  SELECT barCode from #inPutBarCodes
  OPEN cursor_
FETCH NEXT FROM cursor_ INTO @tInputBarCode
WHILE @@FETCH_STATUS = 0
BEGIN
	--print @tInputBarCode
	IF NOT EXISTS( SELECT * FROM MMMedia WITH (NOLOCK) WHERE barcode = @tInputBarCode)
	BEGIN
		print 'Media with Barcode '+@tInputBarCode+ ' does not exists'
		FETCH NEXT FROM cursor_ INTO @tInputBarCode
		continue
	END
    INSERT INTO #TmpMRDepMediaUI
	SELECT v.VolumeID
	FROM MMVolume v WITH (NOLOCK), MMMedia m  WITH (NOLOCK)
	WHERE v.MediaId = m.MediaID AND m.barCode =  @tInputBarCode
	EXEC archMediaRefreshGetDependentMedia
	print 'Barcodes for media dependent on :' + @tInputBarCode
	SELECT m.BarCode
	FROM  #TmpMRDepMediaResultSet t,MMMedia m  WITH (NOLOCK)
	WHERE t.MediaId = m.MediaID
	AND   m.BarCode != @tInputBarCode
	Delete #TmpMRDepMediaResultSet
	Delete #TmpMRDepMediaUI
	FETCH NEXT FROM cursor_ INTO @tInputBarCode
END
IF object_id('tempdb.dbo.#inPutBarCodes') IS  NOT null DROP TABLE #inPutBarCodes
IF object_id('tempdb.dbo.#TmpMRDepMediaUI') IS  NOT null DROP TABLE #TmpMRDepMediaUI
IF object_id('tempdb.dbo.#TmpMRDepMediaResultSet') IS  NOT null DROP TABLE #TmpMRDepMediaResultSet
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_MediaRefreshGetDependentMediaList')
	delete from GxQscripts where name = 'QS_MediaRefreshGetDependentMediaList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MediaRefreshGetDependentMediaList')
	delete from GXDBVersions where aliasname = 'QS_MediaRefreshGetDependentMediaList'
GO

insert into GXDBVersions values(2, 'QS_MediaRefreshGetDependentMediaList',  '00010001000400040000', 'QS_MediaRefreshGetDependentMediaList', '00010001000400040000')
GO

insert into GxQscripts values(2,'QS_MediaRefreshGetDependentMediaList',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		To get dependent media for a Media barCode list'
 + CHAR(10) + '-- 		qoperation execscript -sn MediaRefreshGetDependentMediaList -si inputMediaBarCodesFullPath'
 + CHAR(10) + '-- 		To get dependent media for a Media barCode list Example for barcodes 446AAWL6 and 457AAWL6'
 + CHAR(10) + '-- 		qoperation execscript -sn MediaRefreshGetDependentMediaList -si ''C:\inPutBarCodes.csv'''
 + CHAR(10) + '-- 		inPutBarCodes.csv content:'
 + CHAR(10) + '		446AAWL6
'
 + CHAR(10) + '		457AAWL6
'
)
GO

