

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_MarkSystemMarkedJobsGoodOnCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_MarkSystemMarkedJobsGoodOnCopy.sp,v $ $Id: QS_MarkSystemMarkedJobsGoodOnCopy.sp,v 1.1.4.5 2018/03/20 20:03:47 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_MarkSystemMarkedJobsGoodOnCopy <<<'

IF EXISTS (select * from sysobjects where name='QS_MarkSystemMarkedJobsGoodOnCopy')
	drop procedure QS_MarkSystemMarkedJobsGoodOnCopy
IF EXISTS (select * from GxQscripts where name='QS_MarkSystemMarkedJobsGoodOnCopy')
	delete from GxQscripts where name = 'QS_MarkSystemMarkedJobsGoodOnCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MarkSystemMarkedJobsGoodOnCopy')
	delete from GXDBVersions where aliasname = 'QS_MarkSystemMarkedJobsGoodOnCopy'
GO
print '... Creating Procedure: QS_MarkSystemMarkedJobsGoodOnCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_MarkSystemMarkedJobsGoodOnCopy
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @inputFIle varchar(1024)='',
  @archGorupName varchar(256)='',	-- 'writers', 'useunbuffio', 'reservespace'
  @copyName varchar(1024)='' ,
  @commCellId INT='' ,
  @authCodeStr varchar(1024)=''
AS
Set NOCOUNT ON
DECLARE 	@errCode		INTEGER
DECLARE 	@errString		NVARCHAR(3192)
DECLARE 	@authCode		INTEGER
DECLARE		@CommCellNumber INTEGER
DECLARE		@copyID			INTEGER = 0
SET @errCode  = 0
SET @errString = 'No Error'
SET @authCode = CAST(@authCodeStr AS INT)
select @CommCellNumber = number
FROM APP_CommCell
WHERE id = @commCellId
SELECT @copyID = agc.id
FROM archGroupCopy agc, archGroup ag
WHERE agc.archGroupId = ag.id
AND agc.name = @copyName
AND ag.name = @archGorupName
IF @@ROWCOUNT = 0
BEGIN
	SET @errCode = 1
	SET @errString = 'Incorrect Storage Policy/Copy Name '
	GOTO SCRIPT_EXIT
END
IF object_id('tempdb.dbo.#jobs') IS  NOT null DROP TABLE #jobs
CREATE TABLE #jobs ( jobId bigint)
DECLARE @str_command nvarchar(max)
SET @str_command = 'BULK
INSERT #jobs
FROM '''+ @inputFIle +
'''WITH
(
FIELDTERMINATOR = '','',
ROWTERMINATOR = ''\n''
)'
EXEC SP_EXECUTESQL @str_command
/*
print CHECKSUM(HASHBYTES('SHA1', N'<' +
				CAST(@CommCellNumber AS NVARCHAR(100)) +
				N'>' + CAST(@copyID AS NVARCHAR(100)) ))*/
IF @authCode != CHECKSUM(HASHBYTES('SHA1', N'<' +
				CAST(@CommCellNumber AS NVARCHAR(100)) +
				N'>' + CAST(@copyID AS NVARCHAR(100)) ))
BEGIN
	SET @errCode = 2
	SET @errString = 'Incorrect AuthCode Supplied '
	GOTO SCRIPT_EXIT
END
BEGIN TRAN
IF NOT EXISTS (SELECT  1
FROM JMJobDataStats jds, #jobs j
WHERE jds.jobId = j.jobId
 AND archGrpCopyId = @copyID
  AND jds.commCellID = @commCellId
AND jds.disabled & 4096 = 0
AND jds.disabled & 64 > 0)
BEGIN
	SET @errCode = 3
	SET @errString = 'Error: None of the jobs given in the input file was marked bad by Data Verification'
	GOTO SCRIPT_EXIT
END
print 'Following jobs will be marked good'
SELECT  DISTINCT jds.jobID
FROM JMJobDataStats jds, #jobs j
WHERE jds.jobId = j.jobId
 AND archGrpCopyId = @copyID
  AND jds.commCellID = @commCellId
AND jds.disabled & 4096 = 0
AND jds.disabled & 64 > 0
UPDATE JMJobDataStats
SET disabled = disabled & ~ (64+ 1)
FROM JMJobDataStats jds, #jobs j
WHERE jds.jobId = j.jobId
 AND archGrpCopyId = @copyID
  AND jds.commCellID = @commCellId
AND jds.disabled & 4096 = 0
AND jds.disabled & 64 > 0
IF @@ERROR <>0  OR @@ROWCOUNT = 0
BEGIN
	SET @errCode = 3
	SET @errString = 'Error: None of the jobs given in the input file was marked bad by Data Verification'
	GOTO SCRIPT_EXIT
END
 UPDATE archChunkMapping
SET flags = (flags &~ (2| 8192) )| 1
 FROM archChunkMapping acm, #jobs j
 WHERE j.jobId =  acm.jobID
 AND archCopyId  = @copyID
 AND acm.commCellID = @commCellId
 AND acm.chunkCommCellId = @commCellId
IF @@ERROR <>0
BEGIN
	SET @errCode = 4
	SET @errString = 'Error when updating arhChunkMapping'
	GOTO SCRIPT_EXIT
END
COMMIT TRAN
SCRIPT_EXIT:
SET NOCOUNT OFF
IF object_id('tempdb.dbo.#jobs') IS  NOT null DROP TABLE #jobs
IF(@errCode  = 0 )
BEGIN
	PRINT 'Successfully completed running script.'
END
ELSE
BEGIN
		IF @@TRANCOUNT > 0
			ROLLBACK TRAN
		Raiserror(@errString,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_MarkSystemMarkedJobsGoodOnCopy')
	delete from GxQscripts where name = 'QS_MarkSystemMarkedJobsGoodOnCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MarkSystemMarkedJobsGoodOnCopy')
	delete from GXDBVersions where aliasname = 'QS_MarkSystemMarkedJobsGoodOnCopy'
GO

insert into GXDBVersions values(2, 'QS_MarkSystemMarkedJobsGoodOnCopy',  '00010001000400050000', 'QS_MarkSystemMarkedJobsGoodOnCopy', '00010001000400050000')
GO

insert into GxQscripts values(2,'QS_MarkSystemMarkedJobsGoodOnCopy',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '	Command to mark list of jobs in a given file as good: qoperation execscript -sn MarkSystemMarkedJobsGoodOnCopy -si inputFilePath -si storagePolicy_name -si copyName -si commCellId -si authCodeStr
'
 + CHAR(10) + '-- 	Please enter the jobIDs in the input file seperated by a new line For example:'
 + CHAR(10) + '-- 	JobId1'
 + CHAR(10) + '-- 	JobId2'
 + CHAR(10) + '-- 	JobID3'
)
GO

