

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_MarkOldSynthfullsForCISuccess.sp] ---------- 

SET ANSI_NULLS ON
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_MarkOldSynthfullsForCISuccess.sp,v $ $Id: QS_MarkOldSynthfullsForCISuccess.sp,v 1.3.14.1 2018/03/20 19:56:07 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_MarkOldSynthfullsForCISuccess <<<'

IF EXISTS (select * from sysobjects where name='QS_MarkOldSynthfullsForCISuccess')
	drop procedure QS_MarkOldSynthfullsForCISuccess
IF EXISTS (select * from GxQscripts where name='QS_MarkOldSynthfullsForCISuccess')
	delete from GxQscripts where name = 'QS_MarkOldSynthfullsForCISuccess'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MarkOldSynthfullsForCISuccess')
	delete from GXDBVersions where aliasname = 'QS_MarkOldSynthfullsForCISuccess'
GO
print '... Creating Procedure: QS_MarkOldSynthfullsForCISuccess'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_MarkOldSynthfullsForCISuccess
-- This script picks archive files belonging to the latest syntheticfull for content indexing. Archive files belonging to earlier syntheticfull
-- jobs are marked complete. Delete entries for archive files of earlier syntheticfull jobs.
-- Outputs the job ids which are affected and the number of rows updated in database.
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--  4 Corresponds to "high", same as same functionality in GUI.  Macro doesn't expand right for some reason
-- Qscript Usage.
  @StoragePolicyName nvarchar(max) = N'',
  @SubclientIds varchar(max) = N''
AS
SET NOCOUNT ON
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(64) = 'QS_MarkOldSynthfullsForCISuccess'
DECLARE @localErrorCode	integer = 0
DECLARE @localMsg		varchar(512) ='Successful.'
DECLARE @NoParameter		varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @rowCount int = 0
DECLARE @JOBSPicked VARCHAR(MAX)
DECLARE @archGroupId int = 0
-------------------------------------------------------------
if not exists (select Id from archGroup where name = @StoragePolicyName)
begin
	SET @localMsg = 'Usage: Storage Policy must contain the name of storage policy. SubclientIds must be be equal to ALL OR the list of subclient-ids (comma separated).'
	GOTO ERROR_EXIT
end
--
select @archGroupId = id from archGroup where name = @StoragePolicyName
--
declare @InputAppIds table
(
	Id int primary key
)
--
--
begin try
	if @SubclientIds = 'ALL'
	begin
		insert into  @InputAppIds (Id)
		select
			distinct app.Id
		from
			APP_Application app WITH (NOLOCK)
		inner join
			APP_ClientProp cp WITH (NOLOCK)
		on
			cp.componentNameId = app.clientId and cp.attrName = N'Content Indexing Enabled'
			and cp.attrVal = N'1'
		where
			dataArchGrpID = @archGroupId
	end
	else begin
		insert into @InputAppIds
		SELECT Data FROM dbo.SplitString(@SubclientIds, ',')
	end
	--
	--
	if OBJECT_ID('tempdb..#AppIds') is not null drop table #AppIds
	create table #AppIds
	(
		Id int primary key,
		ClientId int,
		MaxContentIndexedBkpJobId int,
		LatestSFJobId int
	);
	--
	-- List of valid app Ids
	insert into #AppIds (Id, ClientId)
	select
		i.Id, a.clientId from @InputAppIds i
	inner join
		APP_Application a with (nolock) on a.Id = i.Id
	inner join
		APP_ClientProp cp WITH (NOLOCK)
	on
		cp.componentNameId = a.clientId and cp.attrName = N'Content Indexing Enabled'
		and cp.attrVal = N'1'
	where
		a.dataArchGrpID = @archGroupId
	--
	--
	if not exists (select * from #AppIds)
	begin
		SET @localMsg = 'Usage: There are no valid subclients for the specified storage policy to process.'
		GOTO ERROR_EXIT
	end
	--
	--
	update #AppIds
		set MaxContentIndexedBkpJobId = T.MaxJobId
	from #AppIds app
	inner join
	(
		select
			ai.Id, max(a.JobId) MaxJobId from #AppIds ai
		inner join
			archFile a with (nolock) on a.appId = ai.Id and a.fileType = 1
		group by
			ai.Id, a.jobId
		having
			min(a.flags) = 64 /*CVA_AF_CI_SUCCESS_FLAG*/ and max(a.flags) = 64 /*CVA_AF_CI_SUCCESS_FLAG*/
	) T
	on
		T.Id = app.Id
	--
	--
	update #AppIds set LatestSFJobId = T.LastSF
	from #AppIds app
	inner join
	(
		select a.Id, max(j.JobId) LastSF from #AppIds a inner join JMBkpStats j
		on j.appId = a.Id
		and j.bkpLevel in (0x1 /*FULL*/, 0x40 /*SYNTHETIC_FULL*/, 0x80 /*SYNTHETIC_FULL_AND_INCR*/, 0x4000 /*SYNTHETIC_FULL_AND_INCR_BEFORE*/)
		group by a.Id
	) T
	on
		T.Id = app.Id
	--
	--
	declare @AffectedJobIds table
	(
		jobId int
	)
	--
	--
	begin transaction
	update
		archFile
	set
		flags = 64 /*CVA_AF_CI_SUCCESS_FLAG*/
	output
		inserted.jobId
	into
		@AffectedJobIds
	from
		archFile a
	inner join #AppIds app
	on
		app.Id = a.appId
	inner join
		JMBkpStats j with (nolock)
	on
		j.jobId = a.jobId and j.commCellId = a.commCellId
		and j.bkpLevel in (0x40 /*SYNTHETIC_FULL*/, 0x80 /*SYNTHETIC_FULL_AND_INCR*/, 0x4000 /*SYNTHETIC_FULL_AND_INCR_BEFORE*/)
		and j.jobId < app.LatestSFJobId
	where
		a.flags & 16 <> 0 or a.flags & 32 <> 0	and a.filetype = 1
	--
	set @rowcount = @@rowcount
	--
	--
	if @rowcount > 0
	begin
		delete
			archContentIndexingRestart
		from
			archContentIndexingRestart r
		inner join archFile a on a.id = r.archFileId and a.commCellId = r.commCellId
		inner join @AffectedJobIds afj on a.jobId = afj.jobId
	end
	--
	--
	if exists (select * from @AffectedJobIds)
	begin
		SELECT @JOBSPicked =  COALESCE( @JOBSPicked + ',', '') + CONVERT(VARCHAR(10),JOBID) FROM @AffectedJobIds
		GROUP BY JOBID
	end
	else begin
		SELECT @JOBSPicked = 'No jobs affected'
	end
	--
	SET @localMsg = @localMsg + '. Jobs affected: ' + @JOBSPicked
	--
end try
begin catch
	SET @localErrorCode = ERROR_NUMBER()
	SELECT @localMsg = @scriptName + ' Failed with error: ' + ERROR_MESSAGE()
end catch
--
--
ERROR_EXIT:
	IF (OBJECT_ID('tempdb.dbo.#AppIds') IS NOT NULL) DROP TABLE #AppIds
	if @@trancount > 0
	begin
		IF @localErrorCode <> 0 ROLLBACK TRAN
		ELSE COMMIT TRAN
	end
	PRINT ''
	PRINT @scriptName + ' completed at '
					+ Convert(varchar(60), getdate())+' with parameters '
					+ 'Storage Policy ['+ @StoragePolicyName + ']. Subclient Ids [' + @SubclientIds + ']. '
					+ @localMsg
					+ '. ErrorCode (' + Convert(varchar(2),@localErrorCode) +').'
	IF @localErrorCode > 0
	BEGIN
		Raiserror(@localMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
	END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_MarkOldSynthfullsForCISuccess')
	delete from GxQscripts where name = 'QS_MarkOldSynthfullsForCISuccess'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MarkOldSynthfullsForCISuccess')
	delete from GXDBVersions where aliasname = 'QS_MarkOldSynthfullsForCISuccess'
GO

insert into GXDBVersions values(2, 'QS_MarkOldSynthfullsForCISuccess',  '00010003001400010000', 'QS_MarkOldSynthfullsForCISuccess', '00010003001400010000')
GO

insert into GxQscripts values(2,'QS_MarkOldSynthfullsForCISuccess',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '		Storage policy name input must be specified.
'
 + CHAR(10) + '		Note: If jobs for subclients need to be processed, the value of subclientIds should be ALL.
'
 + CHAR(10) + '		Note: Only NOT PICKED jobs will be marked as picked. Output returns what jobs are affected and number of rows updated in Database.
'
)
GO

