

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_MarkJobsToAuxCopyWithPriority.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_MarkJobsToAuxCopyWithPriority')
BEGIN
	print '>>> Drop Stored Procedure: QS_MarkJobsToAuxCopyWithPriority <<<'
	drop procedure QS_MarkJobsToAuxCopyWithPriority
END
IF EXISTS (select * from GxQscripts where name='QS_MarkJobsToAuxCopyWithPriority')
	delete from GxQscripts where name = 'QS_MarkJobsToAuxCopyWithPriority'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MarkJobsToAuxCopyWithPriority')
	delete from GXDBVersions where aliasname = 'QS_MarkJobsToAuxCopyWithPriority'
GO
print '... Creating Procedure: QS_MarkJobsToAuxCopyWithPriority'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_MarkJobsToAuxCopyWithPriority
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @StoragePolicyName NVARCHAR(512) = N'',
  @CopyName NVARCHAR(512) = N'',	
  @OperationType NVARCHAR(50)  = N'',
  @JobIds NVARCHAR(MAX) = N'',
  @InputJobFilePath NVARCHAR(MAX)= N'',
  @CommCellName NVARCHAR(512) = N''			
AS
SET NOCOUNT ON
DECLARE @archGroupId 	INT = 0
DECLARE @copyId			INT	= 0
DECLARE @opMsgId        INT = 0
DECLARE @opEvMsgId      INT = 0
DECLARE @opId           INT = 0
DECLARE @paramMsgId     INT = 0
DECLARE @JobXML			XML
DECLARE @errorCode    INT = 0
DECLARE @commCellId  INTEGER = 0;
-- Assume admin user here
DECLARE @GUIAuditUserId INT = 1    -- we do not have any way to determine user id.
DECLARE @successJobIdStr NVARCHAR(MAX) = N''
IF OBJECT_ID('#inputJobsIdStr') IS NOT NULL DROP TABLE #inputJobsIdStr
CREATE  TABLE  #inputJobsIdStr(jobId NVARCHAR(MAX))
IF OBJECT_ID('#inputJobIds') IS NOT NULL DROP TABLE #inputJobIds
CREATE  TABLE #inputJobIds(jobId INT, commCellId INT PRIMARY KEY(jobId, commCellId))
/* Output Table
CREATE TABLE #QS_MarkJobsToAuxCopyWithPriority_Output(Msg NVARCHAR(MAX))
*/
DECLARE @op INT = 0
DECLARE @errorTable TABLE(id INT IDENTITY(1,1), Msg NVARCHAR(MAX))
DECLARE @now INT = dbo.GetUnixTime(GETUTCDATE())
BEGIN TRY
	BEGIN TRAN
	IF @CommCellName <> N''
	BEGIN
		select @commCellId = id from APP_Commcell WITH (READUNCOMMITTED) where aliasName = @CommCellName
		IF @commCellId = 0
		BEGIN
			INSERT @errorTable
			SELECT 'Input commcell name is not exists. Please provide correct commcell name.'
			GOTO CX_EXIT
		END
	END
	ELSE
	BEGIN
		SET @commCellId = 2  -- Default commcell id
	END
	IF @StoragePolicyName  = N''
	BEGIN
		INSERT @errorTable
		SELECT 'Storage policy name is not provided.'
		GOTO CX_EXIT
	END
	ELSE
	BEGIN
		SELECT @archGroupId = id
		FROM archGroup WITH (NOLOCK)
		WHERE name = @StoragePolicyName
		IF @archGroupId = 0
		BEGIN
			INSERT @errorTable
			SELECT 'Invalid Storage policy name.'
			GOTO CX_EXIT
		END
	END
	IF @CopyName	= N''
	BEGIN
		INSERT @errorTable
		SELECT 'Copy name is not provided.'
		GOTO CX_EXIT
	END
	ELSE
	BEGIN
		SELECT @copyId = id
		FROM archGroupCopy WITH (NOLOCK)
		WHERE name = @CopyName AND archGroupId = @archGroupId
		IF @copyId = 0
		BEGIN
			INSERT @errorTable
			SELECT 'Invalid Copy name.'
			GOTO CX_EXIT
		END
		IF EXISTS(SELECT * FROM archGroupCopy WHERE id = @copyId AND flags & 524288 = 524288    /*CVA_SILO_COPY_FLAG*/)
		BEGIN
			INSERT @errorTable
			SELECT 'Input Copy is a SILO copy, for which any operation is not allowed.'
			GOTO CX_EXIT
		END
	END
	IF @OperationType = N''
	BEGIN
		INSERT @errorTable
		SELECT 'operation type is not provided.'
		GOTO CX_EXIT
	END
	ELSE IF LOWER(@OperationType) = 'set'
		SET @op = 1
	ELSE IF LOWER(@OperationType) = 'reset'
		SET @op = 2
	ELSE
	BEGIN
		INSERT @errorTable
		SELECT 'Invalid operation type'
		GOTO CX_EXIT
	END
	IF @JobIds <> N''
	BEGIN
		INSERT INTO #inputJobsIdStr
		SELECT *
		FROM dbo.SplitStringByDelimiter(@JobIds, ',')
	END
	ELSE IF @InputJobFilePath <> N''
	BEGIN
		DECLARE @query NVARCHAR(1024) = N'BULK INSERT #inputJobsIdStr FROM ''' + @InputJobFilePath + ''' WITH ( ROWTERMINATOR = ''\n'')'
		EXEC (@query)
		IF @@ERROR <> 0
		BEGIN
			INSERT @errorTable
			SELECT 'ErrorCode: ' + CONVERT(NVARCHAR(MAX),@@ERROR) + ', Error Message: ' + ERROR_MESSAGE()
			GOTO CX_EXIT
		END
	END
	ELSE
	BEGIN
		INSERT @errorTable
		VALUES('JobIds input argument or input JobId file path are not provided, any one of the argument should be provided')
		GOTO CX_EXIT
	END
	INSERT @errorTable
	SELECT 'Invalid Character in jobId: ' + jobId
	FROM #inputJobsIdStr
	WHERE  RTRIM(LTRIM(REPLACE(jobId, CHAR(13)+CHAR(10),''))) LIKE '%[^0-9]%'
	IF EXISTS (SELECT * FROM @errorTable)
	GOTO CX_EXIT
	INSERT #inputJobIds
	SELECT CONVERT(INT, RTRIM(LTRIM(REPLACE(jobId, CHAR(13)+CHAR(10),'')))), @commCellId
	FROM #inputJobsIdStr
	IF @@ERROR <> 0
	BEGIN
		INSERT @errorTable
		SELECT 'ErrorCode: ' + CONVERT(NVARCHAR(MAX),@@ERROR) + ', Error Message: ' + ISNULL(ERROR_MESSAGE(), ' ')
		GOTO CX_EXIT
	END
	DELETE #inputJobIds
	WHERE jobId = 0
	IF EXISTS (SELECT *	FROM #inputJobIds I
		LEFT OUTER JOIN  JMJobDataStats J WITH (NOLOCK)
		ON I.jobId = J.jobId AND I.commCellId = J.commCellId AND J.archGrpId = @archGroupId WHERE J.jobId IS NULL )
	BEGIN
		INSERT @errorTable
		VALUES('Below jobs do not belong to input storage policy copy: ')
		INSERT @errorTable
		SELECT I.jobId
		FROM #inputJobIds I
		LEFT OUTER JOIN
		JMJobDataStats J WITH (NOLOCK)
		ON I.jobId = J.jobId AND I.commCellId = J.commCellId AND J.archGrpId = @archGroupId
		WHERE J.jobId IS NULL
		DELETE #inputJobIds
		FROM #inputJobIds I
		LEFT OUTER JOIN
		JMJobDataStats J WITH (NOLOCK)
		ON I.jobId = J.jobId AND I.commCellId = J.commCellId AND J.archGrpId = @archGroupId
		WHERE J.jobId IS NULL
		IF NOT EXISTS (SELECT * FROM #inputJobIds)
			GOTO CX_EXIT
	END
	IF @@ERROR <> 0
	BEGIN
		INSERT @errorTable
		SELECT 'ErrorCode: ' + CONVERT(NVARCHAR(MAX),@@ERROR) + ', Error Message: ' + ISNULL(ERROR_MESSAGE(), ' ')
		GOTO CX_EXIT
	END
	IF @op = 1
	BEGIN
		UPDATE	JDS
SET		flags |= 1
		FROM	JMJobDataStats JDS, #inputJobIds J
		WHERE	JDS.JobId = J.JobId
				AND JDS.CommCellId = J.CommCellId
				AND JDS.archGrpCopyId = @copyId
	END
	ELSE IF @op = 2
	BEGIN
		UPDATE	JDS
SET		flags &= ~1
		FROM	JMJobDataStats JDS, #inputJobIds J
		WHERE	JDS.JobId = J.JobId
				AND JDS.CommCellId = J.CommCellId
				AND JDS.archGrpCopyId = @copyId
	END
	COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	IF (@@TRANCOUNT > 0)
		ROLLBACK TRAN
	;THROW;
END CATCH
CX_EXIT:
	IF EXISTS (SELECT * FROM @errorTable)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#QS_MarkJobsToAuxCopyWithPriority_Output') IS NOT NULL
		BEGIN
			INSERT INTO #QS_MarkJobsToAuxCopyWithPriority_Output
			SELECT	Msg
			FROM	@errorTable
		END
		ELSE
		BEGIN
			SELECT Msg FROM @errorTable
		END
	END
	IF (@@TRANCOUNT > 0)
		ROLLBACK TRAN
IF OBJECT_ID('#inputJobsIdStr') IS NOT NULL DROP TABLE #inputJobsIdStr
IF OBJECT_ID('#inputJobIds') IS NOT NULL DROP TABLE #inputJobIds
SET NOCOUNT OFF
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_MarkJobsToAuxCopyWithPriority')
	delete from GxQscripts where name = 'QS_MarkJobsToAuxCopyWithPriority'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MarkJobsToAuxCopyWithPriority')
	delete from GXDBVersions where aliasname = 'QS_MarkJobsToAuxCopyWithPriority'
GO

insert into GXDBVersions values(2, 'QS_MarkJobsToAuxCopyWithPriority',  '00000000000000000000', 'QS_MarkJobsToAuxCopyWithPriority', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_MarkJobsToAuxCopyWithPriority',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '  Execute the following command to mark jobs to auxiliary copy with priority on a storage policy copy
'
 + CHAR(10) + '  qoperation execscript -sn MarkJobsToAuxCopyWithPriority -si ''StoragePolicy'' -si ''copyName'' -si ''Operation'' -si ''JobIdDetails''
'
 + CHAR(10) + '  Operations supported are: Set, Reset
'
 + CHAR(10) + '  You can enter multiple job IDs separated by comma.
'
 + CHAR(10) + '  Optionally, you can enter job IDs in a text file with each job ID in a separate line, and then specify the file path in the command input as given below:
'
 + CHAR(10) + '  qoperation execscript -sn MarkJobsToAuxCopyWithPriority -si ''StoragePolicy'' -si ''copyName'' -si ''Operation'' -si @InputJobFilePath=''FilePath''
'
 + CHAR(10) + '  You can give commcell name if the jobs are belongs to different commcell 
'
 + CHAR(10) + '  qoperation execscript -sn MarkJobsToAuxCopyWithPriority -si ''StoragePolicy'' -si ''copyName'' -si ''Operation'' -si ''JobIdDetails'' -si @CommCellName=''commcellName''
'
 + CHAR(10) + '  Note: This script is not applicable for the storage policies having jobs from multiple CommCells.
'
)
GO

