

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_MarkJobsOnCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_MarkJobsOnCopy')
BEGIN
	print '>>> Drop Stored Procedure: QS_MarkJobsOnCopy <<<'
	drop procedure QS_MarkJobsOnCopy
END
IF EXISTS (select * from GxQscripts where name='QS_MarkJobsOnCopy')
	delete from GxQscripts where name = 'QS_MarkJobsOnCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MarkJobsOnCopy')
	delete from GXDBVersions where aliasname = 'QS_MarkJobsOnCopy'
GO
print '... Creating Procedure: QS_MarkJobsOnCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_MarkJobsOnCopy
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @StoragePolicyName NVARCHAR(512) = N'',
  @CopyName NVARCHAR(512) = N'',	
  @OperationType NVARCHAR(50)  = N'',
  @JobIds NVARCHAR(MAX) = N'',
  @InputJobFilePath NVARCHAR(MAX)= N'',
  @CommCellName NVARCHAR(512) = N''			
AS
SET NOCOUNT ON
DECLARE @archGroupId 	INT = 0
DECLARE @copyId			INT	= 0
DECLARE @opMsgId        INT = 0
DECLARE @opEvMsgId      INT = 0
DECLARE @opId           INT = 0
DECLARE @paramMsgId     INT = 0
DECLARE @JobXML			XML
DECLARE @errorCode    INT = 0
DECLARE @commCellId  INTEGER = 0;
-- Assume admin user here
DECLARE @GUIAuditUserId INT = 1    -- we do not have any way to determine user id.
DECLARE @successJobIdStr NVARCHAR(MAX) = N''
IF OBJECT_ID('#inputJobsIdStr') IS NOT NULL DROP TABLE #inputJobsIdStr
CREATE  TABLE  #inputJobsIdStr(jobId NVARCHAR(MAX))
IF OBJECT_ID('#inputJobIds') IS NOT NULL DROP TABLE #inputJobIds
CREATE  TABLE #inputJobIds(jobId INT, commCellId INT PRIMARY KEY(jobId, commCellId))
IF OBJECT_ID('#badChunkInfo') IS NOT NULL DROP TABLE #badChunkInfo
CREATE  TABLE  #badChunkInfo(chunkId BIGINT, chunkCCId INT, SIDBStoreId INT PRIMARY KEY(chunkId, chunkCCId, SIDBStoreId))
if object_id('tempdb.dbo.#MMProcessBadChunkInfoList_Output') is not null DROP TABLE #MMProcessBadChunkInfoList_Output
CREATE TABLE #MMProcessBadChunkInfoList_Output (jobId int, archFileCCId int, copyId int)
/* Output Table
CREATE TABLE #QS_MarkJobsOnCopy_Output(Msg NVARCHAR(MAX))
*/
DECLARE @op INT = 0
DECLARE @errorTable TABLE(id INT IDENTITY(1,1), Msg NVARCHAR(MAX))
IF OBJECT_ID('#tmpResutSetForArchAllowJobForCopy') IS NOT NULL DROP TABLE #tmpResutSetForArchAllowJobForCopy
CREATE TABLE #tmpResutSetForArchAllowJobForCopy (retValue int)
IF OBJECT_ID('#tmpResutSetForArchDisAllowJobForCopy') IS NOT NULL DROP TABLE #tmpResutSetForArchDisAllowJobForCopy
CREATE TABLE #tmpResutSetForArchDisAllowJobForCopy (retVal INT, spname NVARCHAR(1024), copyname NVARCHAR(1024))
IF OBJECT_ID('#tmpVerifyJobsRetCode') IS NOT NULL DROP TABLE #tmpVerifyJobsRetCode
CREATE TABLE #tmpVerifyJobsRetCode (retVal INT, opStatus INT)
IF @CommCellName <> N''
BEGIN
	select @commCellId = id from APP_Commcell WITH (READUNCOMMITTED) where aliasName = @CommCellName
	IF @commCellId = 0
	BEGIN
		INSERT @errorTable
		SELECT 'Input commcell name is not exists. Please provide correct commcell name.'
		GOTO CX_EXIT
	END
END
ELSE
BEGIN
	SET @commCellId = 2  -- Default commcell id
END
DECLARE @now INT = dbo.GetUnixTime(GETUTCDATE())
	IF @StoragePolicyName  = N''
	BEGIN
		INSERT @errorTable
		SELECT 'Storage policy name is not provided.'
		GOTO CX_EXIT
	END
	ELSE
	BEGIN
		SELECT @archGroupId = id
		FROM archGroup WITH (NOLOCK)
		WHERE name = @StoragePolicyName
		IF @archGroupId = 0
		BEGIN
			INSERT @errorTable
			SELECT 'Invalid Storage policy name.'
			GOTO CX_EXIT
		END
	END
	IF @CopyName	= N''
	BEGIN
		INSERT @errorTable
		SELECT 'Copy name is not provided.'
		GOTO CX_EXIT
	END
	ELSE
	BEGIN
		SELECT @copyId = id
		FROM archGroupCopy WITH (NOLOCK)
		WHERE name = @CopyName AND archGroupId = @archGroupId
		IF @copyId = 0
		BEGIN
			INSERT @errorTable
			SELECT 'Invalid Copy name.'
			GOTO CX_EXIT
		END
		IF EXISTS(SELECT * FROM archGroupCopy WHERE id = @copyId AND flags & 524288 = 524288    /*CVA_SILO_COPY_FLAG*/)
		BEGIN
			INSERT @errorTable
			SELECT 'Input Copy is a SILO copy, for which any operation is not allowed.'
			GOTO CX_EXIT
		END
	END
	IF @OperationType = N''
	BEGIN
		INSERT @errorTable
		SELECT 'operation type is not provided.'
		GOTO CX_EXIT
	END
	ELSE IF LOWER(@OperationType) = 'allowcopy'
	SET @op = 1
	ELSE IF LOWER(@OperationType) = 'recopy'
	SET @op = 2
	ELSE IF LOWER(@OperationType) = 'donotcopy'
	SET @op = 3
	ELSE IF LOWER(@OperationType) = 'pickforverification'
	SET @op = 4
	ELSE IF LOWER(@OperationType) = 'donotpickforverification'
	SET @op = 5
	ELSE IF LOWER(@OperationType) = 'markJobsBad'
	SET @op = 6
	ELSE IF LOWER(@OperationType) = 'donotretainjob'
	SET @op = 7
	ELSE
	BEGIN
		INSERT @errorTable
		SELECT 'Invalid operation type'
		GOTO CX_EXIT
	END
	IF @JobIds <> N''
	BEGIN
		INSERT INTO #inputJobsIdStr
        SELECT *
		FROM dbo.SplitStringByDelimiter(@JobIds, ',')
    END
	ELSE IF @InputJobFilePath <> N''
	BEGIN
		DECLARE @query NVARCHAR(1024) = N'BULK INSERT #inputJobsIdStr FROM ''' + @InputJobFilePath + ''' WITH ( ROWTERMINATOR = ''\n'')'
		EXEC (@query)
		IF @@ERROR <> 0
		BEGIN
			INSERT @errorTable
			SELECT 'ErrorCode: ' + CONVERT(NVARCHAR(MAX),@@ERROR) + ', Error Message: ' + ERROR_MESSAGE()
			GOTO CX_EXIT
		END
	END
	ELSE
	BEGIN
	 INSERT @errorTable
	 VALUES('JobIds input argument or input JobId file path are not provided, any one of the argument should be provided')
	 GOTO CX_EXIT
	END
	INSERT @errorTable
	SELECT 'Invalid Character in jobId: ' + jobId
	FROM #inputJobsIdStr
	WHERE  RTRIM(LTRIM(REPLACE(jobId, CHAR(13)+CHAR(10),''))) LIKE '%[^0-9]%'
	IF EXISTS (SELECT * FROM @errorTable)
	GOTO CX_EXIT
	INSERT #inputJobIds
	SELECT CONVERT(INT, RTRIM(LTRIM(REPLACE(jobId, CHAR(13)+CHAR(10),'')))), @commCellId
	FROM #inputJobsIdStr
	IF @@ERROR <> 0
	BEGIN
	INSERT @errorTable
	SELECT 'ErrorCode: ' + CONVERT(NVARCHAR(MAX),@@ERROR) + ', Error Message: ' + ISNULL(ERROR_MESSAGE(), ' ')
	GOTO CX_EXIT
	END
	DELETE #inputJobIds
	WHERE jobId = 0
	IF EXISTS (SELECT *	FROM #inputJobIds I
	LEFT OUTER JOIN  JMJobDataStats J WITH (NOLOCK)
	ON I.jobId = J.jobId AND I.commCellId = J.commCellId AND J.archGrpId = @archGroupId WHERE J.jobId IS NULL )
	BEGIN
		INSERT @errorTable
		VALUES('Below jobs do not belong to input storage policy copy: ')
		INSERT @errorTable
		SELECT I.jobId
		FROM #inputJobIds I
		LEFT OUTER JOIN
		JMJobDataStats J WITH (NOLOCK)
		ON I.jobId = J.jobId AND I.commCellId = J.commCellId AND J.archGrpId = @archGroupId
		WHERE J.jobId IS NULL
		DELETE #inputJobIds
		FROM #inputJobIds I
		LEFT OUTER JOIN
		JMJobDataStats J WITH (NOLOCK)
		ON I.jobId = J.jobId AND I.commCellId = J.commCellId AND J.archGrpId = @archGroupId
		WHERE J.jobId IS NULL
		IF NOT EXISTS (SELECT * FROM #inputJobIds)
		GOTO CX_EXIT
	END
	IF @@ERROR <> 0
	BEGIN
	INSERT @errorTable
	SELECT 'ErrorCode: ' + CONVERT(NVARCHAR(MAX),@@ERROR) + ', Error Message: ' + ISNULL(ERROR_MESSAGE(), ' ')
	GOTO CX_EXIT
	END
	IF @op = 6
	BEGIN
		-- Get all the bad chunks info to be created for input jobs.
		INSERT INTO #badChunkInfo
		SELECT DISTINCT ACM.archChunkId, ACM.chunkCommCellId, AFCD.SIDBStoreId
		FROM archChunkMapping ACM WITH (READUNCOMMITTED)
			INNER JOIN #inputJobIds I ON
				ACM.jobId = I.jobId
				AND ACM.chunkCommCellId = I.commCellId
				AND ACM.archCopyId = @copyId
			INNER JOIN archFileCopyDedup AFCD WITH (READUNCOMMITTED) ON
				ACM.archFileId = AFCD.archFileId
				AND ACM.archCopyId = AFCD.archCopyId
				AND ACM.chunkCommCellId = AFCD.commCellId
			LEFT OUTER JOIN archChunkDDBDrop ACDDB WITH (READUNCOMMITTED) ON
				ACM.archChunkId = ACDDB.archChunkId
				AND ACM.chunkCommCellId = ACDDB.chunkCommCellId
				AND AFCD.SIDBStoreId = ACDDB.SIDBStoreId
		WHERE
			ACDDB.archChunkId IS NULL
	END
	DECLARE @notAllowed NVARCHAR(350)
	IF @op = 1
	SET @notAllowed = ' is not allowed for copy. '
	ELSE
	SET @notAllowed = ' is not allowed for recopy. '
	DECLARE jobidcursor CURSOR LOCAL FAST_FORWARD FOR
	SELECT jobId, commcellId FROM #inputJobIds
	OPEN jobidcursor
	DECLARE @jobId INT, @retCode INT = 0
	FETCH NEXT FROM jobidcursor INTO @jobId, @commcellId
	WHILE @@FETCH_STATUS = 0
	BEGIN
	SET @retCode = 0
	IF @op = 1 OR @op = 2
		BEGIN
			BEGIN TRAN
			IF @op = 1
			BEGIN
				EXEC ArchAllowJobForCopy @jobId, @commcellId, @copyId, 0
				SELECT @retCode = retValue
				FROM #tmpResutSetForArchAllowJobForCopy
			END
			ELSE
			BEGIN
				EXEC ArchAllowJobForCopy @jobId, @commcellId, @copyId, 1
				SELECT @retCode = retValue
				FROM #tmpResutSetForArchAllowJobForCopy
			END
			IF @retCode <> 0
			BEGIN
				IF @retCode =  1
				INSERT @errorTable
				SELECT 'jobId: '+ CONVERT(NVARCHAR(MAX),@jobId) + @notAllowed + 'Data is not available on source copy.'
				ELSE IF @retCode = 2
				INSERT @errorTable
				SELECT 'jobId: '+ CONVERT(NVARCHAR(MAX),@jobId) + @notAllowed + 'Unable to delete the existing archive files.'
				ELSE IF @retCode = 4
				INSERT @errorTable
				SELECT 'jobId: '+ CONVERT(NVARCHAR(MAX),@jobId) + @notAllowed + 'Some archive files belong to sealed deduplication store.'
				ELSE IF @retCode = 5
				INSERT @errorTable
				SELECT 'jobId: '+ CONVERT(NVARCHAR(MAX),@jobId) + @notAllowed + 'The job is on a primary copy..'
				ELSE IF @retCode = 6
				INSERT @errorTable
				SELECT 'jobId: '+ CONVERT(NVARCHAR(MAX),@jobId) + @notAllowed + 'The job is on a snap copy..'
				ELSE IF @retCode = 7
				INSERT @errorTable
				SELECT 'jobId: '+ CONVERT(NVARCHAR(MAX),@jobId) + @notAllowed + 'The job is on a silo enabled copy.'
				ELSE IF @retCode = 8
				INSERT @errorTable
				SELECT 'jobId: '+ CONVERT(NVARCHAR(MAX),@jobId) + @notAllowed + 'Auxiliary Copy or MediaRefresh Job is running on this copy.'
				ELSE IF @retCode = 9
				INSERT @errorTable
				SELECT 'jobId: '+ CONVERT(NVARCHAR(MAX),@jobId) + @notAllowed + 'Auxiliary Copy is not allowed for DDB/CvFailoverLogShipping jobs.'
				ELSE
				INSERT @errorTable
				SELECT 'jobId: '+ CONVERT(NVARCHAR(MAX),@jobId) + @notAllowed + 'ArchAllowJobForCopy returned error code' + CONVERT(NVARCHAR(MAX),@retCode)+ '.'
				ROLLBACK
			END
			ELSE
			BEGIN
				COMMIT
				IF 	@successJobIdStr <> N''
				SET @successJobIdStr = @successJobIdStr + ', ' + CONVERT(NVARCHAR(MAX),@jobId)
				ELSE
				SET @successJobIdStr = CONVERT(NVARCHAR(MAX),@jobId)
			END
			TRUNCATE TABLE #tmpResutSetForArchAllowJobForCopy
		END
		ELSE IF (@op = 3) OR (@op = 6)
		BEGIN
			BEGIN TRAN
			BEGIN
				EXEC archDisallowJobForCopy @jobId, @commCellId, @copyId, @now, 0
				SELECT TOP(1) @retCode = retVal
				FROM #tmpResutSetForArchDisAllowJobForCopy
			END
			IF @retCode <> 0
			BEGIN
				IF @retCode = 25
				INSERT @errorTable
				SELECT 'jobId: '+ CONVERT(NVARCHAR(MAX),@jobId) + ' ' + 'Unable to disable job because there is an active job running for this subclient.'
				ELSE IF @retCode = 98
				INSERT @errorTable
				SELECT 'jobId: '+ CONVERT(NVARCHAR(MAX),@jobId) + ' ' + 'Unable to disable job because auxiliary copy, data verification, offline content indexing or media refresh jobs are running for the storage policy copy.'
				ELSE
				INSERT @errorTable
				SELECT 'jobId: '+ CONVERT(NVARCHAR(MAX),@jobId) + ' ' + 'Unable to disable job,  ArchDisallowJobForCopy returned error code' + CONVERT(NVARCHAR(MAX),@retCode)+ '.'
				ROLLBACK
			END
			ELSE
			BEGIN
				COMMIT
				IF 	@successJobIdStr <> N''
				SET @successJobIdStr = @successJobIdStr + ', ' + CONVERT(NVARCHAR(MAX),@jobId)
				ELSE
				SET @successJobIdStr = CONVERT(NVARCHAR(MAX),@jobId)
			END
			IF OBJECT_ID('#tmpResutSetForArchDisAllowJobForCopy') IS NOT NULL TRUNCATE TABLE #tmpResutSetForArchDisAllowJobForCopy
		END
		ELSE IF ((@op = 4 OR @op = 5) AND EXISTS(SELECT 1 FROM JMJobDataStats JDS WITH (NOLOCK) WHERE JDS.archGrpId = @archGroupId AND JDS.archGrpCopyId = @copyId AND JDS.jobId = @jobId AND JDS.status IN (100,102,103) AND JDS.disabled & 256 = 0))
		BEGIN
			BEGIN TRAN
			IF @op = 4
			BEGIN
				INSERT INTO #tmpVerifyJobsRetCode
EXEC  SetArchCheckStatusByJob @jobId, @commCellId, @copyId , 3 /* ACS_TOBECHECKED */ , 1 , -256 /*ACS_RESET_BITMAP*/
			END
			ELSE
			BEGIN
				INSERT INTO #tmpVerifyJobsRetCode
EXEC  SetArchCheckStatusByJob @jobId, @commCellId, @copyId , 2 /*ACS_DONOTCHECK*/ , 0 , -256 /*ACS_RESET_BITMAP*/
			END
			SELECT TOP (1) @retCode = retVal 	FROM	#tmpVerifyJobsRetCode
			IF @retCode <> 0
			BEGIN
				INSERT @errorTable
				SELECT 'jobId: '+ CONVERT(NVARCHAR(MAX),@jobId) + ' ' + 'Unable to pick the job for verification,  SetArchCheckStatusByJob returned error code' + CONVERT(NVARCHAR(MAX),@retCode)+ '.'
				ROLLBACK
			END
			ELSE
			BEGIN
				COMMIT
				IF 	@successJobIdStr <> N''
				SET @successJobIdStr = @successJobIdStr + ', ' + CONVERT(NVARCHAR(MAX),@jobId)
				ELSE
				SET @successJobIdStr = CONVERT(NVARCHAR(MAX),@jobId)
			END
			TRUNCATE TABLE #tmpVerifyJobsRetCode
		END
		-- In addition to disallow copy. Need to do some below steps as well. Hence this is not else if.
		IF @op = 6
		BEGIN
			BEGIN TRAN
			-- Do not copy is already done above.
			UPDATE J
SET disabled = disabled | 64
			FROM JMJobDataStats J
			WHERE J.jobId = @jobId
			AND J.commCellId = @commCellId
			AND J.archGrpCopyId = @copyId
			SELECT @retCode = @@ERROR
			IF @retCode <> 0
			BEGIN
				INSERT @errorTable
				SELECT 'jobId: '+ CONVERT(NVARCHAR(MAX),@jobId) + ' ' + 'Unable to mark the job bad,  Marking job bad returned error code' + CONVERT(NVARCHAR(MAX),@retCode)+ '.'
				ROLLBACK
			END
			ELSE
			BEGIN
				COMMIT
			END
		END
		FETCH NEXT FROM jobidcursor INTO @jobId, @commcellId
	END
	CLOSE   jobidcursor
	DEALLOCATE jobidcursor
	IF @op = 6
	BEGIN
		BEGIN TRAN BADCHUNK
		WHILE (1=1)
		BEGIN
				DECLARE @badChunkList XML
				SET @badChunkList = (
									SELECT TOP(100) T.chunkId as '@chunk', T.chunkCCId as '@chunkCCId', 0 as '@mpId', T.SIDBStoreId as '@StoreId', 0 as '@volId', 0 as '@afId', 0 as '@copyId', 0 as '@flags'
									FROM #badChunkInfo T
										LEFT OUTER JOIN archChunkDDBDrop ACDDB WITH (READUNCOMMITTED) ON
											T.chunkId = ACDDB.archChunkId
											AND T.chunkCCId = ACDDB.chunkCommCellId
											AND T.SIDBStoreId = ACDDB.SIDBStoreId
									WHERE
											ACDDB.archChunkId IS NULL
									ORDER BY T.chunkId ASC
									FOR XML PATH ('h'), root('r')
									)
				EXEC MMProcessBadChunkInfoList @badChunkList, 0, 0
				SELECT @retCode = @@ERROR
				IF @retCode <> 0
					BREAK
				DELETE T1
				FROM #badChunkInfo T1,
					(SELECT TOP(100) chunkId, chunkCCId FROM #badChunkInfo ORDER BY chunkId, chunkCCId ASC) T2
				WHERE T1.chunkId = T2.chunkId
				AND T1.chunkCCId = T2.chunkCCId
				IF NOT EXISTS (SELECT 1 FROM #badChunkInfo)
					BREAK
				ELSE
					WAITFOR DELAY '00:00:01'
				TRUNCATE TABLE #MMProcessBadChunkInfoList_Output
		END
		IF @retCode <> 0
		BEGIN
			INSERT @errorTable
			SELECT 'jobId: '+ CONVERT(NVARCHAR(MAX),@jobId) + ' ' + 'Unable to mark the job bad,  Marking job bad returned error code' + CONVERT(NVARCHAR(MAX),@retCode)+ '.'
			ROLLBACK TRAN BADCHUNK
		END
		ELSE
		BEGIN
			COMMIT TRAN BADCHUNK
		END
	END
	IF @op = 7
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#tblResultArchPinJobsOnCopy') IS NOT NULL  DROP TABLE #tblResultArchPinJobsOnCopy
			CREATE TABLE #tblResultArchPinJobsOnCopy (errorCode int)
		SET @JobXML = (
			SELECT JobId as '@jobId', commCellId as '@commCellId', @copyId as '@archGrpCopyId'
			FROM #inputJobIds FOR XML PATH('JobInfo'), ROOT('GalaxyOperations_PinJobs')
		)
		exec archPinJobsOnCopy 0, 0, @GUIAuditUserId, @JobXML
		SELECT top 1 @errorCode = errorCode FROM #tblResultArchPinJobsOnCopy
		IF @errorCode = 0
		BEGIN
			select @successJobIdStr = coalesce(@successJobIdStr + ',', '') +  convert(varchar(12),JobId)
			from #inputJobIds
			select @successJobIdStr = SUBSTRING(@successJobIdStr, 2, LEN(@successJobIdStr)-1)
		END
		ELSE
		BEGIN
			INSERT @errorTable
			SELECT 'Unable to reset the retention for the jobs.ErrorCode ['+ convert(varchar(12),@errorCode)  +']'
		END
		IF OBJECT_ID('tempdb.dbo.#tblResultArchPinJobsOnCopy') IS NOT NULL  DROP TABLE #tblResultArchPinJobsOnCopy
	END
	IF @successJobIdStr <> N''
	BEGIN
	-- Set Gui Audit Operation
				IF @op = 1
				SET @opMsgId = 1409286167 -- GUIAUDIT_OPS_ALLOW_COPY_JOB, 23
				ELSE IF @op = 2
				SET @opMsgId = 1409286166 -- GUIAUDIT_OPS_ALLOW_COPY_JOB, 22
				ELSE IF @op = 3
				SET @opMsgId = 1409286165 -- GUIAUDIT_OPS_DISABLE_BACKUPS  , 21
				ELSE IF @op = 4
				SET @opMsgId = 1409286170 -- GUIAUDIT_OPS_PICK_JOB_FOR_VERIFICATION  , 26
				ELSE IF @op = 5
				SET @opMsgId = 1409286573 -- GUIAUDIT_OPS_UNPICK_JOB_FOR_VERIFICATION  , 429
				ELSE IF @op = 6
				SET @opMsgId = 1409286433  -- GUIAUDIT_OPS_MARK_JOB_BAD, 289
				ELSE IF @op = 7
				SET @opMsgId = 1409286169  -- GUIAUDIT_OPS_UNPIN_JOB, 25
				EXEC EvGuiAuditSetOpWithEntity @opMsgId, @GUIAuditUserId, 17, @archGroupId, @opEvMsgId OUTPUT, @opId OUTPUT
				SET @paramMsgId = 1426063386 -- GUIAUDIT_PARAMS_STORAGE_POLICY, 26
				EXEC EvGuiAuditSetParamData @opId, @StoragePolicyName, 0
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
				SET @paramMsgId = 1426063387 -- GUIAUDIT_PARAMS_STORAGE_POLICY_COPY, 27
				EXEC EvGuiAuditSetParamData @opId, @CopyName, 0
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
				SET @paramMsgId = 1426063363 --GUIAUDIT_PARAMS_JOB_LIST, 3
				EXEC EvGuiAuditSetParamData @opId, @successJobIdStr, 1
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
	END
CX_EXIT:
	IF EXISTS (SELECT * FROM @errorTable)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#QS_MarkJobsOnCopy_Output') IS NOT NULL
		BEGIN
			INSERT INTO #QS_MarkJobsOnCopy_Output
			SELECT	Msg
			FROM	@errorTable
		END
		ELSE
		BEGIN
			SELECT Msg FROM @errorTable
		END
	END
IF OBJECT_ID('#inputJobsIdStr') IS NOT NULL DROP TABLE #inputJobsIdStr
IF OBJECT_ID('#tmpResutSetForArchAllowJobForCopy') IS NOT NULL DROP TABLE #tmpResutSetForArchAllowJobForCopy
IF OBJECT_ID('#tmpResutSetForArchDisAllowJobForCopy') IS NOT NULL DROP TABLE #tmpResutSetForArchDisAllowJobForCopy
IF OBJECT_ID('#tmpVerifyJobsRetCode') IS NOT NULL DROP TABLE #tmpVerifyJobsRetCode
IF OBJECT_ID('#badChunkInfo') IS NOT NULL DROP TABLE #badChunkInfo
IF OBJECT_ID('#inputJobIds') IS NOT NULL DROP TABLE #inputJobIds
if object_id('tempdb.dbo.#MMProcessBadChunkInfoList_Output') is not null DROP TABLE #MMProcessBadChunkInfoList_Output
SET NOCOUNT OFF
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_MarkJobsOnCopy')
	delete from GxQscripts where name = 'QS_MarkJobsOnCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MarkJobsOnCopy')
	delete from GXDBVersions where aliasname = 'QS_MarkJobsOnCopy'
GO

insert into GXDBVersions values(2, 'QS_MarkJobsOnCopy',  '00000000000000000000', 'QS_MarkJobsOnCopy', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_MarkJobsOnCopy',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '  Execute the following command to mark jobs on a storage policy copy for the auxiliary copy job:
'
 + CHAR(10) + '  qoperation execscript -sn MarkJobsOnCopy -si ''StoragePolicy'' -si ''copyName'' -si ''Operation'' -si ''JobIdDetails''
'
 + CHAR(10) + '  Operations supported are: allowcopy, recopy, donotcopy, markJobsBad, pickForVerification and donotPickForVerification.
'
 + CHAR(10) + '  You can enter multiple job IDs separated by comma.
'
 + CHAR(10) + '  Optionally, you can enter job IDs in a text file with each job ID in a separate line, and then specify the file path in the command input as given below:
'
 + CHAR(10) + '  qoperation execscript -sn MarkJobsOnCopy -si ''StoragePolicy'' -si ''copyName'' -si ''Operation'' -si @InputJobFilePath=''FilePath''
'
 + CHAR(10) + '  You can give commcell name if the jobs are belongs to different commcell 
'
 + CHAR(10) + '  qoperation execscript -sn MarkJobsOnCopy -si ''StoragePolicy'' -si ''copyName'' -si ''Operation'' -si ''JobIdDetails'' -si @CommCellName=''commcellName''
'
 + CHAR(10) + '  Note: This script is not applicable for the storage policies having jobs from multiple CommCells.
'
)
GO

