

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_MarkJobsBadAndRetain.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_MarkJobsBadAndRetain.sp,v $ $Id: QS_MarkJobsBadAndRetain.sp,v 1.1.2.1 2019/06/16 03:03:45 hkapadia Exp $";
--
--  +========================================================================+
--  | Stored Precedure: QS_MarkJobsBadAndRetain()
--  +========================================================================+
--
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_MarkJobsBadAndRetain')
BEGIN
	print '>>> Drop Stored Procedure: QS_MarkJobsBadAndRetain <<<'
	drop procedure QS_MarkJobsBadAndRetain
END
IF EXISTS (select * from GxQscripts where name='QS_MarkJobsBadAndRetain')
	delete from GxQscripts where name = 'QS_MarkJobsBadAndRetain'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MarkJobsBadAndRetain')
	delete from GXDBVersions where aliasname = 'QS_MarkJobsBadAndRetain'
GO
print '... Creating Procedure: QS_MarkJobsBadAndRetain'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_MarkJobsBadAndRetain
--Stored procedure inputs
  @i_retainUntilDate NVARCHAR(1024) = N'INFINITE'
AS
SET NOCOUNT ON
BEGIN TRY
DECLARE @errorCode INT = 0
DECLARE @errorMessage VARCHAR(MAX) = ''
DECLARE @pinEndTime BIGINT
DECLARE @pinTimeForGAT VARCHAR(30) = ''
IF OBJECT_ID('tempdb.dbo.#jobsToBeCopied') IS NOT NULL DROP TABLE #jobsToBeCopied
 CREATE TABLE #jobsToBeCopied
(
	JobId 			INTEGER,
	commCellId 	INTEGER,
	DestCopyId 	INTEGER,
	SrcCopyId 	INTEGER,
	IsBad 			INTEGER
	PRIMARY KEY (JobId, CommCellId, DestCopyId)
)
IF OBJECT_ID('tempdb..#jobsToProcess') IS NOT NULL DROP TABLE #jobsToProcess
CREATE TABLE #jobsToProcess
(
	jobId 				INTEGER,
	commCellId		INTEGER,
	archGrpCopyId INTEGER,
	Primary Key (jobId, commCellId, archGrpCopyId) WITH (ignore_dup_key = ON)
)
IF OBJECT_ID('tempdb..#tblResultArchPinJobsOnCopy') IS NOT NULL DROP TABLE #tblResultArchPinJobsOnCopy
CREATE TABLE #tblResultArchPinJobsOnCopy (errorCode int)
IF(LOWER(@i_retainUntilDate) = 'infinite')
BEGIN
	SET @pinEndTime = -1
	SET @pinTimeForGAT = 'Infinite'
END
ELSE
BEGIN
	SET @pinEndTime = dbo.GetUnixTimeBig(dbo.ClientLocalToUTCTime(@i_retainUntilDate, 2))
	SET @pinTimeForGAT = CAST(dbo.UTCToClientLocalTime(dbo.GetDateTimeBig(@pinEndTime), 2) AS VARCHAR(30))
END
-- Get all the to-be-copied jobs which are not marked aged or do not copy
INSERT INTO #jobsToBeCopied
SELECT DISTINCT JobId, CommCellId, archGrpCopyId, 0, 0
FROM   JMJobDataStats WITH (READUNCOMMITTED)
WHERE  Status IN (101, 102, 103)
AND 	(disabled & 257) = 0
-- Get the Bad jobs by checking error code in archChunkToReplicate table
UPDATE J
SET		J.SrcCopyId = R.SrcCopyId, J.IsBad = 1
FROM	#jobsToBeCopied J, archChunkToReplicate R WITH (READUNCOMMITTED)
WHERE J.jobId = R.backupJobId
AND 	J.commCellId = R.commCellId
AND 	J.destCopyId = R.destCopyId
AND 	R.status = 4
AND 	R.errorCode IN (30017, 30032, 30074, 1208, 65103)
UPDATE J
SET		J.SrcCopyId = R.SrcCopyId, J.IsBad = 1
FROM	#jobsToBeCopied J, archChunkToReplicateHistory R WITH (READUNCOMMITTED)
WHERE J.jobId = R.backupJobId
AND 	J.commCellId = R.commCellId
AND 	J.destCopyId = R.destCopyId
AND 	R.status = 4
AND 	R.errorCode IN (30017, 30032, 30074, 1208, 65103)
AND		J.IsBad = 0
UPDATE	J
SET		J.SrcCopyId = (CASE WHEN (AGC.SourceCopyid > 0) THEN AGC.SourceCopyId WHEN (IsSnapCopy > 0) THEN AG.DefaultSnapCopy ELSE AG.defaultCopy END)
FROM	#jobsToBeCopied J, archGroupCopy AGC WITH (READUNCOMMITTED), archGroup AG WITH (READUNCOMMITTED)
WHERE	J.IsBad = 0
		AND J.destCopyId = AGC.id
		AND AGC.archGroupId = AG.id
UPDATE	J
SET		J.IsBad = 1
FROM	#jobsToBeCopied J, JMJobDataStats JDS WITH (READUNCOMMITTED)
WHERE	J.JobId = JDS.JobId
		AND J.CommCellId = JDS.CommCellId
		AND J.SrcCopyId = JDS.archGrpCopyId
		AND JDS.dataType = 1
		AND JDS.archCheckStatus = 6 /*ACS_FAILED*/
AND	(JDS.disabled & 2048) = 0
-- Delete all good job from temp table
DELETE FROM #jobsToBeCopied
WHERE  IsBad = 0
--Retain jobs and mark them bad
WHILE EXISTS (SELECT 1 FROM #jobsToBeCopied)
BEGIN
	TRUNCATE TABLE #jobsToProcess
	--Pick jobs to retain and mark bad
	;WITH CTE
	AS (
				SELECT TOP 5000 *
				FROM #jobsToBeCopied
				ORDER BY srcCopyId, jobId
			)
	DELETE FROM CTE
	OUTPUT DELETED.JobId, DELETED.commCellId, DELETED.SrcCopyId INTO #jobsToProcess
	DECLARE @l_copyId INT
	--Batching by copy
	DECLARE COPYLIST_CURSOR CURSOR FOR
	SELECT DISTINCT archGrpCopyId FROM #jobsToProcess
	OPEN COPYLIST_CURSOR
	FETCH NEXT FROM COPYLIST_CURSOR INTO @l_copyId
	WHILE (@@FETCH_STATUS = 0)
	BEGIN
		DECLARE @opMsgId        INT = 0
		DECLARE @opEvMsgId      INT = 0
		DECLARE @opId           INT = 0
		DECLARE @paramMsgId     INT = 0
		DECLARE @UserId 				INT = 1    --Assume admin user
		DECLARE @spName NVARCHAR(1024) = ''
		DECLARE @copyName NVARCHAR(1024) = ''
		DECLARE @l_archGroupId INT = 0
		DECLARE @jobListXml XML
		SET @jobListXml =
		    (
		        SELECT jobId, commCellId, archGrpCopyId
		        FROM #jobsToProcess JobInfo
		        WHERE archGrpCopyId = @l_copyId
		        FOR XML AUTO,ROOT('GalaxyOperations_PinJobs')
		    )
		TRUNCATE TABLE #tblResultArchPinJobsOnCopy
		EXEC archPinJobsOnCopy 1, @pinEndTime, @UserId, @jobListXml
		SELECT top 1 @errorCode = errorCode FROM #tblResultArchPinJobsOnCopy
		--Ignore the errors about index backup job
IF(@errorCode & ~(195) <> 0)
		BEGIN
			SET @errorMessage = 'Failed to retain jobs. Stored proc: ArchPinJobsOnCopy failed with error code - ' + CAST(@errorCode AS VARCHAR(10))
			RAISERROR(@errorMessage, 15, 1)
		END
		SELECT @spName = AG.name, @copyName = AGC.name, @l_archGroupId = AG.id
	  FROM   archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	  WHERE   AG.id = AGC.archGroupId
	  AND AGC.id = @l_copyId
SET @opMsgId = (24 | (CAST(POWER(2, 24) AS BIGINT) * 84))
	  EXEC EvGuiAuditSetOpWithEntity @opMsgId, @UserId, 17, @l_archGroupId, @opEvMsgId OUTPUT, @opId OUTPUT
SET @paramMsgId = (26 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	  EXEC EvGuiAuditSetParamData @opId, @spName, 0
	  EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @UserId
SET @paramMsgId = (27 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	  EXEC EvGuiAuditSetParamData @opId, @copyName, 0
	  EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @UserId
SET @paramMsgId = (1164 | (CAST(POWER(2, 24) AS BIGINT) * 85))
    EXEC EvGuiAuditSetParamData @opId, @pinTimeForGAT, 0
    EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @UserId
	  DECLARE @jobList nvarchar(max) = NULL
	  SELECT @jobList = COALESCE(@jobList+', ' ,'') + CAST(jobId as varchar(10))
		FROM #jobsToProcess
		WHERE archGrpCopyId = @l_copyId
SET @paramMsgId = (3 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	  EXEC EvGuiAuditSetParamData @opId, @jobList, 0
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @UserId
		EXEC QS_MarkJobsOnCopy @spName, @copyName, 'markJobsBad', @jobList
		FETCH NEXT FROM COPYLIST_CURSOR INTO @l_copyId
	END
	CLOSE COPYLIST_CURSOR
	DEALLOCATE COPYLIST_CURSOR
END
END TRY
BEGIN CATCH
	IF (CURSOR_STATUS('global', 'COPYLIST_CURSOR') >= -1) OR (CURSOR_STATUS('local', 'COPYLIST_CURSOR') >= -1)
	BEGIN
		IF (CURSOR_STATUS('global', 'COPYLIST_CURSOR') >= 0) OR (CURSOR_STATUS('local', 'COPYLIST_CURSOR') >= 0)
		BEGIN
			CLOSE COPYLIST_CURSOR
		END
		DEALLOCATE COPYLIST_CURSOR
	END
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
 ;THROW
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'QS_MarkJobsBadAndRetain')
	delete from GxQscripts where name = 'QS_MarkJobsBadAndRetain'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MarkJobsBadAndRetain')
	delete from GXDBVersions where aliasname = 'QS_MarkJobsBadAndRetain'
GO

insert into GXDBVersions values(2, 'QS_MarkJobsBadAndRetain',  '00010001000200010000', 'QS_MarkJobsBadAndRetain', '00010001000200010000')
GO

insert into GxQscripts values(2,'QS_MarkJobsBadAndRetain',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '--   QOperation execscript -sn QS_MarkJobsBadAndRetain [-si RetainUntilDate = ''mm/dd/yyyy'' or ''Infinite'']'
)
GO

