

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ManageContentGrouping.sp] ---------- 

/*
Note :
This script is to manage the monikers used in subclient content for content grouping such as 'Images'
Here, group and moniker mean the same
*/
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_ManageContentGrouping.sp,v $ $Id: QS_ManageContentGrouping.sp,v 1.6.60.3 2018/03/22 01:47:28 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ManageContentGrouping <<<'

IF EXISTS (select * from sysobjects where name='QS_ManageContentGrouping')
	drop procedure QS_ManageContentGrouping
IF EXISTS (select * from GxQscripts where name='QS_ManageContentGrouping')
	delete from GxQscripts where name = 'QS_ManageContentGrouping'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ManageContentGrouping')
	delete from GXDBVersions where aliasname = 'QS_ManageContentGrouping'
GO
print '... Creating Procedure: QS_ManageContentGrouping'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ManageContentGrouping
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @groupOpType nvarchar(100),
  @groupName nvarchar(1024) = '',
  @contentList nvarchar(1024) = '',
  @contentListOpType nvarchar(100) = ''
AS
Set NOCOUNT ON
------------ Convenience Definitions    -----------
    DECLARE @scriptName varchar(32)
    SET     @scriptName = 'ManageContentGrouping'
    DECLARE @lastError  integer
    SET     @lastError  = 0
    DECLARE @localErrorMsg  varchar(512)
    SET     @localErrorMsg  ='Error Encountered when running script.'
    DECLARE @now                integer
    DECLARE @userId             integer
	DECLARE @row				integer
	DECLARE @maxId				integer
	DECLARE @row1				integer
	DECLARE @maxId1				integer
	DECLARE @tempGroupName		nvarchar(128)
	DECLARE @tempContentList	nvarchar(3999)
	DECLARE @tempContent		nvarchar(128)
	DECLARE @pos				integer
	DECLARE @copyContentList	nvarchar(3999)
	DECLARE @length				integer
    DECLARE @sql nvarchar(max)
    SET @now = dbo.GetUnixTime(GETDATE())
    SET @userId  = 1
	DECLARE		@groupsAndContentTbl	TABLE (id int identity(1,1),groupName nvarchar(128), contentList nvarchar(3999) )
	Declare     @newxml				    XML
	Declare     @newxmlstring			nvarchar(max)
-----------------------invalid parameters------------------------------
BEGIN TRY
BEGIN TRAN
-- Keep a copy of the contentList
SET @copyContentList = @contentList
---------------------------------------------------------------------------------------
--   Display all the monikers and their contents
----------------------------------------------------------------------------------------
IF @groupOpType = 'displayAllContentGroups'
BEGIN
	DECLARE		@groupListTbl TABLE (id int identity(1,1), groupName nvarchar(max) )
	INSERT @groupListTbl(groupName) SELECT DISTINCT typeName FROM App_FileTypeAndExtensions
	SET @maxId = ISNULL( (SELECT MAX(id) FROM @groupListTbl) , 0)
	SET @row = 1
	WHILE @row <= @maxId
	BEGIN
		SET @tempGroupName = (SELECT groupName FROM @groupListTbl WHERE id=@row)
		if (OBJECT_ID('tempdb.dbo.#contentListTable') is not null)
			DROP TABLE #contentListTable
		CREATE TABLE #contentListTable	(id int identity(1,1), content nvarchar(128) )
		INSERT INTO #contentListTable SELECT extension FROM App_FileTypeAndExtensions WHERE typeName = @tempGroupName
		SET @maxId1 = ISNULL( (SELECT MAX(id) FROM #contentListTable) , 0)
		SET @row1 = 1
		SET @tempContentList = ''
		WHILE @row1 <= @maxId1
		BEGIN
			SET @tempContent = ISNULL((SELECT content FROM #contentListTable WHERE id = @row1), '')
			IF @tempContent = ''
				GOTO DISPLAY_NEXT_GROUP_LOOP
			ELSE
			BEGIN
				IF @tempContentList <> ''
					SET @tempContentList = @tempContentList + ',  '
				SET @length = LEN(@tempContent)
				SET @tempContent = LEFT(@tempContent, @length-4 ) --remove \/\/ at the end
				SET @tempContentList = @tempContentList + @tempContent
			END
			SET @row1 = @row1 + 1
		END
DISPLAY_NEXT_GROUP_LOOP:
		INSERT INTO @groupsAndContentTbl SELECT @tempGroupName, @tempContentList
		SET @row = @row + 1
		DROP TABLE #contentListTable
	END
	SET @maxId = ISNULL( (SELECT MAX(id) FROM @groupsAndContentTbl) , 0)
	SET @row = 1
	WHILE @row <= @maxId
	BEGIN
		SELECT groupName AS 'Group' FROM @groupsAndContentTbl WHERE id = @row
		SELECT ' ' + contentList as Contents FROM @groupsAndContentTbl WHERE id = @row
		SELECT ''
		SET @row = @row + 1
	END
	-- Making unnecessary arguments empty just to avoid confusion
	SET @groupName = ''
	SET @contentList = ''
	SET @contentListOpType = ''
END
---------------------------------------------------------------------------------------
--   Display the contents of  specified moniker
----------------------------------------------------------------------------------------
ELSE IF @groupOpType = 'displayContentGroup'
BEGIN
	IF @groupName = ''
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error : Group name is not given.'
		GOTO ARGS_ERROR
	END
	ELSE IF NOT EXISTS (SELECT * FROM App_FileTypeAndExtensions WHERE typeName = @groupName)
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error : Moniker[' + @groupName + '] does not exist.'
		GOTO ARGS_ERROR
	END
	if (OBJECT_ID('tempdb.dbo.#contentListTable1') is not null)
		DROP TABLE #contentListTable1
	CREATE TABLE #contentListTable1	(id int identity(1,1), content nvarchar(128) )
	INSERT INTO #contentListTable1 SELECT extension FROM App_FileTypeAndExtensions WHERE typeName = @groupName
	SET @maxId1 = ISNULL( (SELECT MAX(id) FROM #contentListTable1) , 0)
	SET @row1 = 1
	SET @tempContentList = ''
	WHILE @row1 <= @maxId1
	BEGIN
		SET @tempContent = ISNULL((SELECT content FROM #contentListTable1 WHERE id = @row1), '')
		IF @tempContent = ''
			GOTO DISPLAY_EXIT_CONTENT_LOOP
		ELSE
		BEGIN
			IF @tempContentList <> ''
				SET @tempContentList = @tempContentList + ',  '
			SET @length = LEN(@tempContent)
			SET @tempContent = LEFT(@tempContent, @length-4 ) --remove \/\/ at the end
			SET @tempContentList = @tempContentList + @tempContent
		END
		SET @row1 = @row1 + 1
	END
DISPLAY_EXIT_CONTENT_LOOP:
	INSERT INTO @groupsAndContentTbl SELECT @groupName, @tempContentList
	SELECT ''
	SELECT ' ' + contentList as 'Contents of moniker' FROM @groupsAndContentTbl
	SELECT ''
	DROP TABLE #contentListTable1
	-- Making unnecessary arguments empty just to avoid confusion
	SET @contentList = ''
	SET @contentListOpType = ''
END
-------------------------------------------------------------------------------------------
--   Add a content group
---------------------------------------------------------------------------------------------
ELSE IF @groupOpType = 'addContentGroup'
BEGIN
	SET @pos = 0
	-- Throw error if the moniker already exists
	IF EXISTS (SELECT * FROM App_FileTypeAndExtensions WHERE typeName = @groupName)
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error : Content group[' + @groupName + '] already exists.'
		GOTO ARGS_ERROR
	END
	IF @groupName <> ''
	BEGIN
		INSERT INTO App_FileTypeAndExtensions
		SELECT @groupName, ''
	END
	ELSE
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error : Group name is not given.'
		GOTO ARGS_ERROR
	END
	-- Making unnecessary arguments empty just to avoid confusion
	SET @contentList = ''
	SET @contentListOpType = ''
END
------------------------------------------------------------------------------------------------
--  Edit the contents of a moniker (insert/remove)
-------------------------------------------------------------------------------------------------
ELSE IF @groupOpType = 'editContentGroup'
BEGIN
	-- Throw error if the moniker does not exist
	IF NOT EXISTS (SELECT * FROM App_FileTypeAndExtensions WHERE typeName = @groupName)
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error : Group name [' + @groupName + '] does not exist.'
		GOTO ARGS_ERROR
	END
	IF @contentListOpType = ''
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error : ContentListOpType is not given.'
		GOTO ARGS_ERROR
	END
	IF @contentList = '' AND @contentListOpType <> 'OVERWRITE'
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error : ContentList is not given.'
		GOTO ARGS_ERROR
	END
	DECLARE		@contentListTbl3	  TABLE (id int identity(1,1), content nvarchar(128) )
	SET @contentList = LTRIM(RTRIM(@contentList)) + ','
	SET @pos = CHARINDEX(',',@contentList, 1)
	WHILE @pos > 0
	BEGIN
		SET @tempContent = LTRIM(RTRIM(LEFT( @contentList, @pos-1 )))
		IF @tempContent <> ''  AND  LEN(@tempContent) <> 0
		BEGIN
			SET @tempContent = @tempCOntent + '\/\/'
			INSERT INTO @contentListTbl3 SELECT @tempContent
		END
		SET @contentList = RIGHT(@contentList, LEN(@contentList) - @pos)
		SET @pos = CHARINDEX(',',@contentList,1)
	END
	IF @contentListOpType = 'ADD'
	BEGIN
		-- Remove the row with no content, since we don't need it anymore
		DELETE FROM App_FileTypeAndExtensions WHERE typeName = @groupName AND extension = ''
		--Filter out the entries which are already there(case-sensitive)
		DELETE FROM @contentListTbl3 WHERE content COLLATE SQL_Latin1_General_Cp1_CS_AS IN (SELECT extension FROM App_FileTypeAndExtensions WHERE typeName = @groupName)
		INSERT INTO App_FileTypeAndExtensions SELECT @groupName, content FROM @contentListTbl3
	END
	ELSE IF @contentListOpType = 'DEL'
	BEGIN
		DELETE FROM App_FileTypeAndExtensions
		WHERE typeName = @groupName AND extension COLLATE SQL_Latin1_General_Cp1_CS_AS IN (SELECT content FROM @contentListTbl3)
	END
	ELSE IF @contentListOpType = 'OVERWRITE'
	BEGIN
		DELETE FROM App_FileTypeAndExtensions WHERE typeName = @groupName
		SET @copyContentList = LTRIM(RTRIM(@copyContentList))
		IF @copyContentList <> ''
			INSERT INTO App_FileTypeAndExtensions SELECT @groupName, content FROM @contentListTbl3
	END
	ELSE
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error : Invalid contentListOpType is given.'
		GOTO ARGS_ERROR
	END
	-- Insert the row with empty content if all the entries of this moniker have been removed from table
	IF NOT EXISTS (SELECT * FROM App_FileTypeAndExtensions WHERE typeName = @groupName)
		INSERT INTO App_FileTypeAndExtensions SELECT @groupName, ''
		set @newxml=
		(select typeName as   '@typeName',
		       extension as '@extension'
			   from App_FileTypeAndExtensions
	    FOR XML PATH ('Moniker'),
		ROOT ('FileTypesAndExtensions'))
	 set @newxmlstring=CONVERT(NVARCHAR(MAX),@newxml)
Insert into App_extendedProperties values ( 1,0,0,0,0,129,'File Type And Extension History',@newxmlstring,'',dbo.GetUnixTime(GETUTCDATE()),0,0)
END
------------------------------------------------------------------------------------------------
--  Delete the moniker
----------------------------------------------------------------------------------------------
ELSE IF @groupOpType = 'delContentGroup'
BEGIN
	IF NOT EXISTS (SELECT * FROM App_FileTypeAndExtensions WHERE typeName = @groupName)
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error : Moniker[' + @groupName + '] does not exist.'
		GOTO ARGS_ERROR
	END
	DELETE FROM App_FileTypeAndExtensions WHERE typeName = @groupName
	set @newxml=
		(select typeName as   '@typeName',
		       extension as '@extension'
			   from App_FileTypeAndExtensions
	    FOR XML PATH ('Moniker'),
		ROOT ('FileTypesAndExtensions'))
    set @newxmlstring=CONVERT(NVARCHAR(MAX),@newxml)
Insert into App_extendedProperties values ( 1,0,0,0,0,129,'File Type And Extension History',@newxmlstring,'',dbo.GetUnixTime(GETUTCDATE()),0,0)
	SELECT '-------------------------------------------------------------------------'
	SELECT 'WARNING : Please make sure that deleted moniker is not the content of any subclient.'
	SELECT '--------------------------------------------------------------------------'
	-- Making unnecessary arguments empty just to avoid confusion
	SET @contentList = ''
	SET @contentListOpType = ''
END
ELSE
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error : Invalid groupOpType given.'
	GOTO ARGS_ERROR
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @lastError = @@ERROR
    SET @localErrorMsg = (SELECT ERROR_MESSAGE())
    goto ARGS_ERROR
END CATCH
 TRANS_EXIT:
ARGS_ERROR:
IF @lastError <> 0
    ROLLBACK TRAN
ELSE
    COMMIT TRAN
PRINT ''
PRINT @scriptName + ' completed at '
                    + Convert(varchar(60), getdate())+' with parameters groupOpType ['
                    + @groupOpType + '] groupName ['
                    + @groupName + '] contentList ['
                    + @copyContentList + '] contentListOpType['
					+ @contentListOpType + '] . ErrorCode ('+
                    + Convert(varchar(2),@lastError) +').'
if @lastError <> 0
        Raiserror(@localErrorMsg,
                    15,  --Severity (> 10 to force DOS Error Code = 1)
                    1    --State
                    )
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ManageContentGrouping')
	delete from GxQscripts where name = 'QS_ManageContentGrouping'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ManageContentGrouping')
	delete from GXDBVersions where aliasname = 'QS_ManageContentGrouping'
GO

insert into GXDBVersions values(2, 'QS_ManageContentGrouping',  '00010006006000030000', 'QS_ManageContentGrouping', '00010006006000030000')
GO

insert into GxQscripts values(2,'QS_ManageContentGrouping',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	--For creating content group:
'
 + CHAR(10) + '    qoperation execscript -sn ManageContentGrouping -si @groupOpType=''addContentGroup'' -si @groupName=''content_group_name'' 
'
 + CHAR(10) + '    qoperation execscript -sn ManageContentGrouping -si ''addContentGroup'' -si ''content_group_name'' 
'
 + CHAR(10) + '	--For editing content group (insert/remove contents to the content group):
'
 + CHAR(10) + '    qoperation execscript -sn ManageContentGrouping -si @groupOpType=''editContentGroup'' -si @groupName=''content_group_name'' -si @contentList=''content1,content2,content3'' -si @contentListOpType=''ADD/DEL/OVERWRITE''
'
 + CHAR(10) + '    qoperation execscript -sn ManageContentGrouping -si ''editContentGroup'' -si ''content_group_name'' -si ''content1,content2,content3'' -si ''ADD/DEL/OVERWRITE'' 
'
 + CHAR(10) + '	--For removing content group:
'
 + CHAR(10) + '    qoperation execscript -sn ManageContentGrouping -si @groupOpType=''delContentGroup'' -si @groupName=''content_group_name'' 
'
 + CHAR(10) + '    qoperation execscript -sn ManageContentGrouping -si ''delContentGroup'' -si ''content_group_name'' 
'
 + CHAR(10) + '	--For displaying the contents of a content group:
'
 + CHAR(10) + '    qoperation execscript -sn ManageContentGrouping -si @groupOpType=''displayContentGroup'' -si @groupName=''content_group_name'' 
'
 + CHAR(10) + '    qoperation execscript -sn ManageContentGrouping -si ''displayContentGroup'' -si ''content_group_name'' 
'
 + CHAR(10) + '	--For displaying all the content groups:
'
 + CHAR(10) + '    qoperation execscript -sn ManageContentGrouping -si @groupOpType=''displayAllContentGroups'' 
'
 + CHAR(10) + '    qoperation execscript -sn ManageContentGrouping -si ''displayAllContentGroups'' 
'
 + CHAR(10) + '    [groupOpType] specifies the operation to be performed on the content group
'
 + CHAR(10) + '    [groupName] specifies the name of the content group to be added/edited/removed
'
 + CHAR(10) + '    [contentList] specifies the list of contents to be added/deleted/edited in the group.
'
 + CHAR(10) + '    [contentListOpType] specifies the operation to be performed on the list of contents. It may be ADD/DEL/OVERWRITE.
'
 + CHAR(10) + '    When executed, the qscript returns one of the following output:
'
 + CHAR(10) + '--   1 - successful execution'
 + CHAR(10) + '--   2 - for failed execution. '
 + CHAR(10) + '--   0 - for all status'
)
GO

