

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ManageAWSKeyForUser.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='QS_ManageAWSKeyForUser')
BEGIN
	print '>>> Drop Stored Procedure: QS_ManageAWSKeyForUser <<<'
	drop procedure QS_ManageAWSKeyForUser
END
IF EXISTS (select * from GxQscripts where name='QS_ManageAWSKeyForUser')
	delete from GxQscripts where name = 'QS_ManageAWSKeyForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ManageAWSKeyForUser')
	delete from GXDBVersions where aliasname = 'QS_ManageAWSKeyForUser'
GO
print '... Creating Procedure: QS_ManageAWSKeyForUser'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure QS_ManageAWSKeyForUser
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_OpType varchar(10),
  @i_userName nvarchar(255), 
  @i_Key nvarchar(255) = N''
AS
BEGIN
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @NoParameter	nvarchar(10)
	SET     @NoParameter	=N''
	DECLARE @errorCode int
	SET @errorCode = 0
	DECLARE @errorString NVARCHAR(1024)
	SET @errorString = N'Succeeded'
	IF(@i_OpType = @NoParameter OR @i_userName = @NoParameter)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error: Insufficient command line parameters. Please refer to the readme file and retry with necessary parameters'
		GOTO exitline
	END
	IF NOT EXISTS (SELECT 1 FROM UMUsers WITH(NOLOCK) WHERE login = @i_userName and enabled = 1)
	BEGIN
		SET @errorCode = 2
		SET @errorString = 'Error. No active user with login name: [' + @i_userName + '] found.'
		GOTO exitline
	END
	DECLARE @SubClientPropId int
	DECLARE @subclientId int
	DECLARE @nowTime  INT = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @encrypedKey varchar(max)
	DECLARE @S3_SECURITY_KEY VARCHAR(20) = 'S3_SECURITY_KEY'
	--
	EXEC pswEncryptionManaged @i_Key, @encrypedKey output
	--
	-- fetch edge drive sub client id for specified user
	--
	SELECT @subclientId = dbo.GetEdgeDriveSubClientId(@i_userName)
	--
	--if edge drive sub client itself does not exist, we have to fail the operation
	--
	IF @subclientId is null
	BEGIN
		SET @errorCode = 3
		SET @errorString = 'Edge drive sub client does not exist for specified user.'
		GOTO exitline
	END
	-- Fetch ID of existing entry for the property..
	SELECT @SubClientPropId = Id FROM APP_SubClientProp WHERE attrName = @S3_SECURITY_KEY AND componentNameId = @subclientId and modified = 0
	--
	IF ISNULL(@i_OpType, '') = 'GET'
	BEGIN
		SELECT @encrypedKey = attrVal FROM APP_SubClientProp WHERE ID = @SubClientPropId
		EXEC miscProc2 @encrypedKey, @i_Key output
		SELECT @i_Key as EdgeDriveSecurityKey
	END
	ELSE IF ISNULL(@i_OpType, '') = 'SET'
	BEGIN
		BEGIN TRAN
		--
		--If sub client property already exists, then we will mark it as deleted by setting modified
		--
		IF @SubClientPropId IS NOT NULL
		BEGIN
			UPDATE APP_SubClientProp SET modified = @nowTime WHERE id = @SubClientPropId
		END
		-- just to be sure check error
		SET @errorCode = @@ERROR
		--
		-- jump on error
		--
		if @errorCode > 0 goto errorline
		--
		-- we are good to insert the value as edge drive sub client property here..
		--
		INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
VALUES(@subclientId, @S3_SECURITY_KEY, 1, @encrypedKey, @nowTime, 0, 0)
		--
		-- just to be sure check error
		SET @errorCode = @@ERROR
		--
		-- jump on error
		--
		if @errorCode = 0
			commit tran
		else
			goto errorline
	END
	ELSE
	BEGIN
		SET @errorString = 'opType input ' + @i_OpType + ' is invalid.'
		SET @errorCode = 4
		GOTO exitline
	END
	exitline:
		IF @errorCode > 0
		BEGIN
			RAISERROR (@errorString,
				15, --Severity (> 10 to force DOS Error Code = 1)
				1   --State
				)
		END
		ELSE IF ISNULL(@i_OpType, '') = 'SET'
		BEGIN
			PRINT 'Successfully completed execution at ' + Convert(varchar(60), getdate())
		END
	--
	-- we are done here
	--
	Return
	--
	-- For SQL Server hard errors, we jump here directly. Print an output line for script execution to see in output
	--
	errorline:
		--
		IF @@TRANCOUNT > 0 ROLLBACK TRAN
		--
		PRINT 'Script failed with SQL Server errors at ' + Convert(varchar(60), getdate())
END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ManageAWSKeyForUser')
	delete from GxQscripts where name = 'QS_ManageAWSKeyForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ManageAWSKeyForUser')
	delete from GXDBVersions where aliasname = 'QS_ManageAWSKeyForUser'
GO

insert into GXDBVersions values(2, 'QS_ManageAWSKeyForUser',  '00000000000000000000', 'QS_ManageAWSKeyForUser', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ManageAWSKeyForUser',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_ManageAWSKeyForUser.sql -si ''GET'' -si ''userName''
'
 + CHAR(10) + '	OR
'
 + CHAR(10) + '	qoperation execscript -sn QS_ManageAWSKeyForUser.sql -si ''SET'' -si ''userName'' -si ''SecurityKey''
'
 + CHAR(10) + '-- 	GET command will return the security key that was already set, if found on edge drive sub client property for specified user.'
 + CHAR(10) + '-- 	userName is login name for desired user.'
 + CHAR(10) + '-- 	SecurityKey is clear text key. It will be encrypted and saved as value of property named S3_SECURITY_KEY on specified user''s edge drive sub client.'
)
GO

