

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_MMViewDDBListing2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_MMViewDDBListing2 <<<'

IF EXISTS (select * from sysobjects where name='QS_MMViewDDBListing2')
	drop procedure QS_MMViewDDBListing2
IF EXISTS (select * from GxQscripts where name='QS_MMViewDDBListing2')
	delete from GxQscripts where name = 'QS_MMViewDDBListing2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MMViewDDBListing2')
	delete from GXDBVersions where aliasname = 'QS_MMViewDDBListing2'
GO
print '... Creating Procedure: QS_MMViewDDBListing2'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_MMViewDDBListing2
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_listSIDBInput int=0
AS
Set NOCOUNT ON
-- i_listDIDBInput -- 0 -- Show All SIDB stores
-- i_listDIDBInput -- 1 -- Show only sealed SIDB stores
      SELECT      APPC.net_hostname AS mediaAgentName,
                  AP.Path AS Path,
                  SIDB.SIDBStoreName AS SIDBStoreName,
                  AG.name AS StoragePolicyName,
                  AGC.name AS StoragePolicyCopyName,
                  AG.SIBlockSizeKB AS BlockSizeUsed,
                  dbo.getDateTime(SIDB.CreatedTime) AS SIDBCreateTime,
                  (CASE
			WHEN SIDB.SealedTime > 0 THEN dbo.getDateTime(SIDB.SealedTime)
			END
		  	) AS SIDBSealedTime,
                  (SIDB.TotalDataSizeBytes / (1024 * 1024 * 1024)) AS TotalDataSizeGB,
                  (SIDB.InstancedDataSizeBytes / (1024 * 1024 * 1024)) AS InstancedDataSizeGB,
                  (CASE
                        WHEN SIDB.status = 0 THEN 'Not Corrupted'
                        WHEN SIDB.status = 1 THEN 'Corrupted'
                        WHEN SIDB.status = 2 THEN 'Reconstructed'
                   ELSE
                        'Unknown'
                   END
                  ) AS SIDBStatus,
                  (CASE
                        WHEN AGC.flags & 2097152 <> 0 THEN 'Enabled'
                  ELSE
                        'Disabled'
                  END
                  ) AS TapeBackupStatus,
                  AAR.retentionDays AS retentionDays,
                  AAR.archiverRetDays AS ArchiverRetentionDays,
                  AAR.fullCycles AS retentionCycle,
                  (CASE
                        WHEN ((SELECT count(*) FROM archAgingRuleExtended AARE WITH (NOLOCK) WHERE AARE.copyId = ACSS.copyId) > 0)
                         THEN 'Enabled'
                        ELSE
                              'Disabled'
                  END
                  ) AS ExtendedRetentionStatus,
                  (CASE	WHEN AT.periodType = 3 THEN AT.numPeriod END) AS newSiloAfterDays,
                  (CASE	WHEN AT.periodType in(2,4)THEN AT.nextEvent END) AS newSiloOnDay,
                  (CASE WHEN AT.dataSizeGB > 0 THEN AT.dataSizeGB END) AS newSiloForSizeInGB
      FROM IdxSIDBStore SIDB WITH (NOLOCK), APP_Client APPC WITH (NOLOCK), IdxAccessPath AP WITH (NOLOCK),
           archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), archAgingRule AAR WITH (NOLOCK),
           archCopySIDBStore ACSS WITH (NOLOCK), archTask AT with (NOLOCK)
      WHERE SIDB.SIDBStoreId <> 0
      AND     SIDB.ClientId = APPC.id
      AND     SIDB.IdxAccessPathId = AP.IdxAccessPathId
      AND     SIDB.SIDBStoreId = ACSS.SIDBStoreId
      AND     ACSS.CopyId = AGC.id
      AND     AGC.archGroupId = AG.id
      AND     ACSS.CopyId = AAR.copyId
      AND	  AGC.sealStoreTaskId = AT.id
      AND     SIDB.SealedTime >= @i_listSIDBInput
-- SealedTime is ZERO for active SIDB stores
GO


IF EXISTS (select * from GxQscripts where name = 'QS_MMViewDDBListing2')
	delete from GxQscripts where name = 'QS_MMViewDDBListing2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MMViewDDBListing2')
	delete from GXDBVersions where aliasname = 'QS_MMViewDDBListing2'
GO

insert into GXDBVersions values(2, 'QS_MMViewDDBListing2',  '00000000000000000000', 'QS_MMViewDDBListing2', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_MMViewDDBListing2',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn MMViewDDBListing2  [-si 0/1]
'
)
GO

