

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_MMExtendDDBLimitsForAllCopies.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_MMExtendDDBLimitsForAllCopies <<<'

IF EXISTS (select * from sysobjects where name='QS_MMExtendDDBLimitsForAllCopies')
	drop procedure QS_MMExtendDDBLimitsForAllCopies
IF EXISTS (select * from GxQscripts where name='QS_MMExtendDDBLimitsForAllCopies')
	delete from GxQscripts where name = 'QS_MMExtendDDBLimitsForAllCopies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MMExtendDDBLimitsForAllCopies')
	delete from GXDBVersions where aliasname = 'QS_MMExtendDDBLimitsForAllCopies'
GO
print '... Creating Procedure: QS_MMExtendDDBLimitsForAllCopies'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_MMExtendDDBLimitsForAllCopies
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
AS
SET NOCOUNT ON
/*Local Variables */
DECLARE @CopiesToUpdate TABLE (archGroupId INT, StoragePolicyName NVARCHAR(144))
DECLARE @ExtensionTimeStamp INT
DECLARE @DecryptedTimeStamp VARCHAR(1000) = ''
DECLARE @EncryptedTimeStamp VARCHAR(5000) = ''
--DECLARE @DecryptedRetries VARCHAR(1000) = ''
--DECLARE @EncryptedRetries VARCHAR(5000) = ''
DECLARE @archGroupId INT
DECLARE @SPName NVARCHAR(144) = ''
DECLARE @ExtensionTimeStampStr VARCHAR(512) = ''
-----------------------error handling----
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
------------------------------------------
-----------------------GUIAuditTrail----
DECLARE @opMsgId int
SET @opMsgId = 0
DECLARE @GUIAuditUserId INT = 1    -- we do not have any way to determine user id.
DECLARE @opEvMsgId      INT = 0
DECLARE @opId           INT = 0
DECLARE @paramMsgId     INT = 0
------------------------------------------
BEGIN TRY
INSERT INTO @CopiesToUpdate(archGroupId,
							StoragePolicyName)
SELECT id, name
FROM archGroup WITH (READUNCOMMITTED)
WHERE flags & 65536 = 65536
	AND SubclientExtensionTimeStamp < dbo.getUnixTime(GETUTCDATE())
SET @ExtensionTimeStamp = dbo.GetUnixTime(DATEADD(DAY, 30, GETUTCDATE()))
SET @ExtensionTimeStampStr = dbo.UTCToClientLocalTime(dbo.getDateTime(@ExtensionTimeStamp), 2)
/*
SET @DecryptedTimeStamp = CAST(@ExtensionTimeStamp AS VARCHAR)
EXEC pswEncryptionManaged @DecryptedTimeStamp, @EncryptedTimeStamp OUTPUT
IF @EncryptedTimeStamp IS NULL OR LEN(@EncryptedTimeStamp) = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Could not encrypt the extended timestamp'
	GOTO ERROR_EXIT
END
*/
DECLARE Extend_Copy_DDBLimit_Cursor CURSOR LOCAL FORWARD_ONLY FOR
SELECT	archGroupId,  StoragePolicyName
FROM	@CopiesToUpdate
OPEN Extend_Copy_DDBLimit_Cursor
FETCH NEXT FROM Extend_Copy_DDBLimit_Cursor INTO @archGroupId, @SPName
WHILE (@@FETCH_STATUS = 0)
BEGIN
	SET @DecryptedTimeStamp = CAST(@archGroupId as VARCHAR) + '_' + CAST(@ExtensionTimeStamp as VARCHAR)
	EXEC pswEncryptionManaged @DecryptedTimeStamp, @EncryptedTimeStamp OUTPUT
	UPDATE archGroup
SET flags = flags & ~65536,
		SubclientExtensionTimeStamp =  @ExtensionTimeStamp,
		SubclientExtensionTimeStampEncrypted = @EncryptedTimeStamp
	WHERE id = @archGroupId
AND flags & 65536 = 65536
		AND SubclientExtensionTimeStamp < dbo.getUnixTime(GETUTCDATE())
	----------------Set GUI Audit Operation------------------
	SET @opMsgId = (7 | (CAST(POWER(2, 24) AS BIGINT) * 84))	 -- 'GUIAUDIT_OPS_CHANGE_SP_PROPS'
	EXEC EvGuiAuditSetOpWithEntity @opMsgId, @GUIAuditUserId, 17 /*STORAGE_POLICY_ENTITY*/, @archGroupId, @opEvMsgId OUTPUT, @opId OUTPUT
	SET @paramMsgId = (26 | (CAST(POWER(2, 24) AS BIGINT) * 85)) --GUIAUDIT_PARAMS_STORAGE_POLICY
	EXEC EvGuiAuditSetParamData @opId, @SPName, 0
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
	SET @paramMsgId = (1113 | (CAST(POWER(2, 24) AS BIGINT) * 85)) --GUIAUDIT_PARAMS_SIDB_ALLOW_SUBCLIENT_ASSOCIATION
	EXEC EvGuiAuditSetParamData @opId, @ExtensionTimeStampStr, 0
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
	-----------------------------------------------------------
	FETCH NEXT FROM Extend_Copy_DDBLimit_Cursor INTO @archGroupId, @SPName
END
CLOSE Extend_Copy_DDBLimit_Cursor
DEALLOCATE Extend_Copy_DDBLimit_Cursor
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = @@ERROR
	SET @errorString = (SELECT ERROR_MESSAGE())
	GOTO ERROR_EXIT
END CATCH
ERROR_EXIT:
IF @errorCode = 0
	print 'Script to extend DDBLimits executed SuccessFully'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_MMExtendDDBLimitsForAllCopies')
	delete from GxQscripts where name = 'QS_MMExtendDDBLimitsForAllCopies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MMExtendDDBLimitsForAllCopies')
	delete from GXDBVersions where aliasname = 'QS_MMExtendDDBLimitsForAllCopies'
GO

insert into GXDBVersions values(2, 'QS_MMExtendDDBLimitsForAllCopies',  '00000000000000000000', 'QS_MMExtendDDBLimitsForAllCopies', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_MMExtendDDBLimitsForAllCopies',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn MMExtendDDBLimitsForAllCopies
'
 + CHAR(10) + '--   script_name : MMExtendDDBLimitsForAllCopies'
)
GO

