

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_MMConvertMagLibToStaticShared.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_MMConvertMagLibToStaticShared')
BEGIN
	print '>>> Drop Stored Procedure: QS_MMConvertMagLibToStaticShared <<<'
	drop procedure QS_MMConvertMagLibToStaticShared
END
IF EXISTS (select * from GxQscripts where name='QS_MMConvertMagLibToStaticShared')
	delete from GxQscripts where name = 'QS_MMConvertMagLibToStaticShared'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MMConvertMagLibToStaticShared')
	delete from GXDBVersions where aliasname = 'QS_MMConvertMagLibToStaticShared'
GO
print '... Creating Procedure: QS_MMConvertMagLibToStaticShared'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_MMConvertMagLibToStaticShared
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @s_libraryName VARCHAR(128)
AS
Set NOCOUNT ON
	DECLARE @i_libraryId	INTEGER
	DECLARE @i_devId	INTEGER
	DECLARE @s_devName	VARCHAR(256)
	DECLARE @s_userName 	VARCHAR(256)
	DECLARE @s_password  	VARCHAR(256)
	DECLARE @i_clientId	INTEGER
	DECLARE @i_mntPathId	INTEGER
	DECLARE @s_mntPath	VARCHAR(2048)
	DECLARE @i_mntPathType	INTEGER
	DECLARE @i_libType	INTEGER
	SET @i_LibraryId = (SELECT libraryId FROM MMLibrary WHERE LibraryName = @s_libraryName)
	IF @@ROWCOUNT = 0
		RETURN 1
	SET @i_mntPathType = (SELECT top 1 MountPathTypeId FROM MMMountPath where LibraryId = @i_libraryId AND MountPathTypeId = 0)
	SET @i_libType = (SELECT LibraryTypeId FROM MMLibrary where LibraryId = @i_libraryId)
	IF @i_libType <> 3 OR @i_mntPathType IS NULL	-- Convert only regular magnetic to static shared
	BEGIN
		RETURN 1;
	END
	SET @i_clientId = (SELECT ClientId FROM MMLibraryController WHERE LibraryId = @i_libraryId)
	BEGIN TRY
		BEGIN TRAN
		DECLARE reader CURSOR FOR SELECT MountPathId FROM MMMountPath WHERE LibraryId = @i_libraryId AND MountPathTypeId = 0
		OPEN reader
		FETCH NEXT FROM reader INTO @i_mntPathId
		WHILE @@FETCH_STATUS=0
		BEGIN
			INSERT INTO MMDevice VALUES('',1,0,1,0,0,0,0,0,0,0,0,0,0,'',0,0,2,0,1)
			SET @i_devId = (select top 1 DeviceID from MMDevice(NOLOCK) ORDER BY DeviceId DESC)
			SET @s_devName = 'Device_'+CONVERT(varchar(10),@i_devId)
			SET @s_userName = (select userName from MMMountPath(NOLOCK) where MountPathId = @i_mntPathId)
			SET @s_password = (select UserPassword from MMMountPath(NOLOCK) where MountPathId = @i_mntPathId)
			UPDATE MMDevice SET AliasName = @s_devName WHERE DeviceId = @i_devId
			INSERT INTO MMMountPathToStorageDevice VALUES (@i_mntPathId,0,@i_devId)
			SET @s_mntPath = (SELECT MountPathName FROM MMMountPath WHERE MountPathId = @i_mntPathId)
			INSERT INTO MMDeviceController VALUES (@i_clientId,@i_devId,0,1,0,0,@s_userName,@s_password,@s_mntPath,0,1,0,0,0,6,0,0,0)
		FETCH NEXT FROM reader INTO @i_mntPathId
		END
		CLOSE reader
		DEALLOCATE reader
		UPDATE MMMountPath SET MountPathName = '', UserName = '', UserPassword = '', MountPathTypeId = 4 WHERE LibraryId = @i_libraryId AND MountPathTypeId = 0
		COMMIT TRAN
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		IF(CURSOR_STATUS('local', 'reader') >= -1 OR CURSOR_STATUS('global', 'reader') >= -1)
		BEGIN
			IF(CURSOR_STATUS('local', 'reader') >= 0 OR CURSOR_STATUS('global', 'reader') >= 0) --Cursor is OPEN
				CLOSE reader
			DEALLOCATE reader
		END
		IF @@TRANCOUNT > 0
			ROLLBACK TRAN
		DECLARE @ErrorString nvarchar(max)
		SET @ErrorString = 'Error Line [' +CAST(ERROR_LINE() AS nvarchar(10)) +']. ' + 'Error Procedure [' + ERROR_PROCEDURE()  +']. ' + ERROR_MESSAGE()
		RAISERROR(@ErrorString, 15, 1)
	END CATCH
	RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_MMConvertMagLibToStaticShared')
	delete from GxQscripts where name = 'QS_MMConvertMagLibToStaticShared'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MMConvertMagLibToStaticShared')
	delete from GXDBVersions where aliasname = 'QS_MMConvertMagLibToStaticShared'
GO

insert into GXDBVersions values(2, 'QS_MMConvertMagLibToStaticShared',  '00000000000000000000', 'QS_MMConvertMagLibToStaticShared', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_MMConvertMagLibToStaticShared',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn MMConvertMagLibToStaticShared -si "LibraryName"
'
)
GO

