

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ListSLAExclusionForSubclients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ListSLAExclusionForSubclients <<<'

IF EXISTS (select * from sysobjects where name='QS_ListSLAExclusionForSubclients')
	drop procedure QS_ListSLAExclusionForSubclients
IF EXISTS (select * from GxQscripts where name='QS_ListSLAExclusionForSubclients')
	delete from GxQscripts where name = 'QS_ListSLAExclusionForSubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ListSLAExclusionForSubclients')
	delete from GXDBVersions where aliasname = 'QS_ListSLAExclusionForSubclients'
GO
print '... Creating Procedure: QS_ListSLAExclusionForSubclients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_ListSLAExclusionForSubclients
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @SubclientExcluded INT = 0
AS
Set NOCOUNT ON
DECLARE @scriptName	varchar(32)
SET	@scriptName	= 'QS_ListSLAExclusionForSubclients'
DECLARE @lastError integer
SET     @lastError = 0									-- Be optimistic
DECLARE @localErrorMsg varchar(512)
SET	@localErrorMsg ='Error Encountered when running script.'
IF @SubclientExcluded NOT IN (0, 1)
BEGIN
		SET @localErrorMsg = 'Incorrect input parameter'
		Set @lastError = 1
		goto ARGS_ERROR
END
SELECT	A.id AS AppId,
CL.name AS ClientName,
IT.name AS AppTypeName,
INS.name AS InstanceName,
BS.name AS BackupsetName,
A.SubclientName,
ISNULL(CP.attrVal, '0') AS ClientExcluded,
ISNULL(SCP.attrVal, '0') AS SubclientExcluded
FROM	APP_Application A
INNER JOIN APP_Client CL ON A.clientId = CL.id AND CL.status&2 = 0
INNER JOIN APP_iDAType IT ON A.appTypeId = IT.type
INNER JOIN APP_InstanceName INS ON A.instance = INS.id
INNER JOIN APP_BackupSetName BS ON A.backupSet = BS.id
LEFT OUTER JOIN APP_ClientProp CP ON A.clientId = CP.componentNameId AND CP.attrName = 'Exclude From SLA' AND CP.attrVal = '1' AND CP.modified = 0
LEFT OUTER JOIN APP_SubClientProp SCP ON A.id = SCP.componentNameId AND SCP.attrName = 'Exclude From SLA' AND SCP.attrVal = '1' AND SCP.modified = 0
WHERE	A.subclientStatus&2 = 0 AND ((ISNULL(SCP.attrVal, '0') = @SubclientExcluded))
ORDER BY ClientName, AppTypeName, InstanceName, BackupsetName, SubclientName
Set NOCOUNT OFF
ARGS_ERROR:
	Print ''
	PRINT @scriptName + ' completed at ' + Convert(varchar(60), getdate()) + '. Exit Code(' +convert(varchar(2), @lastError) + ').'
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ListSLAExclusionForSubclients')
	delete from GxQscripts where name = 'QS_ListSLAExclusionForSubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ListSLAExclusionForSubclients')
	delete from GXDBVersions where aliasname = 'QS_ListSLAExclusionForSubclients'
GO

insert into GXDBVersions values(2, 'QS_ListSLAExclusionForSubclients',  '00000000000000000000', 'QS_ListSLAExclusionForSubclients', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ListSLAExclusionForSubclients',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	List the subclients that have ''Exclude From SLA'' property set or not. 
'
 + CHAR(10) + '-- 	script_name: QS_ListSLAExclusionForSubclients'
 + CHAR(10) + '-- 	Command to list only those subclient which are included for SLA calculation: qoperation execscript -sn QS_ListSLAExclusionForSubclients -si 0 -file "c:\temp\sla.txt"'
 + CHAR(10) + '-- 	Command to list only those subclient which are excluded from SLA calculation: qoperation execscript -sn QS_ListSLAExclusionForSubclients -si 1 -file "c:\temp\sla.txt"'
)
GO

