

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ListRequiredMediaForAuxCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2012  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- CR:  Match the SP & Copy Name Lenght and types. Also be consistent in types across temp tables.  [DONE]
-- CR:  Show user what jobs were actaully marked bad and what were skipped.
-- CR:  On error, get error string from SQL server
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ListRequiredMediaForAuxCopy <<<'

IF EXISTS (select * from sysobjects where name='QS_ListRequiredMediaForAuxCopy')
	drop procedure QS_ListRequiredMediaForAuxCopy
IF EXISTS (select * from GxQscripts where name='QS_ListRequiredMediaForAuxCopy')
	delete from GxQscripts where name = 'QS_ListRequiredMediaForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ListRequiredMediaForAuxCopy')
	delete from GXDBVersions where aliasname = 'QS_ListRequiredMediaForAuxCopy'
GO
print '... Creating Procedure: QS_ListRequiredMediaForAuxCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ListRequiredMediaForAuxCopy
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @inAuxCopyJobId INT = 0
AS
  DECLARE @o_policyName NVARCHAR(256)
  DECLARE @o_copyName NVARCHAR(64)
  DECLARE @o_streamNum integer
  DECLARE @o_barCode char(256)
  DECLARE @o_libraryName NVARCHAR(128)
  DECLARE @o_location NVARCHAR(1024)
SET NOCOUNT ON
DECLARE @scrErrorCode	INT
DECLARE	@scrErrorStr	VARCHAR(1024)
DECLARE	@StorPolId		INT
IF object_id('tempdb.dbo.#TmpReqdMediaList') IS NOT NULL DROP TABLE #TmpReqdMediaList
CREATE TABLE #TmpReqdMediaList (
     policyId         integer,
     policyName       NVARCHAR(256),
     copyId           integer,
     copyName         NVARCHAR(64),
     streamNum        integer,
     mediaGroupId     integer,
     mediaId          integer,
     uniqueId         char(300),
     barCode          char(256),
     attributes       integer,
     guiAttributes    integer,
     libraryId        integer,
     libraryName      NVARCHAR(128),
     locationType     integer,
     locationId       integer,
     location         NVARCHAR(1024),
     uncopiedBytes    bigint)
SET @scrErrorCode = 0
IF(@inAuxCopyJobId > 0)
BEGIN
	SELECT @StorPolId = archGrpID
	FROM	JMAdminJobInfoTable
	WHERE	jobId = @inAuxCopyJobId AND opType IN (13, 104)
	IF (@@ROWCOUNT = 0 OR @@ERROR > 0)
	BEGIN
		SET @scrErrorCode  = -1
		SET @scrErrorStr = 'Failed to read storage policy and copy information of given auxiliary copy job Id:['
			+ CONVERT(varchar(32),@inAuxCopyJobId) + ']. Please provide valid job Id.'
		GOTO SCR_EXIT
	END
	INSERT INTO #TmpReqdMediaList
	EXEC archSourceMediaForAdminJob @StorPolId,@inAuxCopyJobId,6
	IF (@@ERROR > 0)
	BEGIN
		SET @scrErrorCode  = @@ERROR
		SET @scrErrorStr = 'Encountered error ' + CONVERT(VARCHAR(32),@scrErrorCode)  + ' while getting required media list.'
		GOTO SCR_EXIT
	END
	SELECT policyName,copyName,streamNum,barCode,libraryName,location
	FROM	#TmpReqdMediaList
END
ELSE
BEGIN
	SET @scrErrorCode  = -1
	SET @scrErrorStr = 'Invalid auxiliary copy job Id:['
			+ CONVERT(varchar(32),@inAuxCopyJobId) + '] passed. Please provide valid job Id.'
	GOTO SCR_EXIT
END
SCR_EXIT:
DROP TABLE #TmpReqdMediaList
IF(@scrErrorCode <> 0 )
BEGIN
		Raiserror(@scrErrorStr,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ListRequiredMediaForAuxCopy')
	delete from GxQscripts where name = 'QS_ListRequiredMediaForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ListRequiredMediaForAuxCopy')
	delete from GXDBVersions where aliasname = 'QS_ListRequiredMediaForAuxCopy'
GO

insert into GXDBVersions values(2, 'QS_ListRequiredMediaForAuxCopy',  '00000000000000000000', 'QS_ListRequiredMediaForAuxCopy', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ListRequiredMediaForAuxCopy',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Script to list required media by auxiliary copy job.
'
)
GO

