

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ListMediaContents.sp] ---------- 

--  +========================================================================+
--  |		 		Name:  QS_ListMediaContents()
--  | Description:  This SP is from Permanent QScript - ListMediaContents
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_ListMediaContents.sp,v $ $Id: QS_ListMediaContents.sp,v 1.6.48.4 2019/03/15 22:09:44 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_ListMediaContents')
BEGIN
	print '>>> Drop Stored Procedure: QS_ListMediaContents <<<'
	drop procedure QS_ListMediaContents
END
IF EXISTS (select * from GxQscripts where name='QS_ListMediaContents')
	delete from GxQscripts where name = 'QS_ListMediaContents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ListMediaContents')
	delete from GXDBVersions where aliasname = 'QS_ListMediaContents'
GO
print '... Creating Procedure: QS_ListMediaContents'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ListMediaContents
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_Param1 NVARCHAR(2048) = '', --Media_barcode/library_name
  @i_Param2 NVARCHAR(2048) = '', --mountpath_name
  @i_Param3 NVARCHAR(2048) = '' --MediaAgent_name
AS
  DECLARE @o_jobId INTEGER
  DECLARE @o_JobStatus VARCHAR(255)
  DECLARE @o_clientName VARCHAR(255)
  DECLARE @o_appTypeName VARCHAR(255)
  DECLARE @o_instanceName VARCHAR(255)
  DECLARE @o_backupSetName VARCHAR(255)
  DECLARE @o_subclientName NVARCHAR(255)
  DECLARE @o_bkpLevel VARCHAR(255)
  DECLARE @o_cycleSequence VARCHAR(20)
  DECLARE @o_archFileType VARCHAR(255)
  DECLARE @o_backupTime VARCHAR(20)
  DECLARE @o_retainUntil VARCHAR(20)
  DECLARE @o_mediaSideName VARCHAR(255)
  DECLARE @o_archFileName NVARCHAR(2048)
  DECLARE @o_archGroupCopyName NVARCHAR(255)
  DECLARE @o_agedStatus VARCHAR(255)
  DECLARE @o_sizeOnMedia VARCHAR(50)
  DECLARE @o_sizeOfBackup VARCHAR(50)
	SET NOCOUNT ON
	-------------------------------------------------------------------------------
	-- Table variable declarations
	-------------------------------------------------------------------------------
	IF OBJECT_ID('tempdb..#tblMediaContents') IS NOT NULL  DROP TABLE #tblMediaContents
	CREATE TABLE #tblMediaContents
	(
		jobId								INTEGER,
		backupLevel					INTEGER,
		fullCycleNum				INTEGER,
		cycleSeqNum					INTEGER,
		jobStartTime				INTEGER,
		jobStatus						INTEGER,
		jobDataStatus				INTEGER,
		jobDataFlags				INTEGER,
		retentionDays				BIGINT,
		pinJobEndTime				BIGINT,
		archFileId					INTEGER,
archFileName				NVARCHAR(2048),
		archFileType				INTEGER,
		archFileCreateTime	INTEGER,
		isValidData					INTEGER,
		sizeOnMedia					DECIMAL(38, 2),
		sizeOfBackup				DECIMAL(38, 2),
		mediaSideId					INTEGER,
		clientId						INTEGER,
		clientName					VARCHAR(2048),
		appTypeId						INTEGER,
		appTypeName					VARCHAR(2048),
		instanceId					INTEGER,
		instanceName				VARCHAR(2048),
		backupSetId					INTEGER,
		backupSetName				VARCHAR(2048),
		appId								INTEGER,
subclientName				NVARCHAR(255),
		archGroupId					INTEGER,
		archGroupName				NVARCHAR(2048),
		copyId							INTEGER,
		copyName						NVARCHAR(2048),
		mediaSideName				VARCHAR(2048),
		applicationSize				BIGINT
	)
	DECLARE @i_MediaId 		INTEGER
	SET		@i_MediaId 		= 0
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	=''
	IF (@i_Param2 = '')
	BEGIN
		SELECT @i_MediaId = mediaId
		FROM MMMedia WITH (NOLOCK)
		WHERE barcode = @i_Param1
		IF (@i_MediaId = 0)
		BEGIN
			SET @localErrorMsg = 'Error: Barcode not found!'
			SET @lastError = 1
			GOTO   ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		IF NOT EXISTS (SELECT * FROM MMLibrary WHERE aliasName = @i_Param1)
		BEGIN
			SET @localErrorMsg = 'Error: Library not found!'
			SET @lastError = 1
			GOTO   ARGS_ERROR
		END
		IF EXISTS (SELECT * FROM MMLibrary WHERE aliasName = @i_Param1 AND libraryTypeId <> 3) -- CV_LIB_MAGNETIC
		BEGIN
			SET @localErrorMsg = 'Error: Library is not a disk library!'
			SET @lastError = 1
			GOTO   ARGS_ERROR
		END
		IF (@i_Param3 != '') AND NOT EXISTS (SELECT * FROM APP_Client WHERE Name = @i_Param3)
		BEGIN
			SET @localErrorMsg = 'Error: MediaAgent not found!'
			SET @lastError = 1
			GOTO   ARGS_ERROR
		END
		SELECT	TOP 1 @i_MediaId = MP.mediaId
		FROM	MMS2getMountPathList MP, MMLibrary ML WITH (READUNCOMMITTED), APP_Client C WITH (READUNCOMMITTED)
		WHERE	MP.LibraryId = ML.LibraryId
				AND MP.clientId = C.id
				AND ML.AliasName = @i_Param1
				AND MP.MountPathName = @i_Param2
				AND ((C.name = @i_Param3) OR (@i_Param3 = ''))
		IF (@i_MediaId = 0)
		BEGIN
			SET @localErrorMsg = 'Error: Mount Path not found!'
			SET @lastError = 1
			GOTO   ARGS_ERROR
		END
	END
	INSERT INTO #tblMediaContents
	EXEC GetMediaContents @i_MediaId
	UPDATE #tblMediaContents
	SET backupLevel = 1
	WHERE appTypeId IN (45, 56, 57) 	-- Exchange 2000 Data Migrator, Exchange 2003 Data Migrator, Exchange 5.5 Data Migrator
	SELECT 	jobId AS "JobId",
					CASE
						WHEN jobStatus = 0 THEN 'Running'
						WHEN jobStatus = 1 THEN 'Completed'
						WHEN jobStatus = 2 THEN 'Failed'
						WHEN jobStatus = 3 THEN 'Completed with errors'
						WHEN jobStatus = 4 THEN 'Killed'
						WHEN jobStatus = 5 THEN 'Suspended'
						WHEN jobStatus = 6 THEN 'Interrupted'
						WHEN jobStatus = 7 THEN 'Any Status'
						WHEN jobStatus = 8 THEN 'Skipped'
						WHEN jobStatus = 9 THEN 'Failed To Start'
					ELSE 'Not Available'
					END AS "Status",
					clientName AS "Client",
					appTypeName AS "iDataAgent",
					instanceName AS "Instance",
					backupSetName AS "Backup Set",
					subclientName AS "Subclient",
					CASE
						WHEN backupLevel = 1 THEN
							CASE WHEN (appTypeId = 45 OR appTypeId = 56 OR appTypeId = 57 OR appTypeId = 58 OR appTypeId = 73)
								THEN 'New Index'
							ELSE
								'Full'
							END
						WHEN backupLevel = 2 THEN
							CASE WHEN (appTypeId = 4 OR appTypeId = 16 OR appTypeId = 70 OR appTypeId = 5 OR appTypeId = 81 OR appTypeId = 125)
								THEN 'Transaction Log'
							ELSE
								'Incremental'
							END
						WHEN backupLevel = 512 THEN 'Transaction Log'
						WHEN backupLevel = 4 THEN
							CASE WHEN (appTypeId = 37 OR appTypeId = 62)
								THEN 'Delta'
							ELSE
								'Differential'
							END
						WHEN backupLevel = 64 OR backupLevel = 128 THEN 'Synthetic Full'
						WHEN backupLevel = 256 THEN 'Trans. Log No Truncation'
						WHEN backupLevel = 1024 THEN 'Offline Full'
						WHEN backupLevel = 32768 THEN 'Online Full'
						WHEN backupLevel = 2048 THEN 'Snapshot'
						WHEN backupLevel = 4096 THEN 'Create Replica'
						WHEN backupLevel = 8192 THEN 'Update Replica'
					ELSE ''
					END AS "Backup Level",
					(CAST(fullCycleNum AS VARCHAR(10)) + '/' + CAST(cycleSeqNum AS VARCHAR(10))) AS "Cycles/Sequences",
					CASE
						WHEN archFileType = 1 THEN 'Data'
						WHEN archFileType = 2 THEN 'Index'
						WHEN archFileType = 3 THEN 'Archive_file'
						WHEN archFileType = 4 THEN 'Log'
					ELSE ''
					END AS "Archive File Type",
					CONVERT(VARCHAR(20), dbo.UTCToClientLocalTime(dbo.GetDateTime(archFileCreateTime), 2), 120) AS "Backup Time",
					CASE
						WHEN (retentionDays = -1 OR pinJobEndTime = -1)
							THEN 'INFINITE'
						WHEN ((jobStartTime + retentionDays * 24 * 3600) > pinJobEndTime)
							THEN CONVERT(VARCHAR(20), dbo.UTCToClientLocalTime(dbo.GetDateTimeBig((jobStartTime + retentionDays * 24 * 3600)), 2), 120)
						ELSE CONVERT(VARCHAR(20), dbo.UTCToClientLocalTime(dbo.GetDateTimeBig(pinJobEndTime), 2), 120)
					END AS "Retain Until",
					mediaSideName AS "Side",
					archFileName AS "Archive File",
					(archGroupName + '/' + copyName) AS "Storage Policy/Copy",
					CASE 	WHEN (jobDataFlags & 256) > 0 THEN 'AGED' ELSE 'NOT AGED' END AS "Aged Status",
					CASE
						WHEN ABS(sizeOnMedia) < 1024  THEN CAST(CAST(sizeOnMedia AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' Bytes'
						WHEN ABS(sizeOnMedia) < 1048576 THEN CAST(CAST((sizeOnMedia/1024) AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' KB'
						WHEN ABS(sizeOnMedia) < 1073741824 THEN CAST(CAST((sizeOnMedia/1048576) AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' MB'
						WHEN ABS(sizeOnMedia) < 1099511627776 THEN CAST(CAST((sizeOnMedia/1073741824) AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' GB'
						WHEN ABS(sizeOnMedia) < 1125899906842624 THEN CAST(CAST((sizeOnMedia/1099511627776) AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' TB'
						WHEN ABS(sizeOnMedia) < 1152921504606846976 THEN CAST(CAST((sizeOnMedia/1125899906842624) AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' PB'
	        ELSE
	        	CAST(CAST(sizeOnMedia AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' Bytes'
	        END AS "Size On Media",
					CASE
						WHEN ABS(sizeOfBackup) < 1024  THEN CAST(CAST(sizeOfBackup AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' Bytes'
						WHEN ABS(sizeOfBackup) < 1048576 THEN CAST(CAST((sizeOfBackup/1024) AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' KB'
						WHEN ABS(sizeOfBackup) < 1073741824 THEN CAST(CAST((sizeOfBackup/1048576) AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' MB'
						WHEN ABS(sizeOfBackup) < 1099511627776 THEN CAST(CAST((sizeOfBackup/1073741824) AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' GB'
						WHEN ABS(sizeOfBackup) < 1125899906842624 THEN CAST(CAST((sizeOfBackup/1099511627776) AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' TB'
						WHEN ABS(sizeOfBackup) < 1152921504606846976 THEN CAST(CAST((sizeOfBackup/1125899906842624) AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' PB'
	        ELSE
	        	CAST(CAST(sizeOfBackup AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' Bytes'
	        END AS "Size Of Backup"
	FROM #tblMediaContents
	WHERE jobId <> 0 and isValidData > 0
ARGS_ERROR:
	if @lastError <> 0
	BEGIN
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
	END
	IF OBJECT_ID('tempdb..#tblMediaContents') IS NOT NULL  DROP TABLE #tblMediaContents
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ListMediaContents')
	delete from GxQscripts where name = 'QS_ListMediaContents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ListMediaContents')
	delete from GXDBVersions where aliasname = 'QS_ListMediaContents'
GO

insert into GXDBVersions values(2, 'QS_ListMediaContents',  '00010006004800040000', 'QS_ListMediaContents', '00010006004800040000')
GO

insert into GxQscripts values(2,'QS_ListMediaContents',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn ListMediaContents.sql -si media_barcode 
'
 + CHAR(10) + '	qoperation execscript -sn ListMediaContents.sql -si library_name -si mountpath_name -si mediaagent_name
'
)
GO

