

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ListManuallyRetainedJobs.sp] ---------- 

--  +========================================================================+
--  |		 		Name:  QS_ListMediaContents()
--  | Description:  This SP is from Permanent QScript - ListMediaContents
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_ListManuallyRetainedJobs.sp,v $ $Id: QS_ListManuallyRetainedJobs.sp,v 1.3.48.3 2018/03/22 00:59:48 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ListManuallyRetainedJobs <<<'

IF EXISTS (select * from sysobjects where name='QS_ListManuallyRetainedJobs')
	drop procedure QS_ListManuallyRetainedJobs
IF EXISTS (select * from GxQscripts where name='QS_ListManuallyRetainedJobs')
	delete from GxQscripts where name = 'QS_ListManuallyRetainedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ListManuallyRetainedJobs')
	delete from GXDBVersions where aliasname = 'QS_ListManuallyRetainedJobs'
GO
print '... Creating Procedure: QS_ListManuallyRetainedJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ListManuallyRetainedJobs
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_archGrpName NVARCHAR(255) = '',
  @i_archGrpCopyName NVARCHAR(255) = ''
AS
  DECLARE @o_jobId INTEGER
  DECLARE @o_SPName NVARCHAR(255)
  DECLARE @o_CopyName NVARCHAR(255)
  DECLARE @o_retainUntil NVARCHAR(50)
	SET NOCOUNT ON
	IF ((@i_archGrpName = '') AND (@i_archGrpCopyName <> ''))
	BEGIN
		PRINT 'Invalid inputs. Please refer documentation.'
		GOTO CX_EXIT
	END
	DECLARE @archGrpId 	INTEGER
	SET 	@archGrpId	= 0
	DECLARE	@archGrpCopyId 	INTEGER
	SET 	@archGrpCopyId	= 0
	DECLARE	@errorCode	INTEGER
	SET	@errorCode	= 0
	IF (@i_archGrpName <> '')
	BEGIN
		SELECT @archGrpId = id
		FROM archGroup WITH (NOLOCK)
		WHERE name = @i_archGrpName
		SET @errorCode = @@ERROR
		IF @errorCode != 0 GOTO CX_EXIT
		IF @archGrpId = 0
		BEGIN
			PRINT 'Invalid Storage Policy Name.'
			GOTO CX_EXIT
		END
	END
	IF (@i_archGrpCopyName <> '')
	BEGIN
		SELECT @archGrpCopyId = id
		FROM archGroupCopy WITH (NOLOCK)
		WHERE archGroupId = @archGrpId
		AND   name = @i_archGrpCopyName
		SET @errorCode = @@ERROR
		IF @errorCode != 0 GOTO CX_EXIT
		IF @archGrpCopyId = 0
		BEGIN
			PRINT 'Invalid Copy Name.'
			GOTO CX_EXIT
		END
	END
	SELECT DISTINCT jobId AS "Job ID", AG.name AS "Storage Policy Name", AGC.name AS "Copy Name",
		CASE WHEN (manualRetentionEndTime < 0) THEN N'INFINITE'
			WHEN (manualRetentionEndTime = 0) THEN N'NO RETENTION'
			ELSE CAST(dbo.UTCToClientLocalTime(dbo.getDateTimeBig(manualRetentionEndTime), 2) AS NVARCHAR(50))
		END AS "Retention End Time"
	FROM JMJobDataStats JDS WITH (NOLOCK) , archGroup AG WITH (NOLOCK),archGroupCopy AGC WITH (NOLOCK)
	WHERE	AG.id = JDS.archGrpId  AND	AG.id = AGC.archGroupId AND AGC.id = JDS.archGrpCopyId
	AND	(AG.id = @archGrpId OR @archGrpId = 0) AND	(AGC.id = @archGrpCopyId OR @archGrpCopyId = 0)
AND		(disabled & 256) = 0
AND		(disabled & 2) > 0
	ORDER BY AG.name,AGC.name,jobId
	RETURN
  CX_EXIT:
 	PRINT 'Failed to get the list of manually retained jobs.'
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ListManuallyRetainedJobs')
	delete from GxQscripts where name = 'QS_ListManuallyRetainedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ListManuallyRetainedJobs')
	delete from GXDBVersions where aliasname = 'QS_ListManuallyRetainedJobs'
GO

insert into GXDBVersions values(2, 'QS_ListManuallyRetainedJobs',  '00010003004800030000', 'QS_ListManuallyRetainedJobs', '00010003004800030000')
GO

insert into GxQscripts values(2,'QS_ListManuallyRetainedJobs',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn ListManuallyRetainedJobs.sql -si StoragePolicyName -si CopyName 
'
)
GO

