

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ListMAForIndexCacheProfile.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ListMAForIndexCacheProfile <<<'

IF EXISTS (select * from sysobjects where name='QS_ListMAForIndexCacheProfile')
	drop procedure QS_ListMAForIndexCacheProfile
IF EXISTS (select * from GxQscripts where name='QS_ListMAForIndexCacheProfile')
	delete from GxQscripts where name = 'QS_ListMAForIndexCacheProfile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ListMAForIndexCacheProfile')
	delete from GXDBVersions where aliasname = 'QS_ListMAForIndexCacheProfile'
GO
print '... Creating Procedure: QS_ListMAForIndexCacheProfile'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ListMAForIndexCacheProfile
  @catalogServerName VARCHAR(1024) = '%s'
AS
SET NOCOUNT ON
IF NOT EXISTS(SELECT IdxCacheId FROM IdxCache WHERE CatalogServerClientId <> 0 AND Description = @catalogServerName)
BEGIN
	PRINT 'An index cache profile with the given name does not exist'
	RETURN (-1)
END
SELECT Client.name AS 'ClientName', Client.net_hostname AS 'HostName' FROM IdxAccessPath AccessPath, App_Client Client
WHERE
IdxCacheId IN (SELECT IdxCacheId FROM IdxCache WHERE CatalogServerClientId <> 0 AND Description = @catalogServerName)
AND AccessPath.ClientId = Client.id
IF @@ROWCOUNT = 0
BEGIN
PRINT 'No MediaAgents associated with the given index cache profile'
END
RETURN (0)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ListMAForIndexCacheProfile')
	delete from GxQscripts where name = 'QS_ListMAForIndexCacheProfile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ListMAForIndexCacheProfile')
	delete from GXDBVersions where aliasname = 'QS_ListMAForIndexCacheProfile'
GO

insert into GXDBVersions values(2, 'QS_ListMAForIndexCacheProfile',  '00000000000000000000', 'QS_ListMAForIndexCacheProfile', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ListMAForIndexCacheProfile',  0, GETDATE(), GETDATE(), '' + CHAR(10) + ' qoperation execscript -sn QS_ListMAForIndexCacheProfile.sql -si <indexcache-profile-name>
'
 + CHAR(10) + ' If the index cache profile name has unicode or special characters, use double quotes around the index cache profile name
'
)
GO

