

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ListGACPGDSPDependentSPs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_ListGACPGDSPDependentSPs')
BEGIN
	print '>>> Drop Stored Procedure: QS_ListGACPGDSPDependentSPs <<<'
	drop procedure QS_ListGACPGDSPDependentSPs
END
IF EXISTS (select * from GxQscripts where name='QS_ListGACPGDSPDependentSPs')
	delete from GxQscripts where name = 'QS_ListGACPGDSPDependentSPs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ListGACPGDSPDependentSPs')
	delete from GXDBVersions where aliasname = 'QS_ListGACPGDSPDependentSPs'
GO
print '... Creating Procedure: QS_ListGACPGDSPDependentSPs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_ListGACPGDSPDependentSPs
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @spName NVARCHAR(288) =''
AS
SET NOCOUNT ON
DECLARE @isGSP 					integer
SET 	@isGSP					= 0 --0 none 1: GDSP 2: GACP
DECLARE @lastError				integer
SET		@lastError				= 0
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
BEGIN TRY
SELECT @isGSP = case when flags&256 > 0 then 1 when flags&16384 > 0 then 2 else 0 END -- insert macros here
FROM archGroup
WHERE name = @spName
IF @isGSP = 1
BEGIN
	print('Following Storage Policies are dependent on Global Deduplication Policy :'+@spName)
	SELECT ROW_NUMBER()
			OVER (ORDER BY DAG.name, DAGC.name) AS 'S.No.',DAG.name as 'Storaga Policy Name', DAGC.name as 'Copy'
	FROM archGroup GDSP
		INNER JOIN archCopyToGlobalPolicy GP ON GP.globalPolicyId = GDSP.id
		INNER JOIN archGroupCopy DAGC ON DAGC.id = GP.copyId
		INNER JOIN archgroup DAG ON DAG.id = DAGC.archGroupId
	WHERE	GDSP.name = @spName
END
ELSE IF @isGSP = 2
BEGIN
	print('Following Storage Policies are dependent on Global Secondary Copy Policy :'+@spName)
	SELECT ROW_NUMBER()
			OVER (ORDER BY DAG.name, DAGC.name) AS 'S.No.',DAG.name as 'Storaga Policy Name', DAGC.name as 'Copy'
	FROM archGroup GACP
		INNER JOIN archCopyToGlobalPolicy GP ON GP.globalPolicyId = GACP.id
		INNER JOIN archGroupCopy DAGC ON DAGC.id = GP.copyId
		INNER JOIN archgroup DAG ON DAG.id = DAGC.archGroupId
	WHERE	GACP.name = @spName
END
ELSE
BEGIN
SET @localErrorMsg = 'The given Storage Policy Name is neither a Global Secondary Copy Policy nor a Global Deduplication Policy'
SET @lastError = 1
GOTO SCRIPT_EXIT
END
END TRY
BEGIN catch
	set @localErrorMsg = ERROR_MESSAGE()
END catch
SCRIPT_EXIT:
	IF @lastError <> 0
	BEGIN
		set @localErrorMSg = CHAR(13)+CHAR(10) + @localErrorMsg
		Raiserror(@localErrorMsg,
						15,  --Severity (> 10 to force DOS Error Code = 1)
						1	 --State
						)
	END
SET NOCOUNT off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ListGACPGDSPDependentSPs')
	delete from GxQscripts where name = 'QS_ListGACPGDSPDependentSPs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ListGACPGDSPDependentSPs')
	delete from GXDBVersions where aliasname = 'QS_ListGACPGDSPDependentSPs'
GO

insert into GXDBVersions values(2, 'QS_ListGACPGDSPDependentSPs',  '00000000000000000000', 'QS_ListGACPGDSPDependentSPs', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ListGACPGDSPDependentSPs',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '--  qoperation execscript -sn QS_ListGACPGDSPDependentSPs -si NameOfGlobalStoragePolicy  '
 + CHAR(10) + '--  Use the above command to get the list of Storage Policies dependent on the given Global Storage Policy'
)
GO

