

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_LMCreateF5MonitoringPolicyAndTemplate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_LMCreateF5MonitoringPolicyAndTemplate <<<'

IF EXISTS (select * from sysobjects where name='QS_LMCreateF5MonitoringPolicyAndTemplate')
	drop procedure QS_LMCreateF5MonitoringPolicyAndTemplate
IF EXISTS (select * from GxQscripts where name='QS_LMCreateF5MonitoringPolicyAndTemplate')
	delete from GxQscripts where name = 'QS_LMCreateF5MonitoringPolicyAndTemplate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_LMCreateF5MonitoringPolicyAndTemplate')
	delete from GXDBVersions where aliasname = 'QS_LMCreateF5MonitoringPolicyAndTemplate'
GO
print '... Creating Procedure: QS_LMCreateF5MonitoringPolicyAndTemplate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_LMCreateF5MonitoringPolicyAndTemplate
  @i_content NVARCHAR(max)
--QScript is enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- No input for this QScript
AS
SET NOCOUNT ON
DECLARE @curUtcDateTime BIGINT
DECLARE @templateId INT
DECLARE @monitoringPolicyId INT
DECLARE @monitoringPOlicyName NVARCHAR(max)
DECLARE @templateName NVARCHAR(max)
DECLARE @templateXMLString NVARCHAR(max)
DECLARE @errorCode int = 0
DECLARE @errorString NVARCHAR(1024) = ''
BEGIN TRY
BEGIN TRANSACTION LMCreateF5MpTran
SET @curUtcDateTime =  DBO.GetUnixTime(GETUTCDATE())
SET @monitoringPOlicyName = 'F5-System Created Policy'
SET @templateName = 'F5 Template'
SET @templateXMLString = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><LogMonitoring_TemplateXML fileExtension="*.*" isFixedWidth="0" lengthOfHeader="0" seperatorList="1" templateForMonitoringType="0" treatMultipleSeparatorAsOne="1"><columns decimalPlaces="2" defaultOpType="0" index="0" isFacet="1" isIndexed="1" primaryDataType="2" primaryTypeFormat="27" solrFieldName="DateField" useThousandSeparator="0"><column _type_="87" columnId="1" columnName="DateField"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns decimalPlaces="2" defaultOpType="0" index="1" isFacet="1" isIndexed="1" primaryDataType="3" primaryTypeFormat="17" solrFieldName="TimeField" useThousandSeparator="0"><column _type_="87" columnId="2" columnName="TimeField"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/></columns><columns decimalPlaces="2" defaultOpType="2" format="" index="2" isFacet="1" isIndexed="1" primaryDataType="1" primaryTypeFormat="21" solrFieldName="Host" useThousandSeparator="0"><column _type_="87" columnId="3" columnName="Host"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns decimalPlaces="2" defaultOpType="2" format="" index="3" isFacet="1" isIndexed="1" primaryDataType="1" primaryTypeFormat="21" solrFieldName="ProcessField" useThousandSeparator="0"><column _type_="87" columnId="4" columnName="ProcessField"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns decimalPlaces="2" defaultOpType="2" format="" index="4" isFacet="0" isIndexed="1" primaryDataType="1" primaryTypeFormat="22" solrFieldName="Description" useThousandSeparator="0"><column _type_="87" columnId="5" columnName="Description"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns></LogMonitoring_TemplateXML>'
--creating template
IF EXISTS (SELECT 1 FROM APP_Template  WITH (NOLOCK) WHERE templateName = @templateName AND status <> 3)
BEGIN
	SET @templateId = (SELECT TOP 1 templateId FROM APP_Template  WITH (NOLOCK) WHERE templateName = @templateName AND status <> 3)
END
ELSE
BEGIN
	INSERT INTO APP_Template VALUES(2,@templateName,@templateXMLString,'system created template for F5 logs',@curUtcDateTime,0,0,1)
	SET @templateId = @@IDENTITY
END
--creating monitoring policy
IF NOT EXISTS (SELECT 1 FROM APP_MonitoringPolicy  WITH (NOLOCK) WHERE MonitorPolicyName = @monitoringPOlicyName AND status <> 3)
BEGIN
	INSERT INTO APP_MonitoringPolicy VALUES(2,@monitoringPOlicyName,@curUtcDateTime,@curUtcDateTime,'system created monitoring policy for F5 logs',1)
	SET @monitoringPolicyId =  @@IDENTITY
	INSERT INTO APP_MonitorAssocEntity VALUES(@monitoringPolicyId,2,3,@curUtcDateTime,0,2,0)
	INSERT INTO App_MonitorTemplateAssoc VALUES(@monitoringPolicyId,2,@templateId)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Creater User Id',7,1,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'index all lines',2,1,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Content',1,@i_content,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Search in subfolders',2,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'is NetApp Filler Content',7,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture lines before match',2,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture lines after match',2,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture log file header',2,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor old data',2,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor older entries enabler',2,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor entries older than days',7,7,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'capture as attachment',2,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'capture as ftp',2,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Enable CI',2,1,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'extraction options',1,'<?xml version="1.0" encoding="UTF-8"?><LogMonitoring_LMDataExtractionPatterns><patterns eventDisplayName="MonitorStatus" extractionType="0" patternGroupsToExtractValue="2" dataType="2" regexPattern="(.* monitor status )(down|up)" solrFieldNameToIndexMatchedPattern="MonitorStatus" runPatternOnThisColumn="Description" solrFieldNameOfColumn="Description" replaceWith="" /><patterns eventDisplayName="ServiceName" extractionType="0" patternGroupsToExtractValue="4" dataType="2" regexPattern="(.* monitor status )(down|up)(. \[)(.*)(: [up|down])" solrFieldNameToIndexMatchedPattern="ServiceName" runPatternOnThisColumn="Description" solrFieldNameOfColumn="Description" replaceWith="" /><patterns eventDisplayName="duration" extractionType="0" patternGroupsToExtractValue="7" dataType="2" regexPattern="(.* monitor status )(down|up)(. \[)(.*)(: [up|down])(.*was .* for )(.*)(])" solrFieldNameToIndexMatchedPattern="duration" runPatternOnThisColumn="Description" solrFieldNameOfColumn="Description" replaceWith="" /></LogMonitoring_LMDataExtractionPatterns>',@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'enable ci data ageing',2,1,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'age ci data after days',7,15,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Monitoring Type',7,0,@curUtcDateTime,@curUtcDateTime)
	--Insert cloud info if AnalyticalEngine is already configured
	IF exists(SELECT 1 FROM DM2SearchServerCoreInfo SC WITH (NOLOCK) Join DM2CloudCoreRole CR WITH (NOLOCK) ON SC.CloudId = CR.CloudId Join Dm2cloud C WITH (NOLOCK) ON SC.CloudId = C.cloudid WHERE roleid = 3)
	BEGIN
		DECLARE @cloudId int , @cloudName nvarchar(max)
		SELECT TOP 1 @cloudId = C.cloudId , @cloudName = C.name
			FROM DM2SearchServerCoreInfo SC WITH (NOLOCK) Join DM2CloudCoreRole CR WITH (NOLOCK)
					ON SC.CloudId = CR.CloudId Join Dm2cloud C WITH (NOLOCK) ON SC.CloudId = C.cloudid
						 WHERE roleid = 3
		INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Cloud Id',7,@cloudId,@curUtcDateTime,@curUtcDateTime)
		INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Cloud Name',1,@cloudName,@curUtcDateTime,@curUtcDateTime)
	END
END
--creating IIS f5 template
SET @monitoringPOlicyName = 'F5-IIS'
SET @templateName = 'F5 IIS Template'
SET @templateXMLString = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><LogMonitoring_TemplateXML fileExtension="*.log" isFixedWidth="0" lengthOfHeader="4" seperatorList="1" templateForMonitoringType="0" treatMultipleSeparatorAsOne="0"><columns decimalPlaces="2" defaultOpType="2" format="YYYY-MM-DD" index="0" isFacet="1" isIndexed="1" primaryDataType="2" primaryTypeFormat="28" solrFieldName="Date" useThousandSeparator="0"><column _type_="87" columnId="12848" columnName="Date"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns decimalPlaces="2" defaultOpType="0" index="1" isFacet="1" isIndexed="1" primaryDataType="3" primaryTypeFormat="17" solrFieldName="Time" useThousandSeparator="0"><column _type_="87" columnId="12849" columnName="Time"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/></columns><columns decimalPlaces="2" defaultOpType="2" format="" index="2" isFacet="1" isIndexed="1" primaryDataType="1" primaryTypeFormat="21" solrFieldName="SIp" useThousandSeparator="0"><column _type_="87" columnId="12850" columnName="SIp"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns decimalPlaces="2" defaultOpType="2" format="" index="3" isFacet="1" isIndexed="1" primaryDataType="1" primaryTypeFormat="21" solrFieldName="CS_Method" useThousandSeparator="0"><column _type_="87" columnId="12851" columnName="CS Method"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns decimalPlaces="2" defaultOpType="2" format="" index="4" isFacet="1" isIndexed="1" primaryDataType="1" primaryTypeFormat="21" solrFieldName="CS_URI_Stem" useThousandSeparator="0"><column _type_="87" columnId="12852" columnName="CS URI Stem"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns decimalPlaces="2" defaultOpType="2" format="" index="5" isFacet="1" isIndexed="1" primaryDataType="1" primaryTypeFormat="21" solrFieldName="CS_URI_Query" useThousandSeparator="0"><column _type_="87" columnId="12853" columnName="CS URI Query"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns decimalPlaces="2" defaultOpType="2" index="6" isFacet="1" isIndexed="1" primaryDataType="0" primaryTypeFormat="0" solrFieldName="S_Port" useThousandSeparator="0"><column _type_="87" columnId="12854" columnName="S Port"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns decimalPlaces="2" defaultOpType="2" format="" index="7" isFacet="1" isIndexed="1" primaryDataType="1" primaryTypeFormat="21" solrFieldName="CS_UserName" useThousandSeparator="0"><column _type_="87" columnId="12855" columnName="CS UserName"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns decimalPlaces="2" defaultOpType="2" format="" index="8" isFacet="1" isIndexed="1" primaryDataType="1" primaryTypeFormat="21" solrFieldName="C_ip" useThousandSeparator="0"><column _type_="87" columnId="12856" columnName="C ip"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns decimalPlaces="2" defaultOpType="2" format="" index="9" isFacet="1" isIndexed="1" primaryDataType="1" primaryTypeFormat="22" solrFieldName="CS_User_Agent" useThousandSeparator="0"><column _type_="87" columnId="12857" columnName="CS User Agent"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns decimalPlaces="2" defaultOpType="2" index="10" isFacet="1" isIndexed="1" primaryDataType="0" primaryTypeFormat="0" solrFieldName="SC_Status" useThousandSeparator="0"><column _type_="87" columnId="12858" columnName="SC Status"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns decimalPlaces="2" defaultOpType="2" index="11" isFacet="1" isIndexed="1" primaryDataType="0" primaryTypeFormat="0" solrFieldName="SC_Substatus" useThousandSeparator="0"><column _type_="87" columnId="12859" columnName="SC Substatus"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns decimalPlaces="2" defaultOpType="2" index="12" isFacet="1" isIndexed="1" primaryDataType="0" primaryTypeFormat="0" solrFieldName="SC_Win32_Status" useThousandSeparator="0"><column _type_="87" columnId="12860" columnName="SC Win32 Status"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns decimalPlaces="2" defaultOpType="0" index="13" isFacet="1" isIndexed="1" primaryDataType="0" primaryTypeFormat="0" solrFieldName="SC_Bytes" useThousandSeparator="0"><column _type_="87" columnId="12861" columnName="SC Bytes"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/></columns><columns decimalPlaces="2" defaultOpType="2" index="14" isFacet="1" isIndexed="1" primaryDataType="0" primaryTypeFormat="0" solrFieldName="CS_Bytes" useThousandSeparator="0"><column _type_="87" columnId="12862" columnName="CS Bytes"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns decimalPlaces="2" defaultOpType="0" index="15" isFacet="1" isIndexed="1" primaryDataType="0" primaryTypeFormat="0" solrFieldName="Time_Taken" useThousandSeparator="0"><column _type_="87" columnId="12863" columnName="Time Taken"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/></columns></LogMonitoring_TemplateXML>'
--creating template
IF EXISTS (SELECT 1 FROM APP_Template  WITH (NOLOCK) WHERE templateName = @templateName AND status <> 3)
BEGIN
	SET @templateId = (SELECT TOP 1 templateId FROM APP_Template  WITH (NOLOCK) WHERE templateName = @templateName AND status <> 3)
END
ELSE
BEGIN
	INSERT INTO APP_Template VALUES(2,@templateName,@templateXMLString,'system created template for F5 logs',@curUtcDateTime,0,0,1)
	SET @templateId = @@IDENTITY
END
--creating monitoring policy
IF NOT EXISTS (SELECT 1 FROM APP_MonitoringPolicy  WITH (NOLOCK) WHERE MonitorPolicyName = @monitoringPOlicyName AND status <> 3)
BEGIN
	INSERT INTO APP_MonitoringPolicy VALUES(2,@monitoringPOlicyName,@curUtcDateTime,@curUtcDateTime,'system created monitoring policy for F5 logs',1)
	SET @monitoringPolicyId =  @@IDENTITY
	INSERT INTO APP_MonitorAssocEntity VALUES(@monitoringPolicyId,2,3,@curUtcDateTime,0,2,0)
	INSERT INTO App_MonitorTemplateAssoc VALUES(@monitoringPolicyId,2,@templateId)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'age ci data after days',7,15,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'capture as attachment',2,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'capture as ftp',2,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture entire file',2,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture lines before match',2,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture lines after match',2,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture log file header',2,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Content',1,@i_content,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Continuous monitoring',2,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Creater User Id',7,1,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor entries older than days',7,7,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor old data',2,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor older entries enabler',2,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Enable CI',2,1,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'enable ci data ageing',2,1,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'extraction options',1,'<?xml version="1.0" encoding="UTF-8"?><LogMonitoring_LMDataExtractionPatterns><patterns eventDisplayName="ExternalIp" extractionType="0" patternGroupsToExtractValue="0" dataType="2" regexPattern="^(([0-9]|[2-9][0-9]|1[1-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.)(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){2}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$" solrFieldNameToIndexMatchedPattern="ExternalIp" runPatternOnThisColumn="SIp" solrFieldNameOfColumn="SIp" replaceWith="" /><patterns eventDisplayName="ExternalCIp" extractionType="0" patternGroupsToExtractValue="0" dataType="2" regexPattern="^(([0-9]|[2-9][0-9]|1[1-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.)(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){2}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$" solrFieldNameToIndexMatchedPattern="ExternalCIp" runPatternOnThisColumn="C ip" solrFieldNameOfColumn="C_ip" replaceWith="" /></LogMonitoring_LMDataExtractionPatterns>',@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Global Monitoring Password',1,'',@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Global Monitoring User Id',7,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Global Monitoring User Name',1,'',@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Global Monitoring Web Service URL',1,'',@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Global Policy Id',7,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Global Policy Name',1,'',@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'index all lines',2,1,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'is NetApp Filler Content',7,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Monitoring Type',7,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'SAML Token',1,'',@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Search in subfolders',2,1,@curUtcDateTime,@curUtcDateTime)
	--Insert cloud info if AnalyticalEngine is already configured
	IF exists(SELECT 1 FROM DM2SearchServerCoreInfo SC WITH (NOLOCK) Join DM2CloudCoreRole CR WITH (NOLOCK) ON SC.CloudId = CR.CloudId Join Dm2cloud C WITH (NOLOCK) ON SC.CloudId = C.cloudid WHERE roleid = 3)
	BEGIN
		SELECT TOP 1 @cloudId = C.cloudId , @cloudName = C.name
		FROM DM2SearchServerCoreInfo SC WITH (NOLOCK) Join DM2CloudCoreRole CR WITH (NOLOCK)
			ON SC.CloudId = CR.CloudId Join Dm2cloud C WITH (NOLOCK) ON SC.CloudId = C.cloudid
			WHERE roleid = 3
		INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Cloud Id',7,@cloudId,@curUtcDateTime,@curUtcDateTime)
		INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Cloud Name',1,@cloudName,@curUtcDateTime,@curUtcDateTime)
	END
END
COMMIT TRANSACTION LMCreateF5MpTran
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
    PRINT N'Error occured. ErrorNo(' + CAST(@errorCode AS NVARCHAR) + N') ErrorMsg(' + @errorString + N').'
    PRINT N'So Rolling back Transactions.'
	ROLLBACK TRANSACTION LMCreateF5MpTran
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_LMCreateF5MonitoringPolicyAndTemplate')
	delete from GxQscripts where name = 'QS_LMCreateF5MonitoringPolicyAndTemplate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_LMCreateF5MonitoringPolicyAndTemplate')
	delete from GXDBVersions where aliasname = 'QS_LMCreateF5MonitoringPolicyAndTemplate'
GO

insert into GXDBVersions values(2, 'QS_LMCreateF5MonitoringPolicyAndTemplate',  '00000000000000000000', 'QS_LMCreateF5MonitoringPolicyAndTemplate', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_LMCreateF5MonitoringPolicyAndTemplate',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '--  qoperation execscript -sn QS_LMCreateF5MonitoringPolicyAndTemplate'
 + CHAR(10) + '--  - '
 + CHAR(10) + '--  -  The script can be used to create default monitoring policy for F5 logs.'
 + CHAR(10) + '--  -  This default monitoring policy will be created with disabled state.'
 + CHAR(10) + '--  -  If the analytic engine is configured already,then analytical engine will be associated to the default monitoring policy.'
 + CHAR(10) + '--  -  Default monitoring policy cannot be enabled unless analytical engine is configured.'
)
GO

