

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_LMCreateDefaultMonitoringPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_LMCreateDefaultMonitoringPolicy <<<'

IF EXISTS (select * from sysobjects where name='QS_LMCreateDefaultMonitoringPolicy')
	drop procedure QS_LMCreateDefaultMonitoringPolicy
IF EXISTS (select * from GxQscripts where name='QS_LMCreateDefaultMonitoringPolicy')
	delete from GxQscripts where name = 'QS_LMCreateDefaultMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_LMCreateDefaultMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'QS_LMCreateDefaultMonitoringPolicy'
GO
print '... Creating Procedure: QS_LMCreateDefaultMonitoringPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_LMCreateDefaultMonitoringPolicy
--QScript is enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- No input for this QScript
AS
SET NOCOUNT ON
DECLARE @curUtcDateTime BIGINT
DECLARE @monitoringPolicyId INT
DECLARE @monitoringPOlicyName NVARCHAR(max)
DECLARE @errorCode int = 0
DECLARE @errorString NVARCHAR(1024) = ''
BEGIN TRY
BEGIN TRANSACTION LMCreateMpTran
SET @monitoringPOlicyName = 'System Created Policy'
SET @curUtcDateTime =  DBO.GetUnixTime(GETUTCDATE())
IF NOT EXISTS (SELECT 1 FROM APP_MonitoringPolicy WHERE MonitorPolicyName = @monitoringPOlicyName AND status <> 3)
BEGIN
	INSERT INTO APP_MonitoringPolicy VALUES(2,@monitoringPOlicyName,@curUtcDateTime,@curUtcDateTime,'system created default monitoring policy',1)
	SET @monitoringPolicyId =  @@IDENTITY
	INSERT INTO APP_MonitorAssocEntity VALUES(@monitoringPolicyId,2,3,@curUtcDateTime,0,2,0)
	INSERT INTO App_MonitorTemplateAssoc VALUES(@monitoringPolicyId,2,1)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Creater User Id',7,1,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'index all lines',2,1,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Content',1,'%LOG_DIR%',@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Search in subfolders',2,0,@curUtcDateTime,@curUtcDateTime)
	--This should be changed with schedule for every 1 hour
	--insert into APP_MonitoringPolicyProp values(@monitoringPolicyId,2,'Continuous monitoring',2,1,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'is NetApp Filler Content',7,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture log file header',2,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor old data',2,1,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor older entries enabler',2,1,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor entries older than days',7,7,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Enable CI',2,1,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'extraction options',1,'',@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'enable ci data ageing',2,1,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'age ci data after days',7,15,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Monitoring Type',7,0,@curUtcDateTime,@curUtcDateTime)
	INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Discover Event',2,1,@curUtcDateTime,@curUtcDateTime)
	--Insert cloud info if AnalyticalEngine is already configured
	IF exists(SELECT 1 FROM DM2SearchServerCoreInfo SC Join DM2CloudCoreRole CR ON SC.CloudId = CR.CloudId Join Dm2cloud C ON SC.CloudId = C.cloudid WHERE roleid = 3)
	BEGIN
		DECLARE @cloudId int , @cloudName nvarchar(max)
		SELECT TOP 1 @cloudId = C.cloudId , @cloudName = C.name
			FROM DM2SearchServerCoreInfo SC Join DM2CloudCoreRole CR
					ON SC.CloudId = CR.CloudId Join Dm2cloud C ON SC.CloudId = C.cloudid
						 WHERE roleid = 3
		INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Cloud Id',7,@cloudId,@curUtcDateTime,@curUtcDateTime)
		INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Cloud Name',1,@cloudName,@curUtcDateTime,@curUtcDateTime)
	END
END
ELSE IF EXISTS (SELECT 1 FROM APP_MonitoringPolicy WITH(NOLOCK) WHERE MonitorPolicyName = @monitoringPOlicyName AND status <> 3)
BEGIN
	SET @monitoringPolicyId = (SELECT TOP 1 monitorPolicyId FROM APP_MonitoringPolicy WITH(NOLOCK) WHERE MonitorPolicyName = @monitoringPOlicyName AND status <> 3)
	-- If Discover Event is disabled by user , then below Discover Event fields will be present , else create a new one.
	IF NOT EXISTS (SELECT 1 FROM APP_MonitoringPolicyProp WITH(NOLOCK) WHERE monitorPolicyId = @monitoringPolicyId and attrName = 'Discover Event')
	BEGIN
		INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Discover Event',2,1,@curUtcDateTime,@curUtcDateTime)
	END
END
COMMIT TRANSACTION LMCreateMpTran
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
    PRINT N'Error occured. ErrorNo(' + CAST(@errorCode AS NVARCHAR) + N') ErrorMsg(' + @errorString + N').'
    PRINT N'So Rolling back Transactions.'
	ROLLBACK TRANSACTION LMCreateMpTran
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_LMCreateDefaultMonitoringPolicy')
	delete from GxQscripts where name = 'QS_LMCreateDefaultMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_LMCreateDefaultMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'QS_LMCreateDefaultMonitoringPolicy'
GO

insert into GXDBVersions values(2, 'QS_LMCreateDefaultMonitoringPolicy',  '00000000000000000000', 'QS_LMCreateDefaultMonitoringPolicy', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_LMCreateDefaultMonitoringPolicy',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '--  qoperation execscript -sn QS_CreateLMDefaultMonitoringPolicy'
 + CHAR(10) + '--  - '
 + CHAR(10) + '--  -  The script can be used to create default monitoring policy.'
 + CHAR(10) + '--  -  The default monitoring policy will be created with disabled state.'
 + CHAR(10) + '--  -  If the analytic engine is configured already,then analytical engine will be associated to the default monitoring policy.'
 + CHAR(10) + '--  -  Default monitoring policy cannot be enabled unless analytical engine is configured.'
)
GO

