

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_LMCreateDefaultDashBoardAndSearch.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_LMCreateDefaultDashBoardAndSearch <<<'

IF EXISTS (select * from sysobjects where name='QS_LMCreateDefaultDashBoardAndSearch')
	drop procedure QS_LMCreateDefaultDashBoardAndSearch
IF EXISTS (select * from GxQscripts where name='QS_LMCreateDefaultDashBoardAndSearch')
	delete from GxQscripts where name = 'QS_LMCreateDefaultDashBoardAndSearch'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_LMCreateDefaultDashBoardAndSearch')
	delete from GXDBVersions where aliasname = 'QS_LMCreateDefaultDashBoardAndSearch'
GO
print '... Creating Procedure: QS_LMCreateDefaultDashBoardAndSearch'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_LMCreateDefaultDashBoardAndSearch
--QScript is enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- No input for this QScript
AS
SET NOCOUNT ON
DECLARE @curUtcDateTime BIGINT
DECLARE @dashboardId INT
DECLARE @searchId INT
DECLARE @status INT
DECLARE @errorCode int = 0
DECLARE @errorString NVARCHAR(1024) = ''
DECLARE @DashBoardName NVARCHAR(30) = 'Operation Dashboard'
DECLARE @monitoringPOlicyName NVARCHAR(max)
DECLARE @browserURLField NVARCHAR(max)
DECLARE @solrQueryField NVARCHAR(max)
DECLARE @searchLabelField NVARCHAR(max)
DECLARE @searchUrlXml xml
BEGIN TRY
BEGIN TRANSACTION LMCreateDashboardAndSearchTran
SET @monitoringPOlicyName = 'System Created Policy'
set @curUtcDateTime = DBO.GetUnixTime(GETUTCDATE())
--creating dashboard
IF exists(SELECT 1 FROM LMDashBoard WHERE dashBoardName = @DashBoardName AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	SET @dashboardId = (SELECT TOP 1 dashBoardId FROM LMDashBoard WHERE dashBoardName = @DashBoardName AND monitoringAppType = 1 AND creatorUserId = 1)
END
ELSE
BEGIN
	-- status = 4 indicates the default dasboard
	INSERT INTO LMDashBoard (dashBoardName,isPrivate,creatorUserId,status,created,modified)
		VALUES(@DashBoardName,1,1,4,@curUtcDateTime,0)
	SET @dashboardId = @@IDENTITY
END
--creating searches
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;fieldList=MonitoringPolicyName&amp;keyWord=completionstatus%7C%20graphtype%20timechart%20count%20by%20%24completionstatus&amp;startTime=&amp;endTime=&amp;estimatedTimeDiff&amp;gap&amp;isAllTime=true&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss%2Cpid_if%2Cthreadid_sf%2Cjobid_if%2Cdescription_lf&amp;graphScale=linear&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+completionstatus+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;completionstatus| graphtype timechart count by $completionstatus&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt; &lt;b&gt;Time Range:&lt;/b&gt;All Time&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="1" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job Statistics' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job Statistics',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job Statistics' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;completionstatus_state=open&amp;completionstatuskeyVals=%22completionstatuscv_dis_delsuccess%22&amp;fieldList=MonitoringPolicyName%2CcompletionstatuskeyVals&amp;keyWord=graphtype%20compare%20days%20%5B%20Thu%5D%204&amp;startTime=&amp;endTime=&amp;estimatedTimeDiff&amp;gap&amp;isAllTime=true&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss%2Cpid_if%2Cthreadid_sf%2Cjobid_if%2Cdescription_lf&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29+AND+%28keyVals%3A%22completionstatuscv_dis_delsuccess%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare days [ Thu] 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;completionstatus:&lt;/b&gt;completionstatuscv_dis_delsuccess&lt;br&gt; &lt;b&gt;Time Range:&lt;/b&gt;All Time&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="2" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job success on specified days' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job success on specified days',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job success on specified days' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;completionstatus_state=open&amp;completionstatuskeyVals=%22completionstatuscv_dis_delsuccess%22&amp;fieldList=MonitoringPolicyName%2CcompletionstatuskeyVals&amp;keyWord=graphtype%20compare%20daily%204&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss%2Cpid_if%2Cthreadid_sf%2Cjobid_if%2Cdescription_lf&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28%28%28eventTime:[NOW-1DAYS+TO+NOW}%29+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29+AND+%28keyVals%3A%22completionstatuscv_dis_delsuccess%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare daily 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;completionstatus:&lt;/b&gt;completionstatuscv_dis_delsuccess&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="3" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job success - DAILY' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job success - DAILY',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job success - DAILY' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;completionstatus_state=open&amp;completionstatuskeyVals=%22completionstatuscv_dis_delsuccess%22&amp;fieldList=MonitoringPolicyName%2CcompletionstatuskeyVals&amp;keyWord=graphtype%20compare%20weekly%204&amp;startTime=NOW-7DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=604800000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28%28%28eventTime:[NOW-7DAYS+TO+NOW}%29+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29+AND+%28keyVals%3A%22completionstatuscv_dis_delsuccess%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare weekly 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;completionstatus:&lt;/b&gt;completionstatuscv_dis_delsuccess&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-7DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="4" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job success - WEEKLY' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job success - WEEKLY',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job success - WEEKLY' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;completionstatus_state=open&amp;completionstatuskeyVals=%22completionstatuscv_dis_delsuccess%22&amp;fieldList=MonitoringPolicyName%2CcompletionstatuskeyVals&amp;keyWord=graphtype%20compare%20weekly%20%5B%20Mon%5D%204&amp;startTime=NOW-7DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=604800000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28%28%28eventTime:[NOW-7DAYS+TO+NOW}%29+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29+AND+%28keyVals%3A%22completionstatuscv_dis_delsuccess%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare weekly [ Mon] 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;completionstatus:&lt;/b&gt;completionstatuscv_dis_delsuccess&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-7DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="5" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job success - WEEKLY_DAYS' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job success - WEEKLY_DAYS',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job success - WEEKLY_DAYS' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;completionstatus_state=open&amp;completionstatuskeyVals=%22completionstatuscv_dis_delsuccess%22&amp;fieldList=MonitoringPolicyName%2CcompletionstatuskeyVals&amp;keyWord=graphtype%20compare%20monthly%204&amp;startTime=NOW-30DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=2592000000&amp;gap=1DAYS&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28%28%28eventTime:[NOW-30DAYS+TO+NOW}%29+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29+AND+%28keyVals%3A%22completionstatuscv_dis_delsuccess%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare monthly 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;completionstatus:&lt;/b&gt;completionstatuscv_dis_delsuccess&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-30DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="6" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job success - MONTHLY' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job success - MONTHLY',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job success - MONTHLY' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;completionstatus_state=open&amp;completionstatuskeyVals=%22completionstatuscv_dis_delfailed%22&amp;fieldList=MonitoringPolicyName%2CcompletionstatuskeyVals&amp;keyWord=graphtype%20compare%20days%20%5B%20Thu%5D%204&amp;startTime=&amp;endTime=&amp;estimatedTimeDiff&amp;gap&amp;isAllTime=true&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss%2Cpid_if%2Cthreadid_sf%2Cjobid_if%2Cdescription_lf&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29+AND+%28keyVals%3A%22completionstatuscv_dis_delfailed%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare days [ Thu] 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;completionstatus:&lt;/b&gt;completionstatuscv_dis_delfailed&lt;br&gt; &lt;b&gt;Time Range:&lt;/b&gt;All Time&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="7" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job failure on specified days' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job failure on specified days',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job failure on specified days' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;completionstatus_state=open&amp;completionstatuskeyVals=%22completionstatuscv_dis_delfailed%22&amp;fieldList=MonitoringPolicyName%2CcompletionstatuskeyVals&amp;keyWord=graphtype%20compare%20daily%204&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss%2Cpid_if%2Cthreadid_sf%2Cjobid_if%2Cdescription_lf&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28%28%28eventTime:[NOW-1DAYS+TO+NOW}%29+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29+AND+%28keyVals%3A%22completionstatuscv_dis_delfailed%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare daily 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;completionstatus:&lt;/b&gt;completionstatuscv_dis_delfailed&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="8" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job failure - DAILY' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job failure - DAILY',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job failure - DAILY' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;completionstatus_state=open&amp;completionstatuskeyVals=%22completionstatuscv_dis_delfailed%22&amp;fieldList=MonitoringPolicyName%2CcompletionstatuskeyVals&amp;keyWord=graphtype%20compare%20weekly%204&amp;startTime=NOW-7DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=604800000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28%28%28eventTime:[NOW-7DAYS+TO+NOW}%29+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29+AND+%28keyVals%3A%22completionstatuscv_dis_delfailed%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare weekly 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;completionstatus:&lt;/b&gt;completionstatuscv_dis_delfailed&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-7DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="9" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job failure - WEEKLY' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job failure - WEEKLY',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job failure - WEEKLY' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;completionstatus_state=open&amp;completionstatuskeyVals=%22completionstatuscv_dis_delfailed%22&amp;fieldList=MonitoringPolicyName%2CcompletionstatuskeyVals&amp;keyWord=graphtype%20compare%20weekly%20%5B%20Mon%5D%204&amp;startTime=NOW-7DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=604800000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28%28%28eventTime:[NOW-7DAYS+TO+NOW}%29+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29+AND+%28keyVals%3A%22completionstatuscv_dis_delfailed%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare weekly [ Mon] 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;completionstatus:&lt;/b&gt;completionstatuscv_dis_delfailed&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-7DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="10" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job failure - WEEKLY_DAYS' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job failure - WEEKLY_DAYS',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job failure - WEEKLY_DAYS' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;completionstatus_state=open&amp;completionstatuskeyVals=%22completionstatuscv_dis_delfailed%22&amp;fieldList=MonitoringPolicyName%2CcompletionstatuskeyVals&amp;keyWord=graphtype%20compare%20monthly%204&amp;startTime=NOW-30DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=2592000000&amp;gap=1DAYS&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28%28%28eventTime:[NOW-30DAYS+TO+NOW}%29+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29+AND+%28keyVals%3A%22completionstatuscv_dis_delfailed%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare monthly 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;completionstatus:&lt;/b&gt;completionstatuscv_dis_delfailed&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-30DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="11" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job failure - MONTHLY' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job failure - MONTHLY',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job failure - MONTHLY' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;completionstatus_state=open&amp;completionstatuskeyVals=%22completionstatuscv_dis_delwith%20errors%22&amp;fieldList=MonitoringPolicyName%2CcompletionstatuskeyVals&amp;keyWord=graphtype%20compare%20days%20%5B%20Thu%5D%204&amp;startTime=&amp;endTime=&amp;estimatedTimeDiff&amp;gap&amp;isAllTime=true&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29+AND+%28keyVals%3A%22completionstatuscv_dis_delwith+errors%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare days [ Thu] 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;completionstatus:&lt;/b&gt;completionstatuscv_dis_delwith errors&lt;br&gt; &lt;b&gt;Time Range:&lt;/b&gt;All Time&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="12" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job with errors on specified days' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job with errors on specified days',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job with errors on specified days' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;completionstatus_state=open&amp;completionstatuskeyVals=%22completionstatuscv_dis_delwith%20errors%22&amp;fieldList=MonitoringPolicyName%2CcompletionstatuskeyVals&amp;keyWord=graphtype%20compare%20daily%204&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28%28%28eventTime:[NOW-1DAYS+TO+NOW}%29+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29+AND+%28keyVals%3A%22completionstatuscv_dis_delwith+errors%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare daily 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;completionstatus:&lt;/b&gt;completionstatuscv_dis_delwith errors&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="13" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job with errors - DAILY' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job with errors - DAILY',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job with errors - DAILY' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;completionstatus_state=open&amp;completionstatuskeyVals=%22completionstatuscv_dis_delwith%20errors%22&amp;fieldList=MonitoringPolicyName%2CcompletionstatuskeyVals&amp;keyWord=graphtype%20compare%20weekly%204&amp;startTime=NOW-7DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=604800000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28%28%28eventTime:[NOW-7DAYS+TO+NOW}%29+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29+AND+%28keyVals%3A%22completionstatuscv_dis_delwith+errors%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare weekly 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;completionstatus:&lt;/b&gt;completionstatuscv_dis_delwith errors&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-7DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="14" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job with errors - WEEKLY' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job with errors - WEEKLY',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job with errors - WEEKLY' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;completionstatus_state=open&amp;completionstatuskeyVals=%22completionstatuscv_dis_delwith%20errors%22&amp;fieldList=MonitoringPolicyName%2CcompletionstatuskeyVals&amp;keyWord=graphtype%20compare%20weekly%20%5Bmon%5D%204&amp;startTime=NOW-7DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=604800000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28%28%28eventTime:[NOW-7DAYS+TO+NOW}%29+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29+AND+%28keyVals%3A%22completionstatuscv_dis_delwith+errors%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare weekly [mon] 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;completionstatus:&lt;/b&gt;completionstatuscv_dis_delwith errors&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-7DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="15" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job with errors - WEEKLY_DAYS' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job with errors - WEEKLY_DAYS',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job with errors - WEEKLY_DAYS' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;completionstatus_state=open&amp;completionstatuskeyVals=%22completionstatuscv_dis_delwith%20errors%22&amp;fieldList=MonitoringPolicyName%2CcompletionstatuskeyVals&amp;keyWord=graphtype%20compare%20monthly%204&amp;startTime=NOW-30DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=2592000000&amp;gap=1DAYS&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28%28%28eventTime:[NOW-30DAYS+TO+NOW}%29+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29+AND+%28keyVals%3A%22completionstatuscv_dis_delwith+errors%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare monthly 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;completionstatus:&lt;/b&gt;completionstatuscv_dis_delwith errors&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-30DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="16" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job with errors - MONTHLY' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job with errors - MONTHLY',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job with errors - MONTHLY' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;completionstatus_state=open&amp;completionstatuskeyVals=%22completionstatuscv_dis_delkilled%22&amp;fieldList=MonitoringPolicyName%2CcompletionstatuskeyVals&amp;keyWord=graphtype%20compare%20days%20%5B%20Thu%5D%204&amp;startTime=&amp;endTime=&amp;estimatedTimeDiff&amp;gap&amp;isAllTime=true&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29+AND+%28keyVals%3A%22completionstatuscv_dis_delkilled%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare days [ Thu] 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;completionstatus:&lt;/b&gt;completionstatuscv_dis_delkilled&lt;br&gt; &lt;b&gt;Time Range:&lt;/b&gt;All Time&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="17" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job killed on specified days' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job killed on specified days',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job killed on specified days' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;completionstatus_state=open&amp;completionstatuskeyVals=%22completionstatuscv_dis_delkilled%22&amp;fieldList=MonitoringPolicyName%2CcompletionstatuskeyVals&amp;keyWord=graphtype%20compare%20daily%204&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28%28%28eventTime:[NOW-1DAYS+TO+NOW}%29+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29+AND+%28keyVals%3A%22completionstatuscv_dis_delkilled%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare daily 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;completionstatus:&lt;/b&gt;completionstatuscv_dis_delkilled&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="18" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job killed - DAILY' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job killed - DAILY',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job killed - DAILY' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;completionstatus_state=open&amp;completionstatuskeyVals=%22completionstatuscv_dis_delkilled%22&amp;fieldList=MonitoringPolicyName%2CcompletionstatuskeyVals&amp;keyWord=graphtype%20compare%20weekly%204&amp;startTime=NOW-7DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=604800000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28%28%28eventTime:[NOW-7DAYS+TO+NOW}%29+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29+AND+%28keyVals%3A%22completionstatuscv_dis_delkilled%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare weekly 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;completionstatus:&lt;/b&gt;completionstatuscv_dis_delkilled&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-7DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="19" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job killed - WEEKLY' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job killed - WEEKLY',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job killed - WEEKLY' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;completionstatus_state=open&amp;completionstatuskeyVals=%22completionstatuscv_dis_delkilled%22&amp;fieldList=MonitoringPolicyName%2CcompletionstatuskeyVals&amp;keyWord=graphtype%20compare%20weekly%20%5Bmon%5D%204&amp;startTime=NOW-7DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=604800000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28%28%28eventTime:[NOW-7DAYS+TO+NOW}%29+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29+AND+%28keyVals%3A%22completionstatuscv_dis_delkilled%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare weekly [mon] 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;completionstatus:&lt;/b&gt;completionstatuscv_dis_delkilled&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-7DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="20" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job killed - WEEKLY_DAYS' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job killed - WEEKLY_DAYS',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job killed - WEEKLY_DAYS' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;completionstatus_state=open&amp;completionstatuskeyVals=%22completionstatuscv_dis_delkilled%22&amp;fieldList=MonitoringPolicyName%2CcompletionstatuskeyVals&amp;keyWord=graphtype%20compare%20monthly%204&amp;startTime=NOW-30DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=2592000000&amp;gap=1DAYS&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28%28%28eventTime:[NOW-30DAYS+TO+NOW}%29+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29+AND+%28keyVals%3A%22completionstatuscv_dis_delkilled%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare monthly 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;completionstatus:&lt;/b&gt;completionstatuscv_dis_delkilled&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-30DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="21" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job killed - MONTHLY' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job killed - MONTHLY',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job killed - MONTHLY' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;fieldList=MonitoringPolicyName&amp;keyWord=Scheduler%20Phase%20message%20received%20from%20restartPhase%7Cgraphtype%20compare%20days%20%5B%20thu%5D%204&amp;startTime=&amp;endTime=&amp;estimatedTimeDiff&amp;gap&amp;isAllTime=true&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss%2Cpid_if%2Cthreadid_sf%2Cjobid_if%2Cdescription_lf&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+Scheduler+Phase+message+received+from+restartPhase+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;Scheduler Phase message received from restartPhase|graphtype compare days [ thu] 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt; &lt;b&gt;Time Range:&lt;/b&gt;All Time&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="22" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job retries on specified days' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job retries on specified days',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job retries on specified days' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;fieldList=MonitoringPolicyName&amp;keyWord=Scheduler%20Phase%20message%20received%20from%20restartPhase%7Cgraphtype%20compare%20daily%204&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=rawView&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+Scheduler+Phase+message+received+from+restartPhase+AND+%28%28%28eventTime:[NOW-1DAYS+TO+NOW}%29+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;Scheduler Phase message received from restartPhase|graphtype compare daily 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="23" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job retries - DAILY' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job retries - DAILY',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job retries - DAILY' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;fieldList=MonitoringPolicyName&amp;keyWord=Scheduler%20Phase%20message%20received%20from%20restartPhase%7Cgraphtype%20compare%20weekly%204&amp;startTime=NOW-7DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=604800000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=rawView&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+Scheduler+Phase+message+received+from+restartPhase+AND+%28%28%28eventTime:[NOW-7DAYS+TO+NOW}%29+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;Scheduler Phase message received from restartPhase|graphtype compare weekly 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-7DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="24" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job retries - WEEKLY' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job retries - WEEKLY',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job retries - WEEKLY' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;fieldList=MonitoringPolicyName&amp;keyWord=Scheduler%20Phase%20message%20received%20from%20restartPhase%7Cgraphtype%20compare%20weekly%20%5B%20Mon%5D%204&amp;startTime=NOW-7DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=604800000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=rawView&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+Scheduler+Phase+message+received+from+restartPhase+AND+%28%28%28eventTime:[NOW-7DAYS+TO+NOW}%29+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;Scheduler Phase message received from restartPhase|graphtype compare weekly [ Mon] 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-7DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="25" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job retries - WEEKLY_DAYS' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job retries - WEEKLY_DAYS',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job retries - WEEKLY_DAYS' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22System%20Created%20Policy%22&amp;fieldList=MonitoringPolicyName&amp;keyWord=Scheduler%20Phase%20message%20received%20from%20restartPhase%7Cgraphtype%20compare%20monthly%204&amp;startTime=NOW-30DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=2592000000&amp;gap=1DAYS&amp;isAllTime=false&amp;dataView=rawView&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+Scheduler+Phase+message+received+from+restartPhase+AND+%28%28%28eventTime:[NOW-30DAYS+TO+NOW}%29+AND+%28isLMDoc%3A1%29+AND+%28MonitoringPolicyName%3A%22System+Created+Policy%22%29&amp;sort=eventTime+desc'
SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;Scheduler Phase message received from restartPhase|graphtype compare monthly 4&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;System Created Policy&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-30DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrlXml = CONVERT(XML,'<LogMonitoring_SearchURLInfo orderId="26" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />')
IF not exists (SELECT 1 FROM LMUserSearch WHERE searchName = 'Job retries - MONTHLY' AND monitoringAppType = 1 AND creatorUserId = 1)
BEGIN
	INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified)
	VALUES('Job retries - MONTHLY',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime)
	SET @searchId = @@IDENTITY
	INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
	VALUES(@dashboardId,@searchId)
END
ELSE
BEGIN
	SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WHERE searchName = 'Job retries - MONTHLY' AND monitoringAppType = 1 AND creatorUserId = 1)
	SET @status = (SELECT status FROM LMUserSearch WHERE searchId = @searchId)
	IF not exists(SELECT 1 FROM LMDashSearchAssoc WHERE dashBoardId = @dashboardId AND searchId = @searchId)
	BEGIN
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)
		VALUES(@dashboardId,@searchId)
		SET @status = @status | 4
	END
		update LMUserSearch
		set status =  @status
		where searchId = @searchId
END
COMMIT TRANSACTION LMCreateDashboardAndSearchTran
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
    PRINT N'Error occured. ErrorNo(' + CAST(@errorCode AS NVARCHAR) + N') ErrorMsg(' + @errorString + N').'
    PRINT N'So Rolling back Transactions.'
	ROLLBACK TRANSACTION LMCreateDashboardAndSearchTran
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_LMCreateDefaultDashBoardAndSearch')
	delete from GxQscripts where name = 'QS_LMCreateDefaultDashBoardAndSearch'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_LMCreateDefaultDashBoardAndSearch')
	delete from GXDBVersions where aliasname = 'QS_LMCreateDefaultDashBoardAndSearch'
GO

insert into GXDBVersions values(2, 'QS_LMCreateDefaultDashBoardAndSearch',  '00000000000000000000', 'QS_LMCreateDefaultDashBoardAndSearch', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_LMCreateDefaultDashBoardAndSearch',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '--  qoperation execscript -sn QS_LMCreateDefaultDashBoardAndSearch '
 + CHAR(10) + '--  - '
 + CHAR(10) + '--  -  The script can be used to create default dashboard and searches. '
 + CHAR(10) + '--  -  The default dashboard and search can be deleted.'
 + CHAR(10) + '--  -  When the script is ran again,every missing item will be created.'
)
GO

