

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_JobsinSPCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_JobsinSPCopy.sp,v $ $Id: QS_JobsinSPCopy.sp,v 1.6.46.13 2020/01/13 22:46:02 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_JobsinSPCopy')
BEGIN
	print '>>> Drop Stored Procedure: QS_JobsinSPCopy <<<'
	drop procedure QS_JobsinSPCopy
END
IF EXISTS (select * from GxQscripts where name='QS_JobsinSPCopy')
	delete from GxQscripts where name = 'QS_JobsinSPCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_JobsinSPCopy')
	delete from GXDBVersions where aliasname = 'QS_JobsinSPCopy'
GO
print '... Creating Procedure: QS_JobsinSPCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_JobsinSPCopy
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_fromTime VARCHAR(32) = '',
  @i_toTime VARCHAR(32) = '',
  @i_isAged int = 2,
  @i_backupType VARCHAR(32) = '',
  @i_orderBy VARCHAR(32) = '',
  @i_policyName varchar(144) = '',
  @i_copyName varchar(64)  = '',
  @i_retention int = 0,
  @i_includeToBeCopiedJobs int = 0,
  @i_includePartialJobsOnly int = 0
AS
SET NOCOUNT ON
-- @i_fromTime VARCHAR(32)		= '2011-10-13',--start time--yyyy-mm-dd
-- @i_toTime VARCHAR(32)		= '2012-11-30',--end time--yyyy-mm-dd
-- @i_isAged			int		= 2,--0 to not include aged jobs, 1 SHOW ONLY aged jobs, 2 to include all jobs
-- @i_backupType VARCHAR(32)	= '', --'FULL' OR 'INCR'
-- @i_orderBy VARCHAR(32)		= '', --'Client' OR 'Agent'
-- @i_policyName VARCHAR(144)	= '',--data from policy
-- @i_copyName VARCHAR(64)		= '' --data from policy copy -- IF YOU SPECIFY THIS YOU HAVE TO SPECIFY POLICYNAME
DECLARE	@CopyId			INT = 0
DECLARE	@TimeRangeBegin	INT = 0
DECLARE	@TimeRangeEnd	INT = 0
DECLARE	@BackupLevel	INT = 0
DECLARE	  @i_orderByCode	INT = 0
DECLARE @csTimeZone VARCHAR(256)
SELECT	@csTimeZone = timeZone FROM APP_CommCell WHERE id = 2
SELECT	@csTimeZone = TimeZoneStdName FROM SchedTimeZone
WHERE	TimeZoneName= SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
DECLARE	@FromDateTime	DATETIME =   @i_fromTime
DECLARE	@ToDateTime		DATETIME =   @i_toTime
IF   @i_fromTime <> ''
BEGIN
	SET	@FromDateTime	= dbo.ClientLocalToUTCTime(@FromDateTime, 2)
	SET	@TimeRangeBegin = dbo.GetUnixTime(@FromDateTime)
END
IF   @i_toTime <> ''
BEGIN
	SET	@ToDateTime		= dbo.ClientLocalToUTCTime(@ToDateTime, 2)
	SET	@TimeRangeEnd	= dbo.GetUnixTime(@ToDateTime)
END
SET @BackupLevel = CASE WHEN   @i_backupType = 'Full' THEN 1
						WHEN   @i_backupType = 'Incr' THEN 2
						ELSE 0
					END
SET   @i_orderByCode = CASE WHEN   @i_orderBy = 'Client' THEN 1
						WHEN   @i_orderBy = 'Agent' THEN 2
						ELSE 0
					END
DECLARE @TblCopyIds TABLE (CopyId INT);
IF   @i_copyName = '' AND   @i_policyName = ''
	INSERT INTO @TblCopyIds
	SELECT	id
	FROM	archGroupCopy
	where	id > 0
ELSE
	INSERT INTO @TblCopyIds
	SELECT	AGC.id
	FROM	archGroup AG
				INNER JOIN archGroupCopy AGC
					ON AGC.archGroupId = AG.id
	WHERE	AG.name =   @i_policyName AND (AGC.name =   @i_copyName OR   @i_copyName = '')
DECLARE	@TblResult TABLE (
		jobId				int,
		commCellId			int,
		appId				int,
		sizeOfApplication	bigint,
		sizeOfAppCompressed	bigint,
		sizeOfBackup		bigint,
		sizeOfNWTransfer	bigint,
		startTime			int,
		endTime				int,
		opType				int,
		level				int,
		jobStatus			int,
		fullCycleNum		int,
		seqNumInCycle		int,
		duration			int,
		numStreams			int,
		numObjects			bigint,
		initFrom			int,
		attributes			bigint,
		attributesEx		bigint,
		userName			nvarchar(255),
		totalWriteTime		int,
		scanFileFailures	int,
		scanFolderFailures	int,
		bkpFileFailures		int,
		bkpFolderFailures	int,
		subClientId 		int,
		clientId			int	,
		appTypeId			int	,
		instanceId			int,
		backupSetId			int,
		clientName			nvarchar(255),
		appTypeName			varchar(255),
		instanceName		nvarchar(255),
		backupSetName		nvarchar(255),
		subClientName		nvarchar(255),
		commCellName		nvarchar(255),
		dataStatus			int,
		disabled			int,
		toBeCopied			int,
		jobCopyAttributes	int,
		sizeOnMedia			bigint,
		archCheckEndTime	int,
		archCheckStatus 	int,
		extRetentionFlags	int,
		retentionEndTime	bigint,
		copiedTime			bigint,
		agedTime			bigint,
		errorCode			int,
		retainedBy          int,
        copyId              int,
        dedupSaving         bigint,
        jobCopyStatus       int,
		jobDescription		nvarchar(MAX),
		jobDisplayFlags		bigint,
		indexBackupJob		int,
		clientOwnerList		nvarchar(MAX),
		RequiredByJobIds		nvarchar(MAX),
		lastRefreshTime      int,
clientDisplayName	nvarchar(255)
)
DECLARE	@TblResultFinal TABLE (
		mediaList			XML,
		jobId				int,
		commCellId			int,
		appId				int,
		sizeOfApplication	bigint,
		sizeOfAppCompressed	bigint,
		sizeOfBackup		bigint,
		sizeOfNWTransfer	bigint,
		startTime			int,
		endTime				int,
		opType				int,
		level				int,
		jobStatus			int,
		fullCycleNum		int,
		seqNumInCycle		int,
		duration			int,
		numStreams			int,
		numObjects			bigint,
		initFrom			int,
		attributes			bigint,
		attributesEx		bigint,
		userName			nvarchar(255),
		totalWriteTime		int,
		scanFileFailures	int,
		scanFolderFailures	int,
		bkpFileFailures		int,
		bkpFolderFailures	int,
		subClientId 		int,
		clientId			int	,
		appTypeId			int	,
		instanceId			int,
		backupSetId			int,
		clientName			nvarchar(255),
		appTypeName			varchar(255),
		instanceName		nvarchar(255),
		backupSetName		nvarchar(255),
		subClientName		nvarchar(255),
		commCellName		nvarchar(255),
		dataStatus			int,
		disabled			int,
		toBeCopied			int,
		jobCopyAttributes	int,
		sizeOnMedia			bigint,
		archCheckEndTime	int,
		archCheckStatus 	int,
		extRetentionFlags	int,
		retentionEndTime	int,
		copiedTime			int,
		agedTime			int,
		errorCode			int,
		retainedBy          int,
        copyId              int,
        dedupSaving         bigint,
        jobCopyStatus       int,
		jobDescription		nvarchar(MAX),
		jobDisplayFlags		bigint,
		indexBackupJob		int,
		clientOwnerList		nvarchar(MAX),
		RequiredByJobIds		nvarchar(MAX),
		lastRefreshedTime	int,
clientDisplayName	nvarchar(255),
		disabledFromJDS		int
)
--select * from @TblCopyIds
DECLARE Get_CopyID CURSOR FOR
SELECT	CopyId
FROM	@TblCopyIds
DECLARE @xml XML;
OPEN Get_CopyID
FETCH FROM Get_CopyID
INTO @CopyId
WHILE @@FETCH_STATUS = 0
BEGIN
	INSERT INTO @TblResult
	EXEC archViewJobsByCopy @CopyId, 0,   @i_isAged, @BackupLevel, @TimeRangeBegin, @TimeRangeEnd, 0,   @i_orderByCode, 0
	IF EXISTS (SELECT TOP 1 jobId FROM @TblResult)
	BEGIN
		--get MediaList
		CREATE TABLE #tempAFCopy(
		afId    integer,
		ccId    integer
		)
		INSERT INTO #tempAFCopy
		SELECT archFileId, commCellId
		FROM   archFileCopy WITH (READUNCOMMITTED)
		WHERE  archCopyId = @copyId AND isValid = 1
		SELECT DISTINCT archChunkId, ccid
		INTO   #tempChunk
		FROM   archChunkMapping WITH (READUNCOMMITTED), #tempAFCopy
		WHERE  archFileId = afId AND commCellId = ccId AND (archCopyId = @copyId)
		SELECT DISTINCT volumeId
		INTO   #tempVolume
		FROM   archChunk WITH (READUNCOMMITTED), #tempChunk
		WHERE  id = archChunkId and commCellId = ccId
		SET @xml = (SELECT SUBSTRING((SELECT DISTINCT '; '+ MT.MediaTypeName
								FROM #tempVolume T
							LEFT JOIN MMVolume V WITH (READUNCOMMITTED)
								ON T.volumeId=V.VolumeId
							LEFT JOIN MMMedia M WITH (READUNCOMMITTED)
								ON V.MediaId=M.MediaId
							LEFT JOIN MMMediaType MT
								ON M.MediaTypeId = MT.MediaTypeId
							FOR XML PATH('')
					),3, 1000));
		DROP TABLE #tempAFCopy
		DROP TABLE #tempChunk
		DROP TABLE #tempVolume
		INSERT INTO @TblResultFinal
		SELECT	@xml
				,T.*,0
		FROM	@TblResult T
		set @xml = '';
		DELETE @TblResult;
	END
	FETCH FROM Get_CopyID
	INTO @CopyId
END
CLOSE		Get_CopyID
DEALLOCATE	Get_CopyID
DECLARE @phaseData TABLE(jobid int, phases int, duration INT);
INSERT INTO @phaseData
SELECT AT.jobId, COUNT(DISTINCT AT.phaseNum), sum(AT.endTime - AT.startTime)
FROM	JMAdminJobAttemptStatsTable AT, @TblResultFinal T
WHERE AT.jobId = T.jobId AND AT.commCellId = T.commCellId AND AT.phaseNum <> 0
GROUP BY AT.jobId, AT.commCellId
UNION
SELECT AT.jobId, COUNT(DISTINCT AT.phase), sum(AT.servEndDate - AT.servStartDate)
FROM	JMBkpAtmptStats AT, @TblResultFinal T
WHERE AT.jobId = T.jobId AND AT.commCellId = T.commCellId AND AT.phase <> 0
GROUP BY AT.jobId, AT.commCellId
UPDATE	@TblResultFinal
SET		sizeOfNWTransfer = A.nwTransBytes
FROM	JMAdminJobStatsTable A
			JOIN @TblResultFinal F
				ON A.jobId = F.jobId
UPDATE	T
SET		disabledFromJDS = (SELECT dbo.BitwiseOR(disabled) FROM JMJobDataStats WITH (NOLOCK) WHERE jobId = T.jobId AND commCellId = T.commCellId AND archGrpCopyId = T.copyId )
FROM	@TblResultFinal T
SELECT	JobID				= T.jobId,
		CommcellID			= T.commCellId,
		MediaAgent			= ISNULL((select SUBSTRING((SELECT DISTINCT ';' + MA.name
														FROM JMJobResourceHistory RES
																JOIN APP_Client MA
																	ON MA.id = RES.ClientId
														WHERE jobId = T.jobId AND commCellId = T.commCellId FOR XML PATH('')),2,1000)), ''),
		'Storage Policy'					= AG.name,
		'Storage Policy Copy'					= AGC.name,
		Retention			= CASE WHEN AGE.retentionDays < 0 THEN 'INFINITE' ELSE CAST(AGE.retentionDays AS VARCHAR(10))+ ' day(s);' + CAST(AGE.fullCycles AS VARCHAR(10)) +' Cycle(s)' END,
		SPCAgedStatus		= (SELECT CASE WHEN JDS.agedBy & 512 = 512 THEN 'Aged By SPC Rules' WHEN JDS.agedBy > 0 THEN 'General' ELSE 'None' END FROM JMJobDataStats JDS WHERE JDS.jobId = T.jobId and JDS.dataType = 1 and jds.archGrpCopyId = T.copyId),
		Media				= isnull(T.mediaList, ''),
		JobStatus			= ISNULL((CASE WHEN jobStatus = 1 THEN 'Completed' ELSE 'Completed With Errors' END), 'N/A'),
		DataStatus			= CASE WHEN T.dataStatus = 100 THEN 'Available' ELSE 'Partial' END,
		Phases				= PH.phases,
		Client				= clientName,
		HostName			= C.net_hostname,
		AgentType			= appTypeName,
		Instance			= (case when dbo.FixInstanceName(instanceName, appTypeId) <> '' then dbo.FixInstanceName(instanceName, appTypeId) else									instanceName end),
		BackupSet			= backupSetName,
		SubClient			= subClientName,
		Filters				= ISNULL((SELECT (SELECT substring((select ', ' + fileName
																 from	APP_ScFilterFile fltr
																 where fltr.componentNameId = T.appId and fltr.type = 1
																 order by fltr.componentNameId, fltr.type
																 for xml path('')), 3, 1000)) AS INCLUDE,
												(SELECT substring((select ', ' + fileName
																 from	APP_ScFilterFile fltr
																 where fltr.componentNameId = T.appId and fltr.type = 2
																 order by fltr.componentNameId, fltr.type
																 for xml path('')), 3, 1000)) AS EXCLUDE,
												(SELECT substring((select ', ' + fileName
																 from	APP_ScFilterFile fltr
																 where fltr.componentNameId = T.appId and fltr.type = 3
																 order by fltr.componentNameId, fltr.type
																 for xml path('')), 3, 1000)) AS EXCEPTION
									FOR XML PATH ('FILTER')),'NONE'),
		BackupType			= dbo.GetJobBackupTypeDisplay(level),
		Cycle_Seq			= cast(T.fullCycleNum as varchar(10))+ '/' + cast(T.seqNumInCycle as varchar(10)),
		StartTime			= dbo.UTCToLocalStringTime(dbo.GetDateTime(T.startTime), @csTimeZone),
		EndTime				= dbo.UTCToLocalStringTime(dbo.GetDateTime(T.endTime), @csTimeZone),
		'RunLength (Sec)'		= PH.duration,
		'Application Size (GB)'		= CONVERT(DECIMAL(20, 2), ISNULL(CAST(sizeOfApplication AS FLOAT), 0)/1024/1024/1024),
		'Backup Size (GB)'		= CONVERT(DECIMAL(20, 2), ISNULL(CAST(sizeOfBackup AS FLOAT), 0)/1024/1024/1024),
		'Transferred Size (GB)'		= CONVERT(DECIMAL(20, 2), ISNULL(CAST(sizeOfNWTransfer AS FLOAT), 0)/1024/1024/1024),
		'Data Written (GB)'		= CONVERT(DECIMAL(20, 2), ISNULL(CAST(T.sizeOnMedia AS FLOAT), 0)/1024/1024/1024),
		'Dedup Saving(%)'		= CASE WHEN sizeOfApplication > T.sizeOnMedia
								THEN CAST(100.0*(sizeOfApplication - T.sizeOnMedia)/sizeOfApplication AS DECIMAL(5,2))
								ELSE 0 END,
		RetainDataUntil		= case when retentionEndTime IS NULL or retentionEndTime <=0 then 'Infinite' else dbo.UTCToLocalStringTime(dbo.GetDateTime(retentionEndTime), @csTimeZone) end,
		RetainedBy				= CASE
										WHEN T.disabled & 2 = 2
											THEN 'MANUAL RETENTION'
										WHEN T.extRetentionFlags > 0
											THEN 'EXTENDED RETENTION'
										ELSE 'BASIC RETENTION'
									END
FROM	@TblResultFinal T
				JOIN
					archGroupCopy AGC
						ON AGC.id = T.copyId
				JOIN
					archGroup AG
						ON AG.id = AGC.archGroupId
				JOIN
					archAgingRule AGE
						ON AGE.copyId = T.copyId
				JOIN
					APP_Client C
						ON C.id = T.clientId
				JOIN
					@phaseData PH
						ON T.jobId = PH.jobid
WHERE	( (@i_includePartialJobsOnly = 0 AND T.dataStatus IN (100, 102, 103))
		 OR (@i_includePartialJobsOnly = 0 AND @i_includeToBeCopiedJobs & T.dataStatus > 0 AND T.disabledFromJDS & 1 = 0 )
		 OR (@i_includePartialJobsOnly = 1 AND T.dataStatus IN (102, 103)) )
			AND (
					( @i_retention = 0 )
						OR ( @i_retention & 1 > 0 AND t.extRetentionFlags = 0 AND T.disabled & 2 <> 2)
						OR ( @i_retention & 2 > 0 AND T.extRetentionFlags > 0 )
						OR ( @i_retention & 4 > 0 AND T.disabled & 2 = 2 )
				)
ORDER BY T.jobId
SET NOCOUNT OFF
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_JobsinSPCopy')
	delete from GxQscripts where name = 'QS_JobsinSPCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_JobsinSPCopy')
	delete from GXDBVersions where aliasname = 'QS_JobsinSPCopy'
GO

insert into GXDBVersions values(2, 'QS_JobsinSPCopy',  '00010006004600130000', 'QS_JobsinSPCopy', '00010006004600130000')
GO

insert into GxQscripts values(2,'QS_JobsinSPCopy',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_JobsinSPCopy [-si @i_fromTime=''2013/02/12''] [-si @i_toTime=''2013/02/20''] [-si @i_isAged=''2''] [-si @i_backupType=''Full''] [-si @i_orderBy=''Client''] [-si @i_policyName=''policyName''] [-si @i_copyName=''copyName''] [-si @i_retention=''0''] [-si @i_includeToBeCopiedJobs=''0''] [-si @i_includePartialJobsOnly=''0'']
'
 + CHAR(10) + '-- 	Return list of jobs for a Storage policy copy.'
)
GO

