

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_JobsInStoragePolicyCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_JobsInStoragePolicyCopy.sp,v $ $Id: QS_JobsInStoragePolicyCopy.sp,v 1.7.46.9 2018/12/28 19:15:43 prasanthm Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_JobsInStoragePolicyCopy')
BEGIN
	print '>>> Drop Stored Procedure: QS_JobsInStoragePolicyCopy <<<'
	drop procedure QS_JobsInStoragePolicyCopy
END
IF EXISTS (select * from GxQscripts where name='QS_JobsInStoragePolicyCopy')
	delete from GxQscripts where name = 'QS_JobsInStoragePolicyCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_JobsInStoragePolicyCopy')
	delete from GXDBVersions where aliasname = 'QS_JobsInStoragePolicyCopy'
GO
print '... Creating Procedure: QS_JobsInStoragePolicyCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_JobsInStoragePolicyCopy
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @PolicyName VARCHAR(144),
  @CopyName VARCHAR(64),
  @FromTime VARCHAR(32) = '',
  @ToTime VARCHAR(32) = '',
  @BackupType VARCHAR(32) = '',
  @OrderBy VARCHAR(32) = '',
  @IsAged VARCHAR(32) = ''
AS
SET NOCOUNT ON
DECLARE	@CopyId			INT
DECLARE	@TimeRangeBegin	INT = 0
DECLARE	@TimeRangeEnd	INT = 0
DECLARE	@BackupLevel	INT = 0
DECLARE	@OrderByCode	INT = 0
DECLARE	@IsAgedCode		INT = 0
DECLARE @csTimeZone VARCHAR(256)
SELECT	@csTimeZone = timeZone FROM APP_CommCell WHERE id = 2
SELECT	@csTimeZone = TimeZoneStdName FROM SchedTimeZone
WHERE	TimeZoneName= SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
DECLARE	@FromDateTime	DATETIME = @FromTime
DECLARE	@ToDateTime		DATETIME = @ToTime
IF @FromTime <> ''
BEGIN
	SET	@FromDateTime	= dbo.ClientLocalToUTCTime(@FromDateTime, 2)
	SET	@TimeRangeBegin = dbo.GetUnixTime(@FromDateTime)
END
IF @ToTime <> ''
BEGIN
	SET	@ToDateTime		= dbo.ClientLocalToUTCTime(@ToDateTime, 2)
	SET	@TimeRangeEnd	= dbo.GetUnixTime(@ToDateTime)
END
SET @BackupLevel = CASE WHEN @BackupType = 'Full' THEN 1
						WHEN @BackupType = 'Incr' THEN 2
						ELSE 0
					END
SET @OrderByCode = CASE WHEN @OrderBy = 'Client' THEN 1
						WHEN @OrderBy = 'Agent' THEN 2
						ELSE 0
					END
SET @IsAgedCode  = CASE WHEN @IsAged = '1' THEN 1
						WHEN @IsAged = '2' THEN 2
						ELSE 0
					END
SELECT	@CopyId = AGC.id
FROM	archGroup AG INNER JOIN archGroupCopy AGC ON AGC.archGroupId = AG.id
WHERE	AG.name = @PolicyName AND AGC.name = @CopyName
DECLARE	@TblResult TABLE (
		jobId				int,
		commCellId			int,
		appId				int,
		sizeOfApplication	bigint,
		sizeOfAppCompressed	bigint,
		sizeOfBackup		bigint,
		sizeOfNWTransfer	bigint,
		startTime			int,
		endTime				int,
		opType				int,
		level				int,
		jobStatus			int,
		fullCycleNum		int,
		seqNumInCycle		int,
		duration			int,
		numStreams			int,
		numObjects			bigint,
		initFrom			int,
		attributes			bigint,
		attributesEx		bigint,
userName			nvarchar(255),
		totalWriteTime		int,
		scanFileFailures	int,
		scanFolderFailures	int,
		bkpFileFailures		int,
		bkpFolderFailures	int,
		subClientId 		int,
		clientId			int	,
		appTypeId			int	,
		instanceId			int,
		backupSetId			int,
clientName			nvarchar(255),
appTypeName			varchar(255),
instanceName		nvarchar(255),
backupSetName		nvarchar(255),
subClientName		nvarchar(255),
commCellName		nvarchar(255),
		dataStatus			int,
		disabled			int,
		toBeCopied			int,
		jobCopyAttributes	int,
		sizeOnMedia			bigint,
		archCheckEndTime	int,
		archCheckStatus 	int,
		extRetentionFlags	int,
		retentionEndTime	bigint,
		copiedTime			bigint,
		agedTime			bigint,
		errorCode			int,
		retainedBy			int,
		copyId				int,
		dedupSaving			bigint,
		jobCopyStatus		int,
		jobDescription		nvarchar(MAX),
		jobDisplayFlags		bigint,
		indexBackup			int,
		clientOwnerList		nvarchar(MAX),
		RequiredByJobIds		nvarchar(MAX),
		lastRefreshTime      int,
clientDisplayName	nvarchar(255)
)
INSERT INTO @TblResult
EXEC archViewJobsByCopy @CopyId, 0, @IsAgedCode, @BackupLevel, @TimeRangeBegin, @TimeRangeEnd, 0, @OrderByCode, 0
SELECT	JobID				= jobId,
		Status				= CASE WHEN dataStatus = 100 THEN 'Available' ELSE 'Partial' END,
		Client				= clientName,
		AgentType			= appTypeName,
		Instance			= dbo.FixInstanceName(instanceName, appTypeId),
		BackupSet			= backupSetName,
		SubClient			= subClientName,
		JobType				= dbo.GetJobBackupTypeDisplay(level),
		StartTime			= dbo.UTCToLocalStringTime(dbo.GetDateTime(startTime), @csTimeZone),
		EndTime				= dbo.UTCToLocalStringTime(dbo.GetDateTime(endTime), @csTimeZone),
		ApplicationSizeGB	= CAST(sizeOfApplication/1024.0/1024.0/1024.0 AS DECIMAL(20,2)),
		BackupSizeGB		= CAST(sizeOfBackup/1024.0/1024.0/1024.0 AS DECIMAL(20,2)),
		TransferredSizeGB	= CAST(sizeOfNWTransfer/1024.0/1024.0/1024.0 AS DECIMAL(20,2)),
		DataWrittenGB		= CAST(sizeOnMedia/1024.0/1024.0/1024.0 AS DECIMAL(20,2)),
		DedupSavingPct		= CASE WHEN sizeOfApplication > sizeOnMedia
								THEN CAST(100.0*(sizeOfApplication - sizeOnMedia)/sizeOfApplication AS DECIMAL(5,2))
								ELSE 0 END
FROM	@TblResult
WHERE	dataStatus IN (100, 102, 103)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_JobsInStoragePolicyCopy')
	delete from GxQscripts where name = 'QS_JobsInStoragePolicyCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_JobsInStoragePolicyCopy')
	delete from GXDBVersions where aliasname = 'QS_JobsInStoragePolicyCopy'
GO

insert into GXDBVersions values(2, 'QS_JobsInStoragePolicyCopy',  '00010007004600090000', 'QS_JobsInStoragePolicyCopy', '00010007004600090000')
GO

insert into GxQscripts values(2,'QS_JobsInStoragePolicyCopy',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	qoperation execscript -sn QS_JobsInStoragePolicyCopy -si @PolicyName = ''***'' -si @CopyName = ''***'' [-si @FromTime = ''''] [-si @ToTime = ''''] [-si @BackupType = ''Full''] [-si @OrderBy = ''Client''] [-si @IsAged = ''1'']'
 + CHAR(10) + '-- 	Input:'
 + CHAR(10) + '-- 		FromTime and ToTime should be in ''mm/dd/yyyy hh:mm:ss'' format. Default is all time.'
 + CHAR(10) + '-- 		BackupType can be ''Full'' or ''Incr''. Default is for all backup types. '
 + CHAR(10) + '-- 		OrderBy can be ''JobID'', ''Client'' or ''Agent''. Default is descending order of JobID.'
 + CHAR(10) + '-- 		IsAged = 1 for aged jobs only. IsAged = 2 for including aged jobs. Default is for only not aged jobs.'
)
GO

