

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_JobsCopiedByAuxCopyJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_JobsCopiedByAuxCopyJob.sp,v $ $Id: QS_JobsCopiedByAuxCopyJob.sp,v 1.2.54.4 2018/12/21 19:26:08 daruloli Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_JobsCopiedByAuxCopyJob')
BEGIN
	print '>>> Drop Stored Procedure: QS_JobsCopiedByAuxCopyJob <<<'
	drop procedure QS_JobsCopiedByAuxCopyJob
END
IF EXISTS (select * from GxQscripts where name='QS_JobsCopiedByAuxCopyJob')
	delete from GxQscripts where name = 'QS_JobsCopiedByAuxCopyJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_JobsCopiedByAuxCopyJob')
	delete from GXDBVersions where aliasname = 'QS_JobsCopiedByAuxCopyJob'
GO
print '... Creating Procedure: QS_JobsCopiedByAuxCopyJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_JobsCopiedByAuxCopyJob
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_AuxCopyJob VARCHAR(32) = '',
  @i_fromTime VARCHAR(32) = '',
  @i_toTime VARCHAR(32) = '',
  @i_policyName varchar(144) = '',
  @i_copyName varchar(64)  = ''
AS
SET NOCOUNT ON
-- @i_AuxCopyJob			int		= 0
-- @i_fromTime VARCHAR(32)		= '2011-10-13',--start time--yyyy-mm-dd
-- @i_toTime VARCHAR(32)		= '2012-11-30',--end time--yyyy-mm-dd
-- @i_policyName VARCHAR(144)	= '',--data from policy
-- @i_copyName VARCHAR(64)		= '' --data from policy copy -- IF YOU SPECIFY THIS YOU HAVE TO SPECIFY POLICYNAME
DECLARE @AuxCopyJobs TABLE (JobID INTEGER)
DECLARE @TblCopyIds TABLE (PolicyId INTEGER, CopyId INTEGER);
DECLARE @validation  INT = 1
DECLARE @localErrorMsg  VARCHAR(256)
IF   @i_AuxCopyJob <> '' AND @i_AuxCopyJob <> '0'
BEGIN
	INSERT INTO @AuxCopyJobs
	SELECT  JobID
	FROM	JMAdminJobStatsTable
	WHERE	OpType in (13, 104) --AUXCOPY, AUXCOPY2
			AND JobID =  @i_AuxCopyJob
	IF NOT EXISTS (SELECT  * FROM @AuxCopyJobs)
	BEGIN
			SET @validation = 0
			SET @localErrorMsg = 'Error: AuxCopy Job not found!'
			goto   ARGS_ERROR
	END
	SELECT	JDS.auxCopyJobId AS 'AuxCopyJobId',
			JBS.jobId AS 'JobId',
			(CASE WHEN JDS.Status = 100 THEN 'Copied'
				WHEN JDS.Status = 1000 THEN 'Pruned'
				WHEN JDS.Status != 101 THEN 'Partially Copied'
				ELSE 'Unknown'
			END) AS Status,
			ClientName = (select name from APP_Client WITH (READUNCOMMITTED) where id = A.clientId),
			AppTypeName = (select name from APP_iDAType WITH (READUNCOMMITTED) where type = A.appTypeId),
			InstanceName = (select name from APP_InstanceName WITH (READUNCOMMITTED) where id = A.instance),
			BackupSetName = (select name from APP_BackupSetName WITH (READUNCOMMITTED) where id = A.backupSet),
			A.SubclientName,
			DATEADD(SS,(DATEDIFF(SS,GETUTCDATE(),GETDATE())),dbo.GetDateTime(servStartDate)) as 'CommServerStartTime',
			DATEADD(SS,(DATEDIFF(SS,GETUTCDATE(),GETDATE())),dbo.GetDateTime(servEndDate)) as 'CommServerEndTime',
			(CASE WHEN (JDS.DataType = 1) THEN 'Data'
				WHEN (JDS.DataType = 1) THEN 'Data'
				ELSE 'Index'
			END) Type,
			AG.name AS 'StoragePolicyName',
			AGC.name AS 'CopyName'
	FROM	@AuxCopyJobs J,
			JMJobDataStats JDS WITH (READUNCOMMITTED),
			JMBkpStats JBS WITH (READUNCOMMITTED),
			APP_Application A WITH (READUNCOMMITTED),
			ArchGroup AG WITH (READUNCOMMITTED),
			ArchGroupCopy AGC WITH (READUNCOMMITTED)
	WHERE	JDS.AuxCopyJobId = J.JobId
			AND JDS.JobId = JBS.jobId
			AND JDS.commCellId = JBS.commCellId
			AND JDS.status != 101
			AND JDS.appId = A.id
			AND JDS.archGrpId = AG.id
			AND JDS.archGrpCopyId = AGC.id
	ORDER BY JDS.AuxCopyJobId, JDS.JobId, JDS.CommCellId, JDS.DataType, AG.Name, AGC.Name
END
ELSE
BEGIN
	DECLARE	@CopyId			INT = 0
	DECLARE	@TimeRangeBegin	INT = 0
	DECLARE	@TimeRangeEnd	INT = 0
	DECLARE @csTimeZone VARCHAR(256)
	SELECT	@csTimeZone = timeZone FROM APP_CommCell WHERE id = 2
	SELECT	@csTimeZone = TimeZoneStdName FROM SchedTimeZone
	WHERE	TimeZoneName= SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
	DECLARE	@FromDateTime	DATETIME =   @i_fromTime
	DECLARE	@ToDateTime		DATETIME =   @i_toTime
	IF   @i_fromTime <> ''
	BEGIN
		SET	@FromDateTime	= dbo.ClientLocalToUTCTime(@FromDateTime, 2)
		SET	@TimeRangeBegin = dbo.GetUnixTime(@FromDateTime)
	END
	IF (@TimeRangeBegin = 0)
	BEGIN
			SET @validation = 0
			SET @localErrorMsg = 'Error: Invalid from time!'
			goto   ARGS_ERROR
	END
	IF   @i_toTime <> ''
	BEGIN
		SET	@ToDateTime		= dbo.ClientLocalToUTCTime(@ToDateTime, 2)
		SET	@TimeRangeEnd	= dbo.GetUnixTime(@ToDateTime)
	END
	IF (@TimeRangeEnd = 0)
	BEGIN
			SET @validation = 0
			SET @localErrorMsg = 'Error: Invalid to time!'
			goto   ARGS_ERROR
	END
	IF   @i_copyName = '' AND   @i_policyName = ''
		INSERT INTO @TblCopyIds
		SELECT	archGroupId, id
		FROM	archGroupCopy
		where	id > 0
	ELSE
		INSERT INTO @TblCopyIds
		SELECT	AGC.archGroupId, AGC.id
		FROM	archGroup AG
					INNER JOIN archGroupCopy AGC
						ON AGC.archGroupId = AG.id
		WHERE	AG.name =   @i_policyName AND (AGC.name =   @i_copyName OR   @i_copyName = '')
	IF NOT EXISTS (SELECT  * FROM @TblCopyIds)
	BEGIN
			SET @validation = 0
			SET @localErrorMsg = 'Error: Policy or Copy not found!'
			goto   ARGS_ERROR
	END
	INSERT INTO @AuxCopyJobs
	SELECT  DISTINCT JobID
	FROM	JMAdminJobStatsTable JAS, @TblCopyIds C
	WHERE	OpType in (13, 104) -- AUXCOPY, AUXCOPY2
			AND JAS.servEnd BETWEEN @TimeRangeBegin AND @TimeRangeEnd
			AND JAS.archGrpId = C.PolicyId
			AND (JAS.archGrpCopyId = 0 OR JAS.archGrpCopyId = C.CopyId)
	IF NOT EXISTS (SELECT  * FROM @AuxCopyJobs)
	BEGIN
			SET @validation = 0
			SET @localErrorMsg = 'Error: AuxCopy Job not found!'
			goto   ARGS_ERROR
	END
	SELECT	JDS.auxCopyJobId AS 'AuxCopyJobId',
			JBS.jobId AS 'JobId',
			(CASE WHEN JDS.Status = 100 THEN 'Copied'
				WHEN JDS.Status = 1000 THEN 'Pruned'
				WHEN JDS.Status != 101 THEN 'Partially Copied'
				ELSE 'Unknown'
			END) AS Status,
			ClientName = (select name from APP_Client WITH (READUNCOMMITTED) where id = A.clientId),
			AppTypeName = (select name from APP_iDAType WITH (READUNCOMMITTED) where type = A.appTypeId),
			InstanceName = (select name from APP_InstanceName WITH (READUNCOMMITTED) where id = A.instance),
			BackupSetName = (select name from APP_BackupSetName WITH (READUNCOMMITTED) where id = A.backupSet),
			A.SubclientName,
			DATEADD(SS,(DATEDIFF(SS,GETUTCDATE(),GETDATE())),dbo.GetDateTime(servStartDate)) as 'CommServerStartTime',
			DATEADD(SS,(DATEDIFF(SS,GETUTCDATE(),GETDATE())),dbo.GetDateTime(servEndDate)) as 'CommServerEndTime',
			(CASE WHEN (JDS.DataType = 1) THEN 'Data'
				WHEN (JDS.DataType = 1) THEN 'Data'
				ELSE 'Index'
			END) Type,
			AG.name AS 'StoragePolicyName',
			AGC.name AS 'CopyName'
	FROM	@AuxCopyJobs J,
			@TblCopyIds C,
			JMJobDataStats JDS WITH (READUNCOMMITTED),
			JMBkpStats JBS WITH (READUNCOMMITTED),
			APP_Application A WITH (READUNCOMMITTED),
			ArchGroup AG WITH (READUNCOMMITTED),
			ArchGroupCopy AGC WITH (READUNCOMMITTED)
	WHERE	JDS.AuxCopyJobId = J.JobId
			AND C.PolicyId = JDS.archGrpId
			AND C.CopyId = JDS.archGrpCopyId
			AND JDS.JobId = JBS.jobId
			AND JDS.commCellId = JBS.commCellId
			AND JDS.status != 101
			AND JDS.appId = A.id
			AND JDS.archGrpId = AG.id
			AND JDS.archGrpCopyId = AGC.id
	ORDER BY JDS.AuxCopyJobId, JDS.JobId, JDS.CommCellId, JDS.DataType, AG.Name, AGC.Name
END
ARGS_ERROR:
SET NOCOUNT OFF
IF @validation = 0
BEGIN
	Raiserror(@localErrorMsg , 15, 1)
	RETURN -1
END
RETURN 0
GO

IF EXISTS (select * from GxQscripts where name = 'QS_JobsCopiedByAuxCopyJob')
	delete from GxQscripts where name = 'QS_JobsCopiedByAuxCopyJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_JobsCopiedByAuxCopyJob')
	delete from GXDBVersions where aliasname = 'QS_JobsCopiedByAuxCopyJob'
GO

insert into GXDBVersions values(2, 'QS_JobsCopiedByAuxCopyJob',  '00010002005400040000', 'QS_JobsCopiedByAuxCopyJob', '00010002005400040000')
GO

insert into GxQscripts values(2,'QS_JobsCopiedByAuxCopyJob',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_JobsCopiedByAuxCopyJob [-si @i_AuxCopyJob=''0'']  [-si @i_fromTime=''2013/02/12''] [-si @i_toTime=''2013/02/20''] [-si @i_policyName=''policyName''] [-si @i_copyName=''copyName'']
'
 + CHAR(10) + ' Please Note : The Time format in the above queries will vary for Windows and Unix. Windows format : ''2018-11-05'' Unix format : "2018/11/05"
'
 + CHAR(10) + ' Eg Usage : (Windows) qoperation execscript -sn QS_JobsCopiedByAuxCopyJob -si 0 -si @i_fromTime=''2018-11-05'' -si @i_toTime=''2018-11-14''
'
 + CHAR(10) + ' Eg Usage : (Unix) qoperation execscript -sn QS_JobsCopiedByAuxCopyJob -si 0 -si "2018/11/05" -si "2018/11/14"
'
 + CHAR(10) + '--  Options: @i_AuxCopyJob <> 0 : The jobs copied by this AuxCopy job and other parameters will be ignored.'
 + CHAR(10) + '--  Options: @i_AuxCopyJob = 0 , i_fromTime <> NULL, i_toTime <> NULL, i_policyName = NULL and i_copyName = NULL The jobs copied by all auxcopy jobs ran between fromTime and ToTime.'
 + CHAR(10) + '--  Options: @i_AuxCopyJob = 0 , i_fromTime <> NULL, i_toTime <> NULL, i_policyName <> NULL and i_copyName = NULL The jobs copied by all auxcopy jobs ran between fromTime and ToTime on policy.'
 + CHAR(10) + '--  Options: @i_AuxCopyJob = 0 , i_fromTime <> NULL, i_toTime <> NULL, i_policyName <> NULL and i_copyName <> NULL: The jobs copied by all auxcopy jobs ran between fromTime and ToTime on policy and copy.'
 + CHAR(10) + '-- 	Return list of jobs for a AuxCopy Job.'
)
GO

