

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_InheritPinnedRetentionFromSourceCopy.sp] ---------- 

--  +=======================================================================================================================+
--  |		 		Name:  QS_InheritPinnedRetentionFromSourceCopy()
--  | Description:  This Permanent QScript is to inherit the pinned retention from source copy jobs to destination copy jobs
--  +=======================================================================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_InheritPinnedRetentionFromSourceCopy.sp,v $ $Id: QS_InheritPinnedRetentionFromSourceCopy.sp,v 1.2.6.2 2021/04/27 00:33:09 hkapadia Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='QS_InheritPinnedRetentionFromSourceCopy')
BEGIN
	print '>>> Drop Stored Procedure: QS_InheritPinnedRetentionFromSourceCopy <<<'
	drop procedure QS_InheritPinnedRetentionFromSourceCopy
END
IF EXISTS (select * from GxQscripts where name='QS_InheritPinnedRetentionFromSourceCopy')
	delete from GxQscripts where name = 'QS_InheritPinnedRetentionFromSourceCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_InheritPinnedRetentionFromSourceCopy')
	delete from GXDBVersions where aliasname = 'QS_InheritPinnedRetentionFromSourceCopy'
GO
print '... Creating Procedure: QS_InheritPinnedRetentionFromSourceCopy'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure QS_InheritPinnedRetentionFromSourceCopy
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_archGrpName NVARCHAR(255) = '',
  @i_archGrpCopyName NVARCHAR(255) = ''
AS
	SET NOCOUNT ON
	IF ((@i_archGrpName = '') OR (@i_archGrpCopyName = ''))
	BEGIN
		PRINT 'Invalid inputs. Please refer documentation.'
		GOTO CX_ERROR_EXIT
	END
	DECLARE @archGrpId 	INTEGER
	SET 	@archGrpId	= 0
	DECLARE	@archGrpCopyId 	INTEGER
	SET 	@archGrpCopyId	= 0
	DECLARE	@sourceCopyId 	INTEGER
	SET 	@sourceCopyId	= 0
	DECLARE	@errorCode	INTEGER
	SET		@errorCode	= 0
	DECLARE @rowCount INTEGER
	SET			@rowCount = 0
	DECLARE @maxRetry INTEGER
	SET 		@maxRetry = 2
	DECLARE @retryCnt INTEGER
	SET 		@retryCnt = 0
	IF (@i_archGrpName <> '')
	BEGIN
		SELECT @archGrpId = id
		FROM archGroup WITH (NOLOCK)
		WHERE name = @i_archGrpName
		SET @errorCode = @@ERROR
		IF @errorCode != 0 GOTO CX_ERROR_EXIT
		IF @archGrpId = 0
		BEGIN
			PRINT 'Invalid Storage Policy Name.'
			GOTO CX_ERROR_EXIT
		END
	END
	IF (@i_archGrpCopyName <> '')
	BEGIN
		SELECT @archGrpCopyId = id
		FROM archGroupCopy WITH (NOLOCK)
		WHERE archGroupId = @archGrpId
		AND   name = @i_archGrpCopyName
		SET @errorCode = @@ERROR
		IF @errorCode != 0 GOTO CX_ERROR_EXIT
		IF @archGrpCopyId = 0
		BEGIN
			PRINT 'Invalid Copy Name.'
			GOTO CX_ERROR_EXIT
		END
	END
	if (OBJECT_ID('tempdb.dbo.#tblJobsToPin') IS NOT NULL) DROP TABLE #tblJobsToPin
	CREATE TABLE #tblJobsToPin (jobId INTEGER, commCellId INTEGER, archCopyId INTEGER, manualRetentionEndTime BIGINT)
	CREATE INDEX Idx_tmptblJobsToPin_1 ON #tblJobsToPin (jobId, commcellId, archCopyId)
	SELECT @maxRetry = isnull(value, 2)
	FROM mmconfigs WITH (NOLOCK)
	WHERE name = 'DA_CONFIG_NUMBER_OF_RETRY_ON_LOCK'
	SET @errorCode = @@ERROR
	IF @errorCode != 0 GOTO CX_ERROR_EXIT
	SELECT @sourceCopyId = CASE
													WHEN (AGC.isSnapCopy = 0 AND AGC.sourceCopyId = 0) THEN AG.defaultCopy
													WHEN (AGC.isSnapCopy != 0 AND AGC.sourceCopyId = 0) THEN AG.defaultSnapCopy
												 	ELSE (AGC.sourceCopyId)
												 END
	FROM archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
	WHERE AGC.archGroupId = AG.id
	AND		AGC.archGroupId = @archGrpId
	AND		AGC.id = @archGrpCopyId
	SET @errorCode = @@ERROR
	IF @errorCode != 0 GOTO CX_ERROR_EXIT
	--Get the manually retained jobs on source copy and retain them on destination copies
	INSERT INTO #tblJobsToPin
	SELECT JDS.jobId, JDS.commcellId, @archGrpCopyId, CASE WHEN MIN(JDS.manualRetentionEndTime) < 0 THEN -1 ELSE MAX(JDS.manualRetentionEndTime) END
	FROM JMJobDataStats JDS WITH (NOLOCK)
	WHERE JDS.archGrpCopyId = @sourceCopyId
	AND		JDS.manualRetentionEndTime != 0
	GROUP BY JDS.jobId, JDS.commcellId, JDS.archGrpCopyId
	SELECT @errorCode = @@ERROR, @rowCount = @@ROWCOUNT
	IF (@errorCode != 0) GOTO CX_ERROR_EXIT
	IF (@rowCount = 0) GOTO CX_NO_JOBS_TO_PROCESS
	WHILE @retryCnt <= @maxRetry
	BEGIN
		BEGIN TRY
		BEGIN
			BEGIN TRANSACTION
			--Pin the jobs on destination copy
			UPDATE JMJobDataStats
SET disabled = disabled | 2,
					manualRetentionEndTime = TMP.manualRetentionEndTime
			FROM JMJobDataStats JDS, #tblJobsToPin TMP
			WHERE JDS.jobId = TMP.jobId
			AND		JDS.commcellId = TMP.commcellId
			AND		JDS.archGrpCopyId = TMP.archCopyId
			COMMIT TRANSACTION
			GOTO CX_EXIT
		END
		END TRY
  	BEGIN CATCH
		BEGIN
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
  		SET @errorCode = ERROR_NUMBER()
			ROLLBACK TRANSACTION
    	IF @errorCode NOT IN (1222, 1205)
    	BEGIN
    		;THROW --Actually BREAK is not required as THROW will terminate the loop. But BREAK shouldn't harm either. So leaving BREAK to be safe, so we know we won't end up in an infinite loop.
    		BREAK
    	END
    	ELSE
    	BEGIN
    		SET @retryCnt = @retryCnt + 1
    		IF(@retryCnt > @maxRetry)
    		BEGIN
    			;THROW
    		END
    		ELSE
    		BEGIN
	    		WAITFOR DELAY '00:00:05'
	    		CONTINUE
	    	END
    	END
		END
		END CATCH;
	END
	CX_EXIT:
		PRINT 'Successfully retained jobs on Storage Policy [' + @i_archGrpName + '], Copy [' + @i_archGrpCopyName + '].'
		RETURN
	CX_NO_JOBS_TO_PROCESS:
		PRINT 'No jobs to retain on Storage Policy [' + @i_archGrpName + '], Copy [' + @i_archGrpCopyName + '].'
		RETURN
	CX_ERROR_EXIT:
		PRINT 'Failed to retain jobs on Storage Policy [' + @i_archGrpName + '], Copy [' + @i_archGrpCopyName + '].'
		RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'QS_InheritPinnedRetentionFromSourceCopy')
	delete from GxQscripts where name = 'QS_InheritPinnedRetentionFromSourceCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_InheritPinnedRetentionFromSourceCopy')
	delete from GXDBVersions where aliasname = 'QS_InheritPinnedRetentionFromSourceCopy'
GO

insert into GXDBVersions values(2, 'QS_InheritPinnedRetentionFromSourceCopy',  '00010002000600020000', 'QS_InheritPinnedRetentionFromSourceCopy', '00010002000600020000')
GO

insert into GxQscripts values(2,'QS_InheritPinnedRetentionFromSourceCopy',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn InheritPinnedRetentionFromSourceCopy.sql -si StoragePolicyName -si CopyName 
'
)
GO

