

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_IncreaseNumberOfDataReaders.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2015 Commvault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_IncreaseNumberOfDataReaders')
BEGIN
	print '>>> Drop Stored Procedure: QS_IncreaseNumberOfDataReaders <<<'
	drop procedure QS_IncreaseNumberOfDataReaders
END
IF EXISTS (select * from GxQscripts where name='QS_IncreaseNumberOfDataReaders')
	delete from GxQscripts where name = 'QS_IncreaseNumberOfDataReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_IncreaseNumberOfDataReaders')
	delete from GXDBVersions where aliasname = 'QS_IncreaseNumberOfDataReaders'
GO
print '... Creating Procedure: QS_IncreaseNumberOfDataReaders'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_IncreaseNumberOfDataReaders
AS
SET NOCOUNT ON
--
DECLARE @scriptName 			nvarchar(32) = 'IncreaseNumberOfDataReaders';
DECLARE @errorCode 				int = 0;
DECLARE @errorString 			nvarchar(1024) = ''
DECLARE @retVal 				int = 0
DECLARE @retStr 				nvarchar(100)= N''
DECLARE	@rowCnt 				int = 0
DECLARE @filterSubclientStatus 	INT = 0
DECLARE @StreamsPropName		nvarchar(32) = N'sys:nStreams'
DECLARE @SubPolicyPropName 		nvarchar(32) = N'Associated subclient Policy'
DECLARE @nowTime				INT 		 = dbo.GetUnixTime (GetUTCdate())
DECLARE @subClientId			INT
DECLARE @appTypeId				INT
DECLARE @archGroupId			INT
DECLARE @counterPropsChanged    INT = 0
--create temp table
IF OBJECT_ID('tempdb.dbo.#TempSupportedApptypes', 'U') IS NOT NULL
DROP TABLE #TempSupportedApptypes;
CREATE TABLE #TempSupportedApptypes (
	appType INTEGER PRIMARY KEY
)
--Prepare list of supported apptypes for this operation
INSERT INTO #TempSupportedApptypes (appType)
(SELECT DISTINCT appTypeId FROM GetAppTypesForAppGroup(22,0) --APPGRP_W2KFileSystem
UNION
SELECT DISTINCT appTypeId FROM GetAppTypesForAppGroup(34,0) --APPGRP_UnixFileSystem
UNION
SELECT 106
UNION
SELECT 13
)
--list of exclusion subclients
SET @filterSubclientStatus = CONVERT(INT,0x00004) + CONVERT(INT,0x00020) +
CONVERT(INT,0x00010) + CONVERT(INT,0x08000) +
CONVERT(INT,0x800000) + CONVERT(INT,0x80000) +
CONVERT(INT,0x100000)
--iterate through all clients' subclients
DECLARE subClientCursor CURSOR STATIC FOR
SELECT DISTINCT id, appTypeId, dataArchGrpID FROM APP_APPLICATION APPL WITH (NOLOCK) WHERE
(subclientStatus & @filterSubclientStatus) = 0    -- exclude dummy subclients
AND APPL.appTypeId in (SELECT appType FROM #TempSupportedApptypes)
AND (ISNULL((SELECT MAX(attrVal) from APP_SubClientProp WITH (NOLOCK) where componentNameId = APPL.id and attrName in ('Index SubClient','DDB Backup') and modified=0),0)=0) -- exclude ddbbackup and indexbackup subclients since they dont have subclientstatus set
OPEN subClientCursor
FETCH NEXT FROM subClientCursor INTO @subClientId, @appTypeId, @archGroupId
WHILE @@FETCH_STATUS = 0
BEGIN
	--Skip cv_default storage policy subclients
	IF (@archGroupId<=1)
	BEGIN
		FETCH NEXT FROM subClientCursor INTO @subClientId, @appTypeId, @archGroupId
		CONTINUE
	END
	--Skip subclients which have storage policy pointing to atleast one tape
	--So, Include only subclients whose storage policy all copies point to magnetic libraries (cloud or magnetic mounthpath).
	--Also, dataArchGrpID remains the same for subclient policy and subclients associated in App_application table.
	DECLARE @incrSP INT = ISNULL((SELECT incrSP FROM archGroup WITH (NOLOCK) WHERE id=@archGroupId),0)
	DECLARE @countNonMagneticLibraries INT = ISNULL(
	(select TOP 1 MLib.LibraryId
	from MMDataPath DP WITH (NOLOCK)
	INNER JOIN MMDrivePool DPOOL WITH (NOLOCK) ON DP.DrivePoolId = DPOOL.DrivePoolId
	INNER JOIN MMMasterPool MPOOL WITH (NOLOCK) ON DPOOL.MasterPoolId = MPOOL.MasterPoolId
	INNER JOIN MMLibrary MLib WITH (NOLOCK) ON MPOOL.LibraryId = MLib.LibraryId
	WHERE DP.copyId in (select id from archGroupCopy where archGroupId in (@incrSP,@archGroupId))
AND MLib.LibraryTypeId!=3) , 0)
	IF (@countNonMagneticLibraries>0)
	BEGIN
		FETCH NEXT FROM subClientCursor INTO @subClientId, @appTypeId, @archGroupId
		CONTINUE
	END
	--set component id to subclient policy id or subclient id.
	DECLARE @componentNameId INT = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = @SubPolicyPropName AND modified = 0), 0)
	IF (@componentNameId = 0)
	BEGIN
		SET @componentNameId = @subclientId
	END
	--If old property value is not set or is default, update to app-specific default VSA 20 and FS 4
	DECLARE @oldAttrVal INT = ISNULL((SELECT TOP 1 attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND modified =0 AND attrName = @StreamsPropName AND cs_attrName = checksum(@StreamsPropName) ORDER by created DESC), -1)
	IF (@oldAttrVal = -1 OR @oldAttrVal = 2)
	BEGIN
		DECLARE @newAttrVal INT = 2
IF (@appTypeId = 106)
		BEGIN
			SET @newAttrVal = 20
		END
		ELSE
		BEGIN
			SET @newAttrVal = 4
		END
		UPDATE APP_SubclientProp SET modified = @nowTime WHERE componentNameId = @componentNameId AND modified =0 and attrName = @StreamsPropName
		INSERT INTO APP_SubclientProp (componentNameId, created, modified, attrtype, attrname, attrval)
		VALUES (@componentNameId, @nowTime, 0, 7 , @StreamsPropName, @newAttrVal)
		SET @counterPropsChanged = @counterPropsChanged + 1
	END
	FETCH NEXT FROM subClientCursor INTO @subClientId, @appTypeId, @archGroupId
END
PRINT @scriptName + ' completed at ' + CONVERT(nvarchar(60), GETDATE()) + ' with ['  + CONVERT(nvarchar(max),@counterPropsChanged) + '] subclients modified'
CX_EXIT:
CLOSE subClientCursor
DEALLOCATE subClientCursor
IF OBJECT_ID('tempdb.dbo.#TempSupportedApptypes', 'U') IS NOT NULL
DROP TABLE #TempSupportedApptypes;
--if retstr is set, raise error
IF @retStr!=''
	RAISERROR(@retStr, 15 /* Severity > 10 to force DOS error code 1 */, 1);
GO

IF EXISTS (select * from GxQscripts where name = 'QS_IncreaseNumberOfDataReaders')
	delete from GxQscripts where name = 'QS_IncreaseNumberOfDataReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_IncreaseNumberOfDataReaders')
	delete from GXDBVersions where aliasname = 'QS_IncreaseNumberOfDataReaders'
GO

insert into GXDBVersions values(2, 'QS_IncreaseNumberOfDataReaders',  '00000000000000000000', 'QS_IncreaseNumberOfDataReaders', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_IncreaseNumberOfDataReaders',  0, GETDATE(), GETDATE(), '' + CHAR(10) + ' Increase default number of readers for subclients belonging to File System Agents to 4 and Virtual Server Agent to 20
'
 + CHAR(10) + ' 
'
 + CHAR(10) + '--  qoperation execscript -sn IncreaseNumberOfDataReaders.sql '
 + CHAR(10) + ' 
'
)
GO

