

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_HyperScaleMonitoringPolicyAssociation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_HyperScaleMonitoringPolicyAssociation <<<'

IF EXISTS (select * from sysobjects where name='QS_HyperScaleMonitoringPolicyAssociation')
	drop procedure QS_HyperScaleMonitoringPolicyAssociation
IF EXISTS (select * from GxQscripts where name='QS_HyperScaleMonitoringPolicyAssociation')
	delete from GxQscripts where name = 'QS_HyperScaleMonitoringPolicyAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_HyperScaleMonitoringPolicyAssociation')
	delete from GXDBVersions where aliasname = 'QS_HyperScaleMonitoringPolicyAssociation'
GO
print '... Creating Procedure: QS_HyperScaleMonitoringPolicyAssociation'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_HyperScaleMonitoringPolicyAssociation
-- Qscript is Enabled
-- QScript secure this script does the user validation
-- Qscript Usage. Do not use special char in HTML
  @EditMode varchar(16),
  @Nodes nvarchar(max),
  @collInterval int = 15
AS
set nocount on
declare @errorCode int
declare @errorMessage nvarchar(max) = N''
declare @policyName varchar(max)
declare @concatString varchar(max)
--LMGetApplicableAssocCountForMonitoringPolicy variables
declare @userId int = 0
declare @policyId int
declare @ccId int
declare @localeId int = 0
--GUI Audit variables
declare @auditID int
declare @opMsgId int
declare @opEvMsgId int
declare @opErrCode int
declare @alertName varchar(max)
declare @preAssocCount int
declare @postAssocCount int
--Check Logged in user information
if object_id('tempdb.dbo.#tempQSUser') is null
begin
	set @errorCode = 1
	goto proc_exit
end
set @userId = isnull((select userId from #tempQSUser), 0)
if @userId = 0
begin
	set @errorCode = 2
	goto proc_exit
end
set @ccId = isnull(nullif((select origCCId from UMUsers where id = @userId), 0),2)
if (@EditMode <> 'append' and @EditMode <> 'set') or datalength(@Nodes) = 0
begin
	set @errorCode = 3
	goto proc_exit
end
--Get list of valid input nodes
if (object_id('tempdb.dbo.#constNodelist') is not null) drop table #constNodelist
create table #constNodelist (id int, nodeValue nvarchar(255))
insert into #constNodelist(nodeValue)
select Data from dbo.SplitString(@Nodes, ' ');
update n
set n.id = c.id
from #constNodelist n
join APP_Client(nolock) c on c.name = n.nodeValue
where c.origCCId = @ccId
and c.status & 0x00002 <> 0x00002
--Policies to edit
if (object_id('tempdb.dbo.#policyList') is not null) drop table #policyList
create table #policyList (policyId int, policyName nvarchar(255))
insert into #policyList
select monitorPolicyId, MonitorPolicyName
from APP_MonitoringPolicy(nolock)
where MonitorPolicyName = 'System Statistics - System Created Policy'
or MonitorPolicyName = 'DiskIO Statistics - System Created Policy'
or MonitorPolicyName = 'Network Statistics - System Created Policy'
declare @content varchar(max) = '<?xml version=''1.0'' encoding=''UTF-8''?><LogMonitoring_SysMonContentList flushInterval="' + cast(@collInterval as varchar(max)) + '" collectionInterval="' + cast(@collInterval as varchar(max)) + '" flushEventCount="10" />'
update mp
set attrVal = @content
from APP_MonitoringPolicyProp(nolock) mp
join #policyList pl on pl.policyId = mp.monitorPolicyId
where attrName = 'Content'
declare cur cursor local for
	select policyId, policyName
	from #policyList
open cur
fetch next from cur into @policyId, @policyName
while @@FETCH_STATUS = 0
begin
	--If all clients are associated, nothing is to be done
	declare @allClientsSelected int = 0;
	if exists (select 1 from APP_MonitorAssocEntity(nolock)
				where monitorPolicyId = @policyId
				and clientId = 0)
	begin
		if @EditMode = 'append'
			goto cont
		else
			set @allClientsSelected = 1
	end
	--Flags
	--		0 = Client to be added to policy but not already associated with policy	 	(Add for Set, Add for Append)
	--		1 = Client to be added to policy but already associated with policy			(No change for Set, No change for Append)
	--		2 = Client not to be added to policy but already associated with policy		(Remove for Set, No change for Append)
	if (object_id('tempdb.dbo.#nodelist') is not null) drop table #nodelist
create table #nodelist (id int, nodeValue nvarchar(255), flag int)
	insert into #nodelist(id, nodeValue, flag)
	select id, nodeValue, 0
	from #constNodelist
	where id is not null
	if @allClientsSelected = 0
	begin
		--Get clients associated to the monitoring policy
		if (object_id('tempdb.dbo.#assocClients') is not null) drop table #assocClients
create table #assocClients (id int, isPackageInstalled int, clientMangledHostName nvarchar(1024), randomGUID nvarchar(1024), name nvarchar(255))
		insert into #assocClients(id, isPackageInstalled, clientMangledHostName, randomGUID)
		exec LMGetApplicableAssocForMonitoringPolicy @policyId
		delete a
		from #assocClients a
		join APP_Client(nolock) c on c.id = a.id
where c.status & 0x00002 = 0x00002
		select @opErrCode = @@ERROR
		if @opErrCode <> 0
		begin
			set @errorCode = 4;
			set @errorMessage 	+= CHAR(10)
								+ 'Failed to get associations for Policy "'
								+  @policyName
								+ '". ErrorCode: '
								+ cast(@opErrCode as varchar(max));
			goto cont
		end
		update a
		set name = c.name
		from #assocClients a
		join APP_Client(nolock) c on c.id = a.id
		update n
		set flag = 1
		from #nodelist n
		join #assocClients ac on ac.id = n.id
		insert into #nodelist
		select id, name, 2
		from #assocClients ac
		where ac.id not in (select id from #nodeList)
	end
	declare @xml xml =
		(select
			(select
				3 as '@_type_'
				,0 as '@clientGroupId'
				,id as '@clientId'
				,0 as 'flags/@exclude'
			from
				(select id
					from #nodelist
					where id is not null
					and (@EditMode = 'append' or (@EditMode = 'set' and flag <> 2))
				) sub
			for xml path('associations'), type
			)
		for xml path('LogMonitoring_MonitoringPolicy'));
	if (object_id('tempdb.dbo.#outputSuppressor') is not null) drop table #outputSuppressor
	create table #outputSuppressor (errorCode int, errorMessage nvarchar(max))
	insert into #outputSuppressor(errorCode, errorMessage)
	exec LMSetEnityAssocForMonitoringPolicy @userId, @policyId, @ccId, @localeId , @xml
	set @opErrCode = isnull(nullif((select errorCode from #outputSuppressor), 0), 0);
	if @opErrCode <> 0
	begin
		set @errorCode = 5;
		set @errorMessage 	+= CHAR(10)
							+ 'Failed to udpate Policy "'
							+  @policyName
							+ '". Error: '
							+ isnull((select errorMessage from #outputSuppressor), 'Unknown') + ' = ' + cast((select errorCode from #outputSuppressor) as varchar(max))
		goto cont
	end
	set @errorMessage 	+= CHAR(10)
						+ 'Successfully updated Policy "'
						+  @policyName
						+ '".'
	--GUI Audit
	if not exists (select 1
			from #nodelist
			where flag = 0
			or (flag = 2 and @EditMode = 'set'))
		goto cont
set @opMsgId= (425 | (CAST(POWER(2, 24) AS BIGINT) * 84))
	exec EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId output, @auditID output
set @opMsgId=(1153 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	exec EvGuiAuditSetParamData @auditID, @policyName, @userId
	exec EvGuiAuditSetParameter @auditID, @opMsgId, @userId
declare @l_id int, @l_nodeValue nvarchar(255);
	if @EditMode = 'set'
	begin
		if @allClientsSelected = 1
		begin
set @opMsgId=(1652 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			exec EvGuiAuditSetParamData @auditID, '', @userId
			exec EvGuiAuditSetParameter @auditID, @opMsgId, @userId, 'true', '', 0, 0, 1
		end
		else
		begin
			--Add unselected clients to audit
			declare auditcur cursor local for
				select id, nodeValue
				from #nodelist
				where flag = 2
			open auditcur
			fetch next from auditcur into @l_id, @l_nodeValue
			while @@FETCH_STATUS = 0
			begin
set @opMsgId=(1233 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				exec EvGuiAuditSetParamData @auditID, @l_nodeValue, @userId
				exec EvGuiAuditSetParamData @auditID, '', @userId
				exec EvGuiAuditSetParameter @auditID, @opMsgId, @userId, 'true', '', 0, 0, 1
				fetch next from auditcur into @l_id, @l_nodeValue
			end
			close auditcur
			deallocate auditcur
		end
	end
	--Add selected clients to audit
	declare auditcur cursor local for
		select id, nodeValue
		from #nodelist
		where flag = 0
	open auditcur
	fetch next from auditcur into @l_id, @l_nodeValue
	while @@FETCH_STATUS = 0
	begin
set @opMsgId=(1233 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		exec EvGuiAuditSetParamData @auditID, @l_nodeValue, @userId
		exec EvGuiAuditSetParamData @auditID, '', @userId
		exec EvGuiAuditSetParameter @auditID, @opMsgId, @userId, '', 'true', 0, 0, 1
		fetch next from auditcur into @l_id, @l_nodeValue
	end
	close auditcur
	deallocate auditcur
	select @preAssocCount = count(*) from #nodelist where flag > 0
	select @postAssocCount = count(*) from #nodelist where flag < 2
	if @postAssocCount <> @preAssocCount
	begin
set @opMsgId=(1653 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		exec EvGuiAuditSetParameter @auditID, @opMsgId, @userId, '', '', 0, 0, 2
set @opMsgId=(1654 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		exec EvGuiAuditSetParamData @auditID, '', @userId
		exec EvGuiAuditSetParameter @auditID, @opMsgId, @userId, @preAssocCount, @postAssocCount, 0, 0, 2
	end
	cont:
    fetch next from cur into @policyId, @policyName
end
close cur
deallocate cur
proc_exit:
	if @errorCode = 1
		set @errorMessage 	+= CHAR(10)
							+ 'Error: No logged in user found.'
	else if @errorCode = 2
		set @errorMessage 	+= CHAR(10)
							+ 'Error: Logged in user information not found.'
	else if @errorCode = 3
		set @errorMessage 	+= CHAR(10)
							+ 'Error: Invalid arguments supplied.'
							+ CHAR(10)
							+ CHAR(10)
							+ 'Usage: qoperation execscript -sn HyperScaleMonitoringPolicyAssociation -si ''append|set'' -si ''[node]+'' -si ''[collection interval]'''
	if @errorCode not in (0)
        Raiserror(@errorMessage,
                    15,  --Severity (> 10 to force DOS Error Code = 1)
                    1    --State
                    )
    else
        select @errorMessage
	if (object_id('tempdb.dbo.#outputSuppressor') is not null) drop table #outputSuppressor
	if (object_id('tempdb.dbo.#nodelist') is not null) drop table #nodelist
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_HyperScaleMonitoringPolicyAssociation')
	delete from GxQscripts where name = 'QS_HyperScaleMonitoringPolicyAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_HyperScaleMonitoringPolicyAssociation')
	delete from GXDBVersions where aliasname = 'QS_HyperScaleMonitoringPolicyAssociation'
GO

insert into GXDBVersions values(2, 'QS_HyperScaleMonitoringPolicyAssociation',  '00000000000000000000', 'QS_HyperScaleMonitoringPolicyAssociation', '00000000000000000000')
GO

insert into GxQscripts values(2+8,'QS_HyperScaleMonitoringPolicyAssociation',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '--       qoperation execscript -sn HyperScaleMonitoringPolicyAssociation -si ''append|set'' -si ''[node]+'' -si ''[collectionInterval]'''
 + CHAR(10) + '--       Example: qoperation execscript -sn HyperScaleMonitoringPolicyAssociation -si ''set'' -si ''node1 node2 node3'' -si ''1'''
 + CHAR(10) + '--       Example: qoperation execscript -sn HyperScaleMonitoringPolicyAssociation -si ''append'' -si ''node1 node2 node3'''
)
GO

