

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GranularConfigRemoteCache.sp] ---------- 

-------------------------------------------
--         Name:   QS_GranularConfigRemoteCache.sp
--         Date:   12/04/2013
--       Author:   Praveen Kuttappan
--  Description:   configure the packages in remote cache to support granular sync.
-------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_GranularConfigRemoteCache')
BEGIN
	print '>>> Drop Stored Procedure: QS_GranularConfigRemoteCache <<<'
	drop procedure QS_GranularConfigRemoteCache
END
IF EXISTS (select * from GxQscripts where name='QS_GranularConfigRemoteCache')
	delete from GxQscripts where name = 'QS_GranularConfigRemoteCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GranularConfigRemoteCache')
	delete from GXDBVersions where aliasname = 'QS_GranularConfigRemoteCache'
GO
print '... Creating Procedure: QS_GranularConfigRemoteCache'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GranularConfigRemoteCache
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
  @clientName NVARCHAR(max),
  @syncOption NVARCHAR(100),
  @platform1 NVARCHAR(1024)= '',
  @packages1 NVARCHAR(1024)= '',
  @platform2 NVARCHAR(1024)= '',
  @packages2 NVARCHAR(1024)= ''
AS
SET NOCOUNT ON
DECLARE @localErrorMsg	varchar(max)
DECLARE @clientId   INTEGER
DECLARE @lastError	INTEGER
DECLARE @invalidWinPlatform varchar(1024)
DECLARE @invalidUnixPlatform varchar(1024)
DECLARE @invalidWinPackages varchar(1024)
DECLARE @invalidUnixPackages varchar(1024)
DECLARE @invalidUANames varchar(max)
DECLARE @synPackage INTEGER
DECLARE @oTempRCName table ( UANAme varchar(1024))
DECLARE @oTempOsID  INTEGER
DECLARE @tempPlatforms varchar(100)
DECLARE @PackagesList varchar(1024)
DECLARE @currentPackages varchar(1024)
DECLARE @csRelId INT
DECLARE @winPlatform NVARCHAR(1024)= ''
DECLARE @winPackages NVARCHAR(1024)= ''
DECLARE @unixPlatform NVARCHAR(1024)= ''
DECLARE @unixPackages NVARCHAR(1024)= ''
DECLARE @UseNewSync INTEGER = 0
SET	@lastError	= 0
SET @clientId=0
SET @synPackage =0
--Setting CS release version
SET @csRelId = (SELECT releaseId FROM  APP_Client WHERE id = 2)
IF object_id('tempdb.dbo.#ApplicablePlatform') IS NOT null
DROP TABLE #ApplicablePlatform
create table #ApplicablePlatform
(
     OSId	integer,
     isWindows  integer
)
--Temporary table is created to store all valid remote cache UA ID
if object_id('tempdb.dbo.#UA_RCID') IS NOT null DROP TABLE #UA_RCID
create table #UA_RCID
(
	UAId [INTEGER],
	isSyncRequired [INTEGER]
)
insert into #ApplicablePlatform(OSId,isWindows) values(1,1);
insert into #ApplicablePlatform(OSId,isWindows) values(3,1);
insert into #ApplicablePlatform(OSId,isWindows) values(14,0);
insert into #ApplicablePlatform(OSId,isWindows) values(15,0);
insert into #ApplicablePlatform(OSId,isWindows) values(16,0);
insert into #ApplicablePlatform(OSId,isWindows) values(17,0);
insert into #ApplicablePlatform(OSId,isWindows) values(18,0);
insert into #ApplicablePlatform(OSId,isWindows) values(20,0);
insert into #ApplicablePlatform(OSId,isWindows) values(22,0);
insert into #ApplicablePlatform(OSId,isWindows) values(23,0);
insert into #ApplicablePlatform(OSId,isWindows) values(24,0);
insert into #ApplicablePlatform(OSId,isWindows) values(25,0);
insert into #ApplicablePlatform(OSId,isWindows) values(26,0);
--PatchUAContentConfig table is added in V10 SP5 to support granular sync. Validating CS version and return error if version is below V10 SP5
IF object_id('CommServ.dbo.PatchUAContentConfig') IS  null or @csRelId < 15
BEGIN
      SET @localErrorMsg = 'This feature is not supported on version below V10 SP5'
      Set @lastError = 1
      goto   ARGS_ERROR
END
--Setting sync up value according to input. This will be used to insert/update in PatchUaContentConfig table
IF @syncOption like 'SyncAll'
BEGIN
      --Sync all packages for all OS
      SET @synPackage = 1
END
ELSE IF @syncOption like 'SyncNone'
BEGIN
      --Sync updates only for all OS
      SET @synPackage = 0
END
ELSE IF @syncOption like 'SyncCustom'
BEGIN
      --Sync Packages according to list of packages in input
    SET @synPackage = 3
      IF @platform1 = '' or exists (Select _ID from dbo.SplitIDString(@platform1) where _Id in (select OSId from #ApplicablePlatform where isWindows = 1))
      BEGIN
            set @winPlatform  = @platform1
	    set @winPackages = @packages1
	    set @unixPlatform = @platform2
	    set @unixPackages = @packages2
      END
      ELSE
      BEGIN
	    set @winPlatform  = @platform2
	    set @winPackages = @packages2
	    set @unixPlatform = @platform1
	    set @unixPackages = @packages1
      END
      --Platform ID validation: returns error and invalid platform list as error string if given platform ID is not part of defined platform set
      select @invalidWinPlatform = stuff((select ',' +  _ID from dbo.SplitIDString(@winPlatform) where _ID  not in (select CAST(OSId as varchar) from #ApplicablePlatform where isWindows = 1)
                                   for xml path('')),1,1,'')
      select @invalidUnixPlatform = stuff((select ',' +  _ID from dbo.SplitIDString(@unixPlatform)  where _ID  not in (select CAST(OSId as varchar) from #ApplicablePlatform where isWindows = 0)
				   for xml path('')),1,1,'')
      --Package ID verification
      select @invalidWinPackages = stuff((select ',' +  _ID from (SELECT _ID from dbo.SplitIDString(@winPackages) EXCEPT
SELECT cast(id as varchar) from simPackage where InstallableFromGUI = 1  and id < 1001) temp
				   for xml path('')),1,1,'')
      --Package ID verification
      select @invalidUnixPackages = stuff((select ',' +  _ID from (SELECT _ID from dbo.SplitIDString(@unixPackages) EXCEPT
SELECT cast(id as varchar) from simPackage where InstallableFromGUI = 1  and id > 1001 and id < 2000) temp
				    for xml path('')),1,1,'')
END
ELSE
BEGIN
      SET @localErrorMsg = 'Invalid sync option. Valid option is one of the following[SyncAll/SyncNone/SyncCustom]'
      SET @lastError = 1
      goto   ARGS_ERROR
END
--Platform and Packages list must be blank if sync option is either SyncAll or SyncNone
IF (@synPackage =1 or @synPackage =0) and (@platform1 not like '' or @packages1 not like '' or @platform2 not like '' or @packages2 not like '')
BEGIN
      SET @localErrorMsg = 'Invalid Input:Platform or package list are not required if sync option  is SyncAll and SyncNone'
      SET @lastError = 1
      goto  ARGS_ERROR
END
IF LEN(@invalidWinPlatform) > 0
BEGIN
      SET @localErrorMsg = 'Invalid Windows Platforms list:[' + @invalidWinPlatform + ']'
      Set @lastError = 1
      goto  ARGS_ERROR
END
IF  LEN(@invalidUnixPlatform) > 0
BEGIN
      SET @localErrorMsg = 'Invalid Unix Platforms list:[' +  @invalidUnixPlatform + ']'
      Set @lastError = 1
      goto  ARGS_ERROR
END
IF LEN(@invalidWinPackages) > 0
BEGIN
      SET @localErrorMsg = 'Invalid Windows Packages list:[' + @invalidWinPackages + ']'
      Set @lastError = 1
      goto  ARGS_ERROR
END
IF  LEN(@invalidUnixPackages) > 0
BEGIN
      SET @localErrorMsg =  'Invalid Unix Packages list:[' +  @invalidUnixPackages + ']'
      Set @lastError = 1
      goto  ARGS_ERROR
END
IF @clientName like 'All'
BEGIN
      --Get all existing remote cache and insert into temporary table
      INSERT  INTO #UA_RCID
(UAId,isSyncRequired )
      SELECT clientId,0 FROM PatchUpdateAgentInfo PI inner join APP_Client UA on UA.id = PI.clientId
 WHERE PI.isDeleted =0 and UA.releaseId = @csRelId and PI.clientId <> 2
END
ELSE IF @clientName  not like '' and @clientName  not like ' '
BEGIN
      INSERT  INTO  @oTempRCName SELECT distinct data FROM dbo.SplitString(@clientName,',')
      --Insert UA ID for all valid UA names in input
      INSERT  INTO #UA_RCID
(UAId,isSyncRequired )
      SELECT PI.clientId,0 FROM PatchUpdateAgentInfo PI inner join APP_Client UA  on UA.id = PI.clientId
      WHERE UA.name in (select UANAme from @oTempRCName) and PI.isDeleted = 0 and
UA.releaseId = @csRelId and
 PI.clientId <> 2
		      --Find and assign any Invalid UA name
      select @invalidUANames = stuff((select ',' +  name from (SELECT data as name FROM dbo.SplitString(@clientName,',')
EXCEPT
                                                               SELECT  name from APP_Client UA	where UA.id in (select UAId from #UA_RCID)) temp
				       for xml path('')),1,1,'')
      if LEN(@invalidUANames) > 0
      BEGIN
            SET @localErrorMsg = 'Following Remote Cache names are not valid:[' + @invalidUANames + ']'
            Set @lastError = 1
				    goto  ARGS_ERROR
      END
END
ELSE
BEGIN
      SET @localErrorMsg = 'Remote Cache Name cannot be blank'
      Set @lastError = 1
      goto   ARGS_ERROR
END
SELECT TOP 1 @UseNewSync = value FROM GXGlobalParam WHERE name = 'Patch Use New Sync' AND modified = 0
IF object_id('CommServ.dbo.PatchUAPackageConfig') IS  NULL
	SET @UseNewSync = 0
DECLARE remoteCacheCur CURSOR FOR SELECT UAId,OSId FROM #UA_RCID cross join #ApplicablePlatform
OPEN remoteCacheCur
FETCH NEXT FROM remoteCacheCur INTO @clientId,@oTempOsID
WHILE @@FETCH_STATUS = 0
BEGIN
      IF @synPackage = 1 or @synPackage = 0
            SET @PackagesList = ''
      ELSE
      BEGIN
            SET @PackagesList = ''
            IF exists (SELECT _ID from dbo.SplitIDString(@winPlatform) where _ID = @oTempOsID)
            BEGIN
		  IF @winPackages like ''
                       SET @synPackage = 2
		  ELSE
                       SET @synPackage =3
                 SET @PackagesList =  @winPackages
            END
            ELSE IF exists (SELECT _ID from dbo.SplitIDString (@unixPlatform) where _ID = @oTempOsID)
            BEGIN
                  IF @unixPackages like ''
                       SET @synPackage = 2
                  ELSE
                       SET @synPackage =3
                 SET @PackagesList =  @unixPackages
            END
            ELSE IF @winPlatform = '' and @unixPlatform = ''
	        BEGIN
                 SET @synPackage = 2
            END
            ELSE
                 GOTO NEXTUA
      END
      IF exists (select * from PatchUAContentConfig PUA where PUA.UACLientId =  @clientId and PUA.releaseId = @csRelId and PUA.OSId = @oTempOsID)
      BEGIN
			IF @UseNewSync = 0
				select @currentPackages = SelectedPackageList from PatchUAContentConfig PUA where PUA.UACLientId =  @clientId and PUA.releaseId =  @csRelId and PUA.OSId = @oTempOsID
			ELSE
				select @currentPackages = stuff((select ',' +  simPackageId from (
													select  convert(varchar, simPackageId ) as simPackageId
													from PatchUAPackageConfig pc join PatchUAContentConfig cc on
														pc.UAClientID = cc.UAClientId and cc.osid = pc.osid
													where cc.UAClientId = 6 and cc.OSId = 3 and cc.releaseid = 16) temp
												for xml path('')),1,1,'')
            select @PackagesList = stuff((select ',' +  _ID from (select _ID from dbo.SplitIDString(@PackagesList) EXCEPT select _ID from dbo.SplitIDString(@currentPackages)) temp
                                   for xml path('')),1,1,'')
			IF LEN(@PackagesList) > 0 and LEN(@currentPackages) > 0
                 SET @PackagesList = @currentPackages + ',' + @PackagesList
			ELSE IF LEN(@PackagesList) > 0
                 SET @PackagesList = @PackagesList
            ELSE
                 SET @PackagesList = @currentPackages
            if 	@synPackage <> 3
                SET @PackagesList = ''
            update #UA_RCID set isSyncRequired = 1 where UAId = @clientId and not exists
             (select * from PatchUAContentConfig  where UAClientId =  @clientId and releaseId =  @csRelId and OSId = @oTempOsID and syncPackages = @synPackage and @currentPackages = @PackagesList)
			IF @UseNewSync = 0
				update PatchUAContentConfig  set syncPackages = @synPackage,SelectedPackageList = @PackagesList
				where UAClientId =  @clientId and releaseId =  @csRelId and OSId = @oTempOsID
			ELSE
			BEGIN
				UPDATE PatchUAContentConfig  SET syncPackages = @synPackage,SelectedPackageList = ''
				WHERE UAClientId =  @clientId AND releaseId =  @csRelId and OSId = @oTempOsID
				DELETE FROM PatchUAPackageConfig where UAClientID = @clientId and OSId = @oTempOsID
				INSERT INTO PatchUAPackageConfig (UAClientId, simPackageId, OSId)
				SELECT @clientId, T._ID, @oTempOsID
				FROM  dbo.SplitIDs(@PackagesList) T
			END
     END
     ELSE
     BEGIN
		IF @UseNewSync = 0
			insert into PatchUAContentConfig(UaClientId,ReleaseID,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesInCache)
            values(@clientId,@csRelId,@oTempOsID,@synPackage,1,@PackagesList,'')
		ELSE
		BEGIN
			INSERT INTO PatchUAContentConfig(UaClientId,ReleaseID,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesInCache)
            VALUES(@clientId,@csRelId,@oTempOsID,@synPackage,1,'','')
			DELETE FROM PatchUAPackageConfig where UAClientID = @clientId and OSId = @oTempOsID
			INSERT INTO PatchUAPackageConfig (UAClientId, simPackageId, OSId)
			SELECT @clientId, T._ID, @oTempOsID
			FROM  dbo.SplitIDs(@PackagesList) T
		END
	END
     NEXTUA: fetch next from remoteCacheCur into @clientId,@oTempOsID
END
CLOSE remoteCacheCur
deallocate remoteCacheCur
--Following block will set syncPackages column to 2 for all other rows if previous selection was to sync all or syunc none and current option is syncCustom
--This is required to display configuration correctly in GUI(AS per the initial design of GRanular sync)
if @synPackage <> 1 and @synPackage <> 0
BEGIN
     update PatchUAContentConfig set SyncPackages = 2 , SelectedPackageList =''
     where SyncPackages in (1,0) and UAClientId in (select UAId from #UA_RCID) and UAClientId in (select distinct UA1.UAClientId from PatchUAContentConfig UA1 where UA1.SyncPackages in(2,3))
END
UPDATE PatchUpdateAgentInfo SET inSyncWithCS =0,packageStatus=0  WHERE clientId IN (select UAId from #UA_RCID where isSyncRequired =1)
DECLARE @cacheIdList VARCHAR(MAX)
SELECT @cacheIdList = COALESCE(@cacheIdList + ',' ,'') + CAST(id AS VARCHAR(255)) FROM PatchMultiCache
WHERE ClientId IN (select UAId from #UA_RCID where isSyncRequired =1)
EXEC patchCleanCacheEntries 1, 0, @cacheIdList
DROP TABLE #ApplicablePlatform
DROP TABLE #UA_RCID
ARGS_ERROR:
 PRINT @localErrorMsg
            if @lastError <> 0
            BEGIN
                  Raiserror(@localErrorMsg,
15, --Severity (> 10 to force DOS Error Code = 1)
				    1	 --State
					)
            END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GranularConfigRemoteCache')
	delete from GxQscripts where name = 'QS_GranularConfigRemoteCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GranularConfigRemoteCache')
	delete from GXDBVersions where aliasname = 'QS_GranularConfigRemoteCache'
GO

insert into GXDBVersions values(2, 'QS_GranularConfigRemoteCache',  '00000000000000000000', 'QS_GranularConfigRemoteCache', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GranularConfigRemoteCache',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '        Usage: Qoperation execscript sn QS_GranularConfigRemoteCache -si ''RemoteCachesName'' -si ''SyncOption'' -si ''Windows platform IDs'' -si ''Windows package IDs'' -si ''Unix platform IDs'' -si ''Unix package IDs''
'
 + CHAR(10) + '	RemoteCachesName will be either ''All'' or comma seperated remote caches name
'
 + CHAR(10) + '	Following are the valid sync options [SyncAll/SyncNone/SyncCustom]
'
 + CHAR(10) + '	SyncAll    : Sync all packages for all platforms
'
 + CHAR(10) + '	SyncNone   : Do not synchronize any packages
'
 + CHAR(10) + '	SyncCustom : sync only selected packages for selected platforms
'
 + CHAR(10) + '	Following are the valid platform ID for each platforms [Windows(32)=1, Windows(X64)=3,Aix PPC=14,Darwin X86=24,Freebsd X86=25,Freebsd X86_64=26,Hp IA64=20,Linux X86=15,Linux X86_64=16,Linux PPC64=17,Linux 390=18,Solaris SPARC=22,Solaris X86_64=23]
'
 + CHAR(10) + '        Please refer SimPackage table for package IDs
'
 + CHAR(10) + '	Example: qoperation execscript -sn QS_GranularConfigRemoteCache -si All -si SyncAll
'
 + CHAR(10) + '	Example: qoperation execscript -sn QS_GranularConfigRemoteCache -si All -si SyncNone
'
 + CHAR(10) + '	Example: qoperation execscript -sn QS_GranularConfigRemoteCache -si ''myClient1,myClient2'' -si SyncAll
'
 + CHAR(10) + '	Example: qoperation execscript -sn QS_GranularConfigRemoteCache -si ''myClient1,myClient2'' -si SyncNone
'
 + CHAR(10) + '	Example: qoperation execscript -sn QS_GranularConfigRemoteCache -si ''All'' -si SyncCustom -si ''1,3'' -si ''1,702''
'
 + CHAR(10) + '	Example: qoperation execscript -sn QS_GranularConfigRemoteCache -si ''All'' -si SyncCustom -si ''1,3'' -si ''1,702'' -si ''24,25'' -si ''1002''
'
)
GO

