

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetTopSQLTableInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_GetTopSQLTableInfo.sp,v $ $Id: QS_GetTopSQLTableInfo.sp,v 1.3.46.2 2018/03/20 00:10:02 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetTopSQLTableInfo <<<'

IF EXISTS (select * from sysobjects where name='QS_GetTopSQLTableInfo')
	drop procedure QS_GetTopSQLTableInfo
IF EXISTS (select * from GxQscripts where name='QS_GetTopSQLTableInfo')
	delete from GxQscripts where name = 'QS_GetTopSQLTableInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetTopSQLTableInfo')
	delete from GXDBVersions where aliasname = 'QS_GetTopSQLTableInfo'
GO
print '... Creating Procedure: QS_GetTopSQLTableInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetTopSQLTableInfo
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_TopNRows int = 1000
AS
  DECLARE @TableName NVARCHAR(128)
  DECLARE @RowCount BIGINT
  DECLARE @Reserved BIGINT
  DECLARE @Data BIGINT
  DECLARE @Index BIGINT
  DECLARE @Unused BIGINT
SET NOCOUNT ON
BEGIN TRY
SELECT TOP (@i_TopNRows)
	a2.name AS [TableName],
	a1.rows as [RowCount],
	(a1.reserved + ISNULL(a4.reserved,0))* 8 AS [Reserved(KB)],
	a1.data * 8 AS [Data(KB)],
	(CASE WHEN (a1.used + ISNULL(a4.used,0)) > a1.data THEN (a1.used + ISNULL(a4.used,0)) - a1.data ELSE 0 END) * 8 AS [Index(KB)],
	(CASE WHEN (a1.reserved + ISNULL(a4.reserved,0)) > a1.used THEN (a1.reserved + ISNULL(a4.reserved,0)) - a1.used ELSE 0 END) * 8 AS [Unused(KB)]
FROM
	(SELECT
		ps.object_id,
		SUM (
			CASE
				WHEN (ps.index_id < 2) THEN row_count
				ELSE 0
			END
			) AS [rows],
		SUM (ps.reserved_page_count) AS reserved,
		SUM (
			CASE
				WHEN (ps.index_id < 2) THEN (ps.in_row_data_page_count + ps.lob_used_page_count + ps.row_overflow_used_page_count)
				ELSE (ps.lob_used_page_count + ps.row_overflow_used_page_count)
			END
			) AS data,
		SUM (ps.used_page_count) AS used
	FROM sys.dm_db_partition_stats ps
	GROUP BY ps.object_id) AS a1
	LEFT OUTER JOIN
	(SELECT
		it.parent_id,
		SUM(ps.reserved_page_count) AS reserved,
		SUM(ps.used_page_count) AS used
	FROM sys.dm_db_partition_stats ps
		INNER JOIN sys.internal_tables it ON (it.object_id = ps.object_id)
	WHERE (it.internal_type = 202 OR it.internal_type = 204)
	GROUP BY it.parent_id) AS a4 ON (a4.parent_id = a1.object_id)
	INNER JOIN sys.all_objects a2  ON ( a1.object_id = a2.object_id )
	INNER JOIN sys.schemas a3 ON (a2.schema_id = a3.schema_id)
	WHERE a2.type <> N'S' and a2.type <> N'IT'
ORDER BY a1.rows DESC
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT
		ERROR_MESSAGE() as [TableName],
		ERROR_SEVERITY() as [RowCount],
		ERROR_STATE() as [Reserved(KB)],
		ERROR_NUMBER() as [Data(KB)],
		1 as [Index(KB)],
		1 as [Unused(KB)]
END CATCH
SET NOCOUNT OFF
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetTopSQLTableInfo')
	delete from GxQscripts where name = 'QS_GetTopSQLTableInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetTopSQLTableInfo')
	delete from GXDBVersions where aliasname = 'QS_GetTopSQLTableInfo'
GO

insert into GXDBVersions values(2, 'QS_GetTopSQLTableInfo',  '00010003004600020000', 'QS_GetTopSQLTableInfo', '00010003004600020000')
GO

insert into GxQscripts values(2,'QS_GetTopSQLTableInfo',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetTopSQLTableInfo -si @i_TopNRows=''TopNRows''
'
 + CHAR(10) + '-- 	script_name: GetTopSQLTableInfo.'
 + CHAR(10) + '-- 	returns Tables having highest number of records.'
)
GO

