

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetTimeDifferenceWithCS.sp] ---------- 

-------------------------------------------
--         Name:   QS_GetTimeDifferenceWithCS.sql
--         Date:   12-Dec-2012
--       Author:   SKatz
--  Description:   Get the time offset between client and commserver
--
-- TR(original):   None
--     Customer:   Cargill
--   CommcellId:   N/A (generic)
-------------------------------------------
-- TODO:  ADD OVERWRITE (VS UPDATE), NO WAIT FOR JOB RUNNING JOBS TO COMPLETE OPTIONS (hidden)
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetTimeDifferenceWithCS <<<'

IF EXISTS (select * from sysobjects where name='QS_GetTimeDifferenceWithCS')
	drop procedure QS_GetTimeDifferenceWithCS
IF EXISTS (select * from GxQscripts where name='QS_GetTimeDifferenceWithCS')
	delete from GxQscripts where name = 'QS_GetTimeDifferenceWithCS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetTimeDifferenceWithCS')
	delete from GXDBVersions where aliasname = 'QS_GetTimeDifferenceWithCS'
GO
print '... Creating Procedure: QS_GetTimeDifferenceWithCS'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_GetTimeDifferenceWithCS
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--  3 Corresponds to "medium", same as same functionality in GUI.  Macro doesn't expand right for some reason
-- Qscript Usage.
  @i_clientName NVARCHAR(1024) = N'%s',
  @i_csTime NVARCHAR(100) = N'%s',
  @i_otherClientName NVARCHAR(1024) = N'%s'
AS
SET NOCOUNT ON
--set @i_clientName = 'wvhcs-w2k05'
--set @i_csTime = GETDATE()
--set @i_otherClientName = 'samaki'
---- Convenience Definitions    -----------
DECLARE @scriptName             varchar(128) = 'GetTimeDifferenceWithCS'
DECLARE @NoParameter            varchar(10)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
-------- Local Variables    -------------
DECLARE @lastError              integer
DECLARE @localErrorMsg          varchar(512)
SET     @localErrorMsg          ='Error Encountered when running script.'
SET     @lastError              = 0     -- Be optimistic
DECLARE @clientId			INT
DECLARE @otherClientId		INT = 2	-- DEFAULT TO CS
DECLARE @getTime			INT = 0
DECLARE @nowTime			DATETIME = GETDATE()
DECLARE @nowUTCTime			DATETIME = GETUTCDATE()	--GET CURRENT UTC TIME
DECLARE @csUTCTime			DATETIME = dbo.ClientLocalToUTCTime(@nowTime, @otherClientId)	-- CONVERT CS TO UTC TIME
DECLARE @clientUTCTime		DATETIME
DECLARE @csTimeZoneName		NVARCHAR(1024) = ISNULL(dbo.GetClientTimeZone(@otherClientId), '')
DECLARE @clientTimeZoneName	NVARCHAR(1024)
	IF @i_clientName = @NoParameter
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = N'Error. Client name Expected as parameter 1.'
		GOTO ARGS_ERROR
	END
	IF @i_clientName = ''
	BEGIN
		SET @lastError = -1
		SET @localErrorMsg = N'Missing client name'
		GOTO ARGS_ERROR
	END
	IF @i_csTime = @NoParameter
	BEGIN
		SET @i_csTime = ''
	END
	--VALIDATE DATE
	IF @i_csTime <> '' AND @i_csTime <> '0'
	BEGIN
		IF ISDATE(@i_csTime) = 0
		BEGIN
			SET @lastError = -2
			SET @localErrorMsg = N'VAlue ['+@i_csTime+'] is not a valid time'
			GOTO ARGS_ERROR
		END
		SET @getTime = 1
	END
	SET @clientId = ISNULL((SELECT id FROM APP_Client WHERE name=@i_clientName), 0)
	IF @clientId = 0
	BEGIN
		SET @lastError = -3
		SET @localErrorMsg = 'Client ['+@i_clientName+'] is not found'
		GOTO ARGS_ERROR
	END
	SET @clientTimeZoneName = ISNULL(dbo.GetClientTimeZone(@clientId), '')
	IF @clientTimeZoneName = ''
	BEGIN
		SET @lastError = -4
		SET @localErrorMsg = 'Time zone for client ['+@i_clientName+'] is not found'
		GOTO ARGS_ERROR
	END
	IF @i_otherClientName <> @NoParameter
	BEGIN
		SET @otherClientId = ISNULL((SELECT id FROM APP_Client WHERE name=@i_otherClientName), 0)
		IF @otherClientId = 0
		BEGIN
			SET @lastError = -3
			SET @localErrorMsg = 'Client ['+@i_otherClientName+'] is not found'
			GOTO ARGS_ERROR
		END
	END
	SET @csUTCTime = dbo.UTCToClientLocalTime(@nowUTCTime, @otherClientId)
	SET @csTimeZoneName	= ISNULL(dbo.GetClientTimeZone(@otherClientId), '')
	SET @clientUTCTime = dbo.UTCToClientLocalTime(@nowUTCTime, @clientId)
	IF @getTime = 1
	BEGIN
		SELECT dbo.UTCToClientLocalTime(dbo.ClientLocalToUTCTime(@i_csTime, @otherClientId), @clientId) 'Client time'
	END
	ELSE
	BEGIN
		SELECT @clientTimeZoneName 'Client Timezone', @csTimeZoneName 'CS Timezone', dbo.GetUnixTime(@clientUTCTime) - dbo.GetUnixTime(@csUTCTime) 'Time offset (sec)'
	END
ARGS_ERROR:
PRINT ''
	PRINT @scriptName + N' completed at '
			 + Convert(varchar(60), getdate())
			 + N' with Parameters: [' + @i_clientName + N', ' + @i_csTime +
			 + N']. Exit Code(' +convert(varchar(8), @lastError) + N').'
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetTimeDifferenceWithCS')
	delete from GxQscripts where name = 'QS_GetTimeDifferenceWithCS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetTimeDifferenceWithCS')
	delete from GXDBVersions where aliasname = 'QS_GetTimeDifferenceWithCS'
GO

insert into GXDBVersions values(2, 'QS_GetTimeDifferenceWithCS',  '00000000000000000000', 'QS_GetTimeDifferenceWithCS', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetTimeDifferenceWithCS',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '		Script to get the time offset between client and commserver
'
 + CHAR(10) + '		--
'
 + CHAR(10) + '		operation execscript -sn GetTimeDifferenceWithCS -si ''ClientName'' [-si ''CS time''] [-si ''ClientName'']
'
 + CHAR(10) + '      	    
'
)
GO

