

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetSybaseJobList.sp] ---------- 

  -- ----------------------------------------------------------------------
  --
 --           Copyright (c) 1998  CommVault Systems, Inc.
 --                  All rights reserved.
 --
 --
 --        This is unpublished proprietary source code of CommVault
 --        Systems, Inc. The copyright notice above does not evidence
 --        any actual or intended publication of such source code.
 -- ----------------------------------------------------------------------*/
 --  +-----------------------------------------------------------------------+
 --  |           Stored Procedure: "GetSybSQLJobList"                           |
 --  |                                                                       |
 --  |-------------------------------------------------------------------------+
 -- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetSybaseJobList <<<'

IF EXISTS (select * from sysobjects where name='QS_GetSybaseJobList')
	drop procedure QS_GetSybaseJobList
IF EXISTS (select * from GxQscripts where name='QS_GetSybaseJobList')
	delete from GxQscripts where name = 'QS_GetSybaseJobList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSybaseJobList')
	delete from GXDBVersions where aliasname = 'QS_GetSybaseJobList'
GO
print '... Creating Procedure: QS_GetSybaseJobList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetSybaseJobList
 -- Qscript is Enabled
 -- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
 -- Qscript Usage. Do not use special char in HTML
-- Match the data type ( and length of characters) of clientName, instancename and databasename with corresponding tables
  @i_clientName nvarchar(510) = N'', 
  @i_instanceName nvarchar(1024) = N'',
  @i_startTime varchar(256) = '0',
  @i_endTime varchar(256) = '0',
  @i_databaseName nvarchar(64) = N'',
  @i_noTimeRestriction integer = 0,
  @i_enableDateTimeFormat integer = 0
AS
set nocount on
BEGIN TRY
  DECLARE @ClientID INT = -1
  DECLARE @InstanceID INT = -1
  DECLARE @u_startTime BIGINT
  DECLARE @u_endTime BIGINT
  DECLARE @ErrorNumber INTEGER
  DECLARE @ErrorMessage NVARCHAR(MAX)
  DECLARE @DateDifference INT
  DECLARE @CustomError varchar(max) = N''
  DECLARE @SybPageSize INT = 1
  DECLARE @TimeZone varchar(max) = ''
IF @i_clientName = N''
BEGIN
SET @CustomError = 'Client Name is empty. Please provide valid Client Name'
GOTO SKIP_END
END
IF @i_instanceName = N''
BEGIN
SET @CustomError = 'Instance Name is empty. Please provide valid Instance Name'
GOTO SKIP_END
END
IF ISDATE(@i_startTime) <> 1
BEGIN
SET @CustomError = 'Invalid Start time. Please provide valid time MM-DD-YYYY  hh:mm:ss'
GOTO SKIP_END
END
IF ISDATE(@i_endTime) <> 1
BEGIN
SET @CustomError = 'Invalid End time. Please provide valid time MM-DD-YYYY  hh:mm:ss'
GOTO SKIP_END
END
IF CAST(@i_startTime AS DATETIME) > CAST(@i_endTime AS DATETIME)
BEGIN
SET @CustomError = 'Error, end time must be greater than the start time'
GOTO SKIP_END
END
IF @i_noTimeRestriction = 0
BEGIN
IF DATEDIFF(DAY,@i_startTime , @i_endTime ) > 14
BEGIN
SET @CustomError = 'Difference between Start and End date cannot be more than 14 day. To bypass this constraint set @i_noTimeRestriction to 1'
GOTO SKIP_END
END
END
select @ClientID = id from app_client where name = @i_clientName and status = 0
IF @ClientID = -1
BEGIN
SET @CustomError = 'Client Name does not exist. Please provide valid Client Name'
GOTO SKIP_END
END
SET @TimeZone = dbo.GetClientTimeZone(@ClientID)
IF ISNULL(@TimeZone,'TRUE') = 'TRUE'
BEGIN
SET @TimeZone = 'Greenwich Mean Time'
END
select distinct @InstanceID = id from app_instancename where id in
(
	select distinct instance from app_application where
	clientid = @ClientID and
	appTypeId = 5 and
	subclientStatus & 2 <> 2 and
	subclientStatus & 4 <> 4 and
	subclientStatus & 16 <> 16 and
	subclientStatus & 32 <> 32
)
and name = @i_instanceName
IF @InstanceID = -1
BEGIN
SET @CustomError = 'Instance Name does not exist. Please provide valid Instance Name'
GOTO SKIP_END
END
--Get Sybase Page Size
SET @SybPageSize = CAST( (SELECT TOP(1) attrVal from APP_InstanceProp where componentNameId = @InstanceID AND attrName = 'SYBASE page size' and modified = 0) as INT )
IF @SybPageSize <= 0
BEGIN
SET @CustomError = 'ERROR : Unable to fetch Sybase Page Size from Instance properties'
GOTO SKIP_END
END
SET @i_endTime = RTRIM(LTRIM(@i_endTime))
SET @i_startTime = RTRIM(LTRIM(@i_startTime))
SET @u_startTime = dbo.GetUnixTime(dbo.LocalToUTCTime(@i_startTime, @TimeZone))
SET @u_endTime = dbo.GetUnixTime(dbo.LocalToUTCTime(@i_endTime, @TimeZone))
IF object_id('tempdb.dbo.#SybSQLJobs') is not null DROP TABLE #SybSQLJobs
CREATE TABLE #SybSQLJobs
(
	jobid int,
	DatabaseId int,
	DatabaseName nvarchar(max),
	BackupLeveL varchar(16),
	backup_start_time bigint,
	backup_end_time bigint,
	logicalDeviceName varchar(max),
	physicalDevicePath varchar(max),
	DBSize_in_MB bigint
)
IF object_id('tempdb.dbo.#SybJobList') is not null DROP TABLE #SybJobList
CREATE TABLE #SybJobList
(
	jobid int,
	commCellID int
	PRIMARY KEY (jobid, commCellID)
)
IF object_id('tempdb.dbo.#SybSelectedJobs') is not null DROP TABLE #SybSelectedJobs
CREATE TABLE #SybSelectedJobs
(
	jobid int,
	commCellID int,
	bkpLevel int,
	backupStartTime bigint,
	backupEndTIme bigint
	PRIMARY KEY (jobid, commCellID)
)
IF object_id('tempdb.dbo.#SybIncrJobList') is not null DROP TABLE #SybIncrJobList
CREATE TABLE #SybIncrJobList
(
	jobid int,
    commCellID int,
    archFileId bigint,
	backup_start_time bigint,
	backup_end_time bigint,
	bkpLevel int
	PRIMARY KEY (commCellID , archFileId)
)
BEGIN
	--Create temp table #SybJobList with distinct JobID, CCID
	INSERT INTO #SybJobList
		SELECT DISTINCT sybSysDev.sybBackupJobId_l as jobid, sybSysDev.commCellId as commCellID
		FROM sybSystemDevices sybSysDev WITH(NOLOCK)
		WHERE sybSysDev.sybInstanceId = @InstanceID
		AND (@i_databaseName = '' OR sybSysDev.sybDatabaseName = @i_databaseName)
	--Use #SybJobList to filter jobs within Start and End Time
	INSERT INTO #SybSelectedJobs
		SELECT sybjobList.jobid , sybjobList.commCellID, bkpStats.bkpLevel , bkpStats.servStartDate, bkpStats.servEndDate
		FROM #SybJobList as sybjobList , JMBkpStats as bkpStats WITH(NOLOCK)
		WHERE
		bkpStats.dataStatus = 0 -- IGNORE Aged/Pruned/Invalid entries
		AND sybjobList.jobid = bkpStats.jobId
		AND sybjobList.commCellID = bkpStats.commCellId
		AND bkpStats.servStartDate >= @u_startTime
		AND bkpStats.servStartDate <= @u_endTime
	INSERT INTO #SybSQLJobs
		SELECT sybSysDev.sybBackupJobId_l as JOBID, sybSysDev.sybDatabaseId as DatabaseId ,
						sybSysDev.sybDatabaseName as DatabaseName,
						'FULL' as  BackupLevel , sybSelJobs.backupStartTime as backup_start_time, sybSelJobs.backupEndTime as backup_end_time, sybSysDev.sybDevLogicalName as logicalDeviceName, sybSysDev.sybDevPhyName as physicalDevicePath,
						 ((SELECT SUM( CAST(sybSysVsize AS BIGINT) ) from sybSystemUsages where sybDevid = sybSysDev.id ) * @SybPageSize)/ (1024 * 1024) as DBSize_in_MB
		FROM sybSystemDevices sybSysDev WITH(NOLOCK), #SybSelectedJobs sybSelJobs
		WHERE
		sybSysDev.sybInstanceId = @InstanceID
		AND sybSysDev.sybBackupJobId_h = 0
		AND sybSelJobs.jobId = sybSysDev.sybBackupJobId_l
		AND sybSelJobs.commCellId = sybSysDev.commCellId
		AND (@i_databaseName = '' OR sybSysDev.sybDatabaseName = @i_databaseName)
	INSERT INTO #SybIncrJobList
	       SELECT DISTINCT bkpStats.jobId as jobId, bkpStats.commCellId as commCellId, arch.id as archFileId, bkpStats.servStartDate as backup_start_time ,
                                         bkpStats.servEndDate as backup_end_time , bkpStats.bkpLevel as bkpLevel
               FROM APP_Application app , JMBkpStats bkpStats, archFile arch
               WHERE
               app.instance = @InstanceID
			   AND bkpStats.jobId = arch.jobId
			   AND bkpStats.commCellId = arch.CommCellId
               AND bkpStats.appId = app.id
               AND bkpStats.servStartDate >= @u_startTime
               AND bkpStats.servStartDate <= @u_endTime
			   AND (bkpStats.bkpLevel = 2 OR bkpStats.bkpLevel = 256 OR bkpStats.bkpLevel = 4)-- Only INCR , DIFF Jobs
               AND arch.fileType != 1
    INSERT INTO #SybSQLJobs
            SELECT DISTINCT sybIncrJobList.jobId as jobid, sybArchFile.sybDatabaseId as DatabaseId,
                                               sybArchFile.sybDatabaseName as DatabaseName,
                                               (CASE sybIncrJobList.bkpLevel
													when 2 then 'INCR'
													when 256 then 'INCR'
													when 4 then 'DIFF'
													else 'UNKNOWN'
												end) BackupLevel , sybIncrJobList.backup_start_time as backup_start_time,
                                               sybIncrJobList.backup_end_time as backup_end_time,
                                               'N/A' as logicalDeviceName, 'N/A' as physicalDevicePath, -1 as DBSize_in_MB
              FROM #SybIncrJobList as sybIncrJobList , sybArchFileInfo as sybArchFile
              WHERE
              sybIncrJobList.archFileId = sybArchFile.archFileId
			  AND sybIncrJobList.commCellID = sybArchFile.commCellId
			  AND (@i_databaseName = '' OR sybArchFile.sybDatabaseName = @i_databaseName)
END
--OUTPUT--
BEGIN
IF @i_enableDateTimeFormat = 1
BEGIN
SELECT jobid, DatabaseId, DatabaseName, BackupLevel, dbo.UTCToClientLocalTime(dbo.GetDateTime(backup_start_time),@ClientID) as backup_start_time,
		 dbo.UTCToClientLocalTime(dbo.GetDateTime(backup_end_time),@ClientID) as backup_end_time, logicalDeviceName, physicalDevicePath, (CASE DBSize_in_MB
																																			WHEN -1 THEN 'N/A'
																																			ELSE CONVERT(VARCHAR(20),DBSize_in_MB) end) DBSize_in_MB FROM #SybSQLJobs ORDER BY backup_start_time
END
ELSE
BEGIN
SELECT jobid, DatabaseId, DatabaseName, BackupLevel, backup_start_time, backup_end_time, logicalDeviceName, physicalDevicePath, (CASE DBSize_in_MB
																																			WHEN -1 THEN 'N/A'
																																			ELSE CONVERT(VARCHAR(20),DBSize_in_MB) end) DBSize_in_MB FROM #SybSQLJobs ORDER BY backup_start_time
END
END
SKIP_END:
IF object_id('tempdb.dbo.#SybSQLJobs') is not null DROP TABLE #SybSQLJobs
IF object_id('tempdb.dbo.#SybJobList') is not null DROP TABLE #SybJobList
IF object_id('tempdb.dbo.#SybSelectedJobs') is not null DROP TABLE #SybSelectedJobs
IF object_id('tempdb.dbo.#SybIncrJobList') is not null DROP TABLE #SybIncrJobList
IF @CustomError <> N''
SELECT @CustomError
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SELECT @ErrorNumber = ERROR_NUMBER(), @ErrorMessage = ERROR_MESSAGE();
PRINT N'Error occured. ErrorNo(' + CAST(@ErrorNumber AS NVARCHAR(10)) + N') ErrorMsg(' + @ErrorMessage + N').'
END CATCH;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetSybaseJobList')
	delete from GxQscripts where name = 'QS_GetSybaseJobList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSybaseJobList')
	delete from GXDBVersions where aliasname = 'QS_GetSybaseJobList'
GO

insert into GXDBVersions values(2, 'QS_GetSybaseJobList',  '00000000000000000000', 'QS_GetSybaseJobList', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetSybaseJobList',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '    qoperation execscript -sn QS_GetSybaseJobList -si @i_clientName = ''clientname'' -si @i_instanceName=''instanceName'' -si @i_startTime = ''starttime'' -si @i_endTime = ''endtime''  -si @i_databaseName = ''dbname'' @i_noTimeRestriction = ''0 or 1''
'
 + CHAR(10) + '--   script_name: QS_GetSybaseJobList.'
 + CHAR(10) + '--   returns job list and details.'
)
GO

