

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetSubclientConf.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetSubclientConf <<<'

IF EXISTS (select * from sysobjects where name='QS_GetSubclientConf')
	drop procedure QS_GetSubclientConf
IF EXISTS (select * from GxQscripts where name='QS_GetSubclientConf')
	delete from GxQscripts where name = 'QS_GetSubclientConf'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSubclientConf')
	delete from GXDBVersions where aliasname = 'QS_GetSubclientConf'
GO
print '... Creating Procedure: QS_GetSubclientConf'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetSubclientConf
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 varchar(1024) = '%s',
  @PARAM2 varchar(1024) = '%s',
  @PARAM3 varchar(1024) = '%s',
  @PARAM4 varchar(1024) = '%s',
  @PARAM5 varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @PARAM1	varchar(1024)
--SET		@PARAM1 = '%s'
--DECLARE @PARAM2 varchar(1024)
--SET		@PARAM2	= '%s'
--DECLARE @PARAM3 varchar(1024)
--SET		@PARAM3 = '%s'
--DECLARE @PARAM4 varchar(1024)
--SET		@PARAM4 = '%s'
--DECLARE @PARAM5 varchar(1024)
--SET		@PARAM5 = '%s'
---------------------------------------
--test
--SET		@PARAM1= 'c=bingo'
--SET		@PARAM2= 'a=Q_WINNET_FS'
--SET		@PARAM3= 'b=defaultbackupset'
--SET		@PARAM4= 's=default'
---------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'GetSubclientConf'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
--------------------- Get ids --------------
DECLARE @ClientId int
DECLARE @AppTypeId int
DECLARE @InstanceId int
DECLARE @BackupsetId int
DECLARE @subclientId int
if  OBJECTPROPERTY(object_id(N'[dbo].[QscriptGetAppIdsFromNames]'), N'IsProcedure') IS NULL
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'This script requires Stored procedure QscriptGetAppIdsFromNames to be installed. Please install it and try again.'
	GOTO ARGS_ERROR
END
EXECUTE @lastError = QscriptGetAppIdsFromNames @PARAM1, @PARAM2, @PARAM3, @PARAM4, @PARAM5,
	@subclientId OUTPUT, @BackupsetId OUTPUT, @InstanceId OUTPUT, @AppTypeId OUTPUT, @ClientId OUTPUT,
    @localErrorMsg OUTPUT
IF @lastError != 0
BEGIN
	GOTO ARGS_ERROR
END
IF @PARAM1 = '%s'
SET @PARAM1 = ''
IF @PARAM2 = '%s'
SET @PARAM2 = ''
IF @PARAM3 = '%s'
SET @PARAM3 = ''
IF @PARAM4 = '%s'
SET @PARAM4 = ''
IF @PARAM5 = '%s'
SET @PARAM5 = ''
--Get Global filter settings first
DECLARE @GlobalFilterState varchar(32)
DECLARE @propName1 varchar(50)
SET @propName1 = 'use cs setting for Global Filters'
DECLARE @propName2 varchar(32)
SET @propName2 = 'Use Global Filters'
DECLARE @scpid integer
SET @scpid = ISNULL((select attrval from app_backupsetprop where attrname like 'Associated subclient Policy'
   and componentnameid = @backupsetid and modified = 0),0)
DECLARE @useSCPfilters integer
if @scpid >0
begin
	SET @useSCPfilters = ISNULL((select attrval from app_subclientprop where attrname like 'use SCP filters' AND componentNameId = @subclientId and modified = 0), 0)
end
IF @useSCPfilters <> 0
	SET @GlobalFilterState = 'NOT APPLICABLE (SUBCLIENT POLICY)'
ELSE IF @AppTypeId NOT IN (1,11,12,17,18,19,20,21,28,29,36,33,34,36,38,42,43, 54,56,57,58, 63,64,74,86, 105,106)
	SET @GlobalFilterState = 'NOT APPLICABLE'
ELSE IF (ISNULL(( SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND modified =0 and attrName = @propName1), '1')= '0')
BEGIN
	IF(ISNULL((SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND modified =0 and attrName = @propName2), '0') = '1')
		SET @GlobalFilterState = 'ON'
	ELSE
		SET @GlobalFilterState = 'OFF'
END
ELSE
	SET @GlobalFilterState = 'USE CELL LEVEL POLICY'
--Get schedulePolicy
SELECT
	(CASE(FC.type)
		WHEN 1 THEN 'Content'
		WHEN 2 THEN 'Except'
		WHEN 3 THEN 'Exclude'
		WHEN 4 THEN 'Except file'
		WHEN 5 THEN 'Exclude file'
		ELSE 'Unknown'
	END) AS Property, FC.filename AS Value
	FROM APP_ScFilterFile FC
	JOIN APP_Application AP ON AP.id=FC.componentNameId AND FC.modified=0
	WHERE AP.id=@subclientId
UNION
SELECT 'Global Filters',  @GlobalFilterState
UNION
SELECT 'Schedule Policy ', T.taskName
	FROM TM_Task T (NOLOCK)
	JOIN TM_AssocEntity E (NOLOCK) ON E.taskId = T.taskId AND T.taskType = 4 AND E.exclude = 0
	WHERE
	(
		(
			E.clientId = @ClientId AND E.apptypeId = 0 AND E.instanceId = 0 AND E.backupsetId = 0 AND E.subclientId = 0
		)
		OR
		(
			E.clientId = @ClientId AND E.apptypeId = @AppTypeId AND E.instanceId = 0 AND E.backupsetId = 0 AND E.subclientId = 0
		)
		OR
		(
			E.clientId = @ClientId AND E.apptypeId = @AppTypeId AND E.instanceId = @InstanceId AND E.backupsetId = 0 AND E.subclientId = 0
		)
		OR
		(
			E.clientId = @ClientId AND E.apptypeId = @AppTypeId AND E.instanceId = @InstanceId AND E.backupsetId = @BackupsetId AND E.subclientId = 0
		)
		OR
		(
			E.clientId = @ClientId AND E.apptypeId = @AppTypeId AND E.instanceId = @InstanceId AND E.backupsetId = @BackupsetId AND E.subclientId = @subclientId
		)
		OR
		(
			E.clientGroupId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc (NOLOCK) WHERE clientId = @ClientId) AND E.clientId = 0 AND E.apptypeId = 0 AND E.instanceId = 0 AND E.backupsetId = 0 AND E.subclientId = 0
		)
		OR
		(
			E.assocType = 2
		)
	)
	AND NOT EXISTS
	(
		SELECT 1 FROM TM_AssocEntity AE WHERE
		(
			AE.clientId=@ClientId
			AND ( AE.apptypeId=@AppTypeId OR AE.apptypeId=0)
			AND (AE.instanceId=@InstanceId OR AE.instanceId=0)
			AND (AE.backupsetId=@BackupsetId OR AE.backupsetId=0)
			AND (AE.subclientId=@subclientId OR AE.subclientId=0)
			AND AE.exclude = 1
			AND AE.taskId = E.taskId
		)
	)
	AND
	(	--CHECK FOR AGENT TYPE
		(
			EXISTS ( SELECT taskId
						FROM [TM_AssocFilter] WITH (NOLOCK)
						WHERE taskId = T.taskId
					)
			AND
			EXISTS
			( SELECT taskId
				FROM [TM_AssocFilter] FLT WITH (NOLOCK)
				WHERE FLT.taskId = T.taskId
				AND
				(  -- filter_type, 1 is appgroup and 2 is individual apptype
					(
						FLT.filter_type = 2
						AND
						(
							FLT.filter_value = @appTypeId
							OR
							( @appTypeId = 0 AND FLT.filter_value IN (SELECT appTypeId FROM APP_Application WITH (NOLOCK) WHERE clientId=@clientId) )
						)
					)
					OR
					(
						FLT.filter_type = 1
						AND EXISTS
						(
							SELECT FLT.filter_value
							FROM [APP_AppTypeGroupAssoc] WITH (NOLOCK)
							WHERE appGroupId = FLT.filter_value
							AND
							(
								appTypeId = @appTypeId
								OR
								( @appTypeId = 0 AND appTypeId IN (SELECT appTypeId FROM APP_Application WITH (NOLOCK) WHERE clientId=@clientId) )
							)
						)
					)
				)
			)
			OR
			NOT EXISTS ( SELECT taskId
						FROM [TM_AssocFilter] WITH (NOLOCK)
						WHERE taskId = T.taskId
					)
		)
	)
--MSSQL Database files
UNION
SELECT 'SQL Database', SCP.attrName
	FROM APP_SubClientProp SCP
	WHERE SCP.attrType='118'
	AND SCP.modified='0'
	AND SCP.componentNameId = @subclientId
ARGS_ERROR:
/*PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@PARAM1+', '+@PARAM2+', '+@PARAM3+', '+@PARAM4+
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'*/
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetSubclientConf')
	delete from GxQscripts where name = 'QS_GetSubclientConf'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSubclientConf')
	delete from GXDBVersions where aliasname = 'QS_GetSubclientConf'
GO

insert into GXDBVersions values(2, 'QS_GetSubclientConf',  '00000000000000000000', 'QS_GetSubclientConf', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetSubclientConf',  0, GETDATE(), GETDATE(), '' + CHAR(10) + ' qoperation execscript -sn GetSubclientConf.sql -si c=client_name -si a=app_type_name [-si i=instance_name] [-si b=backupset_name] -si s=subclient_name
'
 + CHAR(10) + ' 
'
 + CHAR(10) + ' app_type_name is the argument value for the agent, for example, Q_ORACLE. For a full list of agent argument values, see thedocumentation for Command Line.
'
 + CHAR(10) + ' 
'
 + CHAR(10) + ' Example
'
 + CHAR(10) + ' qoperation execscript -sn GetSubclientConf.sql -si c=desktop -si a=Q_WINDOWS_FS -si s=default
'
 + CHAR(10) + ' 
'
 + CHAR(10) + ' Qscript Output:
'
 + CHAR(10) + ' Client [desktop], iDA [Q_WINDOWS_FS], Instance [], Backupset [], Subclient [default].
'
 + CHAR(10) + ' Property Value
'
 + CHAR(10) + ' Content C:\documents
'
 + CHAR(10) + ' Global Filters ON
'
 + CHAR(10) + ' Schedule Policy standard_policy_001
'
 + CHAR(10) + ' 
'
 + CHAR(10) + '--   script_name : GetSubclientConf'
)
GO

