

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetSubClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_GetSubclients')
BEGIN
	print '>>> Drop Stored Procedure: QS_GetSubclients <<<'
	drop procedure QS_GetSubclients
END
IF EXISTS (select * from GxQscripts where name='QS_GetSubclients')
	delete from GxQscripts where name = 'QS_GetSubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSubclients')
	delete from GXDBVersions where aliasname = 'QS_GetSubclients'
GO
print '... Creating Procedure: QS_GetSubclients'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetSubclients
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT
-------------------------------------------
--DECLARE @clientName varchar(1024)
--SET @clientName = '%s'
-----------------------------------------
--SET @clientName = 'oscar'
-----------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'GetSubclients'
DECLARE	@NoParameter			varchar(10)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
---- Validate inputs   -----------
if(@clientName is NULL)
BEGIN
	SET @localErrorMsg = 'Error.  Client Name [' + @clientName + '] could not be found.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF @clientName = @NoParameter
BEGIN
	SET @localErrorMsg = 'Error.  Client Name was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
DECLARE @clientId int
SET @clientId = ISNULL((select C.Id from APP_Client C where C.name = @clientName), 0)
if(@clientId = 0)
BEGIN
	SET @localErrorMsg = 'Error.  Client ['+ @clientName + '] Does not exist.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--7.0 Get description from APP_Client clientDescription
--8.0 Get description from APP_SubclientProp
-------- Get subclients   -----------
SELECT APP.id, APP.subclientName, IDA.name as iDA, ISNULL(PROP.attrVal, '') as Description
FROM APP_Application APP
LEFT JOIN APP_Client CLI ON APP.clientId = CLI.id
LEFT JOIN APP_iDAType IDA ON APP.appTypeId=IDA.type
LEFT JOIN APP_SubclientProp PROP ON PROP.ComponentNameId = APP.id AND PROP.attrName = N'User Description'
WHERE APP.subclientStatus & 2 <> 2 and APP.subclientStatus & 4 <> 4 and APP.subclientStatus & 16 <> 16 and APP.subclientStatus & 32 <> 32
AND CLI.name = @clientName  AND APP.apptypeid <1000
--select * from app_application where clientid = @clientId
--CV_STATUS_UNINSTALLED		0x0002
--CV_STATUS_DELETED			0x0004
--CV_STATUS_DEFAULT			0x0008
--CV_STATUS_DUMMY			0x0010
--CV_STATUS_HIDDEN			0x0020
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetSubClients')
	delete from GxQscripts where name = 'QS_GetSubClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSubClients')
	delete from GXDBVersions where aliasname = 'QS_GetSubClients'
GO

insert into GXDBVersions values(2, 'QS_GetSubClients',  '00000000000000000000', 'QS_GetSubClients', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetSubClients',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetSubclients.sql -si client_name
'
 + CHAR(10) + '--   script_name : GetSubclients'
)
GO

