

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetSubClientPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_GetSubclientPolicy')
BEGIN
	print '>>> Drop Stored Procedure: QS_GetSubclientPolicy <<<'
	drop procedure QS_GetSubclientPolicy
END
IF EXISTS (select * from GxQscripts where name='QS_GetSubclientPolicy')
	delete from GxQscripts where name = 'QS_GetSubclientPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSubclientPolicy')
	delete from GXDBVersions where aliasname = 'QS_GetSubclientPolicy'
GO
print '... Creating Procedure: QS_GetSubclientPolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetSubclientPolicy
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @param1 varchar(1030) = '%s'
AS
SET NOCOUNT ON
---------------command line inputs--------------------
--DECLARE @param1  NVARCHAR(1030)
--SET @param1 = '%s'
------------------input prefixes-------------------------
DECLARE @clientPrefix  NVARCHAR(32)
SET @clientPrefix = 'c='
DECLARE @scPolicyPrefix NVARCHAR(32)
SET @scPolicyPrefix = 'scp='
---------------------------Sample Input------------------------
--SET @param1 = 'c=kubica_cn'
--SET @param1 = 'scp=SCP2'
---------------------------------------------------------
----------------------script Name-------------------------
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = 'GetSubclientPolicy'
-----------------------error handling-----------------
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
---------------insufficient parameters --------------------------------
DECLARE @noParameter NVARCHAR(32)
SET @noParameter = '%'
SET @noParameter = @noParameter + 's'
IF @param1 = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Please provide client name or subclient policy name as input.'
	GOTO ARGS_ERROR
END
-----------------------invalid parameters------------------------------
DECLARE @clientName NVARCHAR(1024)
SET @clientName = ''
DECLARE @subclientPolicyName NVARCHAR(1024)
SET @subclientPolicyName = ''
IF SUBSTRING(@param1, 1, 2) = @clientPrefix
	SET @clientName =  SUBSTRING(@param1, 3, LEN(@param1)-2)
ELSE IF SUBSTRING(@param1, 1, 4) = @scPolicyPrefix
	SET @subclientPolicyName =  SUBSTRING(@param1, 5, LEN(@param1)-4)
ELSE
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Invalid input ['+@param1+']'
	GOTO ARGS_ERROR
END
IF @clientName = '' AND @subclientPolicyName = ''
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Invalid input ['+@param1+']. Please provide client name or subclient policy name as input.'
	GOTO ARGS_ERROR
END
-----------------------invalid parameters II------------------------------
DECLARE @clientId integer
SET @clientId = ISNULL((SELECT id FROM app_client WHERE name = @clientName), 0)
DECLARE @subclientPolicyId integer
SET @subclientPolicyId = ISNULL((SELECT DISTINCT B.id FROM APP_BackupSetName B INNER JOIN APP_Application A ON A.backupSet = B.id WHERE B.name = @subclientPolicyName AND A.appTypeId = 1030), 0)
IF @clientName <> '' AND @clientId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client ['+ @clientName +'] does not exist.'
	GOTO ARGS_ERROR
END
IF @subclientPolicyName <> '' AND @subclientPolicyId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. SubclientPolicy ['+ @subclientPolicyName +'] does not exist.'
	GOTO ARGS_ERROR
END
-----------------		Create a temporary table with clientId, backupsetId, subclientPolicyId triplet  ------------------------
IF object_id('tempdb.dbo.#SubclientPolicyId_Tbl') is not null
DROP TABLE #SubclientPolicyId_Tbl
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'SubclientPolicyId_Tbl')
	DROP TABLE #SubclientPolicyId_Tbl
CREATE TABLE #SubclientPolicyId_Tbl
	(clientId INT,clientName varchar(255), backupsetId INT,backupsetName varchar(255), subclientPolicyId INT)
INSERT INTO #SubclientPolicyId_Tbl(clientId, clientName, backupsetId, backupsetName, subclientPolicyId)
(
	SELECT DISTINCT C.id, C.name, BSP.componentNameId, B.name, BSP.attrVal
	FROM APP_Client C,APP_BackupSetProp BSP
	INNER JOIN APP_BackupSetName B ON BSP.componentNameId = B.id
	INNER JOIN APP_Application A ON A.backupSet = B.id
	WHERE BSP.attrName = 'Associated subclient Policy' and BSP.modified =0
	AND C.id = A.clientId
	AND BSP.attrVal >0							-- Positive attrval
	AND (A.subclientStatus & 0x4) <> 0x4		--Not deleted
)
--select * from #SubclientPolicyId_Tbl
------------------------get clients/client groups------------------------
IF @clientId > 0
	SELECT DISTINCT P.backupsetName AS 'BackupsetName',B.name as 'SubclientPolicyName'
	FROM #SubclientPolicyId_Tbl P INNER JOIN APP_BackupSetName B  ON P.subclientPolicyId = B.id
	INNER JOIN APP_Application A ON A.backupSet = P.subclientPolicyId
	WHERE P.clientId = @clientId
	AND A.appTypeId = 1030
ELSE IF @subclientPolicyId > 0
	SELECT DISTINCT P.clientName as 'ClientName',P.backupsetName AS 'BackupsetName'
	FROM #SubclientPolicyId_Tbl P INNER JOIN APP_Application A ON P.subclientPolicyId = A.backupSet
	WHERE P.subclientPolicyId = @subclientPolicyId
	AND A.appTypeId = 1030
--DROP TABLE #SubclientPolicyId_Tbl
ARGS_ERROR:
print @scriptName + 'completed at '	+ Convert(varchar(60), getdate())+' with parameters client 	['+ @clientName +'] or subclientPolicy ['+ @subclientPolicyName +']. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetSubClientPolicy')
	delete from GxQscripts where name = 'QS_GetSubClientPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSubClientPolicy')
	delete from GXDBVersions where aliasname = 'QS_GetSubClientPolicy'
GO

insert into GXDBVersions values(2, 'QS_GetSubClientPolicy',  '00000000000000000000', 'QS_GetSubClientPolicy', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetSubClientPolicy',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetSubclientPolicy.sql -si scp=subclient_policy_name/c=client_name
'
 + CHAR(10) + '--   script_name : GetSubclientPolicy'
)
GO

