

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetSchedulePolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetSchedulePolicy <<<'

IF EXISTS (select * from sysobjects where name='QS_GetSchedulePolicy')
	drop procedure QS_GetSchedulePolicy
IF EXISTS (select * from GxQscripts where name='QS_GetSchedulePolicy')
	delete from GxQscripts where name = 'QS_GetSchedulePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSchedulePolicy')
	delete from GXDBVersions where aliasname = 'QS_GetSchedulePolicy'
GO
print '... Creating Procedure: QS_GetSchedulePolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetSchedulePolicy
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 varchar(1024) = '%s',
  @PARAM2 varchar(1024) = '%s',
  @PARAM3 varchar(1024) = '%s',
  @PARAM4 varchar(1024) = '%s',
  @PARAM5 varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @PARAM1	varchar(1024)
--SET		@PARAM1 = '%s'
--DECLARE @PARAM2 varchar(1024)
--SET		@PARAM2	= '%s'
--DECLARE @PARAM3 varchar(1024)
--SET		@PARAM3 = '%s'
--DECLARE @PARAM4 varchar(1024)
--SET		@PARAM4 = '%s'
--DECLARE @PARAM5 varchar(1024)
--SET		@PARAM5 = '%s'
---------------------------------------
--test
--SET		@PARAM1= 'c=iida7w2k8_cn'
--SET		@PARAM2= 'a=Q_WINXP32_FS'
--SET		@PARAM3= 'b=defaultbackupset'
--SET		@PARAM4= 's=default'
---------------------------------------
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'GetSchedulePolicy'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @nowTime	integer
SET     @nowTime	= dbo.GetUnixTime (GetUTCdate())
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
------------ Get ids    -----------
DECLARE @ClientId int
DECLARE @AppTypeId int
DECLARE @InstanceId int
DECLARE @BackupsetId int
DECLARE @subclientId int
if  OBJECTPROPERTY(object_id(N'[dbo].[QscriptGetAppIdsFromNames]'), N'IsProcedure') IS NULL
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'This script requires Stored procedure QscriptGetAppIdsFromNames to be installed. Please install it and try again.'
	GOTO ARGS_ERROR
END
EXECUTE @lastError = QscriptGetAppIdsFromNames  @PARAM1, @PARAM2, @PARAM3, @PARAM4, @PARAM5,
	@subclientId OUTPUT, @BackupsetId OUTPUT, @InstanceId OUTPUT, @AppTypeId OUTPUT, @ClientId OUTPUT,
    @localErrorMsg OUTPUT
IF @lastError != 0
BEGIN
	GOTO ARGS_ERROR
END
IF @PARAM1 = '%s'
SET @PARAM1 = ''
IF @PARAM2 = '%s'
SET @PARAM2 = ''
IF @PARAM3 = '%s'
SET @PARAM3 = ''
IF @PARAM4 = '%s'
 SET @PARAM4 = ''
IF @PARAM5 = '%s'
SET @PARAM5 = ''
------------ Get schedule policy   -----------  QUERY FROM QS_GetSubclientConf.sp
SELECT T.taskName as SchedulePolicy, ST.subTaskName as ScheduleName, PT.description  as Details, T.description as Description
FROM TM_Task AS T
INNER JOIN TM_SubTask AS ST ON ST.taskId=T.taskId
INNER JOIN TM_PatternAssoc AS PA ON PA.subTaskId=ST.subTaskId
INNER JOIN TM_Pattern AS PT ON PT.patternId=PA.patternId
JOIN TM_AssocEntity E (NOLOCK) ON E.taskId = T.taskId AND T.taskType = 4 AND E.exclude = 0
	WHERE
	(
		(
			E.clientId = @ClientId AND E.apptypeId = 0 AND E.instanceId = 0 AND E.backupsetId = 0 AND E.subclientId = 0
		)
		OR
		(
			E.clientId = @ClientId AND E.apptypeId = @AppTypeId AND E.instanceId = 0 AND E.backupsetId = 0 AND E.subclientId = 0
		)
		OR
		(
			E.clientId = @ClientId AND E.apptypeId = @AppTypeId AND E.instanceId = @InstanceId AND E.backupsetId = 0 AND E.subclientId = 0
		)
		OR
		(
			E.clientId = @ClientId AND E.apptypeId = @AppTypeId AND E.instanceId = @InstanceId AND E.backupsetId = @BackupsetId AND E.subclientId = 0
		)
		OR
		(
			E.clientId = @ClientId AND E.apptypeId = @AppTypeId AND E.instanceId = @InstanceId AND E.backupsetId = @BackupsetId AND E.subclientId = @subclientId
		)
		OR
		(
			E.clientGroupId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc (NOLOCK) WHERE clientId = @ClientId) AND E.clientId = 0 AND E.apptypeId = 0 AND E.instanceId = 0 AND E.backupsetId = 0 AND E.subclientId = 0
		)
		OR
		(
			E.assocType = 2
		)
	)
	AND NOT EXISTS
	(
		SELECT 1 FROM TM_AssocEntity AE WHERE
		(
			AE.clientId=@ClientId
			AND ( AE.apptypeId=@AppTypeId OR AE.apptypeId=0)
			AND (AE.instanceId=@InstanceId OR AE.instanceId=0)
			AND (AE.backupsetId=@BackupsetId OR AE.backupsetId=0)
			AND (AE.subclientId=@subclientId OR AE.subclientId=0)
			AND AE.exclude = 1
			AND AE.taskId = E.taskId
		)
	)
	AND
	(	--CHECK FOR AGENT TYPE
		(
			EXISTS ( SELECT taskId
						FROM [TM_AssocFilter] WITH (NOLOCK)
						WHERE taskId = T.taskId
					)
			AND
			EXISTS
			( SELECT taskId
				FROM [TM_AssocFilter] FLT WITH (NOLOCK)
				WHERE FLT.taskId = T.taskId
				AND
				(	-- filter_type, 1 is appgroup and 2 is individual apptype
					(
						FLT.filter_type = 2
						AND
						(
							FLT.filter_value = @appTypeId
							OR
							( @appTypeId = 0 AND FLT.filter_value IN (SELECT appTypeId FROM APP_Application WITH (NOLOCK) WHERE clientId=@clientId) )
						)
					)
					OR
					(
						FLT.filter_type = 1
						AND EXISTS
						(
							SELECT FLT.filter_value
							FROM [APP_AppTypeGroupAssoc] WITH (NOLOCK)
							WHERE appGroupId = FLT.filter_value
							AND
							(
								appTypeId = @appTypeId
								OR
								( @appTypeId = 0 AND appTypeId IN (SELECT appTypeId FROM APP_Application WITH (NOLOCK) WHERE clientId=@clientId) )
							)
						)
					)
				)
			)
			OR
			NOT EXISTS ( SELECT taskId
						FROM [TM_AssocFilter] WITH (NOLOCK)
						WHERE taskId = T.taskId
					)
		)
	)
ARGS_ERROR:
/*PRINT ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@PARAM1+', '+@PARAM2+', '+@PARAM3+', '+@PARAM4+
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'*/
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetSchedulePolicy')
	delete from GxQscripts where name = 'QS_GetSchedulePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSchedulePolicy')
	delete from GXDBVersions where aliasname = 'QS_GetSchedulePolicy'
GO

insert into GXDBVersions values(2, 'QS_GetSchedulePolicy',  '00000000000000000000', 'QS_GetSchedulePolicy', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetSchedulePolicy',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetSchedulePolicy.sql -si c=client_name -si a=app_type_name [-si i=instance_name] [-si b=backupset_name] -si s=subclient_name
'
 + CHAR(10) + '--   script_name : GetSchedulePolicy'
)
GO

