

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetSQLSubClientInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetSQLSubClientInfo <<<'

IF EXISTS (select * from sysobjects where name='QS_GetSQLSubClientInfo')
	drop procedure QS_GetSQLSubClientInfo
IF EXISTS (select * from GxQscripts where name='QS_GetSQLSubClientInfo')
	delete from GxQscripts where name = 'QS_GetSQLSubClientInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSQLSubClientInfo')
	delete from GXDBVersions where aliasname = 'QS_GetSQLSubClientInfo'
GO
print '... Creating Procedure: QS_GetSQLSubClientInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_GetSQLSubClientInfo
-- QScript is enabled
-- QScript secure this script does the user validation
-- Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript usage. Use no special char in HTML
-- SP Input params
  @InstanceId BIGINT = 0,
  @ClientId BIGINT = 0
AS
SET NOCOUNT ON
BEGIN TRY
DECLARE @xmlout XML
-- USER VALIDATION
--Existence of table and fetching of top 1 userId is done for safety measures
IF OBJECT_ID('tempdb.dbo.#tempQSUser') IS NULL
BEGIN
	 SET @xmlout  =( SELECT '-7 ' AS '@errorCode' , 'Error, no logged in user found' AS '@errorMessage' FOR XML PATH ('App_GenericResp'))
	 goto   ARGS_ERROR
END
DECLARE @userId INT
SET @userId = 0
SET @userId =  ISNULL( (select TOP 1 userId from #tempQSUser),0)
IF @userId = 0
BEGIN
	 SET @xmlout =( SELECT '-8 ' AS '@errorCode' , 'Error, no logged in user found' AS '@errorMessage' FOR XML PATH ('App_GenericResp'))
	 goto   ARGS_ERROR
END
-- Cursor declaration
DECLARE curGetSubclientInfo CURSOR FOR
SELECT
      id ,
      subclientName ,
      subclientStatus
		FROM APP_Application
		WHERE appTypeId = 81
			   and instance = @InstanceId
			   and clientId = @ClientId
			   and ((subclientStatus & 4) = 0) -- added for not considering deleted subclients.
-- Table to store contents and subclient information.
DECLARE @subclientList TABLE (subclientId BIGINT ,
subclientName NVARCHAR(255 ),
                        subclientStatus INT,
                        contents XML,
                        sqlSubclientType INT,
                        isSnapBackupEnabled INT,
                        isEnabledBackup INT,
                        isDiscoveryDisabled INT)
DECLARE @subclientId BIGINT
DECLARE @subclientName NVARCHAR (255)
DECLARE @subclientStatus INT
DECLARE @contents XML
DECLARE @sqlSubclientType INT
DECLARE @isSnapBackupEnabled INT
DECLARE @isEnabledBackup INT
DECLARE @isDiscoveryDisabled INT
DECLARE @MsSqlSubclientType INT
OPEN curGetSubclientInfo
-- for each subclient ID. Get contents and subclient properties and insert into table.
FETCH NEXT FROM curGetSubclientInfo  INTO @subclientId, @subclientName, @subclientStatus
WHILE @@FETCH_STATUS = 0
BEGIN
       SET @contents = (SELECT attrName AS '@name' FROM APP_SubClientProp WITH (NOLOCK) WHERE attrType = 118 AND componentNameId = @subclientId AND modified = 0 FOR XML PATH('database' ))
       SET @sqlSubclientType = ISNULL(( SELECT attrVal FROM APP_SubClientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'SQL Special Subclient Type' AND modified = 0), 1)
        SET @MsSqlSubclientType = ISNULL(( SELECT attrVal FROM APP_SubClientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'mssql subclient type' AND modified = 0), 1)
	   IF @MsSqlSubclientType = 1
	   BEGIN
		   SET @isSnapBackupEnabled = ISNULL(( SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Enable Snap Backups' AND modified = 0), 0)
		   SET @isEnabledBackup = ISNULL(( SELECT action FROM JMJobAction WITH (NOLOCK) WHERE clientId = 1 AND mediaAgentID = 1 AND appType = 0 AND optype = 4 AND appId = @subclientId ),0)
		   SET @isDiscoveryDisabled = ISNULL(( SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'MSSQL Disable AutoDiscovery' AND modified = 0), 0)
		   INSERT INTO @subclientList VALUES( @subclientId, @subclientName , @subclientStatus , @contents, @sqlSubclientType, @isSnapBackupEnabled, @isEnabledBackup , @isDiscoveryDisabled)
	   END
       FETCH NEXT FROM curGetSubclientInfo  INTO @subclientId, @subclientName, @subclientStatus
END
CLOSE curGetSubclientInfo
DEALLOCATE curGetSubclientInfo
-- format the output XML
DECLARE @COUNT_ROWS INTEGER
SELECT @COUNT_ROWS = COUNT(*) FROM @subclientList
IF @COUNT_ROWS  != 0
BEGIN
       SET @xmlout  =(
             SELECT
                  subclientId AS '@subclientId' ,
                  subclientName AS '@subclientName' ,
                  subclientStatus AS '@subclientStatus' ,
                  sqlSubclientType AS '@sqlSubclientType' ,
                  isEnabledBackup AS '@disableBackup' ,
                  isSnapBackupEnabled AS '@snapBackupEnable' ,
                  isDiscoveryDisabled AS '@disableAutoDiscovery' ,
                  contents as 'contents'
             FROM @subclientList FOR XML PATH('subclientInfo' ), ROOT('App_SQLSubclientListInfo' ) )
END
ELSE
BEGIN
       SET @xmlout  =( SELECT '-1' AS '@errorCode', 'Failed to get list of subclients and its properties.' AS '@errorMessage' FOR XML PATH ('App_GenericResp'))
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
       -- check if we need to deallocate /close cursor.
       --    send the error message back on failure.
	   DECLARE @curStatus INT
	   SELECT @curStatus = CURSOR_STATUS('global', 'curGetSubclientInfo')
       IF @curStatus = 1 OR @curStatus = 0
       BEGIN
			 CLOSE curGetSubclientInfo
			 DEALLOCATE curGetSubclientInfo
       END
       IF @curStatus = -1
       BEGIN
			 DEALLOCATE curGetSubclientInfo
       END
	   SET @xmlout  =( SELECT '-3 : ' + CONVERT(VARCHAR (128), ERROR_NUMBER()) AS '@errorCode' , 'Exception Caught with FATAL ERROR : ' + ERROR_MESSAGE() AS '@errorMessage' FOR XML PATH ('App_GenericResp'))
END CATCH
ARGS_ERROR:
SELECT @xmlout
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetSQLSubClientInfo')
	delete from GxQscripts where name = 'QS_GetSQLSubClientInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSQLSubClientInfo')
	delete from GXDBVersions where aliasname = 'QS_GetSQLSubClientInfo'
GO

insert into GXDBVersions values(2, 'QS_GetSQLSubClientInfo',  '00000000000000000000', 'QS_GetSQLSubClientInfo', '00000000000000000000')
GO

insert into GxQscripts values(2+8,'QS_GetSQLSubClientInfo',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '    qoperation execscript -sn QS_GetSQLSubClientInfo -si InstanceID -si ClientID
'
 + CHAR(10) + '--   script_name : QS_GetSQLSubClientInfo'
)
GO

