

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetSQLJobList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_GetSQLJobList.sp,v $ $Id: QS_GetSQLJobList.sp,v 1.7.60.4 2018/05/07 18:37:06 ankumar Exp $";
-- 	+-----------------------------------------------------------------------+
--	|			Stored Procedure: "GetSQLJobList"							|
--	|																		|
--	|-------------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetSQLJobList <<<'

IF EXISTS (select * from sysobjects where name='QS_GetSQLJobList')
	drop procedure QS_GetSQLJobList
IF EXISTS (select * from GxQscripts where name='QS_GetSQLJobList')
	delete from GxQscripts where name = 'QS_GetSQLJobList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSQLJobList')
	delete from GXDBVersions where aliasname = 'QS_GetSQLJobList'
GO
print '... Creating Procedure: QS_GetSQLJobList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetSQLJobList
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_clientName nvarchar(max),
  @i_instanceName nvarchar(max),
  @i_startTime varchar(max),
  @i_endTime varchar(max),
  @i_databaseName nvarchar(max) = N'',
  @i_jobid integer = 0,
  @i_backup_set_id integer = 0,
  @i_details integer = 0
AS
 set nocount on
BEGIN TRY
  DECLARE @ClientID INT
  DECLARE @InstanceID INT
  DECLARE @Backup_Set_Id INT
  DECLARE @u_startTime INT
  DECLARE @u_endTime INT
  DECLARE @ErrorNumber INTEGER
  DECLARE @ErrorMessage NVARCHAR(MAX)
select @ClientID = id from app_client where name = @i_clientName and (status = 0 OR status = 4096)
select distinct @InstanceID = id from app_instancename where id in
(
	select distinct instance from app_application where
	clientid = @ClientID and
	appTypeId = 81 and
	subclientStatus & 2 <> 2 and
	subclientStatus & 4 <> 4 and
	subclientStatus & 16 <> 16 and
	subclientStatus & 32 <> 32
)
and name = @i_instanceName
SET @i_endTime = RTRIM(LTRIM(@i_endTime))
SET @i_startTime = RTRIM(LTRIM(@i_startTime))
IF @i_startTime = '0'
BEGIN
	SET @u_startTime = 0
END
ELSE
BEGIN
	SET @u_startTime = dbo.GetUnixTime(dbo.LocalToUTCTime(@i_startTime, dbo.GetClientTimeZone(@ClientID)))
END
IF @i_endTime = '0'
BEGIN
	select @u_endTime = MAX(backup_finish_date) from sqlDbBackupInfo
	where
	instanceId = @InstanceID and
	appId in
	(
		select id from app_application where
		app_application.clientid = @ClientID and
		app_application.appTypeId = 81 and
		app_application.instance = @InstanceID and
		app_application.subclientStatus & 2 <> 2 and
		app_application.subclientStatus & 4 <> 4 and
		app_application.subclientStatus & 16 <> 16 and
		app_application.subclientStatus & 32 <> 32
	)
END
ELSE
BEGIN
	SET @u_endTime = dbo.GetUnixTime(dbo.LocalToUTCTime(@i_endTime, dbo.GetClientTimeZone(@ClientID)))
END
set nocount off
IF object_id('tempdb.dbo.#SQLJobs') is not null DROP TABLE #SQLJobs
CREATE TABLE #SQLJobs
(
	jobid int,
	backup_set_id int,
	id	int,
	appId	int,
	instanceId int,
	sqlNameId int,
	DatabaseName NVarchar(max),
	type CHAR(1),
	backup_size bigint,
	backup_start_date int,
	backup_finish_date int,
	backupmethod varchar(16)
)
IF @i_backup_set_id <> 0
BEGIN
INSERT INTO #SQLJobs
	SELECT DBInfo.jobid as JOBID, DBInfo.backup_set_id as backup_set_id, DBInfo.id as id, DBInfo.appId as appId, DBInfo.InstanceId as InstanceId, DBInfo.sqlNameId, SN2.name as DatabaseName, DBInfo.type, DBInfo.backup_size, DBInfo.backup_start_date, DBInfo.backup_finish_date, (CASE DBInfo.backupmethod
	when 0 then 'VDI'
	when 1 then 'VSS'
	when 2 then 'SNAP'
	end) BackupMethod
	from sqldbbackupinfo DBInfo, app_application APP, SQLNames SN, SQLNames2 SN2
	where
	DBInfo.instanceId = @InstanceID
	AND APP.id = DBInfo.appId
	AND APP.clientId = @ClientID
	AND DBInfo.backup_set_id = @i_backup_set_id
	AND DBInfo.sqlNameid = SN.id
	AND SN.sqlid = SN2.id
	AND SN.type = 1
END
ELSE IF @i_jobid = 0 AND @i_databaseName = N''
BEGIN
INSERT INTO #SQLJobs
	--Get the list of jobs between starttime and endtime
	SELECT DBInfo.jobid as JOBID, DBInfo.backup_set_id as backup_set_id, DBInfo.id as id, DBInfo.appId as appId, DBInfo.InstanceId as InstanceId, DBInfo.sqlNameId, SN2.name as DatabaseName, DBInfo.type, DBInfo.backup_size, DBInfo.backup_start_date, DBInfo.backup_finish_date, (CASE DBInfo.backupmethod
	when 0 then 'VDI'
	when 1 then 'VSS'
	when 2 then 'SNAP'
	end) BackupMethod
	from sqldbbackupinfo DBInfo, app_application APP, SQLNames SN, SQLNames2 SN2
	where
	DBInfo.instanceId = @InstanceID
	AND APP.id = DBInfo.appId
	AND APP.clientId = @ClientID
	AND DBInfo.backup_finish_date BETWEEN @u_startTime and @u_endTime
	AND DBInfo.sqlNameid = SN.id
	AND SN.sqlid = SN2.id
	AND SN.type = 1
END
ELSE IF @i_jobid <> 0 AND @i_databaseName = N''
BEGIN
INSERT INTO #SQLJobs
	SELECT DBInfo.jobid as JOBID, DBInfo.backup_set_id as backup_set_id, DBInfo.id as id, DBInfo.appId as appId, DBInfo.InstanceId as InstanceId, DBInfo.sqlNameId, SN2.name as DatabaseName, DBInfo.type, DBInfo.backup_size, DBInfo.backup_start_date, DBInfo.backup_finish_date, (CASE DBInfo.backupmethod
	when 0 then 'VDI'
	when 1 then 'VSS'
	when 2 then 'SNAP'
	end) BackupMethod
	from sqldbbackupinfo DBInfo, app_application APP, SQLNames SN, SQLNames2 SN2
	where
	DBInfo.instanceId = @InstanceID
	AND APP.id = DBInfo.appId
	AND APP.clientId = @ClientID
	AND DBInfo.jobId = @i_jobid
	AND DBInfo.sqlNameid = SN.id
	AND SN.sqlid = SN2.id
	AND SN.type = 1
END
ELSE IF @i_jobid <> 0 AND @i_databaseName <> N''
BEGIN
INSERT INTO #SQLJobs
	SELECT DBInfo.jobid as JOBID, DBInfo.backup_set_id as backup_set_id, DBInfo.id as id, DBInfo.appId as appId, DBInfo.InstanceId as InstanceId, DBInfo.sqlNameId, SN2.name as DatabaseName, DBInfo.type, DBInfo.backup_size, DBInfo.backup_start_date, DBInfo.backup_finish_date, (CASE DBInfo.backupmethod
	when 0 then 'VDI'
	when 1 then 'VSS'
	when 2 then 'SNAP'
	end) BackupMethod
	from sqldbbackupinfo DBInfo, app_application APP, SQLNames SN, SQLNames2 SN2
	where
	DBInfo.instanceId = @InstanceID
	AND APP.id = DBInfo.appId
	AND APP.clientId = @ClientID
	AND DBInfo.jobId = @i_jobid
	AND DBInfo.sqlNameid = SN.id
	AND SN.sqlid = SN2.id
	AND SN.type = 1
	AND SN2.NAME = @i_databaseName
	AND SN2.type = 1
END
ELSE IF @i_jobid = 0 AND @i_databaseName <> N''
BEGIN
INSERT INTO #SQLJobs
	SELECT DBInfo.jobid as JOBID, DBInfo.backup_set_id as backup_set_id, DBInfo.id as id, DBInfo.appId as appId, DBInfo.InstanceId as InstanceId, DBInfo.sqlNameId, SN2.name as DatabaseName, DBInfo.type, DBInfo.backup_size, DBInfo.backup_start_date, DBInfo.backup_finish_date, (CASE DBInfo.backupmethod
	when 0 then 'VDI'
	when 1 then 'VSS'
	when 2 then 'SNAP'
	end) BackupMethod
	from sqldbbackupinfo DBInfo, app_application APP, SQLNames SN, SQLNames2 SN2
	where
	DBInfo.instanceId = @InstanceID
	AND APP.id = DBInfo.appId
	AND APP.clientId = @ClientID
	AND DBInfo.backup_finish_date BETWEEN @u_startTime and @u_endTime
	AND DBInfo.sqlNameid = SN.id
	AND SN.sqlid = SN2.id
	AND SN.type = 1
	AND SN2.NAME = @i_databaseName
	AND NOT EXISTS (SELECT JBJI.jobid, JBJI.commcellId FROM JMBkpJobInfo JBJI WHERE JBJI.jobid = DBInfo.jobid and JBJI.commcellId = 2)
END
SELECT jobid as jobid, backup_set_id as backup_set_id, DatabaseName as DatabaseName, type as BackupType, backup_size as backup_size, backup_start_date as backup_start_date, backup_finish_date as backup_finish_date,backupmethod as BackupMethod FROM #SQLJobs
IF @i_details <> 0
BEGIN
select DBInfo.jobid, DBName2Tbl.name DatabaseName, GroupName2Tbl.name GroupName, LogicalName2Tbl.name LogicalName, PhysicalName2Tbl.name PhysicalPath, SQLFileInfo.number, SQLFileInfo.pageSize, CHAR(SQLFileInfo.type) Type
from #SQLJobs DBInfo, SQLFileBackupInfo SQLFileInfo,
(SELECT  * FROM SQLNames2 where type = 1) AS DBName2Tbl,
(SELECT  * FROM SQLNames2 where type = 2) AS GroupName2Tbl,
(SELECT  * FROM SQLNames2 where type = 4) AS LogicalName2Tbl,
(SELECT  * FROM SQLNames2 where type = 3) AS PhysicalName2Tbl,
(SELECT  * FROM SQLNames where type = 2) AS GroupNameTbl,
(SELECT  * FROM SQLNames where type = 4) AS LogicalNameTbl,
(SELECT  * FROM SQLNames where type = 3) AS PhysicalNameTbl,
(SELECT  * FROM SQLNames where type = 1) AS DBNameTbl
where
SQLFileInfo.sqlDBBackupinfoid = DBInfo.id
AND SQLFileInfo.sqlNameFgId = GroupNameTbl.id
AND SQLFileInfo.sqlNamePhyId = PhysicalNameTbl.id
AND SQLFileInfo.sqlNameLogId = LogicalNameTbl.id
AND GroupNameTbl.sqlid = GroupName2Tbl.id
AND LogicalNameTbl.sqlid = LogicalName2Tbl.id
AND PhysicalNameTbl.sqlid = PhysicalName2Tbl.id
AND DBNameTbl.sqlid = DBName2Tbl.id
AND DBInfo.sqlNameId = DBNameTbl.id
END
IF object_id('tempdb.dbo.#SQLJobs') is not null DROP TABLE #SQLJobs
END TRY
BEGIN CATCH
DECLARE @ErrorSeverity INT
DECLARE @ErrorState INT
SELECT @ErrorNumber = ERROR_NUMBER(), @ErrorMessage = ERROR_MESSAGE(),
@ErrorSeverity = ERROR_SEVERITY(),@ErrorState = ERROR_STATE()
RAISERROR (@ErrorMessage, @ErrorSeverity , @ErrorState );
END CATCH;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetSQLJobList')
	delete from GxQscripts where name = 'QS_GetSQLJobList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSQLJobList')
	delete from GXDBVersions where aliasname = 'QS_GetSQLJobList'
GO

insert into GXDBVersions values(2, 'QS_GetSQLJobList',  '00010007006000040000', 'QS_GetSQLJobList', '00010007006000040000')
GO

insert into GxQscripts values(2,'QS_GetSQLJobList',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_GetSQLJobList -si @i_clientName = ''clientname'' -si @i_instanceName=''instanceName'' -si @i_startTime = ''starttime'' -si @i_endTime = ''endtime''  -si @i_databaseName = ''dbname'' -si @i_jobid = ''jobid'' -si @i_backup_set_id = ''msdbbackupsetid'' -si @i_details = ''0 or 1''
'
 + CHAR(10) + '-- 	script_name: QS_GetSQLJobList.'
 + CHAR(10) + '-- 	returns job list and details.'
)
GO

