

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetSQLClientInstanceInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetSQLClientInstanceInfo <<<'

IF EXISTS (select * from sysobjects where name='QS_GetSQLClientInstanceInfo')
	drop procedure QS_GetSQLClientInstanceInfo
IF EXISTS (select * from GxQscripts where name='QS_GetSQLClientInstanceInfo')
	delete from GxQscripts where name = 'QS_GetSQLClientInstanceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSQLClientInstanceInfo')
	delete from GXDBVersions where aliasname = 'QS_GetSQLClientInstanceInfo'
GO
print '... Creating Procedure: QS_GetSQLClientInstanceInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_GetSQLClientInstanceInfo
-- QScript is enabled
-- QScript secure this script does the user validation
-- Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript usage. Use no special char in HTML
-- SP Input params
-- no inputs
AS
SET NOCOUNT ON
DECLARE @sOutputXML XML
-- USER VALIDATION
--Existence of table and fetching of top 1 userId is done for safety measures
IF OBJECT_ID('tempdb.dbo.#tempQSUser') IS NULL
BEGIN
	 SET @sOutputXML  =( SELECT '-7 ' AS '@errorCode' , 'Error, no logged in user found' AS '@errorMessage' FOR XML PATH ('App_GenericResp'))
	 goto   ARGS_ERROR
END
DECLARE @userId INT
SET @userId = 0
SET @userId =  ISNULL( (select TOP 1 userId from #tempQSUser),0)
IF @userId = 0
BEGIN
	 SET @sOutputXML  =( SELECT '-8 ' AS '@errorCode' , 'Error, no logged in user found' AS '@errorMessage' FOR XML PATH ('App_GenericResp'))
	 goto   ARGS_ERROR
END
-- Table to store insatnce and client information.
IF OBJECT_ID('tempdb.dbo.#instanceInfo') IS NOT NULL
	DROP TABLE #instanceInfo
create table #instanceInfo (clientId BIGINT , instanceID BIGINT , instanceName NVARCHAR(255 ), status INT,
instanceVersion NVARCHAR(255), instanceServerType NVARCHAR(255))
IF OBJECT_ID('tempdb.dbo.#clientInfo') IS NOT NULL
	DROP TABLE #clientInfo
CREATE TABLE #clientInfo (clientId BIGINT , clientName NVARCHAR (255), clientHostName NVARCHAR(255 ), JobResultsFolder NVARCHAR (255),
TimeZoneName NVARCHAR(255 ), TimeZoneID NVARCHAR(255 ), status INT )
-- Cursor for finding the list of clients and associated SQL instances
DECLARE GetSQLClientInstance CURSOR
                   FOR SELECT DISTINCT(clientId),instance
                               FROM App_Application
                                     WHERE apptypeid = 81
										and ((subclientStatus & 4) = 0) -- added for not considering deleted subclients.
-- User Permission Check Code Starts
IF OBJECT_ID('tempdb.dbo.#SqlClientInstancePermission') IS NOT NULL
	DROP TABLE #SqlClientInstancePermission
CREATE TABLE #SqlClientInstancePermission( clientID INT, permissionId INT PRIMARY KEY(clientId, permissionID))
BEGIN TRY
-- Open the cursor.
OPEN GetSQLClientInstance
DECLARE @clientID BIGINT
DECLARE @instanceID BIGINT
-- For each client and instance ID. get its corresponding information.
FETCH NEXT FROM GetSQLClientInstance INTO @clientid, @instanceID
WHILE @@FETCH_STATUS = 0
BEGIN
DECLARE @name NVARCHAR (255)
       DECLARE @status INT
DECLARE @instVersion NVARCHAR (255)
DECLARE @serverType NVARCHAR (255)
	   IF NOT EXISTS(SELECT 1 FROM #SqlClientInstancePermission WHERE clientID = @clientid)
	   BEGIN
		   IF OBJECT_ID('tempdb.dbo.#SingleClientPermission') IS NOT NULL DROP TABLE #SingleClientPermission
		   CREATE TABLE #SingleClientPermission(permissionId INT)
EXEC sec_getPermissionsOnEntity '#SingleClientPermission', @userId, 3, @clientid
		   INSERT INTO #SqlClientInstancePermission
			  SELECT DISTINCT @clientid, permissionId FROM #SingleClientPermission
		END
       -- get instance information for instance ID.
       SELECT @name = name, @status = status
                         FROM APP_InstanceName WHERE id = @instanceID
	   SET @instVersion = ISNULL((SELECT attrVal FROM APP_InstanceProp WITH (NOLOCK) WHERE APP_InstanceProp.componentNameId = @instanceID AND APP_InstanceProp.attrName = 'MSSQL Version'),'0.0')
	   SET @serverType = ISNULL((SELECT attrVal FROM APP_InstanceProp WITH (NOLOCK) WHERE APP_InstanceProp.componentNameId = @instanceID AND APP_InstanceProp.attrName = 'MSSQL Server Type'),'DataBase Engine')
       INSERT INTO #instanceInfo VALUES (@clientid, @instanceID , @name, @status, @instVersion, @serverType)
       -- check if client associated to instance is already inserted the property values.
       DECLARE @clientIDForCrossCheck BIGINT
       SET @clientIDForCrossCheck = 0
       SELECT  @clientIDForCrossCheck  = clientId FROM #clientInfo WHERE clientId = @clientID
       IF @clientIDForCrossCheck = 0
       BEGIN
             DECLARE @clientIDval BIGINT
DECLARE @clientName NVARCHAR (255)
DECLARE @clientHostName NVARCHAR (255)
DECLARE @Jobresults NVARCHAR (255)
DECLARE @timeZoneval NVARCHAR (255)
DECLARE @timeZoneIDVal NVARCHAR (255)
             DECLARE @stausClient INT
             SET @clientIDval = @clientID
             SELECT @clientName = name, @clientHostName = net_hostname,@Jobresults= jobResultDir, @stausClient = status FROM APP_Client WHERE id = @clientID
             SELECT @timeZoneval= TimeZoneName, @timeZoneIDVal = TimeZoneStdName FROM SchedTimeZone
                               WHERE TimeZoneID = (SELECT attrVal FROM APP_ClientProp
                                                                         WHERE attrName = N'timezone Id' and componentNameId = @clientID)
             INSERT INTO #clientInfo VALUES( @clientIDval, @clientName , @clientHostName, @Jobresults, @timeZoneval, @timeZoneIDVal, @stausClient )
       END
	   DELETE FROM #clientInfo where clientId not in (select clientID from #SqlClientInstancePermission)
       DELETE FROM #instanceInfo where clientId not in (select clientID from #SqlClientInstancePermission)
       FETCH NEXT FROM GetSQLClientInstance INTO @clientid, @instanceID
END
CLOSE GetSQLClientInstance
DEALLOCATE GetSQLClientInstance
-- Format the output XML.
-- No clients found in table.
DECLARE @COUNT_ROWS INTEGER
SELECT @COUNT_ROWS = COUNT(*) FROM #clientInfo
IF @COUNT_ROWS = 0
BEGIN
       SET @sOutputXML = (SELECT '-1' AS '@errorCode' , 'Failed to get client information.' AS '@errorMessage' FOR XML PATH ('App_GenericResp' ))
END
ELSE
BEGIN
		SET @COUNT_ROWS = 0
       -- No instances found in table.
	   SELECT @COUNT_ROWS = COUNT(*)  FROM #instanceInfo
       IF @COUNT_ROWS = 0
       BEGIN
             SET @sOutputXML = (SELECT '-2' AS '@errorCode' , 'Failed to get instance names.' AS '@errorMessage' FOR XML PATH ('App_GenericResp' ))
       END
       ELSE
       BEGIN
             SET @sOutputXML = (SELECT
                         (SELECT clientId AS '@clientID' ,
                        clientName AS '@clientName' ,
                        clientHostName AS '@clientHostName' ,
                        JobResultsFolder AS '@jobResults' ,
                         status AS '@status',
						 TimeZoneName AS '@timeZone',
						 TimeZoneID AS '@timeZoneID'
                         FROM #clientInfo FOR XML PATH('MSSQLClient' ), TYPE ),
                         (SELECT instanceID AS '@instanceID' ,
                        instanceName AS '@instanceName' ,
                        clientId AS '@clientID' ,
                         status AS '@status',
						 instanceVersion AS '@version',
						 instanceServerType AS '@serverType'
                         FROM #instanceInfo FOR XML PATH('MSSQLInstance' ), TYPE) FOR XML PATH( ''),
                         ROOT ('App_SQLClientInstanceInfo' ))
       END
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	   DECLARE @curStatus INT
	   SELECT @curStatus = CURSOR_STATUS('global', 'GetSQLClientInstance')
       IF @curStatus = 1 OR @curStatus = 0
       BEGIN
			 CLOSE GetSQLClientInstance
			 DEALLOCATE GetSQLClientInstance
       END
       IF @curStatus = -1
       BEGIN
			 DEALLOCATE GetSQLClientInstance
       END
       SET @sOutputXML = (SELECT '-3 : ' + CONVERT (VARCHAR( 128), ERROR_NUMBER()) As '@errorCode' , 'Exception Caught with FATAL ERROR : ' + ERROR_MESSAGE() AS '@errorMessage' FOR XML PATH ('App_GenericResp'))
END CATCH
ARGS_ERROR:
SELECT @sOutputXML
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetSQLClientInstanceInfo')
	delete from GxQscripts where name = 'QS_GetSQLClientInstanceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSQLClientInstanceInfo')
	delete from GXDBVersions where aliasname = 'QS_GetSQLClientInstanceInfo'
GO

insert into GXDBVersions values(2, 'QS_GetSQLClientInstanceInfo',  '00000000000000000000', 'QS_GetSQLClientInstanceInfo', '00000000000000000000')
GO

insert into GxQscripts values(2+8,'QS_GetSQLClientInstanceInfo',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '    qoperation execscript -sn QS_GetSQLClientInstanceInfo
'
 + CHAR(10) + '--   script_name : QS_GetSQLClientInstanceInfo'
)
GO

