

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetOraclecredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_GetOraclecredentials')
BEGIN
	print '>>> Drop Stored Procedure: QS_GetOraclecredentials <<<'
	drop procedure QS_GetOraclecredentials
END
IF EXISTS (select * from GxQscripts where name='QS_GetOraclecredentials')
	delete from GxQscripts where name = 'QS_GetOraclecredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetOraclecredentials')
	delete from GXDBVersions where aliasname = 'QS_GetOraclecredentials'
GO
print '... Creating Procedure: QS_GetOraclecredentials'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetOraclecredentials
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 varchar(1024) = '%s',
  @PARAM2 varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- FOLLOWING ARE FILLED IN FROM COMMAND  --
-- .. LINE, IN THIS ORDER (DELETE IF NOT NEEDED)				 --
-------------------------------------------
--DECLARE @PARAM1     	varchar(512)
--DECLARE @PARAM2     	varchar(512)
--SET @PARAM1 = '%s'					-- c=clientName, allclients
--SET @PARAM2 = '%s'					-- Type (Catalog, DB, (user) impersonate
---------------------------------------
-- SET FOR STANDALONE DEBUGGING ONLY --
---------------------------------------
--SET @PARAM1 =	'c=TESTRAC'
-- SET @PARAM1 =	'allclients'
--SET @PARAM2 =	't=DB'
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'GetOraclecredentials'
DECLARE @allClientsOption		varchar(32)
set		@allClientsOption		= 'allClients'
-----
DECLARE @CV_ORACLE_CATALOG_CONNECT		varchar(40)
SET		@CV_ORACLE_CATALOG_CONNECT		= 'Catalog Connect'
DECLARE @CV_ORACLE_CATALOG_CONNECT_PWD	varchar(40)
SET		@CV_ORACLE_CATALOG_CONNECT_PWD	= 'Catalog Connect Password'
-----
DECLARE @CV_ORACLE_SQL_CONNECT			varchar(40)
SET		@CV_ORACLE_SQL_CONNECT			= 'SQL Connect'
DECLARE @CV_ORACLE_SQL_CONNECT_PWD		varchar(40)
SET		@CV_ORACLE_SQL_CONNECT_PWD		= 'SQL Connect Password'
-----
DECLARE @CV_ORACLE_DOMAIN_NAME			varchar(40)
SET		@CV_ORACLE_DOMAIN_NAME			= 'Domain Name'
DECLARE @CV_ORACLE_DOMAIN_USER_PASSWORD	varchar(40)
SET		@CV_ORACLE_DOMAIN_USER_PASSWORD	= 'Domain User Password'
DECLARE	@CV_ORACLE_USER_NAME			varchar(40)
SET		@CV_ORACLE_USER_NAME			='Oracle User'
-----
DECLARE @oneClientOption		varchar(10)
SET		@oneClientOption		='c='
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
DECLARE @clientId				integer
SET		@clientId				=0
DECLARE @password				nvarchar(1024)
DECLARE @userName				nvarchar(1024)
DECLARE @domainName				nvarchar(1024)
SET		@domainName				=''
DECLARE @useConnect				nvarchar(40)
SET		@useConnect				=''
DECLARE @usePassword			nvarchar(40)
SET		@usePassword			=''
DECLARE	@isOracleRAC			integer
SET		@isOracleRAC			= 0
DECLARE @SlashPosn				int
DECLARE @Domain					nvarchar(1024)
DECLARE @currentUserName        nvarchar(512)
DECLARE @currentPassword        nvarchar(512)
DECLARE @currentClientName      nvarchar(512)
DECLARE @currentDomainName      nvarchar(512)
DECLARE @componentNameId        int
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
--- CHECK IF PARAMETERS SPECIFIED CORRECTLY  ---
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
---------------------------------------
---  SPECIFIC CLIENT OR ALL CLIENTS ---
---------------------------------------
IF @PARAM1 = @allClientsOption
	SET @clientId =0
ELSE
BEGIN
	IF SUBSTRING(@PARAM1, 1, 2) = @oneClientOption
	BEGIN
		set @clientId= ISNULL((SELECT id from APP_CLIENT WHERE name = (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2))),0)
		IF @clientId = 0
		BEGIN
			SET @localErrorMsg = 'Error.  Client ['+ (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2)) + '] Does not exist.'
			Set @lastError = 1
			goto   ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @localErrorMsg = 'Error.  Parameter1 must be specified as allclients or c=clientName.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
END
---------------------------------------
---       CREDENTIALS TYPE			---
-- Type is one of:					---
--   Catalog, DB, user impersonate  ---
--   or Oracle RAC					---
---------------------------------------
IF @PARAM2 = 't=Catalog'
BEGIN
	SET		@useConnect				=@CV_ORACLE_CATALOG_CONNECT
	SET		@usePassword			=@CV_ORACLE_CATALOG_CONNECT_PWD
END
ELSE IF @PARAM2 = 't=DB'
BEGIN
	SET		@useConnect				=@CV_ORACLE_SQL_CONNECT
	SET		@usePassword			=@CV_ORACLE_SQL_CONNECT_PWD
END
ELSE IF @PARAM2 = 't=Impersonate'
BEGIN
--	SET		@useConnect				=@CV_ORACLE_DOMAIN_NAME
	SET		@useConnect				=@CV_ORACLE_USER_NAME
	SET		@usePassword			=@CV_ORACLE_DOMAIN_USER_PASSWORD
END
ELSE IF @PARAM2 = 't=RAC'
	SET		@isOracleRAC = 1
-----
ELSE
BEGIN
	SET @localErrorMsg	='Error. Parameter 2 must be specified as t=Catalog|DB|Impersonate|RAC.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--=====================================================
-- DONE PROCESSING CMD ARGS, START THINGS GOING:	 ==
--=====================================================
PRINT @scriptName + ' Started at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ( ' + @PARAM1 +', ' +@PARAM2+ ')'
--------------------------------------------------------------------------
--- ALL COMMAND LINE ARGS PROCESSED, DO SOME WORK!					------
--------------------------------------------------------------------------
BEGIN TRAN
BEGIN TRY
	IF object_id('tempdb.dbo.OracleCredentialsList') is not null DROP TABLE #OracleCredentialsList
	CREATE TABLE #OracleCredentialsList
	(
	clientName nvarchar(512),
	--domainName nvarchar(512)
	userName nvarchar(512),
	encryptedPassword nvarchar(512)
	)
	IF @IsOracleRAC = 0
	BEGIN
		IF @clientId = 0
			DECLARE GetUserNameList CURSOR FOR
			SELECT DISTINCT componentNameId,AttrVal from APP_INSTANCEPROP where AttrName=@useConnect AND componentNameId in (SELECT DISTINCT instance FROM APP_APPLICATION WHERE appTypeId in (2, 22, 80))
		ELSE
          	DECLARE GetUserNameList CURSOR FOR
			SELECT DISTINCT componentNameId,AttrVal from APP_INSTANCEPROP where AttrName=@useConnect AND componentNameId in (SELECT DISTINCT instance FROM APP_APPLICATION WHERE clientID = @clientId AND appTypeId in (2, 22, 80))
		OPEN GetUserNameList
			FETCH GetUserNameList INTO @componentNameId, @currentUserName
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SELECT @currentPassword = (CASE WHEN AttrName = @CV_ORACLE_CATALOG_CONNECT_PWD THEN dbo.pswConvertV5ToV3(attrVal) ELSE attrVal END) from  APP_INSTANCEPROP where componentNameId = @componentNameId and AttrName = @usePassword
				SELECT @currentClientName = name from APP_Client,APP_APPLICATION where APP_APPLICATION.instance = @componentNameId AND APP_APPLICATION.clientId=APP_Client.id
				--SELECT @domainName = AttrVal from  APP_INSTANCEPROP where componentNameId = @componentNameId and AttrName = @CV_ORACLE_DOMAIN_NAME
				INSERT INTO #OracleCredentialsList (clientName, userName, encryptedPassword) VALUES(@currentClientName, @currentUserName , @currentPassword)
				FETCH GetUserNameList INTO @componentNameId, @currentUserName
			END
		CLOSE GetUserNameList
		DEALLOCATE GetUserNameList
	END
    ELSE
	IF @clientId = 0
	BEGIN
        INSERT INTO #OracleCredentialsList SELECT DISTINCT  APP_client.name as clientName,InstanceOraUser as userName ,InstanceOraPasswd as  encryptedPassword from  APP_OracleRACInstance,app_application,APP_client
        WHERE 	instaceId in (Select Distinct instance FROM app_application WHERE appTypeId = 80) AND APP_client.id = app_application.clientId
	END
	ELSE
	BEGIN
		INSERT INTO #OracleCredentialsList SELECT DISTINCT  APP_client.name as clientName,InstanceOraUser as userName ,InstanceOraPasswd as  encryptedPassword from  APP_OracleRACInstance,app_application,APP_client
        WHERE 	instaceId in (Select Distinct instance FROM app_application WHERE appTypeId = 80) AND APP_client.id = app_application.clientId AND app_application.clientId = @clientID
    END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
    set @lastError = ERROR_NUMBER()
    set @localErrorMsg = 'Problems Getting Password/Username ' +ERROR_MESSAGE()
END
END CATCH
----------------------------------------------------
-------   ALL DONE, KEEP OR DESCARD CHANGES   ------
----------------------------------------------------
ALL_DONE:
IF (@lastError  = 0)
	commit   Tran
--	rollback Tran				-- For Debugging
ELSE
	rollback Tran
SELECT clientName,userName,encryptedPassword from #OracleCredentialsList
DROP TABLE #OracleCredentialsList
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ( '
		 +REPLACE(@PARAM1, @NoParameter, '[]') +', '
		 +REPLACE(@PARAM2, @NoParameter, '[]')
         + '). Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetOraclecredentials')
	delete from GxQscripts where name = 'QS_GetOraclecredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetOraclecredentials')
	delete from GXDBVersions where aliasname = 'QS_GetOraclecredentials'
GO

insert into GXDBVersions values(2, 'QS_GetOraclecredentials',  '00000000000000000000', 'QS_GetOraclecredentials', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetOraclecredentials',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qscript -f GetOracleCredentials -i c=clientName|allclients t=Catalog|DB|Impersonate|RAC
'
 + CHAR(10) + '--   script_name : GetOraclecredentials'
)
GO

