

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetOracleSchema.sp] ---------- 

  -- ----------------------------------------------------------------------
  --
 --           Copyright (c) 1998  CommVault Systems, Inc.
 --                  All rights reserved.
 --
 --
 --        This is unpublished proprietary source code of CommVault
 --        Systems, Inc. The copyright notice above does not evidence
 --        any actual or intended publication of such source code.
 -- ----------------------------------------------------------------------*/
 --  +-----------------------------------------------------------------------+
 --  |           Stored Procedure: "QS_GetOracleSchema"                           |
 --  |                                                                       |
 --  |-------------------------------------------------------------------------+
 -- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetOracleSchema <<<'

IF EXISTS (select * from sysobjects where name='QS_GetOracleSchema')
	drop procedure QS_GetOracleSchema
IF EXISTS (select * from GxQscripts where name='QS_GetOracleSchema')
	delete from GxQscripts where name = 'QS_GetOracleSchema'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetOracleSchema')
	delete from GXDBVersions where aliasname = 'QS_GetOracleSchema'
GO
print '... Creating Procedure: QS_GetOracleSchema'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetOracleSchema
 -- Qscript is Enabled
 -- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
 -- Qscript Usage. Do not use special char in HTML
-- Match the data type ( and length of characters) of clientName, instancename with corresponding tables
  @i_clientName nvarchar(510) = N'', 
  @i_instanceName nvarchar(1024) = N'',
  @i_pointInTime varchar(256) = '',
  @i_jobId integer = 0,
  @i_backupSetName varchar(256) = ''
AS
set nocount on
BEGIN TRY
  DECLARE @ClientID INT = -1
  DECLARE @InstanceID INT = -1
  DECLARE @BackupsetID INT = -1
  DECLARE @ErrorNumber INTEGER
  DECLARE @ErrorMessage NVARCHAR(MAX)
  DECLARE @CustomError varchar(max) = N''
  DECLARE @PIT BIGINT = -1
  DECLARE @usePIT INT = 0
  DECLARE @appTypeId INT =0
IF @i_clientName = N''
BEGIN
SET @CustomError = 'Client Name is empty. Please provide valid Client Name'
GOTO SKIP_END
END
IF @i_instanceName = N''
BEGIN
SET @CustomError = 'Instance Name is empty. Please provide valid Instance Name'
GOTO SKIP_END
END
IF @i_pointInTime <> N'' OR @i_jobId = 0
BEGIN
SET @usePIT = 1
END
IF @usePIT = 1
BEGIN
IF @i_pointInTime = N''
BEGIN
SET @i_pointInTime = GETDATE()
END
BEGIN
IF ISDATE(@i_pointInTime) <> 1
BEGIN
SET @CustomError = 'Invalid time. Please provide valid time MM-DD-YYYY  hh:mm:ss'
GOTO SKIP_END
END
END
END
select @ClientID = id from app_client with (nolock) where name = @i_clientName and status = 0
IF @ClientID = -1
BEGIN
SET @CustomError = 'Client Name does not exist. Please provide valid Client Name'
GOTO SKIP_END
END
select distinct @InstanceID = id  from app_instancename
with (nolock) where id in
(
	select distinct instance  from app_application with (nolock) where
	clientid = @ClientID and
	appTypeId in ( 37, 62, 103, 22, 80, 61) and
	subclientStatus & 2 <> 2 and
	subclientStatus & 4 <> 4 and
	subclientStatus & 16 <> 16 and
	subclientStatus & 32 <> 32
)
and name = @i_instanceName
IF @InstanceID = -1
BEGIN
SET @CustomError = 'Instance Name does not exist. Please provide valid Instance Name'
GOTO SKIP_END
END
select distinct @appTypeId=appTypeId from APP_Application where clientId=@ClientID and instance=@InstanceID
IF @i_backupSetName = N'' and @appTypeId in (37, 62, 103)
BEGIN
SET @CustomError = 'Database Name is empty. Please provide valid database Name'
GOTO SKIP_END
END
IF @appTypeId in ( 37, 62, 103)
BEGIN
	select distinct @BackupsetID =id  from APP_BackupSetName
	with (nolock) where id in
	(
		select distinct  backupSet  from app_application with (nolock) where
		clientid = @ClientID and
		appTypeId in ( 37, 62, 103, 22, 80, 61) and
		subclientStatus & 2 <> 2 and
		subclientStatus & 4 <> 4 and
		subclientStatus & 16 <> 16 and
		subclientStatus & 32 <> 32 and
		instance = @InstanceID
	)
	and name = @i_backupSetName
	IF @BackupsetID = -1
	BEGIN
	SET @CustomError = 'Database Name does not exist. Please provide valid database Name'
	GOTO SKIP_END
	END
END
IF @usePIT = 1 -- Use provided point in time value
BEGIN
SET @i_pointInTime = RTRIM(LTRIM(@i_pointInTime))
SET @PIT = dbo.GetUnixTime(dbo.LocalToUTCTime(@i_pointInTime, dbo.GetClientTimeZone(@ClientID)))
END
ELSE -- Get Job End time from JMBkpStats for given JobID
BEGIN
SELECT @PIT = servEndDate FROM JMBkpStats with (nolock) WHERE jobID = @i_jobId AND appId in (SELECT DISTINCT id from APP_Application with (nolock) where instance = @InstanceID)
IF @PIT = -1
BEGIN
SET @CustomError = 'Invalid backup job ID. Please provide valid backup JobID associated with provided database instance'
GOTO SKIP_END
END
END
IF object_id('tempdb.dbo.#OraSchema') is not null DROP TABLE #OraSchema
CREATE TABLE #OraSchema
(
	dataFile varchar(2048),
	dataFileID bigint,
	tableSpaceName varchar(64)
)
BEGIN
	--Create temp table #OraSchema with distinct JobID, CCID
	INSERT INTO #OraSchema
	SELECT oraDataFile.name as dataFile , oraDataFile.contType as dataFileID, oraTblSpc.name as tableSpaceName
	FROM OracleDataFiles oraDataFile , OracleTableSpaces oraTblSpc
	WHERE
	oraDataFile.instId = @InstanceID
	AND oraDataFile.tblId = oraTblSpc.id
	AND oraDataFile.created <= @PIT
	AND (oraDataFile.deleted >= @PIT OR oraDataFile.deleted = 0)
	AND (oraTblSpc.backupsetId = @BackupsetID or @appTypeId in (22, 61, 80) )
END
BEGIN
	SELECT * from #OraSchema ORDER BY dataFileID
END
SKIP_END:
IF object_id('tempdb.dbo.#OraSchema') is not null DROP TABLE #OraSchema
IF @CustomError <> N''
SELECT @CustomError
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SELECT @ErrorNumber = ERROR_NUMBER(), @ErrorMessage = ERROR_MESSAGE();
PRINT N'Error occured. ErrorNo(' + CAST(@ErrorNumber AS NVARCHAR(10)) + N') ErrorMsg(' + @ErrorMessage + N').'
END CATCH;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetOracleSchema')
	delete from GxQscripts where name = 'QS_GetOracleSchema'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetOracleSchema')
	delete from GXDBVersions where aliasname = 'QS_GetOracleSchema'
GO

insert into GXDBVersions values(2, 'QS_GetOracleSchema',  '00000000000000000000', 'QS_GetOracleSchema', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetOracleSchema',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '    qoperation execscript -sn QS_GetOracleSchema -si @i_clientName = ''clientname'' -si @i_instanceName=''instanceName'' -si @i_pointInTime = ''pointInTime'' -si @i_jobId = ''backupJobID'' -si @i_backupSetName = ''db2DatabaseName''
'
 + CHAR(10) + '--   script_name: QS_GetOracleSchema.'
 + CHAR(10) + '--   returns job list and details.'
)
GO

