

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetOracle12CPDBBackupDetails.sp] ---------- 

 --  +-----------------------------------------------------------------------+
 --  |           Stored Procedure: "QS_GetOracle12CPDBBackupDetails"                           |
 --  |                                                                       |
 --  |-------------------------------------------------------------------------+
 -- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetOracle12CPDBBackupDetails <<<'

IF EXISTS (select * from sysobjects where name='QS_GetOracle12CPDBBackupDetails')
	drop procedure QS_GetOracle12CPDBBackupDetails
IF EXISTS (select * from GxQscripts where name='QS_GetOracle12CPDBBackupDetails')
	delete from GxQscripts where name = 'QS_GetOracle12CPDBBackupDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetOracle12CPDBBackupDetails')
	delete from GXDBVersions where aliasname = 'QS_GetOracle12CPDBBackupDetails'
GO
print '... Creating Procedure: QS_GetOracle12CPDBBackupDetails'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetOracle12CPDBBackupDetails
 -- Qscript is Enabled
 -- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
 -- Qscript Usage. Do not use special char in HTML
-- Match the data type ( and length of characters) of clientName, instancename and databasename with corresponding tables
  @i_startTime varchar(256) = '0',
  @i_endTime varchar(256) = '0',
  @i_databaseNameList nvarchar(1024) = N'',
  @i_instanceNameList nvarchar(1024) = N'',
  @i_clientNameList nvarchar(1024) = N'',
  @i_dbIdList nvarchar(1024) = N'',
  @i_noTimeRestriction integer = 0,
  @i_enableDateTimeFormat integer = 0
AS
set nocount on
BEGIN TRY
DECLARE @clientId INT = -1
DECLARE @u_startTime BIGINT
DECLARE @u_endTime BIGINT
DECLARE @ErrorNumber INTEGER
DECLARE @ErrorMessage NVARCHAR(MAX)
DECLARE @DateDifference INT
DECLARE @CustomError varchar(max) = N''
DECLARE @TimeZone varchar(max) = ''
DECLARE @usage varchar(1024) = 'qoperation execscript -sn QS_GetOracle12CPDBBackupDetails  -si @i_startTime = ''start-time in MM/DD/YYYY HH24:MI:SS format'' -si @i_endTime = ''end-time in MM/DD/YYYY HH24:MI:SS format''  -si @i_databaseNameList = ''pdbNameList (delimited by comma)''  -si @i_instanceNameList=''instanceNameList (delimited by comma)'' -si @i_clientNameList = ''clientnameList (delimited by comma)'' -si @i_dbIdList = ''dbIdList (delimited by comma)'' -si @i_noTimeRestriction = ''0 or 1'' -si @i_enableDateTimeFormat  = ''0 or 1'''
IF ISDATE(@i_startTime) <> 1
BEGIN
SET @CustomError = 'Invalid Start time. Please provide valid time MM/DD/YYYY  hh:mm:ss'
GOTO SKIP_END
END
IF ISDATE(@i_endTime) <> 1
BEGIN
SET @CustomError = 'Invalid End time. Please provide valid time MM/DD/YYYY  hh:mm:ss'
GOTO SKIP_END
END
IF CAST(@i_startTime AS DATETIME) > CAST(@i_endTime AS DATETIME)
BEGIN
SET @CustomError = 'Error, END time must be greater than the start time'
GOTO SKIP_END
END
IF @i_databaseNameList = N'' and @i_instanceNameList = N'' and @i_clientNameList = N'' and @i_dbIdList = N''
BEGIN
SET @CustomError = 'Error,  all  the inputs i.e database name list, instanceName list,  clientName list or dbId List cannot be empty, we need atleast one of them'
GOTO SKIP_END
END
IF @i_noTimeRestriction = 0
BEGIN
IF DATEDIFF(DAY,@i_startTime , @i_endTime ) > 14
BEGIN
SET @CustomError = 'Difference BETWEEN Start and End date cannot be more than 14 day. To bypass this constraint set @i_noTimeRestriction to 1'
GOTO SKIP_END
END
END
SET @TimeZone = 'Greenwich Mean Time'
SET @u_startTime = dbo.GetUnixTime(dbo.LocalToUTCTime(@i_startTime, @TimeZone))
SET @u_endTime = dbo.GetUnixTime(dbo.LocalToUTCTime(@i_endTime, @TimeZone))
IF OBJECT_ID('tempdb.dbo.#TempPDBTracking') IS NOT NULL DROP TABLE #TempPDBTracking
CREATE TABLE #TempPDBTracking
(
client nvarchar(255),
instance nvarchar(512),
pdbName varchar(64),
   createdTime INTEGER,
   endBackupTime INTEGER,
   dbId BIGINT
)
INSERT INTO #TempPDBTracking SELECT   c.name as client, i.name as instance, p.name as PDBName, p.created as CreatedTime,
	(CASE WHEN p.deleteFlag = 0 THEN 0 ELSE
	(CASE WHEN p.modified > p.deleted THEN p.modified ELSE p.deleted END) END) as EndTime ,
	p.dbId as DatabaseId
FROM OraclePluggableDBs p INNER JOIN App_InstanceName i on p.instId = i.id
	INNER JOIN App_application a on a.instance = i.id
	INNER JOIN  app_client c on c.id = a.clientId
WHERE
	(@i_instanceNameList = N'' or i.name in (SELECT Data from dbo.SplitString(@i_instanceNameList, ',') ) )
	AND p.name not in ( 'PDB$SEED', 'CDB$ROOT')
	AND (@i_databaseNameList = N'' or p.name in  (SELECT Data FROM dbo.SplitString(@i_databaseNameList, ',') ) )
	AND p.created < @u_endTime
	AND ( p.deleteFlag = 0 OR  p.deleted BETWEEN @u_startTime and @u_endTime)
	AND (@i_clientNameList = N'' OR c.name in (SELECT Data FROM dbo.SplitString(@i_clientNameList, ',') ) )
	AND (@i_dbIdList = N'' OR p.dbId in (select CAST(DATA AS BIGINT) FROM dbo.SplitString(@i_dbIdList, ',') ) )
AND (a.subclientStatus & 0x00008 ) = 0x00008
select  client as Client, instance as Instance, pdbName as PDBName,
     (case when @i_enableDateTimeFormat = 0 THEN STR(CreatedTime) ELSE FORMAT(dbo.GetDateTime(CreatedTime), 'MM-dd-yyyy HH:mm:ss') END) as StartTime ,
	(CASE WHEN endBackupTime = 0 THEN 'CURRENT' ELSE (CASE WHEN @i_enableDateTimeFormat = 0 THEN STR(endBackupTime) ELSE FORMAT(dbo.GetDateTime(endBackupTime), 'MM-dd-yyyy HH:mm:ss') END) END) as EndTime ,
	(CASE WHEN dbId <> 0 THEN STR(dbId) ELSE 'NA' END) as DatabaseId from #TempPDBTracking
	ORDER BY (CASE WHEN dbId <> 0 THEN str(dbId) ELSE pdbName END), EndTime DESC
IF OBJECT_ID('tempdb.dbo.#TempPDBTracking') IS NOT NULL DROP TABLE #TempPDBTracking
SKIP_END:
IF @CustomError <> N''
BEGIN
	SELECT @CustomError
	SELECT 'USAGE: ' + @usage
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SELECT @ErrorNumber = ERROR_NUMBER(), @ErrorMessage = ERROR_MESSAGE();
PRINT N'Error occured. ErrorNo(' + CAST(@ErrorNumber AS NVARCHAR(10)) + N') ErrorMsg(' + @ErrorMessage + N').'
END CATCH;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetOracle12CPDBBackupDetails')
	delete from GxQscripts where name = 'QS_GetOracle12CPDBBackupDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetOracle12CPDBBackupDetails')
	delete from GXDBVersions where aliasname = 'QS_GetOracle12CPDBBackupDetails'
GO

insert into GXDBVersions values(2, 'QS_GetOracle12CPDBBackupDetails',  '00000000000000000000', 'QS_GetOracle12CPDBBackupDetails', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetOracle12CPDBBackupDetails',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '    qoperation execscript -sn QS_GetOracle12CPDBBackupDetails  -si @i_startTime = ''start-time in MM/DD/YYYY HH24:MI:SS format'' -si @i_endTime = ''end-time in MM/DD/YYYY HH24:MI:SS format''  -si @i_databaseNameList = ''pdbNameList (delimited by comma)''  -si @i_instanceNameList=''instanceNameList (delimited by comma)'' -si @i_clientNameList = ''clientnameList (delimited by comma)'' -si @dbIdList = ''dbIdList (delimited by comma)'' -si @i_noTimeRestriction = ''0 or 1'' -si @i_enableDateTimeFormat  = ''0 or 1''
'
 + CHAR(10) + '--   script_name: QS_GetOracle12CPDBBackupDetails'
 + CHAR(10) + '--   returns PDB List and their CDB details when it was backed up'
)
GO

