

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetOperationWindowAll.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_GetOperationWindowAll')
BEGIN
	print '>>> Drop Stored Procedure: QS_GetOperationWindowAll <<<'
	drop procedure QS_GetOperationWindowAll
END
IF EXISTS (select * from GxQscripts where name='QS_GetOperationWindowAll')
	delete from GxQscripts where name = 'QS_GetOperationWindowAll'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetOperationWindowAll')
	delete from GXDBVersions where aliasname = 'QS_GetOperationWindowAll'
GO
print '... Creating Procedure: QS_GetOperationWindowAll'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetOperationWindowAll
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
--SP INPUT PARAMS
  @PARAM1 VARCHAR(1024) = '%s'
AS
-------------------------------------------
-- INPUT
-------------------------------------------
--DECLARE @PARAM1 varchar(1024)
--SET @PARAM1 ='%s'
-----------------------------------------
--SET @PARAM1='cc'
--SET @PARAM1='c=navia'
--SET @PARAM1='cg=s1'
---------------------------------------------
---------------- Constants    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				='GetOperationWindow'
DECLARE @commcellOption			varchar(32)
set		@commcellOption			='cc'
DECLARE @clientGroupOption		varchar(10)
SET		@clientGroupOption		='cg='
DECLARE @clientOption			varchar(10)
SET		@clientOption			='c='
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
-------- Get operation window rules-------------
------****************-----------------
--1. Expand the days and operation from the numbers stored in DB to user readable format
DECLARE @dow TABLE (daysOfWeek int, opType int, daysOfWeekString varchar(1024),OperationString varchar(1024))
DECLARE @daysOfWeek AS INT
DECLARE @opType AS INT
IF ( CURSOR_STATUS(N'global', N'APP_OpWindowRuleItr') >= 0  /* cursor is open */
	OR CURSOR_STATUS(N'local', 'APP_OpWindowRuleItr') >= 0 )
		CLOSE APP_OpWindowRuleItr
IF ( CURSOR_STATUS(N'global', N'APP_OpWindowRuleItr') >= -1  /* cursor is open */
	OR CURSOR_STATUS(N'local', 'APP_OpWindowRuleItr') >= -1 )
		DEALLOCATE APP_OpWindowRuleItr
DECLARE APP_OpWindowRuleItr CURSOR
FOR
	SELECT DISTINCT daysOfWeek, opType
	FROM APP_OpWindowRule
OPEN APP_OpWindowRuleItr
FETCH NEXT FROM APP_OpWindowRuleItr INTO @daysOfWeek, @opType
WHILE @@FETCH_STATUS = 0
BEGIN
	---------days of week----------
	DECLARE @daysOfWeekString NVARCHAR(MAX) = N''
	DECLARE @operationString NVARCHAR(MAX) = N''
	IF @daysOfWeek & 1 = 1 SET @daysOfWeekString = @daysOfWeekString +  'Sun'
	IF @daysOfWeek & 2 = 2
	BEGIN
		IF len(@daysOfWeekString) >0 SET @daysOfWeekString =	@daysOfWeekString + ', '
		SET @daysOfWeekString = @daysOfWeekString +  'Mon'
	END
	IF @daysOfWeek & 4 = 4
	BEGIN
		IF len(@daysOfWeekString) >0 SET @daysOfWeekString =	@daysOfWeekString+ ', '
		SET @daysOfWeekString = @daysOfWeekString +  'Tue'
	END
	IF @daysOfWeek & 8 = 8
	BEGIN
		IF len(@daysOfWeekString) >0 SET @daysOfWeekString =	@daysOfWeekString+ ', '
		SET @daysOfWeekString = @daysOfWeekString +  'Wed'
	END
	IF @daysOfWeek & 16 = 16
	BEGIN
		IF len(@daysOfWeekString) >0 SET @daysOfWeekString =	@daysOfWeekString+ ', '
		SET @daysOfWeekString = @daysOfWeekString +  'Thu'
	END
	IF @daysOfWeek & 32 = 32
	BEGIN
		IF len(@daysOfWeekString) >0 SET @daysOfWeekString =	@daysOfWeekString+ ', '
		SET @daysOfWeekString = @daysOfWeekString +  'Fri'
	END
	IF @daysOfWeek & 64 = 64
	BEGIN
		IF len(@daysOfWeekString) >0 SET @daysOfWeekString =	@daysOfWeekString+ ', '
		SET @daysOfWeekString = @daysOfWeekString +  'Sat'
	END
	-------------------operation string-----------------
	SET @OperationString = ''
	IF @opType & 1		= 1		SET @OperationString =	@OperationString+  'Full Data Management'   --(1<<0)
	IF @opType & 2		= 2
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Non Full Data Management'	--(1<<1)
	END
	IF @opType & 4		= 4
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Synthetic Full'	--(1<<2)
	END
	IF @opType & 8		= 8
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Data Recovery'	--(1<<3)
	END
	IF @opType & 16		= 16
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Auxiliary Copy'	--(1<<4)
	END
	IF @opType & 32		= 32
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Disaster Recovery Backup'	--(1<<5)
	END
	IF @opType & 64		= 64
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Data Verification'	--(1<<6)
	END
	IF @opType & 128	= 128
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Erase Media'	--(1<<7)
	END
	IF @opType & 512	= 512
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Erase Data by browsing'	--(1<<9)
	END
	IF @opType & 1024	= 1024
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Erase Archived Data'	--(1<<10)
	END
	IF @opType & 2048	= 2048
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Offline Content Indexing'	--(1<<11)
	END
	IF @opType & 4096	= 4096
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Online Content Indexing'	--(1<<12)
	END
	IF @opType & 16384	= 16384
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Information Management'	--(1<<14)
	END
	IF @opType & 32768	= 32768
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Media Refresh'	--(1<<15)
	END
	INSERT @dow
	VALUES(@daysOfWeek, @optype, @daysofweekString , @Operationstring)
	FETCH NEXT FROM APP_OpWindowRuleItr INTO @daysOfWeek, @opType
END
CLOSE APP_OpWindowRuleItr
DEALLOCATE APP_OpWindowRuleItr
----------------****************------------------
--COMMCELL LEVEL RULES
IF SUBSTRING(@PARAM1, 1, 2) = @commcellOption
	SELECT		description,
				D.OperationString as Operation,
				dbo.GetDateTime2(startDate, NULL, 1) as StartDate,
				dbo.GetDateTime2(endDate, NULL, 1) as EndDate,
				D.daysOfWeekString as DaysOfWeek,
				CASE
					WHEN startTime <> 0 THEN SUBSTRING(dbo.GetDateTime2(startTime,NULL,0),12, LEN(dbo.GetDateTime2(startTime,NULL,0)))
					ELSE '12:00AM'
				END as StartTime,
				CASE
					WHEN endTime <> 0 THEN SUBSTRING(dbo.GetDateTime2(endTime,NULL,0),12, LEN(dbo.GetDateTime2(endTime,NULL,0)))
					ELSE '12:00AM'
				END as EndTime,
				I.name as iDA,
				 '' as Instance,
				 ''as Backupset,
				 '' as Subclient
		FROM APP_OpWindowRule LEFT JOIN APP_iDAType I on appTypeId=I.type
		INNER JOIN @dow D ON (D.daysOfWeek = APP_OpWindowRule.daysOfWeek AND D.opType = APP_OpWindowRule.opType)
		WHERE clientId = 2 and apptypeId = 1000
--CLIENT GROUP
ELSE IF SUBSTRING(@PARAM1, 1, 3) = @clientGroupOption
BEGIN
		DECLARE @clientgGroupId int
		SET @clientgGroupId = ISNULL((SELECT id FROM APP_ClientGroup WHERE name = (SELECT SUBSTRING(@PARAM1, 4, LEN(@PARAM1)-3))),0)
		IF @clientgGroupId = 0
		BEGIN
				SET @localErrorMsg	='Clientgroup  ['+(SELECT SUBSTRING(@PARAM1, 4, LEN(@PARAM1)-3))+'] does not exist.'
				Set @lastError = 1
				goto   ARGS_ERROR
		END
		SELECT 		description,
					D.OperationString as Operation,
					dbo.GetDateTime2(startDate, NULL, 1) as StartDate,
					dbo.GetDateTime2(endDate, NULL, 1) as EndDate,
					D.daysOfWeekString as DaysOfWeek,
					CASE
						WHEN startTime <> 0 THEN SUBSTRING(dbo.GetDateTime2(startTime,NULL,0),12, LEN(dbo.GetDateTime2(startTime,NULL,0)))
						ELSE '12:00AM'
					END as StartTime,
					CASE
						WHEN endTime <> 0 THEN SUBSTRING(dbo.GetDateTime2(endTime,NULL,0),12, LEN(dbo.GetDateTime2(endTime,NULL,0)))
						ELSE '12:00AM'
					END as EndTime,
					I.name as iDA,
					'' as Instance,
					'' as Backupset,
					'' as Subclient
			FROM APP_OpWindowRule LEFT JOIN APP_iDAType I on appTypeId=I.type
			INNER JOIN @dow D ON (D.daysOfWeek = APP_OpWindowRule.daysOfWeek AND D.opType = APP_OpWindowRule.opType)
			WHERE clientGroupId = (SELECT id from APP_ClientGroup WHERE name = (SELECT SUBSTRING(@PARAM1, 4, LEN(@PARAM1)-3)))
	END
--CLIENT
ELSE IF SUBSTRING(@PARAM1, 1, 2) = @clientOption
BEGIN
		DECLARE @clientId int
		SET @clientId = ISNULL((SELECT id FROM APP_Client WHERE name = (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2))),0)
		IF @clientId = 0
		BEGIN
				SET @localErrorMsg	='Client ['+(SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2))+'] does not exist.'
				Set @lastError = 1
				goto   ARGS_ERROR
		END
		SELECT	O.description,
				D.OperationString as Operation,
				D.daysOfWeekString as DaysOfWeek,
				dbo.GetDateTime2(O.startDate, NULL, 1) as StartDate,
				dbo.GetDateTime2(O.endDate, NULL, 1) as EndDate,
				CASE
					WHEN startTime <> 0 THEN SUBSTRING(dbo.GetDateTime2(startTime,NULL,0),12, LEN(dbo.GetDateTime2(startTime,NULL,0)))
					ELSE '12:00AM'
				END as StartTime,
				CASE
					WHEN endTime <> 0 THEN SUBSTRING(dbo.GetDateTime2(endTime,NULL,0),12, LEN(dbo.GetDateTime2(endTime,NULL,0)))
					ELSE '12:00AM'
				END as EndTime,
				Ida.name as iDA,
				ISNULL(Ins.name, '') as Instance,
				ISNULL(Bs.name, '')  as Backupset,
				ISNULL(SC.subclientname, '')  as Subclient
		FROM APP_OpWindowRule O
		LEFT JOIN APP_Client C ON O.clientId=C.id
		LEFT JOIN APP_iDAType Ida ON O.appTypeId=Ida.type
		LEFT JOIN APP_InstanceName Ins ON O.instanceId=Ins.id and Ins.id >1
		LEFT JOIN APP_BackupsetName BS ON O.backupsetId=BS.id
		LEFT JOIN APP_Application SC ON O.subclientId=SC.id
		INNER JOIN @dow D ON (D.daysOfWeek = O.daysOfWeek AND D.opType = O.opType)
		WHERE C.id= @clientId AND (O.appTypeId <> 1000)		--Operation window specified at commcell level gets saved as clientId = 2 and apptypeid = 1000
															--This should not come and mess up with the output when queried against clientId = 2 at client level
END
ELSE
BEGIN
	SET @localErrorMsg	='Parameter 1 must be cc or cg=client_group_name or c=client_name. ['+@PARAM1+'] not supported.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetOperationWindowAll')
	delete from GxQscripts where name = 'QS_GetOperationWindowAll'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetOperationWindowAll')
	delete from GXDBVersions where aliasname = 'QS_GetOperationWindowAll'
GO

insert into GXDBVersions values(2, 'QS_GetOperationWindowAll',  '00000000000000000000', 'QS_GetOperationWindowAll', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetOperationWindowAll',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetOperationWindowAll.sql -si cc | cg=client_group_name | c=client_name
'
 + CHAR(10) + '-- 	script_name: GetOperationWindowAll'
)
GO

