

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetOperationWindow.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_GetOperationWindow')
BEGIN
	print '>>> Drop Stored Procedure: QS_GetOperationWindow <<<'
	drop procedure QS_GetOperationWindow
END
IF EXISTS (select * from GxQscripts where name='QS_GetOperationWindow')
	delete from GxQscripts where name = 'QS_GetOperationWindow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetOperationWindow')
	delete from GXDBVersions where aliasname = 'QS_GetOperationWindow'
GO
print '... Creating Procedure: QS_GetOperationWindow'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetOperationWindow
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
--SP INPUT PARAMS
  @PARAM1 varchar(1024) = '%s'
AS
SET NOCOUNT ON
-------------------------------------------
-- @PARAM1  IS FILLED IN FROM COMMANDLINE			 --
-------------------------------------------
--DECLARE @PARAM1 varchar(1024)
--SET @PARAM1 ='%s'
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				='GetOperationWindow'
DECLARE @commcellOption			varchar(32)
set		@commcellOption			='cc'
DECLARE @clientGroupOption		varchar(10)
SET		@clientGroupOption		='cg='
DECLARE @clientOption			varchar(10)
SET		@clientOption			='c='
DECLARE @COMMCELLID int
SET		@COMMCELLID = 2
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-----------------------------------------
--SET @PARAM1='cc'
--SET @PARAM1='c=navia'
--SET @PARAM1='cg=g1'
---------------------------------------------
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
	-----------------*****************-------------------
DECLARE @O_operationWindowRules TABLE (description nvarchar(max),operationString varchar(1024) ,daysofweek varchar(1024) ,	operations int,days int ,StartTime nvarchar(100), EndTime nvarchar (100), ida nvarchar(100) )
		-------------------*********-----------------
--COMMCELL LEVEL RULES
IF SUBSTRING(@PARAM1, 1, 2) = @commcellOption
	INSERT INTO @O_operationWindowRules
	SELECT		description,
				'','',
				opType as operations,
				daysOfWeek as days,
				case startTime when 0 then '12:00AM' else
				SUBSTRING(dbo.GetDateTime2(startTime,NULL,0),12, LEN(dbo.GetDateTime2(startTime,NULL,0))) end as StartTime,
				SUBSTRING(dbo.GetDateTime2(endTime,NULL,0),12, LEN(dbo.GetDateTime2(endTime,NULL,0))) as EndTime,
				I.name as iDA
		FROM APP_OpWindowRule LEFT JOIN APP_iDAType I on appTypeId=I.type
		WHERE clientId = @COMMCELLID and apptypeId = 1000
--CLIENT GROUP
ELSE IF SUBSTRING(@PARAM1, 1, 3) = @clientGroupOption
BEGIN
		DECLARE @clientgGroupId int
		SET @clientgGroupId = ISNULL((SELECT id FROM APP_ClientGroup WHERE name = (SELECT SUBSTRING(@PARAM1, 4, LEN(@PARAM1)-3))),0)
		IF @clientgGroupId = 0
		BEGIN
				SET @localErrorMsg	='Clientgroup  ['+(SELECT SUBSTRING(@PARAM1, 4, LEN(@PARAM1)-3))+'] does not exist.'
				Set @lastError = 1
				goto   ARGS_ERROR
		END
		INSERT INTO @O_operationWindowRules
		SELECT 		description,
					'','',
					opType as operations,
					daysOfWeek as days,
					case startTime when 0 then '12:00AM' else
					SUBSTRING(dbo.GetDateTime2(startTime,NULL,0),12, LEN(dbo.GetDateTime2(startTime,NULL,0))) end as StartTime,
					SUBSTRING(dbo.GetDateTime2(endTime,NULL,0),12, LEN(dbo.GetDateTime2(endTime,NULL,0))) as EndTime,
					I.name as iDA
			FROM APP_OpWindowRule LEFT JOIN APP_iDAType I on appTypeId=I.type
			WHERE clientGroupId = (SELECT id from APP_ClientGroup WHERE name = (SELECT SUBSTRING(@PARAM1, 4, LEN(@PARAM1)-3)))
	END
--CLIENT
ELSE IF SUBSTRING(@PARAM1, 1, 2) = @clientOption
BEGIN
		DECLARE @clientId int
		SET @clientId = ISNULL((SELECT id FROM APP_Client WHERE name = (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2))),0)
		IF @clientId = 0
		BEGIN
				SET @localErrorMsg	='Client ['+(SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2))+'] does not exist.'
				Set @lastError = 1
				goto   ARGS_ERROR
		END
		INSERT INTO @O_operationWindowRules
		SELECT	O.description,
				'','',
				opType as operations,
				daysOfWeek as days,
				case startTime when 0 then '12:00AM' else
				SUBSTRING(dbo.GetDateTime2(o.startTime,NULL,0),12, LEN(dbo.GetDateTime2(o.startTime,NULL,0))) end as StartTime,
				SUBSTRING(dbo.GetDateTime2(o.endTime,NULL,0),12, LEN(dbo.GetDateTime2(o.endTime,NULL,0))) as EndTime,
				I.name as iDA
		FROM APP_OpWindowRule O
		INNER JOIN APP_Client C ON O.clientId=C.id
		INNER JOIN APP_iDAType I ON O.appTypeId=I.type
		WHERE C.id= @clientId
END
ELSE
BEGIN
	SET @localErrorMsg	='Parameter 1 must be cc or cg=client_group_name or c=client_name. ['+@PARAM1+'] not supported.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
UPDATE @O_operationWindowRules
SET daysofweek =
		CASE WHEN DAYS&1 = 1	THEN	'Sun,' ELSE  '' END
	+	CASE WHEN DAYS&2 = 2	THEN	'Mon,' ELSE  '' END
	+	CASE WHEN DAYS&4 = 4	THEN	'Tue,' ELSE  '' END
	+	CASE WHEN DAYS&8 = 8	THEN	'Wed,' ELSE  '' END
	+	CASE WHEN DAYS&16 = 16	THEN	'Thu,' ELSE  '' END
	+	CASE WHEN DAYS&32 = 32	THEN	'Fri,' ELSE  '' END
	+	CASE WHEN DAYS&64 = 64	THEN	'Sat,' ELSE  '' END
	,
operationString =
		CASE WHEN  operations & 1		= 1		THEN 'Full Data Management,'		ELSE ''--(1<<0)
	END
	+	CASE WHEN  operations & 2		= 2 	THEN 'Non Full Data Management,'	ELSE ''--(1<<1)
	END
	+	CASE WHEN  operations & 4		= 4		THEN 'Synthetic Full,'				ELSE '' --(1<<2)
	END
	+	CASE WHEN  operations & 8		= 8		THEN 'Data Recovery,'				ELSE '' --(1<<3)
	END
	+	CASE WHEN  operations & 16		= 16	THEN 'Auxiliary Copy,'				ELSE ''--(1<<4)
	END
	+	CASE WHEN  operations & 32		= 32	THEN 'Disaster Recovery Backup,'	ELSE ''--(1<<5)
	END
	+	CASE WHEN  operations & 64		= 64	THEN 'Data Verification,'			ELSE ''--(1<<6)
	END
	+	CASE WHEN  operations & 128		= 128	THEN 'Erase Media,'					ELSE ''--(1<<7)
	END
	+	CASE WHEN  operations & 512		= 512	THEN 'Erase Data by browsing,'		ELSE ''--(1<<9)
	END
	+	CASE WHEN  operations & 1024	= 1024	THEN 'Erase Archived Data,'			ELSE ''--(1<<10)
	END
	+	CASE WHEN  operations & 2048	= 2048	THEN 'Offline Content Indexing,'	ELSE ''--(1<<11)
	END
	+	CASE WHEN  operations & 4096	= 4096  THEN 'Online Content Indexing,'		ELSE ''--(1<<12)
	END
	+	CASE WHEN  operations & 16384	= 16384 THEN 'Information Management,'		ELSE ''--(1<<14)
	END
	+	CASE WHEN  operations & 32768	= 32768 THEN 'Media Refresh,'				ELSE ''--(1<<15)
	END
SELECT description,operationString,daysofweek,StartTime,EndTime,ida FROM @O_operationWindowRules
ARGS_ERROR:
 if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetOperationWindow')
	delete from GxQscripts where name = 'QS_GetOperationWindow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetOperationWindow')
	delete from GXDBVersions where aliasname = 'QS_GetOperationWindow'
GO

insert into GXDBVersions values(2, 'QS_GetOperationWindow',  '00000000000000000000', 'QS_GetOperationWindow', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetOperationWindow',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetOperationWindow.sql -si cc | cg=client_group_name | c=client_name
'
 + CHAR(10) + '-- 	script_name: GetOperationWindow'
)
GO

