

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetOneTouchBackupJobs.sp] ---------- 

--  +========================================================================+
--  |		 		Name:  QS_GetOneTouchBackupJobsAll
--  | Description:  This SP is from Permanent QScript - GetOneTouchBackupJobs
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_GetOneTouchBackupJobs.sp,v $ $Id: QS_GetOneTouchBackupJobs.sp,v 1.8.60.2 2018/03/22 02:57:05 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetOneTouchBackupJobs <<<'

IF EXISTS (select * from sysobjects where name='QS_GetOneTouchBackupJobs')
	drop procedure QS_GetOneTouchBackupJobs
IF EXISTS (select * from GxQscripts where name='QS_GetOneTouchBackupJobs')
	delete from GxQscripts where name = 'QS_GetOneTouchBackupJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetOneTouchBackupJobs')
	delete from GXDBVersions where aliasname = 'QS_GetOneTouchBackupJobs'
GO
print '... Creating Procedure: QS_GetOneTouchBackupJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetOneTouchBackupJobs
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @PARAM1 varchar(1024) = '%s', 
  @PARAM2 varchar(1024) = '%s',
  @PARAM3 varchar(1024) = '%s',
  @PARAM4 varchar(1024) = '%s',
  @PARAM5 varchar(1024) = '%s'
---------------------------------------
--test
--SET		@PARAM1= 'c=linux1touchcs_cn'
--SET		@PARAM2= 'a=Q_WINXP32_FS'
--SET		@PARAM1= 'c=onetouch4_CN'
--SET		@PARAM2= 'a=Q_LINUX_FS'
--SET		@PARAM3= 'b=defaultbackupset'
--SET		@PARAM4= 's=default'
---------------------------------------
AS
	DECLARE @scriptName				varchar(32)
	SET		@scriptName				= 'GetOneTouchBackupJobs'
	DECLARE @lastError				integer
	DECLARE @errorMsg				varchar(512)
	DECLARE @userId					INT
	DECLARE @NoParameter			varchar(10)
	SET		@errorMsg				='Error Encountered when running script.'
	SET     @lastError				= 0		-- Be optimistic
	SET		@userId					= 0
	SET		@NoParameter			='%'						-- Get Around QScript Parameter
	SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
----------------------- const   -----------
	DECLARE @onetouchOptype int
	SET @onetouchOptype  = 43	--SYSRECOVERYBACKUP
	DECLARE @statusSuccess int
	SET @statusSuccess  = 1		--Successful Jobs
DECLARE @backupSetName varchar(100)
	SET @backupSetName  = 'b=defaultBackupSet'
DECLARE @subclientName varchar(100)
	SET @subclientName  = 's=default'
	SET NOCOUNT ON
--------------------- Local Variables    -------------
	DECLARE @ClientId int
	DECLARE @AppTypeId int
	DECLARE @InstanceId int
	DECLARE @BackupsetId int
	DECLARE @subclientId int
	DECLARE @subClientPassed int
	DECLARE @backupSetPassed int
	SET @subClientPassed = 1
	SET @backupSetPassed = 1
DECLARE @clientName nvarchar(100)
DECLARE @appTypeName nvarchar(100)
	BEGIN TRY
	--------------------- Input validation    -------------
	--defaultBackupSet and default subclient are used if the names are not provided.
	--Donot call the SP QscriptGetAppIdsFromNames - because it needs the backupsetname and subclientname, which are optional for this qscript
	--If this SP is called assuming the backupset and subclient names as 'defaultbackupset' and 'default', then the output of the script will display these names also,
	--which may not always exist, thereby confusing the user
	IF @PARAM1 NOT LIKE 'c=%' OR @PARAM2 NOT LIKE 'a=%' OR (@PARAM3 <> @NoParameter AND @PARAM3 NOT LIKE 'b=%') OR (@PARAM4 <> @NoParameter AND @PARAM4 NOT LIKE 's=%')
	BEGIN
		SET @lastError = 1
		SET @errorMsg = 'Error. Inputs are missing or specified in the wrong format. Please refer to documentation for proper specification'
		GOTO ARGS_ERROR
	END
	SET @clientName = SUBSTRING(@PARAM1,LEN('c=')+1,LEN(@PARAM1)-LEN('c='))
	SET @ClientId = ISNULL((SELECT id FROM APP_CLIENT WITH (NOLOCK) WHERE name = @clientName),0)
	IF @ClientId = 0 OR @clientid IS NULL
	BEGIN
		SET @lastError = 1
		SET @errorMsg = 'Error. Client Name [' + @clientName + '] is invalid'
		GOTO ARGS_ERROR
	END
	SET @appTypeName = SUBSTRING(@PARAM2,LEN('a=')+1,LEN(@PARAM2)-LEN('a='))
	IF @appTypeName = 'Q_FILESYSTEM'
		SELECT @ApptypeId = appTypeId
		FROM APP_IDAName WITH (NOLOCK)
		WHERE clientId = @ClientId AND appTypeId IN (SELECT appTypeId
													 FROM APP_AppTypeGroupAssoc WITH (NOLOCK)
													 WHERE appGroupId = (SELECT appTypeGroupId
																		 FROM APP_AppTypeGroup WITH (NOLOCK)
																		 WHERE groupName = 'APPGRP_FileSystemIDA'))
	ELSE
		SELECT @ApptypeId =
        CASE @appTypeName
WHEN 'Q_WINDOWS_FS'THEN 33
WHEN 'Q_WINDOWS_FS_64'THEN 34
WHEN 'Q_WINNET_FS'THEN 42
WHEN 'Q_WINNET_FS_64'THEN 43
WHEN 'Q_SHAREPOINT_SERVER'THEN 78
WHEN 'Q_SHAREPOINT_SERVER'THEN 69
WHEN 'Q_MSEXCH_MB'THEN 54
WHEN 'Q_MSEXCH_DB'THEN 53
WHEN 'Q_MSEX_WEB'THEN 55
WHEN 'Q_MSEX_MIG'THEN 56
WHEN 'Q_MSEX_PUB'THEN 35
WHEN 'Q_FS'THEN 1
WHEN 'Q_WIN2K_FS'THEN 11
WHEN 'Q_NETWARE_FS'THEN 12
WHEN 'Q_HPUX64_FS'THEN 18
WHEN 'Q_SOLARIS64_FS'THEN 20
WHEN 'Q_AIX_FS'THEN 21
WHEN 'Q_HPUX_FS'THEN 17
WHEN 'Q_SOLARIS_FS'THEN 19
WHEN 'Q_LINUX_FS'THEN 29
WHEN 'Q_WINXP32_FS'THEN 33
WHEN 'Q_WINXP64_FS'THEN 34
WHEN 'Q_TRU64_FS_64'THEN 36
WHEN 'Q_TRU64_FS_32'THEN 38
WHEN 'Q_WINNET32_FS'THEN 42
WHEN 'Q_WINNET64_FS'THEN 43
WHEN 'Q_MAC_FS'THEN 63
WHEN 'Q_SGI_FS'THEN 64
WHEN 'Q_FREEBSD_FS'THEN 74
WHEN 'Q_WINFS_MIG'THEN 58
WHEN 'Q_UNIXFS_MIG'THEN 66
WHEN 'Q_ORACLE'THEN 22
WHEN 'Q_DB2'THEN 37
WHEN 'Q_UNIX_DB2'THEN 62
WHEN 'Q_INFORMIX'THEN 3
WHEN 'Q_MSSQLSERVER'THEN 4
WHEN 'Q_MSSQL_2K'THEN 16
WHEN 'Q_MSSQL_YUKON'THEN 70
WHEN 'Q_MSSQL'THEN 81
WHEN 'Q_SYBASE'THEN 5
WHEN 'Q_MSEX_MB'THEN 8
WHEN 'Q_MSEX2K_MB'THEN 14
WHEN 'Q_MSEX2003_MB'THEN 54
WHEN 'Q_MSEX_DB'THEN 9
WHEN 'Q_MSEX2K_DB'THEN 15
WHEN 'Q_MSEX2003_DB'THEN 53
WHEN 'Q_MSEX55_PUB'THEN 35
WHEN 'Q_MSEX2K_WEB'THEN 44
WHEN 'Q_MSEX2003_WEB'THEN 55
WHEN 'Q_MSEX_ARCH'THEN 67
WHEN 'Q_MSEX55_ARCH'THEN 68
WHEN 'Q_MSEX2K_MIG'THEN 45
WHEN 'Q_MSEX2003_MIG'THEN 56
WHEN 'Q_MSEX55_MIG'THEN 57
WHEN 'Q_LOTUS_DB'THEN 6
WHEN 'Q_LOTUS_UNIX_DB'THEN 51
WHEN 'Q_LOTUS_DOMINO_DB'THEN 59
WHEN 'Q_LOTUS6_DB'THEN 77
WHEN 'Q_LOTUS_DOC'THEN 7
WHEN 'Q_LOTUS_UNIX_DOC'THEN 52
WHEN 'Q_LOTUS_DOMINO_DOC'THEN 60
WHEN 'Q_SHAREPOINT_DB'THEN 69
WHEN 'Q_SHAREPOINT_DOC'THEN 78
WHEN 'Q_GROUPWISE'THEN 71
WHEN 'Q_NDS'THEN 10
WHEN 'Q_SDM_WIN2K'THEN 24
WHEN 'Q_SDM_UNIX'THEN 48
WHEN 'Q_SAP_ORADB'THEN 61
WHEN 'Q_SAP_SAPDB'THEN 79
WHEN 'Q_PROXYHOST'THEN 25
WHEN 'Q_PROXYHOST_UNIX'THEN 40
WHEN 'Q_ACTIVEDIR'THEN 41
WHEN 'Q_IMAGELEVEL_WIN'THEN 65
WHEN 'Q_IMAGELEVEL_UNIX'THEN 75
WHEN 'Q_IMAGELEVEL_PROXY'THEN 76
WHEN 'Q_NETSTORAGE_MIG'THEN 73
WHEN 'Q_NAS'THEN 13
WHEN 'Q_REPLICATION'THEN 47
WHEN 'Q_REPLICATION_UNIX'THEN 50
WHEN 'Q_MSEXPF_MIG'THEN 82
WHEN 'Q_ORACLE_RAC'THEN 80
WHEN 'Q_NETWARE_MIG'THEN 83
WHEN 'Q_FILE_REPLICATION'THEN 84
WHEN 'Q_DATA_CLASSIFICATION'THEN 85
WHEN 'Q_NETWARE_LINUX'THEN 86
WHEN 'Q_PROXYHOST_IMAGE_UNIX'THEN 87
WHEN 'Q_CENTERA'THEN 88
WHEN 'Q_SHAREPOINT_ARCH'THEN 89
WHEN 'Q_LOTUS_DOC_MIG'THEN 90
WHEN 'Q_DPM_AGENT'THEN 91
WHEN 'Q_DB2_DPF'THEN 103
WHEN 'Q_MYSQL'THEN 104
            ELSE 0
		END
	IF NOT EXISTS (SELECT * FROM APP_IDAName WITH (NOLOCK) WHERE clientId = @clientid and appTypeId = @AppTypeId)
		SET @AppTypeId = 0
	if @APPTYPEID = 0 OR @AppTypeId IS NULL
	BEGIN
		SET @lastError = 1
		SET @errorMsg = 'Error. App Type [' + @appTypeName + '] is invalid for client ['+@clientName +']'
		GOTO ARGS_ERROR
	END
	IF @PARAM3 = @NoParameter
	BEGIN
		SET @backupSetName = (SELECT TOP (1) A.name from APP_BackupSetName A WITH (NOLOCK) INNER JOIN APP_Application B WITH (NOLOCK) ON B.backupSet = A.id where B.clientId = @ClientId and B.appTypeId = @AppTypeId and A.status & 8 >0)
		SET @PARAM3 = 'b=' + @backupSetName
		SET @backupSetPassed = 0
	END
	SET @backupSetName = SUBSTRING(@param3,len('b=')+1,len(@PARAM3)-LEN('b='))
	SET @BackupsetId = ISNULL((select top(1) A.ID from APP_BackupSetName A WITH (NOLOCK) inner join APP_Application B  WITH (NOLOCK) on A.id = B.backupSet where B.clientId = @ClientId and B.appTypeId = @AppTypeId and A.name = @backupSetName),0)
	IF @BackupsetId = 0
    BEGIN
		SET @lastError = 1
		SET @errorMsg = 'Backupset passed '+ @backupSetName +' is invalid'
		GOTO ARGS_ERROR
	END
	IF @PARAM4 = @NoParameter
	BEGIN
		select @subclientName = subclientName from APP_Application WITH (NOLOCK) where backupSet = @BackupsetId and subclientstatus & 8 >0
		SET @PARAM4 = 's=' + @subclientName
		SET @subClientPassed = 0
	END
	SET @subclientName = SUBSTRING(@PARAM4,LEN('s=')+1,len(@param4)-LEN('s='))
	SET @subclientId  = ISNULL((SELECT ID FROM APP_Application WITH (NOLOCK) WHERE subclientName  = @subclientName and backupSet = @BackupsetId ),0)
	IF @subclientid = 0 or @subclientId is null
	BEGIN
		SET @lastError = 1
		SET @errorMsg = 'Error. Subclient ['+ @subclientName +'] is invalid'
		GOTO ARGS_ERROR
	END
	---------------------- Get FULL and Incremental  Backup Jobs with optype 43 set ----------------------
	IF @subClientPassed = 0 AND @backupSetPassed = 0
	--no backupset and subclient was passed
	BEGIN
		--no subclient was passed seach in all subclients
		SELECT JB.jobid,dbo.UTCToClientLocalTime(dbo.getdatetime(JB.servStartDate), 2) as StartTime,dbo.UTCToClientLocalTime(dbo.getdatetime(JB.servEndDate), 2) as EndTime from JMBkpStats as JB
		INNER JOIN JMJobStats as JS on JB.jobid = JS.jobId
		WHERE JB.appId IN (select B.id from APP_BackupSetName A INNER JOIN APP_Application B ON B.backupSet = A.id where B.clientId = @ClientId and B.appTypeId = @AppTypeId) and ( JB.bkpLevel = 1 or JB.bkpLevel = 2 ) and JS.opType = @onetouchOptype and JB.status = 1 and JB.agedTime = 0
	END
	ELSE IF @subClientPassed = 0
	BEGIN
		--no subclient was passed seach in all subclients
		SELECT JB.jobid,dbo.UTCToClientLocalTime(dbo.getdatetime(JB.servStartDate), 2) as StartTime,dbo.UTCToClientLocalTime(dbo.getdatetime(JB.servEndDate), 2) as EndTime from JMBkpStats as JB
		INNER JOIN JMJobStats as JS on JB.jobid = JS.jobId
		WHERE JB.appId IN (select B.id from APP_BackupSetName A INNER JOIN APP_Application B ON B.backupSet = A.id where A.id = @BackupsetId and B.clientId = @ClientId and B.appTypeId = @AppTypeId) and ( JB.bkpLevel = 1 or JB.bkpLevel = 2 ) and JS.opType = @onetouchOptype and JB.status = 1 and JB.agedTime = 0
	END
	ELSE
	BEGIN
		--subclient was passed search only for this subclient
		SELECT JB.jobid,dbo.UTCToClientLocalTime(dbo.getdatetime(JB.servStartDate), 2) as StartTime,dbo.UTCToClientLocalTime(dbo.getdatetime(JB.servEndDate), 2) as EndTime from JMBkpStats as JB
		INNER JOIN JMJobStats as JS on JB.jobid = JS.jobId
		WHERE JB.appId = @subclientId and ( JB.bkpLevel = 1 or JB.bkpLevel = 2 ) and JS.opType = @onetouchOptype and JB.status = 1 and JB.agedTime = 0
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    Set @lastError = ERROR_NUMBER()
    SET @errorMsg  = ERROR_MESSAGE()
END CATCH
ARGS_ERROR:
print @scriptName + ' completed at '	+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@lastError) +').'
if @lastError <> 0
	Raiserror(@errorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetOneTouchBackupJobs')
	delete from GxQscripts where name = 'QS_GetOneTouchBackupJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetOneTouchBackupJobs')
	delete from GXDBVersions where aliasname = 'QS_GetOneTouchBackupJobs'
GO

insert into GXDBVersions values(2, 'QS_GetOneTouchBackupJobs',  '00010008006000020000', 'QS_GetOneTouchBackupJobs', '00010008006000020000')
GO

insert into GxQscripts values(2,'QS_GetOneTouchBackupJobs',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetOneTouchBackupJobs.sql -si c=CLIENT_NAME a=APPTYPE b=backupset s=subclient 
'
)
GO

