

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetNetworkPendingJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetNetworkPendingJobs <<<'

IF EXISTS (select * from sysobjects where name='QS_GetNetworkPendingJobs')
	drop procedure QS_GetNetworkPendingJobs
IF EXISTS (select * from GxQscripts where name='QS_GetNetworkPendingJobs')
	delete from GxQscripts where name = 'QS_GetNetworkPendingJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetNetworkPendingJobs')
	delete from GXDBVersions where aliasname = 'QS_GetNetworkPendingJobs'
GO
print '... Creating Procedure: QS_GetNetworkPendingJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetNetworkPendingJobs
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--sp input param
  @noOfHours varchar(1024) = '%s'
AS
Set NOCOUNT ON
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'GetNetworkPendingJobs'
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
DECLARE @currTime				integer
DECLARE @NoParameter varchar(4)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
--DECLARE @noOfHours varchar(1024)
--SET @noOfHours = '%s'
if (@noOfHours = @NoParameter)
BEGIN
	SET @localErrorMsg = 'Error. input argument was not supplied.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
set @currTime = dbo.getunixtime(getutcdate())
-- errorType=400 ==> NETWORKERROR
select jobId from jmjobinfo t1 where errorType = 400 and state = 2 and
(t1.jobStartTime < @currTime and
(t1.jobStartTime  < @currTime - CAST(@noOfHours AS DECIMAL)*60*60))
and not exists(select t2.jobid from JMBkpAttemptInfo t2 where t2.jobid = t1.jobid)
order by jobid
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetNetworkPendingJobs')
	delete from GxQscripts where name = 'QS_GetNetworkPendingJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetNetworkPendingJobs')
	delete from GXDBVersions where aliasname = 'QS_GetNetworkPendingJobs'
GO

insert into GXDBVersions values(2, 'QS_GetNetworkPendingJobs',  '00000000000000000000', 'QS_GetNetworkPendingJobs', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetNetworkPendingJobs',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetNetworkPendingJobs.sql -si numberOfHours
'
 + CHAR(10) + '--   script_name : GetNetworkPendingJobs'
)
GO

