

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetMediaRetentionTimes.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_GetMediaRetentionTimes.sp,v $ $Id: QS_GetMediaRetentionTimes.sp,v 1.1.2.1 2018/11/29 00:03:24 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_GetMediaRetentionTimes')
BEGIN
	print '>>> Drop Stored Procedure: QS_GetMediaRetentionTimes <<<'
	drop procedure QS_GetMediaRetentionTimes
END
IF EXISTS (select * from GxQscripts where name='QS_GetMediaRetentionTimes')
	delete from GxQscripts where name = 'QS_GetMediaRetentionTimes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetMediaRetentionTimes')
	delete from GXDBVersions where aliasname = 'QS_GetMediaRetentionTimes'
GO
print '... Creating Procedure: QS_GetMediaRetentionTimes'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetMediaRetentionTimes
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_LibraryAliasName NVARCHAR(128) = N''
AS
SET NOCOUNT ON
DECLARE @l_libraryId INT = 0
IF(LEN(ISNULL(@i_LibraryAliasName, 0))) > 0
	SELECT @l_libraryId = libraryId FROM MMLibrary WITH(NOLOCK) WHERE AliasName = @i_LibraryAliasName
SELECT Lib.AliasName "Library", BarCode, MediaId,
						 CASE WHEN minRetentionTime = -1 THEN 'Infinite'
							  WHEN minRetentionTime > 0 THEN CAST(dbo.UTCToClientLocalTime(dbo.GetDateTime(minRetentionTime),2) AS VARCHAR(32))
							  ELSE 'N/A' END "Min Retention Time",
						 CASE WHEN retentionExpireTime = -1 THEN 'Infinite'
							  WHEN retentionExpireTime > 0 THEN CAST(dbo.UTCToClientLocalTime(dbo.GetDateTime(retentionExpireTime),2) AS VARCHAR(32))
							  ELSE 'N/A' END "Max Retention Time",
						 CASE WHEN LastBackupTime > 0 THEN CAST(dbo.UTCToClientLocalTime(dbo.GetDateTime(LastBackupTime),2) AS VARCHAR(32))
							  ELSE 'N/A' END "Last Backup Time"
FROM MMMedia M WITH(NOLOCK) INNER JOIN MMLibrary Lib WITH(NOLOCK) ON M.LibraryId = Lib.LibraryId
WHERE M.MediaTypeId <> 10001 AND M.isAged = 0 AND M.isInMediaGroup = 1
AND (@l_libraryId = 0 OR M.libraryId = @l_libraryId)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetMediaRetentionTimes')
	delete from GxQscripts where name = 'QS_GetMediaRetentionTimes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetMediaRetentionTimes')
	delete from GXDBVersions where aliasname = 'QS_GetMediaRetentionTimes'
GO

insert into GXDBVersions values(2, 'QS_GetMediaRetentionTimes',  '00010001000200010000', 'QS_GetMediaRetentionTimes', '00010001000200010000')
GO

insert into GxQscripts values(2,'QS_GetMediaRetentionTimes',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_GetMediaRetentionTimes [-si @i_LibraryAliasName=''Library Name'']
'
 + CHAR(10) + '-- 	Return list of tape media with their retention time information.'
)
GO

